/*
 * Decompiled with CFR 0.152.
 */
package org.merlyn.dataplatform;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONObject;
import org.merlyn.dataplatform.EventBuilder;
import org.merlyn.dataplatform.FieldType;
import org.merlyn.dataplatform.encryptor.Encryptor;
import org.merlyn.dataplatform.exporter.Exporter;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001a\u0010\u000b\u001a\u00020\f2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\nJ\u000e\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000fH\u0002R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/merlyn/dataplatform/EventTracker;", "", "producerId", "", "encryptor", "Lorg/merlyn/dataplatform/encryptor/Encryptor;", "exporter", "Lorg/merlyn/dataplatform/exporter/Exporter;", "(Ljava/lang/String;Lorg/merlyn/dataplatform/encryptor/Encryptor;Lorg/merlyn/dataplatform/exporter/Exporter;)V", "data", "", "setDefaultOptions", "", "track", "builder", "Lorg/merlyn/dataplatform/EventBuilder;", "traverse", "Lorg/json/JSONObject;", "event", "data-platform-api"})
public final class EventTracker {
    @NotNull
    private final String producerId;
    @NotNull
    private final Encryptor encryptor;
    @NotNull
    private final Exporter exporter;
    @NotNull
    private Map<String, String> data;

    public EventTracker(@NotNull String producerId, @NotNull Encryptor encryptor, @NotNull Exporter exporter) {
        Intrinsics.checkNotNullParameter((Object)producerId, (String)"producerId");
        Intrinsics.checkNotNullParameter((Object)encryptor, (String)"encryptor");
        Intrinsics.checkNotNullParameter((Object)exporter, (String)"exporter");
        this.producerId = producerId;
        this.encryptor = encryptor;
        this.exporter = exporter;
        this.data = MapsKt.emptyMap();
    }

    public final void setDefaultOptions(@NotNull Map<String, String> data) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        this.data = data;
    }

    public final void track(@NotNull EventBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        builder.set("producerId", this.producerId);
        for (Map.Entry<String, String> data : this.data.entrySet()) {
            builder.set(data.getKey(), data.getValue());
        }
        if (!builder.shouldSkip()) {
            this.exporter.export(this.traverse(builder));
        }
    }

    private final JSONObject traverse(EventBuilder event) {
        JSONObject json = new JSONObject();
        for (Map.Entry<String, Pair<FieldType, Object>> e : event.get().entrySet()) {
            String k = e.getKey();
            Object v = e.getValue().getSecond();
            switch (WhenMappings.$EnumSwitchMapping$0[((FieldType)((Object)e.getValue().getFirst())).ordinal()]) {
                case 1: {
                    Intrinsics.checkNotNull((Object)v, (String)"null cannot be cast to non-null type kotlin.String");
                    json.put(k, (Object)((String)v));
                    break;
                }
                case 2: {
                    Intrinsics.checkNotNull((Object)v, (String)"null cannot be cast to non-null type kotlin.collections.List<kotlin.String>");
                    json.put(k, (Collection)((List)v));
                    break;
                }
                case 3: {
                    Intrinsics.checkNotNull((Object)v, (String)"null cannot be cast to non-null type kotlin.String");
                    json.put(k, (Object)this.encryptor.encrypt((String)v));
                    break;
                }
                case 4: {
                    Intrinsics.checkNotNull((Object)v, (String)"null cannot be cast to non-null type kotlin.Int");
                    json.put(k, ((Integer)v).intValue());
                    break;
                }
                case 5: {
                    Intrinsics.checkNotNull((Object)v, (String)"null cannot be cast to non-null type kotlin.Long");
                    json.put(k, ((Long)v).longValue());
                    break;
                }
                case 6: {
                    Intrinsics.checkNotNull((Object)v, (String)"null cannot be cast to non-null type kotlin.Boolean");
                    json.put(k, ((Boolean)v).booleanValue());
                    break;
                }
                case 7: {
                    Intrinsics.checkNotNull((Object)v, (String)"null cannot be cast to non-null type org.merlyn.dataplatform.EventBuilder");
                    json.put(k, (Object)this.traverse((EventBuilder)v));
                    break;
                }
                case 8: {
                    JSONArray array = new JSONArray();
                    Intrinsics.checkNotNull((Object)v, (String)"null cannot be cast to non-null type kotlin.collections.List<org.merlyn.dataplatform.EventBuilder>");
                    for (EventBuilder subE : (List)v) {
                        array.put((Object)this.traverse(subE));
                    }
                    json.put(k, (Object)array);
                }
            }
        }
        return json;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FieldType.values().length];
            try {
                nArray[FieldType.STRING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FieldType.STRING_LIST.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FieldType.ENCRYPTED_STRING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FieldType.INT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FieldType.LONG.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FieldType.BOOLEAN.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FieldType.EVENT.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FieldType.EVENT_LIST.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

