/*
 * Decompiled with CFR 0.152.
 */
package org.merlyn.desktopapp.checker;

import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.serialization.json.JsonElementBuildersKt;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonObjectBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.merlyn.diagnostics.Checker;
import org.merlyn.diagnostics.models.CheckResult;
import org.merlyn.diagnostics.models.CheckerConfig;
import org.merlyn.diagnostics.models.CheckerMessages;
import org.merlyn.diagnostics.models.Help;
import org.merlyn.sharedui.viewmodels.usecases.ObserveAccessibilityPermissionsUseCase;
import org.merlyn.sharedui.viewmodels.usecases.ObserveMicrophonePermissionsStateUseCase;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\b\u001a\u00020\tH\u0096@\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/merlyn/desktopapp/checker/OriginPermissionChecker;", "Lorg/merlyn/diagnostics/Checker;", "observeAccessibilityPermissionsUseCase", "Lorg/merlyn/sharedui/viewmodels/usecases/ObserveAccessibilityPermissionsUseCase;", "observeMicrophonePermissionsStateUseCase", "Lorg/merlyn/sharedui/viewmodels/usecases/ObserveMicrophonePermissionsStateUseCase;", "<init>", "(Lorg/merlyn/sharedui/viewmodels/usecases/ObserveAccessibilityPermissionsUseCase;Lorg/merlyn/sharedui/viewmodels/usecases/ObserveMicrophonePermissionsStateUseCase;)V", "check", "Lorg/merlyn/diagnostics/models/CheckResult;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "configuration", "Lorg/merlyn/diagnostics/models/CheckerConfig;", "app"})
@SourceDebugExtension(value={"SMAP\nOriginPermissionChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OriginPermissionChecker.kt\norg/merlyn/desktopapp/checker/OriginPermissionChecker\n+ 2 JsonElementBuilders.kt\nkotlinx/serialization/json/JsonElementBuildersKt\n*L\n1#1,48:1\n28#2,4:49\n*S KotlinDebug\n*F\n+ 1 OriginPermissionChecker.kt\norg/merlyn/desktopapp/checker/OriginPermissionChecker\n*L\n43#1:49,4\n*E\n"})
public final class OriginPermissionChecker
implements Checker {
    @NotNull
    private final ObserveAccessibilityPermissionsUseCase observeAccessibilityPermissionsUseCase;
    @NotNull
    private final ObserveMicrophonePermissionsStateUseCase observeMicrophonePermissionsStateUseCase;

    public OriginPermissionChecker(@NotNull ObserveAccessibilityPermissionsUseCase observeAccessibilityPermissionsUseCase, @NotNull ObserveMicrophonePermissionsStateUseCase observeMicrophonePermissionsStateUseCase) {
        Intrinsics.checkNotNullParameter((Object)observeAccessibilityPermissionsUseCase, (String)"observeAccessibilityPermissionsUseCase");
        Intrinsics.checkNotNullParameter((Object)observeMicrophonePermissionsStateUseCase, (String)"observeMicrophonePermissionsStateUseCase");
        this.observeAccessibilityPermissionsUseCase = observeAccessibilityPermissionsUseCase;
        this.observeMicrophonePermissionsStateUseCase = observeMicrophonePermissionsStateUseCase;
    }

    @Nullable
    public Object check(@NotNull Continuation<? super CheckResult> $completion) {
        StateFlow accessibility = this.observeAccessibilityPermissionsUseCase.getAccessibilityPermissionsAreGranted();
        StateFlow micro = this.observeMicrophonePermissionsStateUseCase.getHasRecordPermissions();
        Object[] objectArray = new String[]{"Accessibility permission granted: " + ((Boolean)accessibility.getValue() != false ? "yes" : "no"), "Microphone permission granted: " + ((Boolean)micro.getValue() != false ? "yes" : "no")};
        return new CheckResult((Boolean)accessibility.getValue() != false && (Boolean)micro.getValue() != false, 0, CollectionsKt.listOf((Object[])objectArray));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public CheckerConfig configuration() {
        void $this$configuration_u24lambda_u240;
        JsonObjectBuilder builder$iv;
        List list = CollectionsKt.listOf((Object)"Some permissions have not been granted for Origin");
        boolean $i$f$buildJsonObject = false;
        JsonObjectBuilder jsonObjectBuilder = builder$iv = new JsonObjectBuilder();
        String string = "text";
        CheckerMessages checkerMessages = new CheckerMessages("Permissions have been granted for Origin", list, "Checking system permissions are granted for Origin");
        boolean bl = false;
        JsonElementBuildersKt.put((JsonObjectBuilder)$this$configuration_u24lambda_u240, (String)"title", (String)"Provide the relevant permissions to the Desktop App");
        Unit unit = Unit.INSTANCE;
        JsonObject jsonObject = builder$iv.build();
        String string2 = string;
        List list2 = CollectionsKt.listOf((Object)new Help(string2, jsonObject));
        CheckerMessages checkerMessages2 = checkerMessages;
        return new CheckerConfig(checkerMessages2, list2);
    }
}

