/*
 * Decompiled with CFR 0.152.
 */
package org.merlyn.desktopapp.config;

import com.sksamuel.hoplite.ClasspathResourceLoader;
import com.sksamuel.hoplite.ConfigLoader;
import com.sksamuel.hoplite.ConfigLoaderBuilder;
import com.sksamuel.hoplite.ConfigLoaderBuilderExtensionsKt;
import com.sksamuel.hoplite.ConfigSource;
import com.sksamuel.hoplite.PropertySource;
import com.sksamuel.hoplite.sources.EnvironmentVariablesPropertySource;
import com.sksamuel.hoplite.watch.ReloadableConfig;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.merlyn.desktopapp.config.AppConfig;
import org.merlyn.desktopapp.config.AppEnvironment;
import org.merlyn.desktopapp.config.EnvironmentConfig;
import org.merlyn.desktopapp.config.GetAppConfigLoaderBuilderKt;
import org.merlyn.desktopapp.config.StageConfigKt;
import org.merlyn.sharedui.regionselection.Region;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u000f\u001a\u00020\nJ\u0006\u0010\u0010\u001a\u00020\fJ\b\u0010\u0011\u001a\u00020\u0012H\u0002J\u000e\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/merlyn/desktopapp/config/StageConfig;", "", "interval", "Lkotlin/time/Duration;", "region", "Lorg/merlyn/sharedui/regionselection/Region;", "<init>", "(JLorg/merlyn/sharedui/regionselection/Region;Lkotlin/jvm/internal/DefaultConstructorMarker;)V", "appConfig", "Ljava/util/concurrent/atomic/AtomicReference;", "Lorg/merlyn/desktopapp/config/AppConfig;", "envConfig", "Lorg/merlyn/desktopapp/config/EnvironmentConfig;", "appConfigReloader", "Lcom/sksamuel/hoplite/watch/ReloadableConfig;", "getApplicationConfig", "getEnvironmentConfig", "loadEnvConfig", "", "updateEnvironment", "appEnvironment", "Lorg/merlyn/desktopapp/config/AppEnvironment;", "Companion", "app"})
@SourceDebugExtension(value={"SMAP\nStageConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StageConfig.kt\norg/merlyn/desktopapp/config/StageConfig\n+ 2 ConfigLoader.kt\ncom/sksamuel/hoplite/ConfigLoader\n*L\n1#1,176:1\n78#2,13:177\n124#2:190\n*S KotlinDebug\n*F\n+ 1 StageConfig.kt\norg/merlyn/desktopapp/config/StageConfig\n*L\n168#1:177,13\n168#1:190\n*E\n"})
public final class StageConfig {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Region region;
    @NotNull
    private final AtomicReference<AppConfig> appConfig;
    @NotNull
    private final AtomicReference<EnvironmentConfig> envConfig;
    @NotNull
    private final ReloadableConfig<AppConfig> appConfigReloader;
    @NotNull
    public static final String ENV_VARS_PREFIX = "merlyn_";

    private StageConfig(long interval, Region region) {
        Intrinsics.checkNotNullParameter((Object)region, (String)"region");
        this.region = region;
        this.appConfig = new AtomicReference();
        this.envConfig = new AtomicReference();
        this.appConfigReloader = new ReloadableConfig(GetAppConfigLoaderBuilderKt.getAppConfigLoaderBuilder(), Reflection.getOrCreateKotlinClass(AppConfig.class)).addInterval-LRDsOJo(interval);
        this.appConfig.set((AppConfig)this.appConfigReloader.getLatest());
        this.loadEnvConfig();
        this.appConfigReloader.subscribe(arg_0 -> StageConfig._init_$lambda$0(this, arg_0));
    }

    @NotNull
    public final AppConfig getApplicationConfig() {
        AppConfig appConfig = this.appConfig.get();
        Intrinsics.checkNotNullExpressionValue((Object)appConfig, (String)"get(...)");
        return appConfig;
    }

    @NotNull
    public final EnvironmentConfig getEnvironmentConfig() {
        EnvironmentConfig environmentConfig = this.envConfig.get();
        Intrinsics.checkNotNullExpressionValue((Object)environmentConfig, (String)"get(...)");
        return environmentConfig;
    }

    /*
     * WARNING - void declaration
     */
    private final void loadEnvConfig() {
        void this_$iv;
        ConfigLoaderBuilder builder = ConfigLoaderBuilder.Companion.default().addPropertySource((PropertySource)new EnvironmentVariablesPropertySource(true, true, null, ENV_VARS_PREFIX, 4, null));
        if (this.getApplicationConfig().getAppEnv() == AppEnvironment.LOCAL) {
            ConfigLoaderBuilderExtensionsKt.addMapSource((ConfigLoaderBuilder)builder, (Map)MapsKt.mapOf((Pair)TuplesKt.to((Object)"cloudUrl", (Object)"ws://localhost:3000")));
        }
        ConfigLoader configLoader = ConfigLoaderBuilderExtensionsKt.addResourceSource$default((ConfigLoaderBuilder)builder, (String)StageConfigKt.getFile(this.getApplicationConfig().getAppEnv(), this.region), (boolean)false, (boolean)false, (int)6, null).build();
        Object[] resourceOrFiles$iv = new String[]{};
        boolean $i$f$loadConfigOrThrow = false;
        List resourceOrFiles$iv$iv = ArraysKt.toList((Object[])resourceOrFiles$iv);
        ClasspathResourceLoader classpathResourceLoader$iv$iv = ClasspathResourceLoader.Companion.toClasspathResourceLoader(ConfigSource.Companion.class);
        boolean $i$f$loadConfigOrThrow2 = false;
        void this_$iv$iv$iv = this_$iv;
        boolean $i$f$loadConfig = false;
        this.envConfig.set((EnvironmentConfig)this_$iv.returnOrThrow(this_$iv$iv$iv.loadConfig(Reflection.getOrCreateKotlinClass(EnvironmentConfig.class), CollectionsKt.emptyList(), resourceOrFiles$iv$iv, classpathResourceLoader$iv$iv)));
    }

    public final void updateEnvironment(@NotNull AppEnvironment appEnvironment) {
        Intrinsics.checkNotNullParameter((Object)((Object)appEnvironment), (String)"appEnvironment");
        System.setProperty("config.override.appEnv", appEnvironment.name());
    }

    private static final Unit _init_$lambda$0(StageConfig this$0, AppConfig it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.appConfig.set(it);
        this$0.loadEnvConfig();
        return Unit.INSTANCE;
    }

    public /* synthetic */ StageConfig(long interval, Region region, DefaultConstructorMarker $constructor_marker) {
        this(interval, region);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/merlyn/desktopapp/config/StageConfig$Companion;", "", "<init>", "()V", "ENV_VARS_PREFIX", "", "app"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

