/*
 * Decompiled with CFR 0.152.
 */
package org.merlyn.desktopapp.coresdk.agent.impl;

import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.serialization.json.JsonObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.merlyn.agent.Action;
import org.merlyn.agent.ActionContext;
import org.merlyn.agent.Intent;
import org.merlyn.agent.IntentContext;
import org.merlyn.agent.KeyEvent;
import org.merlyn.agent.KeyEventAction;
import org.merlyn.agent.KeyEventContext;
import org.merlyn.desktopapp.config.remote.RemoteConfig;
import org.merlyn.desktopapp.config.remote.RemoteConfigFlags;
import org.merlyn.desktopapp.coresdk.agent.DesktopAppAgent;
import org.merlyn.desktopapp.coresdk.rcu.KeyCode;
import org.merlyn.sharedui.viewmodels.usecases.HideSpotlightUseCase;
import org.merlyn.sharedui.viewmodels.usecases.ShowSpotlightUseCase;
import org.merlyn.sharedui.viewmodels.usecases.UndoSpotlightUseCase;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 $2\u00020\u0001:\u0001$B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0016J\u0016\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0096@\u00a2\u0006\u0002\u0010\u001bJ\u001e\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0096@\u00a2\u0006\u0002\u0010!J\b\u0010\"\u001a\u00020\u0018H\u0002J\b\u0010#\u001a\u00020\u0018H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\rX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\rX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u000f\"\u0004\b\u0012\u0010\u0013\u00a8\u0006%"}, d2={"Lorg/merlyn/desktopapp/coresdk/agent/impl/SpotlightAgent;", "Lorg/merlyn/desktopapp/coresdk/agent/DesktopAppAgent;", "showSpotlightUseCase", "Lorg/merlyn/sharedui/viewmodels/usecases/ShowSpotlightUseCase;", "hideSpotlightUseCase", "Lorg/merlyn/sharedui/viewmodels/usecases/HideSpotlightUseCase;", "undoSpotlightUseCase", "Lorg/merlyn/sharedui/viewmodels/usecases/UndoSpotlightUseCase;", "remoteConfig", "Lorg/merlyn/desktopapp/config/remote/RemoteConfig;", "<init>", "(Lorg/merlyn/sharedui/viewmodels/usecases/ShowSpotlightUseCase;Lorg/merlyn/sharedui/viewmodels/usecases/HideSpotlightUseCase;Lorg/merlyn/sharedui/viewmodels/usecases/UndoSpotlightUseCase;Lorg/merlyn/desktopapp/config/remote/RemoteConfig;)V", "agentName", "", "getAgentName", "()Ljava/lang/String;", "agentVersion", "getAgentVersion", "setAgentVersion", "(Ljava/lang/String;)V", "getManagedShortPressKeyCodes", "", "Lorg/merlyn/desktopapp/coresdk/rcu/KeyCode;", "handleKeyEvent", "", "event", "Lorg/merlyn/desktopapp/coresdk/rcu/KeyEvent;", "(Lorg/merlyn/desktopapp/coresdk/rcu/KeyEvent;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "handleIntent", "intent", "Lorg/merlyn/agent/Intent;", "intentContext", "Lorg/merlyn/agent/IntentContext;", "(Lorg/merlyn/agent/Intent;Lorg/merlyn/agent/IntentContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "openSpotlight", "closeSpotlight", "Companion", "app"})
public final class SpotlightAgent
implements DesktopAppAgent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ShowSpotlightUseCase showSpotlightUseCase;
    @NotNull
    private final HideSpotlightUseCase hideSpotlightUseCase;
    @NotNull
    private final UndoSpotlightUseCase undoSpotlightUseCase;
    @NotNull
    private final RemoteConfig remoteConfig;
    @NotNull
    private final String agentName;
    @NotNull
    private String agentVersion;
    @NotNull
    public static final String AGENT_NAME = "DesktopSpotlightAgent";
    @NotNull
    public static final String AGENT_VERSION = "1.0.0";

    public SpotlightAgent(@NotNull ShowSpotlightUseCase showSpotlightUseCase, @NotNull HideSpotlightUseCase hideSpotlightUseCase, @NotNull UndoSpotlightUseCase undoSpotlightUseCase, @NotNull RemoteConfig remoteConfig) {
        Intrinsics.checkNotNullParameter((Object)showSpotlightUseCase, (String)"showSpotlightUseCase");
        Intrinsics.checkNotNullParameter((Object)hideSpotlightUseCase, (String)"hideSpotlightUseCase");
        Intrinsics.checkNotNullParameter((Object)undoSpotlightUseCase, (String)"undoSpotlightUseCase");
        Intrinsics.checkNotNullParameter((Object)remoteConfig, (String)"remoteConfig");
        this.showSpotlightUseCase = showSpotlightUseCase;
        this.hideSpotlightUseCase = hideSpotlightUseCase;
        this.undoSpotlightUseCase = undoSpotlightUseCase;
        this.remoteConfig = remoteConfig;
        this.agentName = AGENT_NAME;
        this.agentVersion = AGENT_VERSION;
    }

    @NotNull
    public String getAgentName() {
        return this.agentName;
    }

    @Override
    @NotNull
    public String getAgentVersion() {
        return this.agentVersion;
    }

    @Override
    public void setAgentVersion(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.agentVersion = string;
    }

    @Override
    @NotNull
    public Set<KeyCode> getManagedShortPressKeyCodes() {
        return SetsKt.setOf((Object)((Object)KeyCode.BACK));
    }

    @Override
    @Nullable
    public Object handleKeyEvent(@NotNull org.merlyn.desktopapp.coresdk.rcu.KeyEvent event, @NotNull Continuation<? super Unit> $completion) {
        if (event.getKeyCode() == KeyCode.BACK && event.getKeyAction() == KeyEventAction.Up) {
            RemoteConfigFlags remoteConfigFlags = this.remoteConfig.get();
            boolean bl = remoteConfigFlags != null ? remoteConfigFlags.getEnableSpotlight() : false;
            if (bl) {
                this.undoSpotlightUseCase.invoke();
            }
        }
        return Unit.INSTANCE;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    public Object handleIntent(@NotNull Intent intent, @NotNull IntentContext intentContext, @NotNull Continuation<? super Unit> $completion) {
        String string = intent.getIntent();
        if (Intrinsics.areEqual((Object)string, (Object)"OPEN")) {
            RemoteConfigFlags remoteConfigFlags = this.remoteConfig.get();
            boolean bl = remoteConfigFlags != null ? remoteConfigFlags.getEnableSpotlight() : false;
            if (bl) {
                this.openSpotlight();
                return Unit.INSTANCE;
            }
            Object object = DesktopAppAgent.DefaultImpls.handleIntent(this, intent, intentContext, $completion);
            if (object != IntrinsicsKt.getCOROUTINE_SUSPENDED()) return Unit.INSTANCE;
            return object;
        }
        if (Intrinsics.areEqual((Object)string, (Object)"CLOSE")) {
            this.closeSpotlight();
            return Unit.INSTANCE;
        }
        Object object = DesktopAppAgent.DefaultImpls.handleIntent(this, intent, intentContext, $completion);
        if (object != IntrinsicsKt.getCOROUTINE_SUSPENDED()) return Unit.INSTANCE;
        return object;
    }

    private final void openSpotlight() {
        this.showSpotlightUseCase.invoke();
    }

    private final void closeSpotlight() {
        this.hideSpotlightUseCase.invoke();
    }

    @Override
    @NotNull
    public Set<KeyCode> getManagedLongPressKeyCodes() {
        return DesktopAppAgent.DefaultImpls.getManagedLongPressKeyCodes(this);
    }

    @Nullable
    public Object handleKeyEvent(@NotNull KeyEvent keyEvent, @NotNull KeyEventContext keyEventContext, @NotNull Continuation<? super Unit> $completion) {
        return DesktopAppAgent.DefaultImpls.handleKeyEvent(this, keyEvent, keyEventContext, $completion);
    }

    @Override
    @Nullable
    public Object handleLongPressEvent(@NotNull org.merlyn.desktopapp.coresdk.rcu.KeyEvent event, @NotNull Continuation<? super Unit> $completion) {
        return DesktopAppAgent.DefaultImpls.handleLongPressEvent(this, event, $completion);
    }

    @Nullable
    public Object handleAction(@NotNull Action action, @NotNull ActionContext actionContext, @NotNull Continuation<? super Unit> $completion) {
        return DesktopAppAgent.DefaultImpls.handleAction(this, action, actionContext, $completion);
    }

    @Nullable
    public StateFlow<JsonObject> getAgentContext() {
        return DesktopAppAgent.DefaultImpls.getAgentContext(this);
    }

    @NotNull
    public List<String> getKeyCodes() {
        return DesktopAppAgent.DefaultImpls.getKeyCodes(this);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/merlyn/desktopapp/coresdk/agent/impl/SpotlightAgent$Companion;", "", "<init>", "()V", "AGENT_NAME", "", "AGENT_VERSION", "app"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

