/*
 * Decompiled with CFR 0.152.
 */
package org.merlyn.desktopapp.dataplatform;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.merlyn.core.analytics.AnalyticsLogger;
import org.merlyn.dataplatform.EventBuilder;
import org.merlyn.dataplatform.ModalityType;
import org.merlyn.dataplatform.OutcomeType;
import org.merlyn.desktopapp.dataplatform.DataPlatformEvents;
import org.merlyn.desktopapp.service.rcu.DeviceSpecs;
import org.merlyn.sharedui.fxviews.ftue.FtuePageId;
import org.merlyn.sharedui.fxviews.models.TimerViewState;
import org.merlyn.sharedui.utils.AnnotationsEvents;
import org.merlyn.sharedui.utils.ClickEvents;
import org.merlyn.sharedui.utils.DrawableOverlayEvents;
import org.merlyn.sharedui.utils.SpotlightEvents;
import org.merlyn.sharedui.viewmodels.usecases.LoginState;
import org.merlyn.sharedui.viewmodels.usecases.ObserveLoginStateUseCaseKt;
import org.merlyn.sharedui.viewmodels.usecases.ObserveWebServerStartedUseCase;
import org.merlyn.sharedui.viewmodels.usecases.StatusDiagnosticEvents;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 U2\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u00042\u00020\u0005:\u0001UB\u000f\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\rH\u0016J\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\rH\u0016J\u0010\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\rH\u0016J\u0010\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\rH\u0016J\u0010\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\rH\u0016J\b\u0010\u001b\u001a\u00020\u000bH\u0016J\u0010\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\rH\u0016J\u0010\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J \u0010 \u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"2\u0006\u0010$\u001a\u00020\"H\u0016J\b\u0010%\u001a\u00020\u000bH\u0016J\u0018\u0010&\u001a\u00020\u000b2\u0006\u0010'\u001a\u00020\"2\u0006\u0010(\u001a\u00020\"H\u0016J\b\u0010)\u001a\u00020\u000bH\u0016J \u0010*\u001a\u00020\u000b2\u0006\u0010'\u001a\u00020\"2\u0006\u0010(\u001a\u00020\"2\u0006\u0010+\u001a\u00020,H\u0016J\b\u0010-\u001a\u00020\u000bH\u0016J\u0010\u0010.\u001a\u00020\u000b2\u0006\u0010/\u001a\u00020\rH\u0016J\u0018\u00100\u001a\u00020\u000b2\u0006\u00101\u001a\u00020\"2\u0006\u0010\u0017\u001a\u00020\rH\u0002J\u0018\u00102\u001a\u00020\u000b2\u0006\u00103\u001a\u0002042\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u00105\u001a\u00020\u000b2\u0006\u00106\u001a\u000207H\u0016J\u0010\u00108\u001a\u00020\u000b2\u0006\u00109\u001a\u00020\"H\u0016J\u001a\u00108\u001a\u00020\u000b2\u0006\u00109\u001a\u00020\"2\b\u0010:\u001a\u0004\u0018\u00010;H\u0016J\u0010\u0010<\u001a\u00020\u000b2\u0006\u0010=\u001a\u00020\rH\u0016J\u0010\u0010>\u001a\u00020\u000b2\u0006\u0010?\u001a\u00020\rH\u0016J\u0010\u0010@\u001a\u00020\u000b2\u0006\u0010A\u001a\u00020BH\u0016J\u0010\u0010C\u001a\u00020\u000b2\u0006\u0010D\u001a\u00020EH\u0016J\u0010\u0010F\u001a\u00020\u000b2\u0006\u0010G\u001a\u00020\"H\u0016J\u0010\u0010H\u001a\u00020\u000b2\u0006\u0010I\u001a\u00020\"H\u0016J\u001f\u0010J\u001a\u00020\u000b2\u0006\u0010K\u001a\u00020L2\b\u0010M\u001a\u0004\u0018\u00010\rH\u0016\u00a2\u0006\u0002\u0010NJ\u0010\u0010O\u001a\u00020\u000b2\u0006\u0010D\u001a\u00020EH\u0016J\u0010\u0010P\u001a\u00020\u000b2\u0006\u0010I\u001a\u00020\"H\u0016J\b\u0010Q\u001a\u00020\u000bH\u0016J\b\u0010R\u001a\u00020\u000bH\u0016J\b\u0010S\u001a\u00020\u000bH\u0016J\u0010\u0010T\u001a\u00020\u000b2\u0006\u0010K\u001a\u00020LH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006V"}, d2={"Lorg/merlyn/desktopapp/dataplatform/DataPlatformEventsImpl;", "Lorg/merlyn/desktopapp/dataplatform/DataPlatformEvents;", "Lorg/merlyn/sharedui/utils/ClickEvents;", "Lorg/merlyn/sharedui/viewmodels/usecases/StatusDiagnosticEvents;", "Lorg/merlyn/sharedui/utils/AnnotationsEvents;", "Lorg/merlyn/sharedui/utils/SpotlightEvents;", "analyticsLogger", "Lorg/merlyn/core/analytics/AnalyticsLogger;", "<init>", "(Lorg/merlyn/core/analytics/AnalyticsLogger;)V", "chatMuted", "", "muted", "", "chatOpened", "isOpen", "dongleSpecs", "specs", "Lorg/merlyn/desktopapp/service/rcu/DeviceSpecs;", "remoteSpecs", "dongleAttached", "isAttached", "accessKeyEvents", "enabled", "accessMic", "browserConnected", "isConnected", "browserConnectionRejected", "cloudConnected", "serverStatus", "status", "Lorg/merlyn/sharedui/viewmodels/usecases/ObserveWebServerStartedUseCase$Status;", "updateCapabilities", "os", "", "currentVersion", "capabilities", "updateAvailable", "updateIgnored", "fromVersion", "toVersion", "updatePerformed", "updateFailed", "attempt", "", "firmwareUpdateAvailable", "firmwareUpdatePerformed", "isSuccess", "binaryEvent", "eventName", "registerSpecs", "eventBuilder", "Lorg/merlyn/dataplatform/EventBuilder;", "userLogin", "loginState", "Lorg/merlyn/sharedui/viewmodels/usecases/LoginState;", "track", "buttonId", "timerViewState", "Lorg/merlyn/sharedui/fxviews/models/TimerViewState;", "trackFtueCompleted", "ftueCompleted", "trackFtueRemind", "rcuBackButton", "trackFtuePageChange", "ftuePageId", "Lorg/merlyn/sharedui/fxviews/ftue/FtuePageId;", "trackAnnotationsVisibility", "visibility", "Lorg/merlyn/sharedui/utils/DrawableOverlayEvents$Visibility;", "trackAnnotationsColor", "color", "trackAnnotationsTool", "tool", "trackAnnotationsAction", "action", "Lorg/merlyn/sharedui/utils/DrawableOverlayEvents$Action;", "explicit", "(Lorg/merlyn/sharedui/utils/DrawableOverlayEvents$Action;Ljava/lang/Boolean;)V", "trackSpotlightVisibility", "trackSpotlightTool", "trackSpotlightSearch", "trackSpotlightPermissionError", "trackSpotlightStartError", "trackSpotlightAction", "Companion", "app"})
public final class DataPlatformEventsImpl
implements DataPlatformEvents,
ClickEvents,
StatusDiagnosticEvents,
AnnotationsEvents,
SpotlightEvents {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AnalyticsLogger analyticsLogger;
    @NotNull
    public static final String BUTTON_CLICK_EVENT_TYPE = "ButtonClick";
    @NotNull
    public static final String CHAT_MUTED_EVENT_TYPE = "ChatMuted";
    @NotNull
    public static final String CHAT_OPENED_EVENT_TYPE = "ChatOpened";
    @NotNull
    public static final String CHAT_CLOSED_EVENT_TYPE = "ChatClosed";
    @NotNull
    public static final String FTUE_COMPLETED_EVENT_TYPE = "FtueCompleted";
    @NotNull
    public static final String FTUE_PAGE_CHANGE_EVENT_TYPE = "FtuePageChange";
    @NotNull
    public static final String FTUE_REMIND_EVENT_TYPE = "FtueRemind";
    @NotNull
    public static final String BUTTON_ID = "buttonId";
    @NotNull
    public static final String CHAT_MUTED = "muted";
    @NotNull
    public static final String TIMER_ID = "timerId";
    @NotNull
    public static final String TIMER_IS_PAUSED = "timerPaused";
    @NotNull
    public static final String TIMER_IS_FINISHED = "timerFinished";
    @NotNull
    public static final String TIMER_TIME = "timerTime";
    @NotNull
    public static final String FTUE_PAGE_ID = "ftuePageId";
    @NotNull
    public static final String FTUE_FINISHED = "ftueFinished";
    @NotNull
    public static final String DONGLE_ATTACHED = "usbDongleIn";
    @NotNull
    public static final String DONGLE_DETTACHED = "usbDongleOut";
    @NotNull
    public static final String ACCESS_KEYEVENTS = "accessKeyEvents";
    @NotNull
    public static final String ACCESS_MIC = "accessMic";
    @NotNull
    public static final String LOGIN = "login";
    @NotNull
    public static final String LOGOUT = "logout";
    @NotNull
    public static final String SUBSCRIPTION = "validSubscription";
    @NotNull
    public static final String BROWSER_CONNECTED = "chromeExtensionConnected";
    @NotNull
    public static final String CLOUD_CONNECTED = "cloudConnected";
    @NotNull
    public static final String SERVER_STARTED = "serverStarted";
    @NotNull
    public static final String CAUSE = "cause";
    @NotNull
    public static final String UPDATE_CAPABILITIES = "updateCapabilities";
    @NotNull
    public static final String OS = "os";
    @NotNull
    public static final String CURRENT_VERSION = "currentVersion";
    @NotNull
    public static final String CAPABILITIES = "capabilities";
    @NotNull
    public static final String UPDATE_DETECTED = "updateDetected";
    @NotNull
    public static final String UPDATE_IGNORED = "updateIgnored";
    @NotNull
    public static final String REASON = "reason";
    @NotNull
    public static final String USER_PERMISSIONS = "userPermissions";
    @NotNull
    public static final String UPDATE_EXECUTED = "updateExecuted";
    @NotNull
    public static final String UPDATE_FAILED = "updateFailed";
    @NotNull
    public static final String FROM_VERSION = "fromVersion";
    @NotNull
    public static final String TO_VERSION = "toVersion";
    @NotNull
    public static final String ATTEMPT = "attempt";
    @NotNull
    public static final String FIRMWARE_UPDATE_DETECTED = "firmwareUpdateDetected";
    @NotNull
    public static final String FIRMWARE_UPDATE_EXECUTED = "firmwareUpdateExecuted";
    @NotNull
    public static final String BROWSER_CONNECTION_REJECTED = "chromeExtensionConnectionRejected";
    @NotNull
    public static final String RCU_DONGLE_DATA = "rcuDongle";
    @NotNull
    public static final String RCU_REMOTE_DATA = "rcuRemote";
    @NotNull
    public static final String HW_VERSION = "hwVersion";
    @NotNull
    public static final String FW_VERSION = "fwVersion";
    @NotNull
    public static final String ANNOTATIONS_VISIBILITY_EVENT_TYPE = "annotationsVisibility";
    @NotNull
    public static final String ANNOTATIONS_VISIBILITY_OPERATION = "operation";
    @NotNull
    public static final String ANNOTATIONS_COLOR_EVENT_TYPE = "annotationsSelectColor";
    @NotNull
    public static final String ANNOTATIONS_COLOR = "color";
    @NotNull
    public static final String ANNOTATIONS_TOOL_EVENT_TYPE = "annotationsSelectTool";
    @NotNull
    public static final String ANNOTATIONS_TOOL = "tool";
    @NotNull
    public static final String ANNOTATIONS_ACTION_EVENT_TYPE = "annotationsAction";
    @NotNull
    public static final String ANNOTATIONS_ACTION = "action";
    @NotNull
    public static final String ANNOTATIONS_ACTION_EXPLICIT = "explicit";
    @NotNull
    public static final String SPOTLIGHT_VISIBILITY_EVENT_TYPE = "spotlightVisibility";
    @NotNull
    public static final String SPOTLIGHT_VISIBILITY_OPERATION = "operation";
    @NotNull
    public static final String SPOTLIGHT_TOOL_EVENT_TYPE = "spotlightSelectTool";
    @NotNull
    public static final String SPOTLIGHT_TOOL = "tool";
    @NotNull
    public static final String SPOTLIGHT_SEARCH = "spotlightSearch";
    @NotNull
    public static final String SPOTLIGHT_PERMISSIONS_ERROR = "spotlightPermissionsError";
    @NotNull
    public static final String SPOTLIGHT_START_ERROR = "spotlightStartError";
    @NotNull
    public static final String SPOTLIGHT_ACTION_EVENT_TYPE = "spotlightAction";
    @NotNull
    public static final String SPOTLIGHT_ACTION = "action";

    public DataPlatformEventsImpl(@NotNull AnalyticsLogger analyticsLogger) {
        Intrinsics.checkNotNullParameter((Object)analyticsLogger, (String)"analyticsLogger");
        this.analyticsLogger = analyticsLogger;
    }

    @Override
    public void chatMuted(boolean muted) {
        this.analyticsLogger.log(EventBuilder.Companion.create(CHAT_MUTED_EVENT_TYPE).set(CHAT_MUTED, String.valueOf(muted)));
    }

    @Override
    public void chatOpened(boolean isOpen) {
        String eventType = isOpen ? CHAT_OPENED_EVENT_TYPE : CHAT_CLOSED_EVENT_TYPE;
        this.analyticsLogger.log(EventBuilder.Companion.create(eventType));
    }

    @Override
    public void dongleSpecs(@NotNull DeviceSpecs specs) {
        Intrinsics.checkNotNullParameter((Object)specs, (String)"specs");
        this.registerSpecs(EventBuilder.Companion.create(RCU_DONGLE_DATA), specs);
    }

    @Override
    public void remoteSpecs(@NotNull DeviceSpecs specs) {
        Intrinsics.checkNotNullParameter((Object)specs, (String)"specs");
        this.registerSpecs(EventBuilder.Companion.create(RCU_REMOTE_DATA), specs);
    }

    public void dongleAttached(boolean isAttached) {
        this.analyticsLogger.log(EventBuilder.Companion.create(isAttached ? DONGLE_ATTACHED : DONGLE_DETTACHED));
    }

    public void accessKeyEvents(boolean enabled) {
        this.binaryEvent(ACCESS_KEYEVENTS, enabled);
    }

    public void accessMic(boolean enabled) {
        this.binaryEvent(ACCESS_MIC, enabled);
    }

    public void browserConnected(boolean isConnected) {
        this.binaryEvent(BROWSER_CONNECTED, isConnected);
    }

    public void browserConnectionRejected() {
        this.analyticsLogger.log(EventBuilder.Companion.create(BROWSER_CONNECTION_REJECTED));
    }

    public void cloudConnected(boolean isConnected) {
        this.binaryEvent(CLOUD_CONNECTED, isConnected);
    }

    public void serverStatus(@NotNull ObserveWebServerStartedUseCase.Status status) {
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        EventBuilder eventBuilder = EventBuilder.Companion.create(SERVER_STARTED);
        switch (WhenMappings.$EnumSwitchMapping$0[status.ordinal()]) {
            case 1: {
                return;
            }
            case 2: {
                EventBuilder eventBuilder2 = eventBuilder.setOutcomeType(OutcomeType.CONSUMED);
                break;
            }
            default: {
                eventBuilder.setOutcomeType(OutcomeType.FAILED);
                EventBuilder eventBuilder2 = eventBuilder.set(CAUSE, status.name());
            }
        }
        this.analyticsLogger.log(eventBuilder);
    }

    public void updateCapabilities(@NotNull String os, @NotNull String currentVersion, @NotNull String capabilities) {
        Intrinsics.checkNotNullParameter((Object)os, (String)OS);
        Intrinsics.checkNotNullParameter((Object)currentVersion, (String)CURRENT_VERSION);
        Intrinsics.checkNotNullParameter((Object)capabilities, (String)CAPABILITIES);
        this.analyticsLogger.log(EventBuilder.Companion.create(UPDATE_CAPABILITIES).set(OS, os).set(CURRENT_VERSION, currentVersion).set(CAPABILITIES, capabilities));
    }

    public void updateAvailable() {
        this.analyticsLogger.log(EventBuilder.Companion.create(UPDATE_DETECTED));
    }

    public void updateIgnored(@NotNull String fromVersion, @NotNull String toVersion) {
        Intrinsics.checkNotNullParameter((Object)fromVersion, (String)FROM_VERSION);
        Intrinsics.checkNotNullParameter((Object)toVersion, (String)TO_VERSION);
        this.analyticsLogger.log(EventBuilder.Companion.create(UPDATE_IGNORED).set(FROM_VERSION, fromVersion).set(TO_VERSION, toVersion).set(REASON, USER_PERMISSIONS));
    }

    public void updatePerformed() {
        this.analyticsLogger.log(EventBuilder.Companion.create(UPDATE_EXECUTED));
    }

    public void updateFailed(@NotNull String fromVersion, @NotNull String toVersion, int attempt) {
        Intrinsics.checkNotNullParameter((Object)fromVersion, (String)FROM_VERSION);
        Intrinsics.checkNotNullParameter((Object)toVersion, (String)TO_VERSION);
        this.analyticsLogger.log(EventBuilder.Companion.create(UPDATE_FAILED).set(FROM_VERSION, fromVersion).set(TO_VERSION, toVersion).set(ATTEMPT, attempt));
    }

    public void firmwareUpdateAvailable() {
        this.analyticsLogger.log(EventBuilder.Companion.create(FIRMWARE_UPDATE_DETECTED));
    }

    public void firmwareUpdatePerformed(boolean isSuccess) {
        this.binaryEvent(FIRMWARE_UPDATE_EXECUTED, isSuccess);
    }

    private final void binaryEvent(String eventName, boolean enabled) {
        EventBuilder eventBuilder = EventBuilder.Companion.create(eventName);
        eventBuilder.setOutcomeType(enabled ? OutcomeType.CONSUMED : OutcomeType.FAILED);
        this.analyticsLogger.log(eventBuilder);
    }

    private final void registerSpecs(EventBuilder eventBuilder, DeviceSpecs specs) {
        eventBuilder.set(HW_VERSION, specs.getHardwareVersion-wnDlQe8());
        eventBuilder.set(FW_VERSION, specs.getFirmwareVersion-joqIrf8());
        this.analyticsLogger.log(eventBuilder);
    }

    public void userLogin(@NotNull LoginState loginState) {
        Intrinsics.checkNotNullParameter((Object)loginState, (String)"loginState");
        if (ObserveLoginStateUseCaseKt.isLoggedIn((LoginState)loginState)) {
            EventBuilder eventBuilder = EventBuilder.Companion.create(LOGIN);
            eventBuilder.set(SUBSCRIPTION, String.valueOf(ObserveLoginStateUseCaseKt.getHasValidLicense((LoginState)loginState)));
            this.analyticsLogger.log(eventBuilder);
        } else {
            this.analyticsLogger.log(EventBuilder.Companion.create(LOGOUT));
        }
    }

    public void track(@NotNull String buttonId) {
        Intrinsics.checkNotNullParameter((Object)buttonId, (String)BUTTON_ID);
        this.analyticsLogger.log(EventBuilder.Companion.create(BUTTON_CLICK_EVENT_TYPE).set(BUTTON_ID, buttonId));
    }

    public void track(@NotNull String buttonId, @Nullable TimerViewState timerViewState) {
        Intrinsics.checkNotNullParameter((Object)buttonId, (String)BUTTON_ID);
        EventBuilder builder = EventBuilder.Companion.create(BUTTON_CLICK_EVENT_TYPE).set(BUTTON_ID, buttonId);
        TimerViewState timerViewState2 = timerViewState;
        if (timerViewState2 != null) {
            TimerViewState it = timerViewState2;
            boolean bl = false;
            builder.set(TIMER_ID, it.getId());
            builder.set(TIMER_IS_PAUSED, it.isPaused());
            builder.set(TIMER_IS_FINISHED, it.isFinished());
            builder.set(TIMER_TIME, it.getTime());
        }
        this.analyticsLogger.log(builder);
    }

    public void trackFtueCompleted(boolean ftueCompleted) {
        this.analyticsLogger.log(EventBuilder.Companion.create(FTUE_COMPLETED_EVENT_TYPE).set(FTUE_FINISHED, ftueCompleted));
    }

    public void trackFtueRemind(boolean rcuBackButton) {
        EventBuilder builder = EventBuilder.Companion.create(FTUE_REMIND_EVENT_TYPE);
        if (rcuBackButton) {
            builder.setModalityType(ModalityType.RCU);
        }
        this.analyticsLogger.log(builder);
    }

    public void trackFtuePageChange(@NotNull FtuePageId ftuePageId) {
        Intrinsics.checkNotNullParameter((Object)ftuePageId, (String)FTUE_PAGE_ID);
        this.analyticsLogger.log(EventBuilder.Companion.create(FTUE_PAGE_CHANGE_EVENT_TYPE).set(FTUE_PAGE_ID, ftuePageId.name()));
    }

    public void trackAnnotationsVisibility(@NotNull DrawableOverlayEvents.Visibility visibility) {
        Intrinsics.checkNotNullParameter((Object)visibility, (String)"visibility");
        this.analyticsLogger.log(EventBuilder.Companion.create(ANNOTATIONS_VISIBILITY_EVENT_TYPE).set("operation", visibility.getOperation()));
    }

    public void trackAnnotationsColor(@NotNull String color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)ANNOTATIONS_COLOR);
        this.analyticsLogger.log(EventBuilder.Companion.create(ANNOTATIONS_COLOR_EVENT_TYPE).set(ANNOTATIONS_COLOR, color));
    }

    public void trackAnnotationsTool(@NotNull String tool) {
        Intrinsics.checkNotNullParameter((Object)tool, (String)"tool");
        this.analyticsLogger.log(EventBuilder.Companion.create(ANNOTATIONS_TOOL_EVENT_TYPE).set("tool", tool));
    }

    public void trackAnnotationsAction(@NotNull DrawableOverlayEvents.Action action, @Nullable Boolean explicit) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        EventBuilder builder = EventBuilder.Companion.create(ANNOTATIONS_ACTION_EVENT_TYPE);
        builder.set("action", action.getAction());
        if (explicit != null) {
            builder.set(ANNOTATIONS_ACTION_EXPLICIT, explicit.booleanValue());
        }
        this.analyticsLogger.log(builder);
    }

    public void trackSpotlightVisibility(@NotNull DrawableOverlayEvents.Visibility visibility) {
        Intrinsics.checkNotNullParameter((Object)visibility, (String)"visibility");
        this.analyticsLogger.log(EventBuilder.Companion.create(SPOTLIGHT_VISIBILITY_EVENT_TYPE).set("operation", visibility.getOperation()));
    }

    public void trackSpotlightTool(@NotNull String tool) {
        Intrinsics.checkNotNullParameter((Object)tool, (String)"tool");
        this.analyticsLogger.log(EventBuilder.Companion.create(SPOTLIGHT_TOOL_EVENT_TYPE).set("tool", tool));
    }

    public void trackSpotlightSearch() {
        this.analyticsLogger.log(EventBuilder.Companion.create(SPOTLIGHT_SEARCH));
    }

    public void trackSpotlightPermissionError() {
        this.analyticsLogger.log(EventBuilder.Companion.create(SPOTLIGHT_PERMISSIONS_ERROR));
    }

    public void trackSpotlightStartError() {
        this.analyticsLogger.log(EventBuilder.Companion.create(SPOTLIGHT_START_ERROR));
    }

    public void trackSpotlightAction(@NotNull DrawableOverlayEvents.Action action) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        EventBuilder builder = EventBuilder.Companion.create(SPOTLIGHT_ACTION_EVENT_TYPE);
        builder.set("action", action.getAction());
        this.analyticsLogger.log(builder);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b@\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u00102\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u00103\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u00104\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u00105\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u00106\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u00107\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u00108\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u00109\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010:\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010;\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010<\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010=\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010>\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010?\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010@\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010A\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010B\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010C\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010D\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006E"}, d2={"Lorg/merlyn/desktopapp/dataplatform/DataPlatformEventsImpl$Companion;", "", "<init>", "()V", "BUTTON_CLICK_EVENT_TYPE", "", "CHAT_MUTED_EVENT_TYPE", "CHAT_OPENED_EVENT_TYPE", "CHAT_CLOSED_EVENT_TYPE", "FTUE_COMPLETED_EVENT_TYPE", "FTUE_PAGE_CHANGE_EVENT_TYPE", "FTUE_REMIND_EVENT_TYPE", "BUTTON_ID", "CHAT_MUTED", "TIMER_ID", "TIMER_IS_PAUSED", "TIMER_IS_FINISHED", "TIMER_TIME", "FTUE_PAGE_ID", "FTUE_FINISHED", "DONGLE_ATTACHED", "DONGLE_DETTACHED", "ACCESS_KEYEVENTS", "ACCESS_MIC", "LOGIN", "LOGOUT", "SUBSCRIPTION", "BROWSER_CONNECTED", "CLOUD_CONNECTED", "SERVER_STARTED", "CAUSE", "UPDATE_CAPABILITIES", "OS", "CURRENT_VERSION", "CAPABILITIES", "UPDATE_DETECTED", "UPDATE_IGNORED", "REASON", "USER_PERMISSIONS", "UPDATE_EXECUTED", "UPDATE_FAILED", "FROM_VERSION", "TO_VERSION", "ATTEMPT", "FIRMWARE_UPDATE_DETECTED", "FIRMWARE_UPDATE_EXECUTED", "BROWSER_CONNECTION_REJECTED", "RCU_DONGLE_DATA", "RCU_REMOTE_DATA", "HW_VERSION", "FW_VERSION", "ANNOTATIONS_VISIBILITY_EVENT_TYPE", "ANNOTATIONS_VISIBILITY_OPERATION", "ANNOTATIONS_COLOR_EVENT_TYPE", "ANNOTATIONS_COLOR", "ANNOTATIONS_TOOL_EVENT_TYPE", "ANNOTATIONS_TOOL", "ANNOTATIONS_ACTION_EVENT_TYPE", "ANNOTATIONS_ACTION", "ANNOTATIONS_ACTION_EXPLICIT", "SPOTLIGHT_VISIBILITY_EVENT_TYPE", "SPOTLIGHT_VISIBILITY_OPERATION", "SPOTLIGHT_TOOL_EVENT_TYPE", "SPOTLIGHT_TOOL", "SPOTLIGHT_SEARCH", "SPOTLIGHT_PERMISSIONS_ERROR", "SPOTLIGHT_START_ERROR", "SPOTLIGHT_ACTION_EVENT_TYPE", "SPOTLIGHT_ACTION", "app"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ObserveWebServerStartedUseCase.Status.values().length];
            try {
                nArray[ObserveWebServerStartedUseCase.Status.NotStarted.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ObserveWebServerStartedUseCase.Status.Started.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

