/*
 * Decompiled with CFR 0.152.
 */
package org.merlyn.desktopapp.log;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.core.AppenderBase;
import com.j256.cloudwatchlogbackappender.CloudWatchAppender;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.ExecutorsKt;
import org.jetbrains.annotations.NotNull;
import org.koin.core.Koin;
import org.koin.core.qualifier.Qualifier;
import org.koin.core.scope.Scope;
import org.koin.java.KoinJavaComponent;
import org.merlyn.desktopapp.log.LogbackService;
import org.merlyn.desktopapp.storage.LoggingEventDao;
import org.slf4j.event.KeyValuePair;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001e2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001eB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0002H\u0014J\u0006\u0010\u0017\u001a\u00020\u0015J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u0002H\u0002J\u0010\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u0002H\u0002J\u0006\u0010\u001b\u001a\u00020\u0010J\b\u0010\u001c\u001a\u00020\u001dH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001f"}, d2={"Lorg/merlyn/desktopapp/log/DesktopAppEmergencyAppender;", "Lch/qos/logback/core/AppenderBase;", "Lch/qos/logback/classic/spi/ILoggingEvent;", "<init>", "()V", "batchSize", "", "logsToPoll", "Ljava/util/concurrent/atomic/AtomicBoolean;", "daysAllowedForLogging", "", "getDaysAllowedForLogging$app", "()J", "appendScope", "Lkotlinx/coroutines/CoroutineScope;", "isAwsConnectionEnabled", "", "()Z", "setAwsConnectionEnabled", "(Z)V", "append", "", "eventObject", "pollEventsToCloudwatch", "restoreRealTimestampIfPresent", "logEvent", "isAllowedLog", "areLogsToPoll", "getLoggingEventDao", "Lorg/merlyn/desktopapp/storage/LoggingEventDao;", "Companion", "app"})
@SourceDebugExtension(value={"SMAP\nDesktopAppEmergencyAppender.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DesktopAppEmergencyAppender.kt\norg/merlyn/desktopapp/log/DesktopAppEmergencyAppender\n+ 2 Koin.kt\norg/koin/core/Koin\n+ 3 Scope.kt\norg/koin/core/scope/Scope\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,89:1\n105#2,4:90\n105#2,4:99\n136#3:94\n136#3:103\n1869#4,2:95\n295#4,2:97\n*S KotlinDebug\n*F\n+ 1 DesktopAppEmergencyAppender.kt\norg/merlyn/desktopapp/log/DesktopAppEmergencyAppender\n*L\n49#1:90,4\n83#1:99,4\n49#1:94\n83#1:103\n54#1:95,2\n70#1:97,2\n*E\n"})
public final class DesktopAppEmergencyAppender
extends AppenderBase<ILoggingEvent> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int batchSize;
    @NotNull
    private final AtomicBoolean logsToPoll = new AtomicBoolean(true);
    private final long daysAllowedForLogging = Duration.getInWholeMilliseconds-impl((long)DurationKt.toDuration((int)4, (DurationUnit)DurationUnit.DAYS));
    @NotNull
    private final CoroutineScope appendScope;
    private boolean isAwsConnectionEnabled;
    @NotNull
    public static final String REAL_TIMESTAMP_MDC = "realTimestamp";

    public DesktopAppEmergencyAppender() {
        this.batchSize = 20;
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"newSingleThreadExecutor(...)");
        this.appendScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)ExecutorsKt.from((ExecutorService)executorService)));
        this.isAwsConnectionEnabled = true;
    }

    public final long getDaysAllowedForLogging$app() {
        return this.daysAllowedForLogging;
    }

    public final boolean isAwsConnectionEnabled() {
        return this.isAwsConnectionEnabled;
    }

    public final void setAwsConnectionEnabled(boolean bl) {
        this.isAwsConnectionEnabled = bl;
    }

    protected void append(@NotNull ILoggingEvent eventObject) {
        Intrinsics.checkNotNullParameter((Object)eventObject, (String)"eventObject");
        if (this.isAwsConnectionEnabled) {
            BuildersKt.launch$default((CoroutineScope)this.appendScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, eventObject, null){
                int label;
                private /* synthetic */ Object L$0;
                final /* synthetic */ DesktopAppEmergencyAppender this$0;
                final /* synthetic */ ILoggingEvent $eventObject;
                {
                    this.this$0 = $receiver;
                    this.$eventObject = $eventObject;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            CoroutineScope $this$launch = (CoroutineScope)this.L$0;
                            DesktopAppEmergencyAppender.access$restoreRealTimestampIfPresent(this.this$0, this.$eventObject);
                            if (DesktopAppEmergencyAppender.access$isAllowedLog(this.this$0, this.$eventObject)) {
                                CoroutineScope coroutineScope = $this$launch;
                                DesktopAppEmergencyAppender desktopAppEmergencyAppender = this.this$0;
                                ILoggingEvent iLoggingEvent = this.$eventObject;
                                try {
                                    boolean bl = false;
                                    DesktopAppEmergencyAppender.access$getLogsToPoll$p(desktopAppEmergencyAppender).set(true);
                                    DesktopAppEmergencyAppender.access$getLoggingEventDao(desktopAppEmergencyAppender).add(iLoggingEvent);
                                    Object object2 = Result.constructor-impl((Object)Unit.INSTANCE);
                                }
                                catch (Throwable throwable) {
                                    Object object3 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                                }
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                    var3_3.L$0 = value2;
                    return (Continuation)var3_3;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
    }

    public final void pollEventsToCloudwatch() {
        List<ILoggingEvent> events;
        Koin $this$iv = KoinJavaComponent.getKoin();
        Qualifier qualifier$iv = null;
        Function0 parameters$iv = null;
        boolean $i$f$get = false;
        Scope this_$iv$iv = $this$iv.getScopeRegistry().getRootScope();
        boolean $i$f$get2 = false;
        LogbackService logbackService = (LogbackService)this_$iv$iv.get(Reflection.getOrCreateKotlinClass(LogbackService.class), qualifier$iv, parameters$iv);
        LoggingEventDao loggingEventDao = this.getLoggingEventDao();
        do {
            events = loggingEventDao.getBatch(this.batchSize);
            Iterable $this$forEach$iv = events;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CloudWatchAppender it;
                ILoggingEvent logEvent = (ILoggingEvent)element$iv;
                boolean bl = false;
                String string = logEvent.getLoggerName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLoggerName(...)");
                if (logbackService.getAppenderByLoggerName(string) == null) continue;
                boolean bl2 = false;
                if (!this.isAllowedLog(logEvent)) continue;
                it.doAppend((Object)logEvent);
            }
        } while (!((Collection)events).isEmpty());
        this.logsToPoll.set(false);
        loggingEventDao.cleanup();
    }

    /*
     * WARNING - void declaration
     */
    private final void restoreRealTimestampIfPresent(ILoggingEvent logEvent) {
        block3: {
            Object v0;
            block2: {
                void $this$firstOrNull$iv;
                List list;
                if (!(logEvent instanceof LoggingEvent) || (list = ((LoggingEvent)logEvent).getKeyValuePairs()) == null) break block3;
                Iterable iterable = list;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    KeyValuePair it = (KeyValuePair)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.key, (Object)REAL_TIMESTAMP_MDC)) continue;
                    v0 = element$iv;
                    break block2;
                }
                v0 = null;
            }
            KeyValuePair keyValuePair = v0;
            if (keyValuePair != null) {
                KeyValuePair it = keyValuePair;
                boolean bl = false;
                LoggingEvent loggingEvent = (LoggingEvent)logEvent;
                Object object = it.value;
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Long");
                loggingEvent.setTimeStamp(((Long)object).longValue());
                ((LoggingEvent)logEvent).getKeyValuePairs().remove(it);
            }
        }
    }

    private final boolean isAllowedLog(ILoggingEvent logEvent) {
        return System.currentTimeMillis() - logEvent.getTimeStamp() < this.daysAllowedForLogging;
    }

    public final boolean areLogsToPoll() {
        return this.logsToPoll.get();
    }

    private final LoggingEventDao getLoggingEventDao() {
        Koin $this$iv = KoinJavaComponent.getKoin();
        Qualifier qualifier$iv = null;
        Function0 parameters$iv = null;
        boolean $i$f$get = false;
        Scope this_$iv$iv = $this$iv.getScopeRegistry().getRootScope();
        boolean $i$f$get2 = false;
        return (LoggingEventDao)this_$iv$iv.get(Reflection.getOrCreateKotlinClass(LoggingEventDao.class), qualifier$iv, parameters$iv);
    }

    public static final /* synthetic */ void access$restoreRealTimestampIfPresent(DesktopAppEmergencyAppender $this, ILoggingEvent logEvent) {
        $this.restoreRealTimestampIfPresent(logEvent);
    }

    public static final /* synthetic */ boolean access$isAllowedLog(DesktopAppEmergencyAppender $this, ILoggingEvent logEvent) {
        return $this.isAllowedLog(logEvent);
    }

    public static final /* synthetic */ AtomicBoolean access$getLogsToPoll$p(DesktopAppEmergencyAppender $this) {
        return $this.logsToPoll;
    }

    public static final /* synthetic */ LoggingEventDao access$getLoggingEventDao(DesktopAppEmergencyAppender $this) {
        return $this.getLoggingEventDao();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/merlyn/desktopapp/log/DesktopAppEmergencyAppender$Companion;", "", "<init>", "()V", "REAL_TIMESTAMP_MDC", "", "app"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

