/*
 * Decompiled with CFR 0.152.
 */
package org.merlyn.desktopapp.service.browser;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.merlyn.desktopapp.http.commands.UnableToHandleException;
import org.merlyn.desktopapp.service.browser.BrowserApplication;
import org.merlyn.desktopapp.storage.BrowserType;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\tJ\u0010\u0010\f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\r\u001a\u00020\u000eJ\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eJ\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00040\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/merlyn/desktopapp/service/browser/BrowserApplications;", "", "supportedBrowser", "", "Lorg/merlyn/desktopapp/service/browser/BrowserApplication;", "<init>", "(Ljava/util/List;)V", "supportedBrowserByTypeMap", "", "Lorg/merlyn/desktopapp/storage/BrowserType;", "getBrowserFromType", "type", "getBrowserFromCmd", "cmd", "", "isSupportedCommand", "", "browser", "app"})
@SourceDebugExtension(value={"SMAP\nBrowserApplicationDefinitions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BrowserApplicationDefinitions.kt\norg/merlyn/desktopapp/service/browser/BrowserApplications\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,46:1\n1208#2,2:47\n1236#2,4:49\n295#2,2:53\n1761#2,3:55\n*S KotlinDebug\n*F\n+ 1 BrowserApplicationDefinitions.kt\norg/merlyn/desktopapp/service/browser/BrowserApplications\n*L\n27#1:47,2\n27#1:49,4\n36#1:53,2\n44#1:55,3\n*E\n"})
public final class BrowserApplications {
    @NotNull
    private final List<BrowserApplication> supportedBrowser;
    @NotNull
    private final Map<BrowserType, BrowserApplication> supportedBrowserByTypeMap;

    /*
     * WARNING - void declaration
     */
    public BrowserApplications(@NotNull List<? extends BrowserApplication> supportedBrowser) {
        void $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        Intrinsics.checkNotNullParameter(supportedBrowser, (String)"supportedBrowser");
        this.supportedBrowser = supportedBrowser;
        Iterable iterable = this.supportedBrowser;
        BrowserApplications browserApplications = this;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        void var5_6 = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            BrowserApplication browserApplication = (BrowserApplication)element$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            map2.put(it.getType(), element$iv$iv);
        }
        browserApplications.supportedBrowserByTypeMap = destination$iv$iv;
    }

    @NotNull
    public final BrowserApplication getBrowserFromType(@NotNull BrowserType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        BrowserApplication browserApplication = this.supportedBrowserByTypeMap.get((Object)type);
        if (browserApplication == null) {
            boolean bl = false;
            throw new UnableToHandleException("Received type: " + type + " without associated ");
        }
        return browserApplication;
    }

    @Nullable
    public final BrowserApplication getBrowserFromCmd(@NotNull String cmd) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
            Iterable $this$firstOrNull$iv = this.supportedBrowser;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                BrowserApplication browser = (BrowserApplication)element$iv;
                boolean bl = false;
                if (!this.isSupportedCommand(browser, cmd)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    public final boolean isSupportedCommand(@NotNull BrowserType type, @NotNull String cmd) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        BrowserApplication browser = this.getBrowserFromType(type);
        return this.isSupportedCommand(browser, cmd);
    }

    private final boolean isSupportedCommand(BrowserApplication browser, String cmd) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = browser.getApplicationNames();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.contains$default((CharSequence)cmd, (CharSequence)it, (boolean)false, (int)2, null)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }
}

