/*
 * Decompiled with CFR 0.152.
 */
package org.merlyn.desktopapp.service.impl;

import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.merlyn.desktopapp.config.StageConfig;
import org.merlyn.desktopapp.service.RestartFunction;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0001\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u000fH\u0004R\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/merlyn/desktopapp/service/impl/BaseRestartFunction;", "Lorg/merlyn/desktopapp/service/RestartFunction;", "config", "Lorg/merlyn/desktopapp/config/StageConfig;", "<init>", "(Lorg/merlyn/desktopapp/config/StageConfig;)V", "logger", "Lmu/KLogger;", "getLogger", "()Lmu/KLogger;", "restartDelay", "", "getRestartDelay", "()J", "appDir", "", "execute", "", "getAppDir", "app"})
public class BaseRestartFunction
implements RestartFunction {
    @NotNull
    private final KLogger logger;
    private final long restartDelay;
    @Nullable
    private final String appDir;

    public BaseRestartFunction(@NotNull StageConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.logger = KotlinLogging.INSTANCE.logger(BaseRestartFunction::logger$lambda$0);
        this.restartDelay = config.getApplicationConfig().getUpdateRestartDelay();
        this.appDir = System.getProperty("app.dir", null);
    }

    @NotNull
    protected final KLogger getLogger() {
        return this.logger;
    }

    protected final long getRestartDelay() {
        return this.restartDelay;
    }

    @Override
    @NotNull
    public Void execute() {
        this.logger.debug(BaseRestartFunction::execute$lambda$1);
        throw new NotImplementedError(null, 1, null);
    }

    @NotNull
    protected final String getAppDir() {
        CharSequence charSequence = this.appDir;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            throw new RuntimeException("No appDir set, unable to perform restart");
        }
        this.logger.debug(() -> BaseRestartFunction.getAppDir$lambda$2(this));
        return this.appDir;
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Object execute$lambda$1() {
        return "Restart function not implemented for host";
    }

    private static final Object getAppDir$lambda$2(BaseRestartFunction this$0) {
        return "appDir: " + this$0.appDir;
    }
}

