/*
 * Decompiled with CFR 0.152.
 */
package org.merlyn.desktopapp.storage.database;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.merlyn.desktopapp.storage.database.LoggingEventDatabaseDao;
import org.merlyn.desktopapp.storage.database.ScreensConfigurationDatabaseDao;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0013\u001a\u00020\u0014R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0016"}, d2={"Lorg/merlyn/desktopapp/storage/database/SqliteDatabase;", "", "path", "", "<init>", "(Ljava/lang/String;)V", "databasePath", "logger", "Lmu/KLogger;", "connection", "Ljava/sql/Connection;", "loggingEventDao", "Lorg/merlyn/desktopapp/storage/database/LoggingEventDatabaseDao;", "getLoggingEventDao", "()Lorg/merlyn/desktopapp/storage/database/LoggingEventDatabaseDao;", "screensConfigurationDao", "Lorg/merlyn/desktopapp/storage/database/ScreensConfigurationDatabaseDao;", "getScreensConfigurationDao", "()Lorg/merlyn/desktopapp/storage/database/ScreensConfigurationDatabaseDao;", "deleteDatabase", "", "Companion", "app"})
@SourceDebugExtension(value={"SMAP\nSqliteDatabase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqliteDatabase.kt\norg/merlyn/desktopapp/storage/database/SqliteDatabase\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,43:1\n1#2:44\n*E\n"})
public final class SqliteDatabase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String databasePath;
    @NotNull
    private final KLogger logger;
    @Nullable
    private final Connection connection;
    @NotNull
    private final LoggingEventDatabaseDao loggingEventDao;
    @NotNull
    private final ScreensConfigurationDatabaseDao screensConfigurationDao;
    @NotNull
    public static final String DATABASE_FILE_NAME = "mm-desktop.db";

    /*
     * WARNING - void declaration
     */
    public SqliteDatabase(@NotNull String path) {
        Connection connection;
        SqliteDatabase sqliteDatabase;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        String[] stringArray = new String[]{DATABASE_FILE_NAME};
        Path path2 = Paths.get(path, Arrays.copyOf(stringArray, stringArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
        this.databasePath = ((Object)path2.toAbsolutePath()).toString();
        this.logger = KotlinLogging.INSTANCE.logger(SqliteDatabase::logger$lambda$0);
        String url = "jdbc:sqlite:" + this.databasePath;
        SqliteDatabase sqliteDatabase2 = this;
        try {
            Connection connection2;
            sqliteDatabase = sqliteDatabase2;
            Connection connection3 = DriverManager.getConnection(url);
            if (connection3 != null) {
                void it;
                Connection connection4;
                Connection connection5 = connection4 = connection3;
                SqliteDatabase sqliteDatabase3 = sqliteDatabase;
                boolean bl = false;
                it.getMetaData();
                sqliteDatabase = sqliteDatabase3;
                connection2 = connection4;
            } else {
                connection2 = null;
            }
            connection = connection2;
        }
        catch (SQLException sQLException) {
            void ex;
            sqliteDatabase = sqliteDatabase2;
            this.logger.error((Throwable)ex, SqliteDatabase::_init_$lambda$2);
            connection = null;
        }
        sqliteDatabase.connection = connection;
        this.loggingEventDao = new LoggingEventDatabaseDao(this.connection);
        this.screensConfigurationDao = new ScreensConfigurationDatabaseDao(this.connection);
    }

    @NotNull
    public final LoggingEventDatabaseDao getLoggingEventDao() {
        return this.loggingEventDao;
    }

    @NotNull
    public final ScreensConfigurationDatabaseDao getScreensConfigurationDao() {
        return this.screensConfigurationDao;
    }

    public final void deleteDatabase() {
        Connection connection = this.connection;
        if (connection != null) {
            connection.close();
        }
        new File(this.databasePath).delete();
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Object _init_$lambda$2() {
        return "Unable to open or create settings database";
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/merlyn/desktopapp/storage/database/SqliteDatabase$Companion;", "", "<init>", "()V", "DATABASE_FILE_NAME", "", "app"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

