/*
 * Decompiled with CFR 0.152.
 */
package org.merlyn.desktopapp.storage.modernimpl;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.merlyn.desktopapp.storage.TokenCachedData;
import org.merlyn.desktopapp.storage.TokenData;
import org.merlyn.desktopapp.storage.TokenDataDao;
import org.merlyn.desktopapp.storage.TokenSecureData;
import org.merlyn.desktopapp.storage.credentials.TokenCredentialsStore;
import org.merlyn.desktopapp.storage.modernimpl.DefaultEntities;
import org.merlyn.desktopapp.storage.modernimpl.PreferencesFileStorage;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\f\u0010\u0010\u001a\u00020\t*\u00020\u0011H\u0002J,\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00152\b\u0010\u0017\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0018\u001a\u00020\u0013H\u0016J\b\u0010\u0019\u001a\u00020\u0013H\u0016J\b\u0010\u001a\u001a\u00020\u0013H\u0016J\b\u0010\u001b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001c"}, d2={"Lorg/merlyn/desktopapp/storage/modernimpl/TokenDataDaoImpl;", "Lorg/merlyn/desktopapp/storage/TokenDataDao;", "tokenCredentialsStore", "Lorg/merlyn/desktopapp/storage/credentials/TokenCredentialsStore;", "preferencesFileStorage", "Lorg/merlyn/desktopapp/storage/modernimpl/PreferencesFileStorage;", "<init>", "(Lorg/merlyn/desktopapp/storage/credentials/TokenCredentialsStore;Lorg/merlyn/desktopapp/storage/modernimpl/PreferencesFileStorage;)V", "uninitializedTokenData", "Lorg/merlyn/desktopapp/storage/TokenData;", "_tokenData", "Lkotlinx/coroutines/flow/MutableStateFlow;", "tokenData", "Lkotlinx/coroutines/flow/StateFlow;", "getTokenData", "()Lkotlinx/coroutines/flow/StateFlow;", "toTokenData", "Lorg/merlyn/desktopapp/storage/TokenSecureData;", "updateTokens", "", "accessToken", "", "refreshToken", "idToken", "hasValidLicenseCached", "clearAccessToken", "clear", "get", "app"})
@SourceDebugExtension(value={"SMAP\nTokenDataDaoImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TokenDataDaoImpl.kt\norg/merlyn/desktopapp/storage/modernimpl/TokenDataDaoImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,69:1\n1#2:70\n*E\n"})
public final class TokenDataDaoImpl
implements TokenDataDao {
    @NotNull
    private final TokenCredentialsStore tokenCredentialsStore;
    @NotNull
    private final PreferencesFileStorage preferencesFileStorage;
    @NotNull
    private final TokenData uninitializedTokenData;
    @NotNull
    private final MutableStateFlow<TokenData> _tokenData;
    @NotNull
    private final StateFlow<TokenData> tokenData;

    public TokenDataDaoImpl(@NotNull TokenCredentialsStore tokenCredentialsStore, @NotNull PreferencesFileStorage preferencesFileStorage) {
        Intrinsics.checkNotNullParameter((Object)tokenCredentialsStore, (String)"tokenCredentialsStore");
        Intrinsics.checkNotNullParameter((Object)preferencesFileStorage, (String)"preferencesFileStorage");
        this.tokenCredentialsStore = tokenCredentialsStore;
        this.preferencesFileStorage = preferencesFileStorage;
        this.uninitializedTokenData = new TokenData(null, null, null, false);
        Object object = this.tokenCredentialsStore.get();
        if (object == null || (object = this.toTokenData((TokenSecureData)object)) == null) {
            object = this.uninitializedTokenData;
        }
        this._tokenData = StateFlowKt.MutableStateFlow((Object)object);
        this.tokenData = FlowKt.asStateFlow(this._tokenData);
    }

    @Override
    @NotNull
    public StateFlow<TokenData> getTokenData() {
        return this.tokenData;
    }

    private final TokenData toTokenData(TokenSecureData $this$toTokenData) {
        String string = $this$toTokenData.getAccessToken();
        String string2 = $this$toTokenData.getRefreshToken();
        String string3 = $this$toTokenData.getIdToken();
        TokenCachedData tokenCachedData = this.preferencesFileStorage.getTokenCachedData();
        if (tokenCachedData == null) {
            tokenCachedData = DefaultEntities.INSTANCE.getDefaultTokenCached();
        }
        return new TokenData(string, string2, string3, tokenCachedData.getHasValidLicenseCached());
    }

    @Override
    public boolean updateTokens(@NotNull String accessToken, @Nullable String refreshToken, @Nullable String idToken, boolean hasValidLicenseCached) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)accessToken, (String)"accessToken");
        boolean it = bl = this.tokenCredentialsStore.set(accessToken, refreshToken, idToken);
        boolean bl2 = false;
        this.preferencesFileStorage.setTokenCachedData(new TokenCachedData(hasValidLicenseCached));
        it = bl;
        boolean bl3 = false;
        this._tokenData.setValue((Object)new TokenData(accessToken, refreshToken, idToken, hasValidLicenseCached));
        return bl;
    }

    @Override
    public boolean clearAccessToken() {
        boolean bl;
        boolean it = bl = this.tokenCredentialsStore.clearAccessToken();
        boolean bl2 = false;
        this._tokenData.setValue((Object)TokenData.copy$default((TokenData)this._tokenData.getValue(), null, null, null, false, 14, null));
        return bl;
    }

    @Override
    public boolean clear() {
        boolean bl;
        boolean it = bl = this.tokenCredentialsStore.clear();
        boolean bl2 = false;
        this.preferencesFileStorage.setTokenCachedData(new TokenCachedData(false));
        it = bl;
        boolean bl3 = false;
        this._tokenData.setValue((Object)this.uninitializedTokenData);
        return bl;
    }

    @Override
    @NotNull
    public TokenData get() {
        return (TokenData)this._tokenData.getValue();
    }
}

