/*
 * Decompiled with CFR 0.152.
 */
package org.merlyn.desktopapp.view.javafx.adapters;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javafx.collections.ObservableList;
import javafx.stage.Screen;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.merlyn.desktopapp.os.OS;
import org.merlyn.desktopapp.storage.ScreensConfigurationDao;
import org.merlyn.desktopapp.storage.database.FindScreenResult;
import org.merlyn.desktopapp.storage.database.ScreenInformation;
import org.merlyn.desktopapp.view.javafx.adapters.GetSoloApplicationScreenKt;
import org.merlyn.sharedui.viewmodels.usecases.GetApplicationScreen;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\b\u001a\u00020\tH\u0097\u0002J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000bH\u0016J\b\u0010\u000f\u001a\u00020\tH\u0002J\n\u0010\u0010\u001a\u0004\u0018\u00010\tH\u0002J\b\u0010\u0011\u001a\u00020\tH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/merlyn/desktopapp/view/javafx/adapters/GetSoloApplicationScreen;", "Lorg/merlyn/sharedui/viewmodels/usecases/GetApplicationScreen;", "hostOs", "Lorg/merlyn/desktopapp/os/OS;", "screensConfigurationDao", "Lorg/merlyn/desktopapp/storage/ScreensConfigurationDao;", "<init>", "(Lorg/merlyn/desktopapp/os/OS;Lorg/merlyn/desktopapp/storage/ScreensConfigurationDao;)V", "invoke", "Ljavafx/stage/Screen;", "getActiveScreenIndex", "", "setActiveScreenIndex", "", "activeScreen", "calculateSecondaryScreen", "getSelectedScreen", "getDefaultScreen", "app"})
@SourceDebugExtension(value={"SMAP\nGetSoloApplicationScreen.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GetSoloApplicationScreen.kt\norg/merlyn/desktopapp/view/javafx/adapters/GetSoloApplicationScreen\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,66:1\n827#2:67\n855#2,2:68\n*S KotlinDebug\n*F\n+ 1 GetSoloApplicationScreen.kt\norg/merlyn/desktopapp/view/javafx/adapters/GetSoloApplicationScreen\n*L\n57#1:67\n57#1:68,2\n*E\n"})
public final class GetSoloApplicationScreen
implements GetApplicationScreen {
    @NotNull
    private final OS hostOs;
    @NotNull
    private final ScreensConfigurationDao screensConfigurationDao;

    public GetSoloApplicationScreen(@NotNull OS hostOs, @NotNull ScreensConfigurationDao screensConfigurationDao) {
        Intrinsics.checkNotNullParameter((Object)((Object)hostOs), (String)"hostOs");
        Intrinsics.checkNotNullParameter((Object)screensConfigurationDao, (String)"screensConfigurationDao");
        this.hostOs = hostOs;
        this.screensConfigurationDao = screensConfigurationDao;
    }

    @Deprecated(message="Use CurrentScreenState.currentScreenState flow instead", replaceWith=@ReplaceWith(expression="CurrentScreenState.currentScreenState.value", imports={}), level=DeprecationLevel.WARNING)
    @NotNull
    public Screen invoke() {
        Screen screen;
        switch (WhenMappings.$EnumSwitchMapping$0[this.hostOs.ordinal()]) {
            case 1: {
                screen = this.calculateSecondaryScreen();
                break;
            }
            case 2: {
                screen = this.calculateSecondaryScreen();
                break;
            }
            default: {
                Screen screen2 = Screen.getPrimary();
                screen = screen2;
                Intrinsics.checkNotNullExpressionValue((Object)screen2, (String)"getPrimary(...)");
            }
        }
        return screen;
    }

    public int getActiveScreenIndex() {
        if (this.hostOs != OS.Windows && this.hostOs != OS.MacOS) {
            return 0;
        }
        Screen screen = this.invoke();
        ObservableList screens = Screen.getScreens();
        return screens.size() == 1 ? 0 : screens.indexOf((Object)screen);
    }

    public void setActiveScreenIndex(int activeScreen) {
        ObservableList observableList = Screen.getScreens();
        Intrinsics.checkNotNullExpressionValue((Object)observableList, (String)"getScreens(...)");
        this.screensConfigurationDao.upsert((Collection<ScreenInformation>)GetSoloApplicationScreenKt.toScreenInformation((Collection)observableList), activeScreen);
    }

    private final Screen calculateSecondaryScreen() {
        Screen screen;
        if (Screen.getScreens().size() == 1) {
            Screen screen2 = Screen.getPrimary();
            screen = screen2;
            Intrinsics.checkNotNullExpressionValue((Object)screen2, (String)"getPrimary(...)");
        } else {
            screen = this.getSelectedScreen();
            if (screen == null) {
                screen = this.getDefaultScreen();
            }
        }
        return screen;
    }

    private final Screen getSelectedScreen() {
        ObservableList screens = Screen.getScreens();
        Intrinsics.checkNotNull((Object)screens);
        FindScreenResult result = this.screensConfigurationDao.find((Collection<ScreenInformation>)GetSoloApplicationScreenKt.toScreenInformation((Collection)screens));
        if (Intrinsics.areEqual((Object)result, (Object)FindScreenResult.Companion.getNotFound())) {
            return null;
        }
        int activeScreen = (int)result.getActiveScreen();
        return activeScreen >= 0 && activeScreen < screens.size() ? (Screen)screens.get(activeScreen) : null;
    }

    /*
     * WARNING - void declaration
     */
    private final Screen getDefaultScreen() {
        void $this$filterNotTo$iv$iv;
        ObservableList observableList = Screen.getScreens();
        Intrinsics.checkNotNullExpressionValue((Object)observableList, (String)"getScreens(...)");
        Iterable $this$filterNot$iv = (Iterable)observableList;
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            Screen it = (Screen)element$iv$iv;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)it, (Object)Screen.getPrimary())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Screen screen = (Screen)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
        if (screen == null) {
            Screen screen2 = Screen.getPrimary();
            screen = screen2;
            Intrinsics.checkNotNullExpressionValue((Object)screen2, (String)"getPrimary(...)");
        }
        return screen;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[OS.values().length];
            try {
                nArray[OS.Windows.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OS.MacOS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

