/*
 * Decompiled with CFR 0.152.
 */
package org.merlyn.core.analytics;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.merlyn.core.analytics.AlertImpressionLogger;
import org.merlyn.core.analytics.AnalyticsLogger;
import org.merlyn.core.analytics.BaseAnalyticsRenderImpressionLogger;
import org.merlyn.core.analytics.ConfirmationImpressionLogger;
import org.merlyn.core.analytics.EventImpressionLogger;
import org.merlyn.core.analytics.RecommendationsImpressionLogger;
import org.merlyn.core.render.Render;
import org.merlyn.core.render.RenderAlert;
import org.merlyn.core.render.RenderConfirmation;
import org.merlyn.core.render.RenderEvent;
import org.merlyn.core.render.RenderRecommendations;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/merlyn/core/analytics/AnalyticsRenderImpressionLogger;", "", "analyticsLogger", "Lorg/merlyn/core/analytics/AnalyticsLogger;", "<init>", "(Lorg/merlyn/core/analytics/AnalyticsLogger;)V", "alertImpressionLogger", "Lorg/merlyn/core/analytics/AlertImpressionLogger;", "eventImpressionLogger", "Lorg/merlyn/core/analytics/EventImpressionLogger;", "recommendationsImpressionLogger", "Lorg/merlyn/core/analytics/RecommendationsImpressionLogger;", "confirmationImpressionLogger", "Lorg/merlyn/core/analytics/ConfirmationImpressionLogger;", "log", "", "render", "Lorg/merlyn/core/render/Render;", "sdkCore"})
public final class AnalyticsRenderImpressionLogger {
    @NotNull
    private final AlertImpressionLogger alertImpressionLogger;
    @NotNull
    private final EventImpressionLogger eventImpressionLogger;
    @NotNull
    private final RecommendationsImpressionLogger recommendationsImpressionLogger;
    @NotNull
    private final ConfirmationImpressionLogger confirmationImpressionLogger;

    public AnalyticsRenderImpressionLogger(@NotNull AnalyticsLogger analyticsLogger) {
        Intrinsics.checkNotNullParameter((Object)analyticsLogger, (String)"analyticsLogger");
        this.alertImpressionLogger = new AlertImpressionLogger(analyticsLogger);
        this.eventImpressionLogger = new EventImpressionLogger(analyticsLogger);
        this.recommendationsImpressionLogger = new RecommendationsImpressionLogger(analyticsLogger);
        this.confirmationImpressionLogger = new ConfirmationImpressionLogger(analyticsLogger);
    }

    public final void log(@NotNull Render render2) {
        BaseAnalyticsRenderImpressionLogger baseAnalyticsRenderImpressionLogger;
        Intrinsics.checkNotNullParameter((Object)render2, (String)"render");
        Render render3 = render2;
        if (render3 instanceof RenderAlert) {
            baseAnalyticsRenderImpressionLogger = this.alertImpressionLogger;
        } else if (render3 instanceof RenderEvent) {
            baseAnalyticsRenderImpressionLogger = this.eventImpressionLogger;
        } else if (render3 instanceof RenderRecommendations) {
            baseAnalyticsRenderImpressionLogger = this.recommendationsImpressionLogger;
        } else if (render3 instanceof RenderConfirmation) {
            baseAnalyticsRenderImpressionLogger = this.confirmationImpressionLogger;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        BaseAnalyticsRenderImpressionLogger renderImpressionLogger = baseAnalyticsRenderImpressionLogger;
        renderImpressionLogger.log(render2);
    }
}

