/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.services.ec2.model.Tag;
import com.amazonaws.services.ec2.model.TagSpecification;
import com.amazonaws.services.ec2.model.transform.TagStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class TagSpecificationStaxUnmarshaller
implements Unmarshaller<TagSpecification, StaxUnmarshallerContext> {
    private static TagSpecificationStaxUnmarshaller instance;

    public TagSpecification unmarshall(StaxUnmarshallerContext context) throws Exception {
        TagSpecification tagSpecification = new TagSpecification();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return tagSpecification;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("resourceType", targetDepth)) {
                    tagSpecification.setResourceType(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Tag", targetDepth)) {
                    tagSpecification.withTags(new ArrayList<Tag>());
                    continue;
                }
                if (!context.testExpression("Tag/item", targetDepth)) continue;
                tagSpecification.withTags(TagStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return tagSpecification;
    }

    public static TagSpecificationStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new TagSpecificationStaxUnmarshaller();
        }
        return instance;
    }
}

