/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.storage.macosx;

import com.microsoft.alm.helpers.Func;
import com.microsoft.alm.helpers.IOHelper;
import com.microsoft.alm.helpers.StringHelper;
import com.microsoft.alm.oauth2.useragent.subprocess.DefaultProcessFactory;
import com.microsoft.alm.oauth2.useragent.subprocess.ProcessCoordinator;
import com.microsoft.alm.oauth2.useragent.subprocess.TestableProcess;
import com.microsoft.alm.oauth2.useragent.subprocess.TestableProcessFactory;
import com.microsoft.alm.secret.Credential;
import com.microsoft.alm.secret.Token;
import com.microsoft.alm.secret.TokenPair;
import com.microsoft.alm.secret.TokenType;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class KeychainSecurityCliStore {
    static final String SECURITY = "/usr/bin/security";
    static final String DELETE_GENERIC_PASSWORD = "delete-generic-password";
    static final String FIND_GENERIC_PASSWORD = "find-generic-password";
    static final String ADD_GENERIC_PASSWORD = "add-generic-password";
    static final String SHOW_KEYCHAIN_INFO = "show-keychain-info";
    static final String ACCOUNT_PARAMETER = "-a";
    static final String ACCOUNT_METADATA = "acct";
    static final String PASSWORD = "password";
    private static final String SERVICE_PARAMETER = "-s";
    private static final String KIND_PARAMETER = "-D";
    private static final String PASSWORD_PARAMETER = "-w";
    private static final String UPDATE_IF_ALREADY_EXISTS = "-U";
    private static final int ITEM_NOT_FOUND_EXIT_CODE = 44;
    private static final int USER_INTERACTION_NOT_ALLOWED_EXIT_CODE = 36;
    private static final String INTERACTIVE_MODE = "-i";
    private static final Func<String, String> QUOTING_PROCESSOR = new Func<String, String>(){

        public String call(String s) {
            if (s.contains(" ")) {
                return '\"' + s + '\"';
            }
            return s;
        }
    };
    private final TestableProcessFactory processFactory;
    private static final Pattern MetadataLinePattern = Pattern.compile("^(\\w+):\\s\"(.+)\"");

    protected boolean deleteByKind(String targetName, SecretKind kind) {
        try {
            TestableProcess process = this.processFactory.create(new String[]{SECURITY, DELETE_GENERIC_PASSWORD, SERVICE_PARAMETER, targetName, KIND_PARAMETER, kind.name()});
            process.waitFor();
            return true;
        }
        catch (IOException e) {
            throw new Error(e);
        }
        catch (InterruptedException e) {
            throw new Error(e);
        }
    }

    public KeychainSecurityCliStore() {
        this((TestableProcessFactory)new DefaultProcessFactory());
    }

    KeychainSecurityCliStore(TestableProcessFactory processFactory) {
        this.processFactory = processFactory;
    }

    static Map<String, Object> parseKeychainMetaData(String metadata) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        KeychainSecurityCliStore.parseKeychainMetaData(metadata, result);
        return result;
    }

    static void parseKeychainMetaData(String metadata, Map<String, Object> result) {
        StringReader sr = new StringReader(metadata);
        BufferedReader br = new BufferedReader(sr);
        boolean parsingAttributes = false;
        try {
            String line;
            while ((line = br.readLine()) != null) {
                if (parsingAttributes) {
                    KeychainSecurityCliStore.parseAttributeLine(line, result);
                    continue;
                }
                if ("attributes:".equals(line)) {
                    parsingAttributes = true;
                    continue;
                }
                KeychainSecurityCliStore.parseMetadataLine(line, result);
            }
        }
        catch (IOException e) {
            throw new Error(e);
        }
        finally {
            IOHelper.closeQuietly((Closeable)br);
        }
    }

    static void parseMetadataLine(String line, Map<String, Object> destination) {
        Matcher matcher = MetadataLinePattern.matcher(line);
        if (matcher.matches()) {
            String key = matcher.group(1);
            String value = matcher.group(2);
            destination.put(key, value);
        }
    }

    static void parseAttributeLine(String line, Map<String, Object> destination) {
        String template = "Undefined transition '%1$s' from %2$s.";
        StringBuilder key = new StringBuilder();
        StringBuilder type = new StringBuilder();
        StringBuilder value = new StringBuilder();
        boolean isNullValue = false;
        AttributeParsingState state = AttributeParsingState.Spaces;
        block43: for (char c : line.toCharArray()) {
            switch (state) {
                case Spaces: {
                    switch (c) {
                        case ' ': {
                            continue block43;
                        }
                        case '0': {
                            state = AttributeParsingState.HexKey;
                            key.append(c);
                            continue block43;
                        }
                        case '\"': {
                            state = AttributeParsingState.StringKey;
                            continue block43;
                        }
                    }
                    throw new Error(String.format("Undefined transition '%1$s' from %2$s.", new Object[]{Character.valueOf(c), state}));
                }
                case HexKey: {
                    switch (c) {
                        case ' ': {
                            state = AttributeParsingState.BeforeType;
                            continue block43;
                        }
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': 
                        case 'A': 
                        case 'B': 
                        case 'C': 
                        case 'D': 
                        case 'E': 
                        case 'F': 
                        case 'x': {
                            key.append(c);
                            continue block43;
                        }
                    }
                    throw new Error(String.format("Undefined transition '%1$s' from %2$s.", new Object[]{Character.valueOf(c), state}));
                }
                case StringKey: {
                    switch (c) {
                        case '\"': {
                            state = AttributeParsingState.BeforeType;
                            continue block43;
                        }
                    }
                    key.append(c);
                    continue block43;
                }
                case BeforeType: {
                    switch (c) {
                        case '<': {
                            state = AttributeParsingState.Type;
                            continue block43;
                        }
                    }
                    throw new Error(String.format("Undefined transition '%1$s' from %2$s.", new Object[]{Character.valueOf(c), state}));
                }
                case Type: {
                    switch (c) {
                        case '>': {
                            state = AttributeParsingState.AfterType;
                            continue block43;
                        }
                    }
                    type.append(c);
                    continue block43;
                }
                case AfterType: {
                    switch (c) {
                        case '=': {
                            state = AttributeParsingState.BeforeValue;
                            continue block43;
                        }
                    }
                    throw new Error(String.format("Undefined transition '%1$s' from %2$s.", new Object[]{Character.valueOf(c), state}));
                }
                case BeforeValue: {
                    switch (c) {
                        case '<': {
                            state = AttributeParsingState.NullValue;
                            isNullValue = true;
                            value.append(c);
                            continue block43;
                        }
                        case '0': {
                            state = AttributeParsingState.TimeDateValue;
                            value.append(c);
                            continue block43;
                        }
                        case '\"': {
                            state = AttributeParsingState.StringValue;
                            continue block43;
                        }
                    }
                    throw new Error(String.format("Undefined transition '%1$s' from %2$s.", new Object[]{Character.valueOf(c), state}));
                }
                case NullValue: {
                    switch (c) {
                        case '>': {
                            state = AttributeParsingState.ValueFinished;
                            value.append(c);
                            continue block43;
                        }
                        case 'L': 
                        case 'N': 
                        case 'U': {
                            value.append(c);
                            continue block43;
                        }
                    }
                    throw new Error(String.format("Undefined transition '%1$s' from %2$s.", new Object[]{Character.valueOf(c), state}));
                }
                case StringValue: {
                    value.append(c);
                    continue block43;
                }
                case TimeDateValue: {
                    value.append(c);
                    continue block43;
                }
                case ValueFinished: {
                    throw new Error(String.format("Undefined transition '%1$s' from %2$s.", new Object[]{Character.valueOf(c), state}));
                }
            }
        }
        if (isNullValue) {
            destination.put(key.toString(), null);
        } else if ("blob".equals(type.toString())) {
            int lastCharIndex = value.length() - 1;
            value.deleteCharAt(lastCharIndex);
            destination.put(key.toString(), value.toString());
        }
    }

    public boolean isKeychainAvailable() {
        try {
            TestableProcess process = this.processFactory.create(new String[]{SECURITY, SHOW_KEYCHAIN_INFO});
            ProcessCoordinator coordinator = new ProcessCoordinator(process);
            int result = coordinator.waitFor();
            String stdOut = coordinator.getStdOut();
            String stdErr = coordinator.getStdErr();
            KeychainSecurityCliStore.checkResult(result, stdOut, stdErr);
        }
        catch (IOException e) {
            throw new Error(e);
        }
        catch (InterruptedException e) {
            throw new Error(e);
        }
        catch (SecurityException e) {
            return false;
        }
        return true;
    }

    static void checkResult(int result, String stdOut, String stdErr) {
        if (result != 0) {
            if (result == 36) {
                throw new SecurityException("User interaction is not allowed.");
            }
            String template = "%1$s exited with result %2$d.\nstdOut: %3$s\nstdErr: %4$s\n";
            String message = String.format("%1$s exited with result %2$d.\nstdOut: %3$s\nstdErr: %4$s\n", SECURITY, result, stdOut, stdErr);
            throw new Error(message);
        }
    }

    static Map<String, Object> read(SecretKind secretKind, TestableProcessFactory processFactory, String serviceName) {
        String stdErr;
        String stdOut;
        try {
            TestableProcess process = processFactory.create(new String[]{SECURITY, FIND_GENERIC_PASSWORD, SERVICE_PARAMETER, serviceName, KIND_PARAMETER, secretKind.name(), "-g"});
            ProcessCoordinator coordinator = new ProcessCoordinator(process);
            int result = coordinator.waitFor();
            stdOut = coordinator.getStdOut();
            stdErr = coordinator.getStdErr();
            if (result != 0 && result != 44) {
                KeychainSecurityCliStore.checkResult(result, stdOut, stdErr);
            }
        }
        catch (IOException e) {
            throw new Error(e);
        }
        catch (InterruptedException e) {
            throw new Error(e);
        }
        Map<String, Object> metaData = KeychainSecurityCliStore.parseKeychainMetaData(stdOut);
        KeychainSecurityCliStore.parseKeychainMetaData(stdErr, metaData);
        return metaData;
    }

    public Credential readCredentials(String targetName) {
        Credential result;
        Map<String, Object> metaData = KeychainSecurityCliStore.read(SecretKind.Credential, this.processFactory, targetName);
        if (metaData.size() > 0) {
            String userName = (String)metaData.get(ACCOUNT_METADATA);
            String password = (String)metaData.get(PASSWORD);
            result = new Credential(userName, password);
        } else {
            result = null;
        }
        return result;
    }

    public Token readToken(String targetName) {
        Token result;
        Map<String, Object> metaData = KeychainSecurityCliStore.read(SecretKind.Token, this.processFactory, targetName);
        if (metaData.size() > 0) {
            String typeName = (String)metaData.get(ACCOUNT_METADATA);
            String password = (String)metaData.get(PASSWORD);
            result = new Token(password, typeName);
        } else {
            result = null;
        }
        return result;
    }

    public TokenPair readTokenPair(String targetName) {
        String password;
        String password2;
        Map<String, Object> accessTokenMetaData = KeychainSecurityCliStore.read(SecretKind.TokenPair_Access_Token, this.processFactory, targetName);
        String accessToken = accessTokenMetaData.size() > 0 ? (password2 = (String)accessTokenMetaData.get(PASSWORD)) : null;
        Map<String, Object> refreshTokenMetaData = KeychainSecurityCliStore.read(SecretKind.TokenPair_Refresh_Token, this.processFactory, targetName);
        String refreshToken = refreshTokenMetaData.size() > 0 ? (password = (String)refreshTokenMetaData.get(PASSWORD)) : null;
        if (accessToken != null && refreshToken != null) {
            return new TokenPair(accessToken, refreshToken);
        }
        return null;
    }

    static void write(SecretKind secretKind, TestableProcessFactory processFactory, String serviceName, String accountName, String password) {
        try {
            TestableProcess addProcess = processFactory.create(new String[]{SECURITY, INTERACTIVE_MODE});
            String[] commandParts = new String[]{ADD_GENERIC_PASSWORD, UPDATE_IF_ALREADY_EXISTS, ACCOUNT_PARAMETER, accountName, SERVICE_PARAMETER, serviceName, PASSWORD_PARAMETER, password, KIND_PARAMETER, secretKind.name()};
            ProcessCoordinator coordinator = new ProcessCoordinator(addProcess);
            String command = StringHelper.join((String)" ", (String[])commandParts, (int)0, (int)commandParts.length, QUOTING_PROCESSOR);
            coordinator.println(command);
            int result = coordinator.waitFor();
            String stdOut = coordinator.getStdOut();
            String stdErr = coordinator.getStdErr();
            KeychainSecurityCliStore.checkResult(result, stdOut, stdErr);
        }
        catch (IOException e) {
            throw new Error(e);
        }
        catch (InterruptedException e) {
            throw new Error(e);
        }
    }

    public void writeCredential(String targetName, Credential credentials) {
        KeychainSecurityCliStore.write(SecretKind.Credential, this.processFactory, targetName, credentials.Username, credentials.Password);
    }

    public void writeToken(String targetName, Token token) {
        this.writeTokenKind(targetName, SecretKind.Token, token);
    }

    private void writeTokenKind(String targetName, SecretKind secretKind, Token token) {
        AtomicReference accountNameReference = new AtomicReference();
        Token.getFriendlyNameFromType((TokenType)token.Type, accountNameReference);
        String accountName = (String)accountNameReference.get();
        KeychainSecurityCliStore.write(secretKind, this.processFactory, targetName, accountName, token.Value);
    }

    public void writeTokenPair(String targetName, TokenPair tokenPair) {
        if (tokenPair.AccessToken.Value != null) {
            this.writeTokenKind(targetName, SecretKind.TokenPair_Access_Token, tokenPair.AccessToken);
        }
        if (tokenPair.RefreshToken.Value != null) {
            this.writeTokenKind(targetName, SecretKind.TokenPair_Refresh_Token, tokenPair.RefreshToken);
        }
    }

    static enum AttributeParsingState {
        Spaces,
        StringKey,
        HexKey,
        BeforeType,
        Type,
        AfterType,
        BeforeValue,
        NullValue,
        StringValue,
        TimeDateValue,
        ValueFinished;

    }

    static enum SecretKind {
        Credential,
        Token,
        TokenPair_Access_Token,
        TokenPair_Refresh_Token;

    }
}

