/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.usb.common;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.util.Arrays;
import java.util.concurrent.ArrayBlockingQueue;
import net.codecrete.usb.UsbDirection;
import net.codecrete.usb.common.Transfer;
import net.codecrete.usb.common.UsbDeviceImpl;
import org.jetbrains.annotations.NotNull;

public abstract class EndpointOutputStream
extends OutputStream {
    protected UsbDeviceImpl device;
    protected final int endpointNumber;
    protected final Arena arena;
    private final int packetSize;
    private final int transferSize;
    private final ArrayBlockingQueue<Transfer> availableTransferQueue;
    private boolean needsZlp;
    private Transfer currentTransfer;
    private int writeOffset;
    private int numOutstandingTransfers;
    private boolean hasError;

    protected EndpointOutputStream(UsbDeviceImpl device, int endpointNumber, int bufferSize) {
        this.device = device;
        this.endpointNumber = endpointNumber;
        this.arena = Arena.ofShared();
        this.packetSize = device.getEndpoint(UsbDirection.OUT, endpointNumber).getPacketSize();
        int numPacketsPerTransfer = (int)Math.round(Math.sqrt((double)bufferSize / (double)this.packetSize));
        numPacketsPerTransfer = Math.min(Math.max(numPacketsPerTransfer, 4), 32);
        this.transferSize = numPacketsPerTransfer * this.packetSize;
        int maxOutstandingTransfers = Math.max((bufferSize + this.transferSize / 2) / this.transferSize, 3);
        this.configureEndpoint();
        this.availableTransferQueue = new ArrayBlockingQueue(maxOutstandingTransfers);
        for (int i = 0; i < maxOutstandingTransfers; ++i) {
            Transfer transfer = device.createTransfer();
            transfer.setData(this.arena.allocate(this.transferSize, 8L));
            transfer.setCompletion(this::onCompletion);
            if (i == 0) {
                this.currentTransfer = transfer;
                continue;
            }
            this.availableTransferQueue.add(transfer);
        }
    }

    private boolean isClosed() {
        return this.device == null;
    }

    @Override
    public void close() throws IOException {
        if (this.isClosed()) {
            return;
        }
        if (!this.hasError) {
            this.flush();
        } else {
            this.waitForOutstandingTransfers();
        }
        this.device = null;
        this.availableTransferQueue.clear();
        this.currentTransfer = null;
        this.arena.close();
    }

    @Override
    public void write(int b) throws IOException {
        this.checkIsOpen();
        this.currentTransfer.data().set(ValueLayout.JAVA_BYTE, (long)this.writeOffset, (byte)b);
        ++this.writeOffset;
        if (this.writeOffset == this.transferSize) {
            this.submitTransfer(this.writeOffset);
        }
    }

    @Override
    public void write(byte @NotNull [] b, int off, int len) throws IOException {
        this.checkIsOpen();
        while (len > 0) {
            int chunkSize = Math.min(len, this.transferSize - this.writeOffset);
            MemorySegment.copy(b, off, this.currentTransfer.data(), ValueLayout.JAVA_BYTE, (long)this.writeOffset, chunkSize);
            this.writeOffset += chunkSize;
            off += chunkSize;
            len -= chunkSize;
            if (this.writeOffset != this.transferSize) continue;
            this.submitTransfer(this.writeOffset);
        }
    }

    @Override
    public void flush() throws IOException {
        this.checkIsOpen();
        if (this.writeOffset > 0) {
            this.submitTransfer(this.writeOffset);
        }
        if (this.needsZlp) {
            this.submitTransfer(0);
        }
        this.waitForOutstandingTransfers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void submitTransfer(int size) throws IOException {
        try {
            this.currentTransfer.setDataSize(size);
            this.submitTransferOut(this.currentTransfer);
            EndpointOutputStream endpointOutputStream = this;
            synchronized (endpointOutputStream) {
                ++this.numOutstandingTransfers;
            }
            this.needsZlp = size == this.packetSize;
            this.writeOffset = 0;
            this.currentTransfer = this.waitForAvailableTransfer();
        }
        catch (Exception t) {
            this.hasError = true;
            this.close();
            throw t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForOutstandingTransfers() {
        int numTransfers;
        EndpointOutputStream endpointOutputStream = this;
        synchronized (endpointOutputStream) {
            numTransfers = this.numOutstandingTransfers + this.availableTransferQueue.size();
        }
        if (numTransfers == 0) {
            return;
        }
        Transfer[] transfers = new Transfer[numTransfers];
        for (int i = 0; i < numTransfers; ++i) {
            transfers[i] = this.waitForAvailableTransfer();
        }
        if (!this.hasError) {
            this.availableTransferQueue.addAll(Arrays.asList(transfers));
        }
    }

    private Transfer waitForAvailableTransfer() {
        while (true) {
            try {
                Transfer transfer = this.availableTransferQueue.take();
                int result = transfer.resultCode();
                if (result != 0 && !this.hasError) {
                    transfer.setResultCode(0);
                    this.device.throwOSException(result, "error occurred while transmitting to endpoint %d", this.endpointNumber);
                }
                return transfer;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                continue;
            }
            break;
        }
    }

    private synchronized void onCompletion(Transfer transfer) {
        this.availableTransferQueue.add(transfer);
        --this.numOutstandingTransfers;
    }

    protected abstract void submitTransferOut(Transfer var1);

    protected void configureEndpoint() {
    }

    private void checkIsOpen() throws IOException {
        if (this.isClosed()) {
            throw new IOException("endpoint output stream has been closed");
        }
    }
}

