/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.metrics;

import io.sentry.MeasurementUnit;
import io.sentry.metrics.MetricType;
import io.sentry.metrics.MetricsHelper;
import io.sentry.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class MetricResourceIdentifier {
    @NotNull
    private final MetricType metricType;
    @NotNull
    private final String key;
    @Nullable
    private final MeasurementUnit unit;

    public MetricResourceIdentifier(@NotNull MetricType metricType, @NotNull String key, @Nullable MeasurementUnit unit) {
        this.metricType = metricType;
        this.key = key;
        this.unit = unit;
    }

    @NotNull
    public MetricType getMetricType() {
        return this.metricType;
    }

    @NotNull
    public String getKey() {
        return this.key;
    }

    @Nullable
    public MeasurementUnit getUnit() {
        return this.unit;
    }

    public String toString() {
        return String.format("%s:%s@%s", MetricsHelper.toStatsdType(this.metricType), MetricsHelper.sanitizeKey(this.key), this.unit);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        @NotNull MetricResourceIdentifier that = (MetricResourceIdentifier)o;
        return this.metricType == that.metricType && Objects.equals(this.key, that.key) && Objects.equals(this.unit, that.unit);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.metricType, this.key, this.unit});
    }
}

