/*
 * Decompiled with CFR 0.152.
 */
package org.rococoa;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.cglib.core.DefaultNamingPolicy;
import net.sf.cglib.core.NamingPolicy;
import net.sf.cglib.core.Predicate;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import org.rococoa.Foundation;
import org.rococoa.ID;
import org.rococoa.ObjCClass;
import org.rococoa.ObjCObject;
import org.rococoa.cocoa.CFIndex;
import org.rococoa.internal.OCInvocationCallbacks;
import org.rococoa.internal.ObjCObjectInvocationHandler;
import org.rococoa.internal.VarArgsUnpacker;

public abstract class Rococoa {
    private static final Logger logging = Logger.getLogger("org.rococoa.proxy");

    public static <T extends ObjCClass> T createClass(String ocClassName, Class<T> type) {
        return (T)((ObjCClass)Rococoa.wrap(Foundation.getClass(ocClassName), type, false));
    }

    public static <T extends ObjCObject> T create(String ocClassName, Class<T> javaClass, String ocMethodName, Object ... args) {
        boolean weOwnObject = Foundation.selectorNameMeansWeOwnReturnedObject(ocMethodName);
        boolean retain = !weOwnObject;
        return Rococoa.create(ocClassName, javaClass, ocMethodName, retain, args);
    }

    public static <T extends ObjCObject> T create(String ocClassName, Class<T> javaClass) {
        return Rococoa.create(ocClassName, javaClass, "new", new Object[0]);
    }

    private static <T extends ObjCObject> T create(String ocClassName, Class<T> javaClass, String ocFactoryName, boolean retain, Object ... args) {
        if (logging.isLoggable(Level.FINEST)) {
            logging.finest(String.format("creating [%s (%s)].%s(%s)", ocClassName, javaClass.getName(), ocFactoryName, new VarArgsUnpacker(args)));
        }
        ID ocClass = Foundation.getClass(ocClassName);
        ID ocInstance = Foundation.send(ocClass, ocFactoryName, ID.class, args);
        CFIndex initialRetainCount = Foundation.cfGetRetainCount(ocInstance);
        T result = Rococoa.wrap(ocInstance, javaClass, retain);
        Rococoa.checkRetainCount(ocInstance, retain ? initialRetainCount.intValue() + 1 : initialRetainCount.intValue());
        return result;
    }

    public static <T extends ObjCObject> T wrap(ID id, Class<T> javaClass) {
        return Rococoa.wrap(id, javaClass, true);
    }

    public static <T extends ObjCObject> T cast(ObjCObject object, Class<T> desiredType) {
        if (object == null) {
            return null;
        }
        return Rococoa.wrap(object.id(), desiredType, true);
    }

    public static <T extends ObjCObject> T wrap(ID id, Class<T> javaClass, boolean retain) {
        if (id == null || id.isNull()) {
            return null;
        }
        ObjCObjectInvocationHandler invocationHandler = new ObjCObjectInvocationHandler(id, javaClass, retain);
        return (T)((ObjCObject)Rococoa.createProxy(javaClass, invocationHandler));
    }

    @Deprecated
    public static ID wrap(Object javaObject) {
        OCInvocationCallbacks callbacks = new OCInvocationCallbacks(javaObject);
        ID idOfOCProxy = Foundation.newOCProxy(callbacks);
        return new ProxyID(idOfOCProxy, callbacks);
    }

    public static ObjCObject proxy(Object javaObject) {
        return Rococoa.proxy(javaObject, ObjCObject.class);
    }

    public static <T extends ObjCObject> T proxy(Object javaObject, Class<T> javaType) {
        ID proxyID = Rococoa.wrap(javaObject);
        return Rococoa.wrap(proxyID, javaType, false);
    }

    private static <T> T createProxy(final Class<T> type, ObjCObjectInvocationHandler invocationHandler) {
        if (type.isInterface()) {
            return (T)Proxy.newProxyInstance(invocationHandler.getClass().getClassLoader(), new Class[]{type}, (InvocationHandler)invocationHandler);
        }
        Enhancer e = new Enhancer();
        e.setUseCache(true);
        e.setNamingPolicy((NamingPolicy)new DefaultNamingPolicy(){

            public String getClassName(String prefix, String source, Object key, Predicate names) {
                if (source.equals(Enhancer.class.getName())) {
                    return type.getName() + "$$ByRococoa";
                }
                return super.getClassName(prefix, source, key, names);
            }
        });
        e.setSuperclass(type);
        e.setCallback((Callback)invocationHandler);
        return (T)e.create();
    }

    private static void checkRetainCount(ID ocInstance, int expected) {
        CFIndex retainCount = Foundation.cfGetRetainCount(ocInstance);
        if (retainCount.intValue() != expected) {
            logging.warning("Created an object which had a retain count of " + (Object)((Object)retainCount) + " not " + expected);
        }
    }

    private Rococoa() {
    }

    public static class ProxyID
    extends ID {
        private OCInvocationCallbacks callbacks;

        public ProxyID() {
        }

        public ProxyID(ID anotherID, OCInvocationCallbacks callbacks) {
            super(anotherID);
            this.callbacks = callbacks;
        }
    }
}

