/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.AddPrefixListEntry;
import com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.amazonaws.services.ec2.model.RemovePrefixListEntry;
import com.amazonaws.services.ec2.model.transform.ModifyManagedPrefixListRequestMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ModifyManagedPrefixListRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable,
DryRunSupportedRequest<ModifyManagedPrefixListRequest> {
    private String prefixListId;
    private Long currentVersion;
    private String prefixListName;
    private SdkInternalList<AddPrefixListEntry> addEntries;
    private SdkInternalList<RemovePrefixListEntry> removeEntries;

    public void setPrefixListId(String prefixListId) {
        this.prefixListId = prefixListId;
    }

    public String getPrefixListId() {
        return this.prefixListId;
    }

    public ModifyManagedPrefixListRequest withPrefixListId(String prefixListId) {
        this.setPrefixListId(prefixListId);
        return this;
    }

    public void setCurrentVersion(Long currentVersion) {
        this.currentVersion = currentVersion;
    }

    public Long getCurrentVersion() {
        return this.currentVersion;
    }

    public ModifyManagedPrefixListRequest withCurrentVersion(Long currentVersion) {
        this.setCurrentVersion(currentVersion);
        return this;
    }

    public void setPrefixListName(String prefixListName) {
        this.prefixListName = prefixListName;
    }

    public String getPrefixListName() {
        return this.prefixListName;
    }

    public ModifyManagedPrefixListRequest withPrefixListName(String prefixListName) {
        this.setPrefixListName(prefixListName);
        return this;
    }

    public List<AddPrefixListEntry> getAddEntries() {
        if (this.addEntries == null) {
            this.addEntries = new SdkInternalList();
        }
        return this.addEntries;
    }

    public void setAddEntries(Collection<AddPrefixListEntry> addEntries) {
        if (addEntries == null) {
            this.addEntries = null;
            return;
        }
        this.addEntries = new SdkInternalList(addEntries);
    }

    public ModifyManagedPrefixListRequest withAddEntries(AddPrefixListEntry ... addEntries) {
        if (this.addEntries == null) {
            this.setAddEntries((Collection<AddPrefixListEntry>)new SdkInternalList(addEntries.length));
        }
        for (AddPrefixListEntry ele : addEntries) {
            this.addEntries.add((Object)ele);
        }
        return this;
    }

    public ModifyManagedPrefixListRequest withAddEntries(Collection<AddPrefixListEntry> addEntries) {
        this.setAddEntries(addEntries);
        return this;
    }

    public List<RemovePrefixListEntry> getRemoveEntries() {
        if (this.removeEntries == null) {
            this.removeEntries = new SdkInternalList();
        }
        return this.removeEntries;
    }

    public void setRemoveEntries(Collection<RemovePrefixListEntry> removeEntries) {
        if (removeEntries == null) {
            this.removeEntries = null;
            return;
        }
        this.removeEntries = new SdkInternalList(removeEntries);
    }

    public ModifyManagedPrefixListRequest withRemoveEntries(RemovePrefixListEntry ... removeEntries) {
        if (this.removeEntries == null) {
            this.setRemoveEntries((Collection<RemovePrefixListEntry>)new SdkInternalList(removeEntries.length));
        }
        for (RemovePrefixListEntry ele : removeEntries) {
            this.removeEntries.add((Object)ele);
        }
        return this;
    }

    public ModifyManagedPrefixListRequest withRemoveEntries(Collection<RemovePrefixListEntry> removeEntries) {
        this.setRemoveEntries(removeEntries);
        return this;
    }

    @Override
    public Request<ModifyManagedPrefixListRequest> getDryRunRequest() {
        Request<ModifyManagedPrefixListRequest> request = new ModifyManagedPrefixListRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPrefixListId() != null) {
            sb.append("PrefixListId: ").append(this.getPrefixListId()).append(",");
        }
        if (this.getCurrentVersion() != null) {
            sb.append("CurrentVersion: ").append(this.getCurrentVersion()).append(",");
        }
        if (this.getPrefixListName() != null) {
            sb.append("PrefixListName: ").append(this.getPrefixListName()).append(",");
        }
        if (this.getAddEntries() != null) {
            sb.append("AddEntries: ").append(this.getAddEntries()).append(",");
        }
        if (this.getRemoveEntries() != null) {
            sb.append("RemoveEntries: ").append(this.getRemoveEntries());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyManagedPrefixListRequest)) {
            return false;
        }
        ModifyManagedPrefixListRequest other = (ModifyManagedPrefixListRequest)obj;
        if (other.getPrefixListId() == null ^ this.getPrefixListId() == null) {
            return false;
        }
        if (other.getPrefixListId() != null && !other.getPrefixListId().equals(this.getPrefixListId())) {
            return false;
        }
        if (other.getCurrentVersion() == null ^ this.getCurrentVersion() == null) {
            return false;
        }
        if (other.getCurrentVersion() != null && !other.getCurrentVersion().equals(this.getCurrentVersion())) {
            return false;
        }
        if (other.getPrefixListName() == null ^ this.getPrefixListName() == null) {
            return false;
        }
        if (other.getPrefixListName() != null && !other.getPrefixListName().equals(this.getPrefixListName())) {
            return false;
        }
        if (other.getAddEntries() == null ^ this.getAddEntries() == null) {
            return false;
        }
        if (other.getAddEntries() != null && !other.getAddEntries().equals(this.getAddEntries())) {
            return false;
        }
        if (other.getRemoveEntries() == null ^ this.getRemoveEntries() == null) {
            return false;
        }
        return other.getRemoveEntries() == null || other.getRemoveEntries().equals(this.getRemoveEntries());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPrefixListId() == null ? 0 : this.getPrefixListId().hashCode());
        hashCode = 31 * hashCode + (this.getCurrentVersion() == null ? 0 : this.getCurrentVersion().hashCode());
        hashCode = 31 * hashCode + (this.getPrefixListName() == null ? 0 : this.getPrefixListName().hashCode());
        hashCode = 31 * hashCode + (this.getAddEntries() == null ? 0 : this.getAddEntries().hashCode());
        hashCode = 31 * hashCode + (this.getRemoveEntries() == null ? 0 : this.getRemoveEntries().hashCode());
        return hashCode;
    }

    public ModifyManagedPrefixListRequest clone() {
        return (ModifyManagedPrefixListRequest)super.clone();
    }
}

