/*
 * Decompiled with CFR 0.152.
 */
package org.merlyn.desktopapp.coresdk;

import java.util.Base64;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.merlyn.desktopapp.coresdk.DecodedJwt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0080\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011\u00a8\u0006\u001f"}, d2={"Lorg/merlyn/desktopapp/coresdk/DecodedJwtImpl;", "Lorg/merlyn/desktopapp/coresdk/DecodedJwt;", "jwt", "", "<init>", "(Ljava/lang/String;)V", "getJwt", "()Ljava/lang/String;", "jwtParts", "", "decoder", "Ljava/util/Base64$Decoder;", "kotlin.jvm.PlatformType", "Ljava/util/Base64$Decoder;", "header", "Lkotlinx/serialization/json/JsonObject;", "getHeader", "()Lkotlinx/serialization/json/JsonObject;", "payload", "getPayload", "decodePart", "index", "", "component1", "copy", "equals", "", "other", "", "hashCode", "toString", "app"})
@SourceDebugExtension(value={"SMAP\nJWTToken.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JWTToken.kt\norg/merlyn/desktopapp/coresdk/DecodedJwtImpl\n+ 2 Json.kt\nkotlinx/serialization/json/Json\n*L\n1#1,60:1\n96#2:61\n*S KotlinDebug\n*F\n+ 1 JWTToken.kt\norg/merlyn/desktopapp/coresdk/DecodedJwtImpl\n*L\n57#1:61\n*E\n"})
public final class DecodedJwtImpl
implements DecodedJwt {
    @NotNull
    private final String jwt;
    @NotNull
    private final List<String> jwtParts;
    private final Base64.Decoder decoder;
    @NotNull
    private final JsonObject header;
    @NotNull
    private final JsonObject payload;

    public DecodedJwtImpl(@NotNull String jwt) {
        Intrinsics.checkNotNullParameter((Object)jwt, (String)"jwt");
        this.jwt = jwt;
        String[] stringArray = new String[]{"."};
        this.jwtParts = StringsKt.split$default((CharSequence)this.jwt, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        if (!(this.jwtParts.size() == 3)) {
            boolean bl = false;
            String string = "Invalid JWT: should contain 3 parts (header, payload and signature), separated by '.' but it was " + this.jwt;
            throw new IllegalStateException(string.toString());
        }
        this.decoder = Base64.getUrlDecoder();
        this.header = this.decodePart(0);
        this.payload = this.decodePart(1);
    }

    @NotNull
    public final String getJwt() {
        return this.jwt;
    }

    @Override
    @NotNull
    public JsonObject getHeader() {
        return this.header;
    }

    @Override
    @NotNull
    public JsonObject getPayload() {
        return this.payload;
    }

    private final JsonObject decodePart(int index) {
        byte[] byArray = this.decoder.decode(this.jwtParts.get(index));
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"decode(...)");
        byte[] byArray2 = byArray;
        String partAsString = new String(byArray2, Charsets.UTF_8);
        Json this_$iv = (Json)Json.Default;
        boolean $i$f$decodeFromString = false;
        this_$iv.getSerializersModule();
        return (JsonObject)this_$iv.decodeFromString((DeserializationStrategy)JsonObject.Companion.serializer(), partAsString);
    }

    @NotNull
    public final String component1() {
        return this.jwt;
    }

    @NotNull
    public final DecodedJwtImpl copy(@NotNull String jwt) {
        Intrinsics.checkNotNullParameter((Object)jwt, (String)"jwt");
        return new DecodedJwtImpl(jwt);
    }

    public static /* synthetic */ DecodedJwtImpl copy$default(DecodedJwtImpl decodedJwtImpl, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = decodedJwtImpl.jwt;
        }
        return decodedJwtImpl.copy(string);
    }

    @NotNull
    public String toString() {
        return "DecodedJwtImpl(jwt=" + this.jwt + ")";
    }

    public int hashCode() {
        return this.jwt.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DecodedJwtImpl)) {
            return false;
        }
        DecodedJwtImpl decodedJwtImpl = (DecodedJwtImpl)other;
        return Intrinsics.areEqual((Object)this.jwt, (Object)decodedJwtImpl.jwt);
    }
}

