/*
 * Decompiled with CFR 0.152.
 */
package org.merlyn.desktopapp.http;

import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import io.ktor.http.HttpHeaders;
import io.ktor.http.HttpStatusCode;
import io.ktor.http.content.OutgoingContent;
import io.ktor.serialization.WebsocketContentConverter;
import io.ktor.serialization.kotlinx.KotlinxWebsocketSerializationConverter;
import io.ktor.serialization.kotlinx.json.JsonSupportKt;
import io.ktor.server.application.Application;
import io.ktor.server.application.ApplicationCall;
import io.ktor.server.application.ApplicationPluginKt;
import io.ktor.server.application.Plugin;
import io.ktor.server.freemarker.FreeMarkerKt;
import io.ktor.server.plugins.callloging.CallLoggingConfig;
import io.ktor.server.plugins.callloging.CallLoggingKt;
import io.ktor.server.plugins.contentnegotiation.ContentNegotiationConfig;
import io.ktor.server.plugins.contentnegotiation.ContentNegotiationKt;
import io.ktor.server.plugins.cors.CORSConfig;
import io.ktor.server.plugins.cors.routing.CORSKt;
import io.ktor.server.plugins.ratelimit.RateLimitConfig;
import io.ktor.server.plugins.ratelimit.RateLimitKt;
import io.ktor.server.plugins.ratelimit.RateLimitProviderConfig;
import io.ktor.server.plugins.ratelimit.RateLimiter;
import io.ktor.server.plugins.ratelimit.RoutingKt;
import io.ktor.server.plugins.statuspages.StatusPagesConfig;
import io.ktor.server.plugins.statuspages.StatusPagesKt;
import io.ktor.server.request.ApplicationRequest;
import io.ktor.server.request.ApplicationRequestPropertiesKt;
import io.ktor.server.response.ApplicationResponse;
import io.ktor.server.response.ApplicationResponseFunctionsKt;
import io.ktor.server.response.ApplicationSendPipeline;
import io.ktor.server.response.ResponseTypeKt;
import io.ktor.server.routing.Route;
import io.ktor.server.routing.Routing;
import io.ktor.server.websocket.WebSockets;
import io.ktor.util.pipeline.Pipeline;
import io.ktor.util.reflect.TypeInfo;
import io.ktor.util.reflect.TypeInfoJvmKt;
import java.lang.reflect.Type;
import java.time.Duration;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.reflect.KType;
import kotlin.reflect.TypesJVMKt;
import kotlinx.serialization.SerialFormat;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonBuilder;
import kotlinx.serialization.json.JsonKt;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.koin.core.Koin;
import org.koin.core.qualifier.Qualifier;
import org.koin.core.scope.Scope;
import org.koin.ktor.ext.ApplicationExtKt;
import org.merlyn.desktopapp.config.AppConfig;
import org.merlyn.desktopapp.config.StageConfig;
import org.merlyn.desktopapp.http.BrowserWebSocketRateLimiter;
import org.merlyn.desktopapp.http.HttpServer;
import org.merlyn.desktopapp.http.routes.AuthRoutesKt;
import org.merlyn.desktopapp.http.routes.DiagnosticRoutesKt;
import org.merlyn.desktopapp.http.routes.HealthRoutesKt;
import org.merlyn.desktopapp.http.routes.InterInstanceIPCRoutesKt;
import org.merlyn.desktopapp.http.routes.InternalRoutesKt;
import org.merlyn.desktopapp.http.routes.PingRouteKt;
import org.merlyn.desktopapp.http.routes.WebsocketRoutesKt;
import org.merlyn.desktopapp.http.routes.WindowManagementRoutesKt;
import org.merlyn.desktopapp.http.routes.WorkflowRoutesKt;
import org.merlyn.desktopapp.log.LogbackService;
import org.merlyn.desktopapp.log.LogbackServiceKt;
import org.merlyn.desktopapp.storage.DeviceDataDao;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000\u00a8\u0006\t\u00b2\u0006\n\u0010\n\u001a\u00020\u000bX\u008a\u0084\u0002\u00b2\u0006\n\u0010\f\u001a\u00020\rX\u008a\u0084\u0002\u00b2\u0006\n\u0010\u0007\u001a\u00020\bX\u008a\u0084\u0002\u00b2\u0006\n\u0010\u000e\u001a\u00020\u000fX\u008a\u0084\u0002"}, d2={"websocketBrowserExtensionServer", "", "Lio/ktor/server/application/Application;", "getLoggerForErrorInCall", "", "call", "Lio/ktor/server/application/ApplicationCall;", "logbackService", "Lorg/merlyn/desktopapp/log/LogbackService;", "app", "config", "Lorg/merlyn/desktopapp/config/StageConfig;", "deviceDataDao", "Lorg/merlyn/desktopapp/storage/DeviceDataDao;", "browserWebSocketRateLimiter", "Lorg/merlyn/desktopapp/http/BrowserWebSocketRateLimiter;"})
@SourceDebugExtension(value={"SMAP\nHttpServer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpServer.kt\norg/merlyn/desktopapp/http/HttpServerKt\n+ 2 ApplicationExt.kt\norg/koin/ktor/ext/ApplicationExtKt\n+ 3 Durations.kt\nio/ktor/server/websocket/DurationsKt\n+ 4 StatusPages.kt\nio/ktor/server/plugins/statuspages/StatusPagesConfig\n*L\n1#1,138:1\n53#2,5:139\n53#2,5:144\n53#2,5:149\n53#2,5:154\n58#3,5:159\n68#3,2:164\n127#4:166\n*S KotlinDebug\n*F\n+ 1 HttpServer.kt\norg/merlyn/desktopapp/http/HttpServerKt\n*L\n50#1:139,5\n51#1:144,5\n52#1:149,5\n53#1:154,5\n60#1:159,5\n61#1:164,2\n72#1:166\n*E\n"})
public final class HttpServerKt {
    public static final void websocketBrowserExtensionServer(@NotNull Application $this$websocketBrowserExtensionServer) {
        Intrinsics.checkNotNullParameter((Object)$this$websocketBrowserExtensionServer, (String)"<this>");
        Application $this$inject_u24default$iv = $this$websocketBrowserExtensionServer;
        Qualifier qualifier$iv = null;
        Function0 parameters$iv = null;
        boolean $i$f$inject = false;
        Lazy config$delegate = LazyKt.lazy((Function0)((Function0)new Function0<StageConfig>($this$inject_u24default$iv, qualifier$iv, parameters$iv){
            final /* synthetic */ Application $this_inject;
            final /* synthetic */ Qualifier $qualifier;
            final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = $receiver;
                this.$qualifier = $qualifier;
                this.$parameters = $parameters;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final StageConfig invoke() {
                void qualifier$iv;
                void $this$get$iv;
                Application application = this.$this_inject;
                Qualifier qualifier = this.$qualifier;
                Function0 parameters$iv = this.$parameters;
                boolean $i$f$get = false;
                Koin this_$iv$iv = ApplicationExtKt.getKoin((Application)$this$get$iv);
                boolean $i$f$get2 = false;
                Scope this_$iv$iv$iv = this_$iv$iv.getScopeRegistry().getRootScope();
                boolean $i$f$get3 = false;
                return this_$iv$iv$iv.get(Reflection.getOrCreateKotlinClass(StageConfig.class), (Qualifier)qualifier$iv, parameters$iv);
            }
        }));
        Application $this$inject_u24default$iv2 = $this$websocketBrowserExtensionServer;
        Qualifier qualifier$iv2 = null;
        Function0 parameters$iv2 = null;
        boolean $i$f$inject2 = false;
        Lazy deviceDataDao$delegate = LazyKt.lazy((Function0)((Function0)new Function0<DeviceDataDao>($this$inject_u24default$iv2, qualifier$iv2, parameters$iv2){
            final /* synthetic */ Application $this_inject;
            final /* synthetic */ Qualifier $qualifier;
            final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = $receiver;
                this.$qualifier = $qualifier;
                this.$parameters = $parameters;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final DeviceDataDao invoke() {
                void qualifier$iv;
                void $this$get$iv;
                Application application = this.$this_inject;
                Qualifier qualifier = this.$qualifier;
                Function0 parameters$iv = this.$parameters;
                boolean $i$f$get = false;
                Koin this_$iv$iv = ApplicationExtKt.getKoin((Application)$this$get$iv);
                boolean $i$f$get2 = false;
                Scope this_$iv$iv$iv = this_$iv$iv.getScopeRegistry().getRootScope();
                boolean $i$f$get3 = false;
                return this_$iv$iv$iv.get(Reflection.getOrCreateKotlinClass(DeviceDataDao.class), (Qualifier)qualifier$iv, parameters$iv);
            }
        }));
        Application $this$inject_u24default$iv3 = $this$websocketBrowserExtensionServer;
        Qualifier qualifier$iv3 = null;
        Function0 parameters$iv3 = null;
        boolean $i$f$inject3 = false;
        Lazy logbackService$delegate = LazyKt.lazy((Function0)((Function0)new Function0<LogbackService>($this$inject_u24default$iv3, qualifier$iv3, parameters$iv3){
            final /* synthetic */ Application $this_inject;
            final /* synthetic */ Qualifier $qualifier;
            final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = $receiver;
                this.$qualifier = $qualifier;
                this.$parameters = $parameters;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final LogbackService invoke() {
                void qualifier$iv;
                void $this$get$iv;
                Application application = this.$this_inject;
                Qualifier qualifier = this.$qualifier;
                Function0 parameters$iv = this.$parameters;
                boolean $i$f$get = false;
                Koin this_$iv$iv = ApplicationExtKt.getKoin((Application)$this$get$iv);
                boolean $i$f$get2 = false;
                Scope this_$iv$iv$iv = this_$iv$iv.getScopeRegistry().getRootScope();
                boolean $i$f$get3 = false;
                return this_$iv$iv$iv.get(Reflection.getOrCreateKotlinClass(LogbackService.class), (Qualifier)qualifier$iv, parameters$iv);
            }
        }));
        Application $this$inject_u24default$iv4 = $this$websocketBrowserExtensionServer;
        Qualifier qualifier$iv4 = null;
        Function0 parameters$iv4 = null;
        boolean $i$f$inject4 = false;
        Lazy browserWebSocketRateLimiter$delegate = LazyKt.lazy((Function0)((Function0)new Function0<BrowserWebSocketRateLimiter>($this$inject_u24default$iv4, qualifier$iv4, parameters$iv4){
            final /* synthetic */ Application $this_inject;
            final /* synthetic */ Qualifier $qualifier;
            final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = $receiver;
                this.$qualifier = $qualifier;
                this.$parameters = $parameters;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final BrowserWebSocketRateLimiter invoke() {
                void qualifier$iv;
                void $this$get$iv;
                Application application = this.$this_inject;
                Qualifier qualifier = this.$qualifier;
                Function0 parameters$iv = this.$parameters;
                boolean $i$f$get = false;
                Koin this_$iv$iv = ApplicationExtKt.getKoin((Application)$this$get$iv);
                boolean $i$f$get2 = false;
                Scope this_$iv$iv$iv = this_$iv$iv.getScopeRegistry().getRootScope();
                boolean $i$f$get3 = false;
                return this_$iv$iv$iv.get(Reflection.getOrCreateKotlinClass(BrowserWebSocketRateLimiter.class), (Qualifier)qualifier$iv, parameters$iv);
            }
        }));
        AppConfig appConfig = HttpServerKt.websocketBrowserExtensionServer$lambda$0((Lazy<StageConfig>)config$delegate).getApplicationConfig();
        Duration pingPeriodDuration = Duration.ofSeconds(appConfig.getServerPingPeriod());
        Duration timeoutDuration = Duration.ofSeconds(appConfig.getServerTimeout());
        ApplicationPluginKt.install((Pipeline)((Pipeline)$this$websocketBrowserExtensionServer), (Plugin)((Plugin)WebSockets.Plugin), arg_0 -> HttpServerKt.websocketBrowserExtensionServer$lambda$4(pingPeriodDuration, timeoutDuration, arg_0));
        ApplicationPluginKt.install((Pipeline)((Pipeline)$this$websocketBrowserExtensionServer), (Plugin)((Plugin)FreeMarkerKt.getFreeMarker()), HttpServerKt::websocketBrowserExtensionServer$lambda$5);
        ApplicationPluginKt.install((Pipeline)((Pipeline)$this$websocketBrowserExtensionServer), (Plugin)((Plugin)ContentNegotiationKt.getContentNegotiation()), HttpServerKt::websocketBrowserExtensionServer$lambda$7);
        ApplicationPluginKt.install((Pipeline)((Pipeline)$this$websocketBrowserExtensionServer), (Plugin)((Plugin)StatusPagesKt.getStatusPages()), arg_0 -> HttpServerKt.websocketBrowserExtensionServer$lambda$8(logbackService$delegate, config$delegate, arg_0));
        ApplicationPluginKt.install((Pipeline)((Pipeline)$this$websocketBrowserExtensionServer), (Plugin)((Plugin)CORSKt.getCORS()), arg_0 -> HttpServerKt.websocketBrowserExtensionServer$lambda$9(config$delegate, arg_0));
        ApplicationPluginKt.install((Pipeline)((Pipeline)$this$websocketBrowserExtensionServer), (Plugin)((Plugin)CallLoggingKt.getCallLogging()), arg_0 -> HttpServerKt.websocketBrowserExtensionServer$lambda$11(deviceDataDao$delegate, arg_0));
        ApplicationPluginKt.install((Pipeline)((Pipeline)$this$websocketBrowserExtensionServer), (Plugin)((Plugin)RateLimitKt.getRateLimit()), arg_0 -> HttpServerKt.websocketBrowserExtensionServer$lambda$14(browserWebSocketRateLimiter$delegate, arg_0));
        io.ktor.server.routing.RoutingKt.routing((Application)$this$websocketBrowserExtensionServer, HttpServerKt::websocketBrowserExtensionServer$lambda$16);
    }

    @NotNull
    public static final String getLoggerForErrorInCall(@NotNull ApplicationCall call, @NotNull LogbackService logbackService) {
        String string;
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)logbackService, (String)"logbackService");
        if (Intrinsics.areEqual((Object)"/authcompleted", (Object)ApplicationRequestPropertiesKt.path((ApplicationRequest)call.getRequest()))) {
            string = logbackService.getCrashLogger();
        } else {
            String string2 = Reflection.getOrCreateKotlinClass(HttpServer.class).getQualifiedName();
            string = string2;
            Intrinsics.checkNotNull((Object)string2);
        }
        return string;
    }

    private static final StageConfig websocketBrowserExtensionServer$lambda$0(Lazy<StageConfig> $config$delegate) {
        Lazy<StageConfig> lazy = $config$delegate;
        return (StageConfig)lazy.getValue();
    }

    private static final DeviceDataDao websocketBrowserExtensionServer$lambda$1(Lazy<? extends DeviceDataDao> $deviceDataDao$delegate) {
        Lazy<? extends DeviceDataDao> lazy = $deviceDataDao$delegate;
        return (DeviceDataDao)lazy.getValue();
    }

    private static final LogbackService websocketBrowserExtensionServer$lambda$2(Lazy<LogbackService> $logbackService$delegate) {
        Lazy<LogbackService> lazy = $logbackService$delegate;
        return (LogbackService)lazy.getValue();
    }

    private static final BrowserWebSocketRateLimiter websocketBrowserExtensionServer$lambda$3(Lazy<BrowserWebSocketRateLimiter> $browserWebSocketRateLimiter$delegate) {
        Lazy<BrowserWebSocketRateLimiter> lazy = $browserWebSocketRateLimiter$delegate;
        return (BrowserWebSocketRateLimiter)lazy.getValue();
    }

    private static final Unit websocketBrowserExtensionServer$lambda$4(Duration $pingPeriodDuration, Duration $timeoutDuration, WebSockets.WebSocketOptions $this$install) {
        Intrinsics.checkNotNullParameter((Object)$this$install, (String)"$this$install");
        WebSockets.WebSocketOptions $this$pingPeriod$iv = $this$install;
        boolean $i$f$setPingPeriod = false;
        $this$pingPeriod$iv.setPingPeriodMillis($pingPeriodDuration == null ? 0L : $pingPeriodDuration.toMillis());
        WebSockets.WebSocketOptions $this$timeout$iv = $this$install;
        boolean $i$f$setTimeout = false;
        $this$timeout$iv.setTimeoutMillis($timeoutDuration.toMillis());
        $this$install.setMaxFrameSize(Long.MAX_VALUE);
        $this$install.setMasking(false);
        $this$install.setContentConverter((WebsocketContentConverter)new KotlinxWebsocketSerializationConverter((SerialFormat)Json.Default));
        return Unit.INSTANCE;
    }

    private static final Unit websocketBrowserExtensionServer$lambda$5(Configuration $this$install) {
        Intrinsics.checkNotNullParameter((Object)$this$install, (String)"$this$install");
        $this$install.setTemplateLoader((TemplateLoader)new ClassTemplateLoader($this$install.getClass(), "/templates"));
        return Unit.INSTANCE;
    }

    private static final Unit websocketBrowserExtensionServer$lambda$7$lambda$6(JsonBuilder $this$Json) {
        Intrinsics.checkNotNullParameter((Object)$this$Json, (String)"$this$Json");
        $this$Json.setExplicitNulls(false);
        return Unit.INSTANCE;
    }

    private static final Unit websocketBrowserExtensionServer$lambda$7(ContentNegotiationConfig $this$install) {
        Intrinsics.checkNotNullParameter((Object)$this$install, (String)"$this$install");
        JsonSupportKt.json$default((io.ktor.serialization.Configuration)((io.ktor.serialization.Configuration)$this$install), (Json)JsonKt.Json$default(null, HttpServerKt::websocketBrowserExtensionServer$lambda$7$lambda$6, (int)1, null), null, (int)2, null);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit websocketBrowserExtensionServer$lambda$8(Lazy $logbackService$delegate, Lazy $config$delegate, StatusPagesConfig $this$install) {
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)$this$install, (String)"$this$install");
        StatusPagesConfig statusPagesConfig = $this$install;
        Function3 handler$iv = (Function3)new Function3<ApplicationCall, Throwable, Continuation<? super Unit>, Object>((Lazy<LogbackService>)$logbackService$delegate, (Lazy<StageConfig>)$config$delegate, null){
            int label;
            /* synthetic */ Object L$0;
            /* synthetic */ Object L$1;
            final /* synthetic */ Lazy<LogbackService> $logbackService$delegate;
            final /* synthetic */ Lazy<StageConfig> $config$delegate;
            {
                this.$logbackService$delegate = $logbackService$delegate;
                this.$config$delegate = $config$delegate;
                super(3, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                void var2_3;
                void $result;
                String[] stringArray;
                Object object2;
                block10: {
                    Object object3;
                    String string;
                    String[] call;
                    object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            void var3_4;
                            ResultKt.throwOnFailure((Object)object);
                            call = (String[])this.L$0;
                            Throwable cause = (Throwable)this.L$1;
                            if (Intrinsics.areEqual((Object)ApplicationRequestPropertiesKt.path((ApplicationRequest)call.getRequest()), (Object)"/")) return Unit.INSTANCE;
                            KotlinLogging.INSTANCE.logger(HttpServerKt.getLoggerForErrorInCall((ApplicationCall)call, HttpServerKt.access$websocketBrowserExtensionServer$lambda$2(this.$logbackService$delegate))).error("Error processing HTTP request " + ApplicationRequestPropertiesKt.path((ApplicationRequest)call.getRequest()) + ": " + cause.getMessage(), (Throwable)var3_4);
                            string = ApplicationRequestPropertiesKt.path((ApplicationRequest)call.getRequest());
                            stringArray = new String[]{"/authcompleted", "/logoutcompleted"};
                            if (!CollectionsKt.listOf((Object[])stringArray).contains(string)) break;
                            this.L$0 = null;
                            this.label = 1;
                            Object object4 = ApplicationResponseFunctionsKt.respondRedirect$default((ApplicationCall)call, (String)HttpServerKt.access$websocketBrowserExtensionServer$lambda$0(this.$config$delegate).getEnvironmentConfig().getTeacherPortalErrorRedirectUrl(), (boolean)false, (Continuation)((Continuation)this), (int)2, null);
                            if (object4 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object4 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    if (Intrinsics.areEqual((Object)string, (Object)"/workflows")) {
                        void $this$respond$iv;
                        stringArray = call;
                        HttpStatusCode message$iv = HttpStatusCode.Companion.getUnauthorized();
                        boolean $i$f$respondWithType = false;
                        if (!(message$iv instanceof OutgoingContent) && !(message$iv instanceof byte[])) {
                            boolean $i$f$typeInfo = false;
                            KType kType$iv$iv = Reflection.typeOf(HttpStatusCode.class);
                            Type reifiedType$iv$iv = TypesJVMKt.getJavaType((KType)kType$iv$iv);
                            ResponseTypeKt.setResponseType((ApplicationResponse)$this$respond$iv.getResponse(), (TypeInfo)TypeInfoJvmKt.typeInfoImpl((Type)reifiedType$iv$iv, (KClass)Reflection.getOrCreateKotlinClass(HttpStatusCode.class), (KType)kType$iv$iv));
                        }
                        ApplicationSendPipeline applicationSendPipeline = $this$respond$iv.getResponse().getPipeline();
                        Intrinsics.checkNotNull((Object)message$iv, (String)"null cannot be cast to non-null type kotlin.Any");
                        this.L$0 = null;
                        this.label = 2;
                        object3 = applicationSendPipeline.execute((Object)$this$respond$iv, (Object)message$iv, (Continuation)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    break block10;
                    {
                        case 2: {
                            boolean $i$f$respondWithType = false;
                            ResultKt.throwOnFailure((Object)$result);
                            object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                }
                stringArray = HttpStatusCode.Companion.getInternalServerError();
                this.L$0 = null;
                this.label = 3;
                Object object5 = ApplicationResponseFunctionsKt.respondText$default((ApplicationCall)var2_3, (String)"Error processing request", null, (HttpStatusCode)stringArray, null, (Continuation)((Continuation)this), (int)10, null);
                if (object5 != object2) return Unit.INSTANCE;
                return object2;
                {
                    case 3: {
                        ResultKt.throwOnFailure((Object)$result);
                        object5 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Object invoke(ApplicationCall p1, Throwable p2, Continuation<? super Unit> p3) {
                var var4_4 = new /* invalid duplicate definition of identical inner class */;
                var4_4.L$0 = p1;
                var4_4.L$1 = p2;
                return var4_4.invokeSuspend(Unit.INSTANCE);
            }
        };
        boolean $i$f$exception = false;
        this_$iv.exception(Reflection.getOrCreateKotlinClass(Throwable.class), handler$iv);
        return Unit.INSTANCE;
    }

    private static final Unit websocketBrowserExtensionServer$lambda$9(Lazy $config$delegate, CORSConfig $this$install) {
        Intrinsics.checkNotNullParameter((Object)$this$install, (String)"$this$install");
        List<String> hosts = HttpServerKt.websocketBrowserExtensionServer$lambda$0((Lazy<StageConfig>)$config$delegate).getEnvironmentConfig().getServerAllowedHosts();
        if (hosts.contains("*")) {
            $this$install.anyHost();
        } else {
            for (String host : hosts) {
                CORSConfig.allowHost$default((CORSConfig)$this$install, (String)host, null, null, (int)6, null);
            }
        }
        $this$install.allowHeader(HttpHeaders.INSTANCE.getContentType());
        $this$install.allowHeader(HttpHeaders.INSTANCE.getOrigin());
        return Unit.INSTANCE;
    }

    private static final String websocketBrowserExtensionServer$lambda$11$lambda$10(Lazy $deviceDataDao$delegate, ApplicationCall it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return HttpServerKt.websocketBrowserExtensionServer$lambda$1((Lazy<? extends DeviceDataDao>)$deviceDataDao$delegate).get().getDeviceId();
    }

    private static final Unit websocketBrowserExtensionServer$lambda$11(Lazy $deviceDataDao$delegate, CallLoggingConfig $this$install) {
        Intrinsics.checkNotNullParameter((Object)$this$install, (String)"$this$install");
        $this$install.disableDefaultColors();
        $this$install.mdc(LogbackServiceKt.getDeviceIdMDCKey(), arg_0 -> HttpServerKt.websocketBrowserExtensionServer$lambda$11$lambda$10($deviceDataDao$delegate, arg_0));
        return Unit.INSTANCE;
    }

    private static final RateLimiter websocketBrowserExtensionServer$lambda$14$lambda$13$lambda$12(Lazy $browserWebSocketRateLimiter$delegate, ApplicationCall applicationCall, Object object) {
        Intrinsics.checkNotNullParameter((Object)applicationCall, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)object, (String)"<unused var>");
        return HttpServerKt.websocketBrowserExtensionServer$lambda$3((Lazy<BrowserWebSocketRateLimiter>)$browserWebSocketRateLimiter$delegate);
    }

    private static final Unit websocketBrowserExtensionServer$lambda$14$lambda$13(Lazy $browserWebSocketRateLimiter$delegate, RateLimitProviderConfig $this$register) {
        Intrinsics.checkNotNullParameter((Object)$this$register, (String)"$this$register");
        $this$register.rateLimiter((arg_0, arg_1) -> HttpServerKt.websocketBrowserExtensionServer$lambda$14$lambda$13$lambda$12($browserWebSocketRateLimiter$delegate, arg_0, arg_1));
        return Unit.INSTANCE;
    }

    private static final Unit websocketBrowserExtensionServer$lambda$14(Lazy $browserWebSocketRateLimiter$delegate, RateLimitConfig $this$install) {
        Intrinsics.checkNotNullParameter((Object)$this$install, (String)"$this$install");
        RateLimitConfig.register-zVFXGRI$default((RateLimitConfig)$this$install, null, arg_0 -> HttpServerKt.websocketBrowserExtensionServer$lambda$14$lambda$13($browserWebSocketRateLimiter$delegate, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit websocketBrowserExtensionServer$lambda$16$lambda$15(Route $this$rateLimit) {
        Intrinsics.checkNotNullParameter((Object)$this$rateLimit, (String)"$this$rateLimit");
        WebsocketRoutesKt.webSocketRoutes($this$rateLimit);
        return Unit.INSTANCE;
    }

    private static final Unit websocketBrowserExtensionServer$lambda$16(Routing $this$routing) {
        Intrinsics.checkNotNullParameter((Object)$this$routing, (String)"$this$routing");
        PingRouteKt.pingRoute((Route)$this$routing);
        AuthRoutesKt.authRoutes((Route)$this$routing);
        HealthRoutesKt.healthRoutes((Route)$this$routing);
        DiagnosticRoutesKt.diagnosticRoutes((Route)$this$routing);
        InternalRoutesKt.internalRoutes((Route)$this$routing);
        WorkflowRoutesKt.workflowRoutes((Route)$this$routing);
        WindowManagementRoutesKt.windowManagementRoutes((Route)$this$routing);
        InterInstanceIPCRoutesKt.interInstanceIPCRoutes((Route)$this$routing);
        InterInstanceIPCRoutesKt.interInstanceIPCWebSocketRoutes((Route)$this$routing);
        RoutingKt.rateLimit-TBT8wpQ$default((Route)((Route)$this$routing), null, HttpServerKt::websocketBrowserExtensionServer$lambda$16$lambda$15, (int)1, null);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ LogbackService access$websocketBrowserExtensionServer$lambda$2(Lazy $logbackService$delegate) {
        return HttpServerKt.websocketBrowserExtensionServer$lambda$2((Lazy<LogbackService>)$logbackService$delegate);
    }

    public static final /* synthetic */ StageConfig access$websocketBrowserExtensionServer$lambda$0(Lazy $config$delegate) {
        return HttpServerKt.websocketBrowserExtensionServer$lambda$0((Lazy<StageConfig>)$config$delegate);
    }
}

