/*
 * Decompiled with CFR 0.152.
 */
package org.merlyn.desktopapp.http;

import java.time.Duration;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.merlyn.desktopapp.config.StageConfig;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0007J\u000e\u0010\f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0007J\u000e\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0007J$\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00072\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\n0\u0012H\u0002J$\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u000e2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\n0\u0012H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/merlyn/desktopapp/http/InstantHelper;", "", "config", "Lorg/merlyn/desktopapp/config/StageConfig;", "<init>", "(Lorg/merlyn/desktopapp/config/StageConfig;)V", "intervalToRefreshAccessToken", "", "intervalToRefreshLogCredentials", "accessTokenNeedsRefresh", "", "tokenExpiration", "accessTokenIsInvalid", "logCredentialsNeedsRefresh", "Ljava/time/Instant;", "tokenIsUsable", "processTokenExpiration", "check", "Lkotlin/Function1;", "tokenInstant", "app"})
public final class InstantHelper {
    private final long intervalToRefreshAccessToken;
    private final long intervalToRefreshLogCredentials;

    public InstantHelper(@NotNull StageConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.intervalToRefreshAccessToken = (long)2 * kotlin.time.Duration.getInWholeSeconds-impl((long)DurationKt.toDuration((int)config.getApplicationConfig().getAuthWorkerSchedule(), (DurationUnit)DurationUnit.MINUTES));
        this.intervalToRefreshLogCredentials = kotlin.time.Duration.getInWholeSeconds-impl((long)DurationKt.toDuration((int)config.getApplicationConfig().getAuthWorkerSchedule(), (DurationUnit)DurationUnit.MINUTES));
    }

    public final boolean accessTokenNeedsRefresh(long tokenExpiration) {
        return this.processTokenExpiration(tokenExpiration, (Function1<? super Long, Boolean>)((Function1)arg_0 -> InstantHelper.accessTokenNeedsRefresh$lambda$0(this, arg_0)));
    }

    public final boolean accessTokenIsInvalid(long tokenExpiration) {
        return this.processTokenExpiration(tokenExpiration, (Function1<? super Long, Boolean>)((Function1)InstantHelper::accessTokenIsInvalid$lambda$1));
    }

    public final boolean logCredentialsNeedsRefresh(@NotNull Instant tokenExpiration) {
        Intrinsics.checkNotNullParameter((Object)tokenExpiration, (String)"tokenExpiration");
        return this.processTokenExpiration(tokenExpiration, (Function1<? super Long, Boolean>)((Function1)arg_0 -> InstantHelper.logCredentialsNeedsRefresh$lambda$2(this, arg_0)));
    }

    public final boolean tokenIsUsable(long tokenExpiration) {
        return this.processTokenExpiration(tokenExpiration, (Function1<? super Long, Boolean>)((Function1)InstantHelper::tokenIsUsable$lambda$3));
    }

    private final boolean processTokenExpiration(long tokenExpiration, Function1<? super Long, Boolean> check) {
        Instant instant = Instant.ofEpochSecond(tokenExpiration);
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"ofEpochSecond(...)");
        return this.processTokenExpiration(instant, check);
    }

    private final boolean processTokenExpiration(Instant tokenInstant, Function1<? super Long, Boolean> check) {
        Instant now = Instant.now();
        long intervalInSeconds = Duration.between(now, tokenInstant).getSeconds();
        return (Boolean)check.invoke((Object)intervalInSeconds);
    }

    private static final boolean accessTokenNeedsRefresh$lambda$0(InstantHelper this$0, long it) {
        return it <= this$0.intervalToRefreshAccessToken;
    }

    private static final boolean accessTokenIsInvalid$lambda$1(long it) {
        return it <= 0L;
    }

    private static final boolean logCredentialsNeedsRefresh$lambda$2(InstantHelper this$0, long it) {
        return it <= this$0.intervalToRefreshLogCredentials;
    }

    private static final boolean tokenIsUsable$lambda$3(long it) {
        return it > kotlin.time.Duration.getInWholeSeconds-impl((long)DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.MINUTES));
    }
}

