/*
 * Decompiled with CFR 0.152.
 */
package org.merlyn.desktopapp.http;

import io.ktor.client.HttpClient;
import io.ktor.client.plugins.HttpClientPlugin;
import io.ktor.client.plugins.HttpRequestTimeoutException;
import io.ktor.client.request.HttpRequestBuilder;
import io.ktor.client.request.HttpSendPipeline;
import io.ktor.client.statement.HttpReceivePipeline;
import io.ktor.client.statement.HttpResponse;
import io.ktor.client.statement.HttpResponseKt;
import io.ktor.client.utils.ExceptionUtilsJvmKt;
import io.ktor.http.Url;
import io.ktor.util.AttributeKey;
import io.ktor.util.Attributes;
import io.ktor.util.pipeline.PipelineContext;
import io.ktor.util.pipeline.PipelinePhase;
import io.micrometer.core.instrument.Timer;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.merlyn.desktopapp.metrics.Metric;
import org.merlyn.desktopapp.metrics.MetricName;
import software.amazon.awssdk.http.HttpStatusFamily;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00172\u00020\u0001:\u0002\u0016\u0017B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003JP\u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00060\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0010H\u0002JF\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0010H\u0002J>\u0010\u0015\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0010H\u0002\u00a8\u0006\u0018"}, d2={"Lorg/merlyn/desktopapp/http/KtorClientMicrometerMetrics;", "", "<init>", "()V", "getLabels", "", "Lkotlin/Pair;", "", "url", "Lio/ktor/http/Url;", "method", "status", "", "throwable", "", "additionalAttributes", "", "stopTimer", "", "sample", "Lio/micrometer/core/instrument/Timer$Sample;", "recordError", "Config", "Feature", "app"})
@SourceDebugExtension(value={"SMAP\nHttpClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpClient.kt\norg/merlyn/desktopapp/http/KtorClientMicrometerMetrics\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,203:1\n1#2:204\n126#3:205\n153#3,3:206\n*S KotlinDebug\n*F\n+ 1 HttpClient.kt\norg/merlyn/desktopapp/http/KtorClientMicrometerMetrics\n*L\n72#1:205\n72#1:206,3\n*E\n"})
public final class KtorClientMicrometerMetrics {
    @NotNull
    public static final Feature Feature = new Feature(null);
    @NotNull
    private static final AttributeKey<KtorClientMicrometerMetrics> key = new AttributeKey("ClientMetrics");
    @NotNull
    private static final AttributeKey<Map<String, String>> additionalAttributesKey = new AttributeKey("ClientMetricsAdditionalTags");
    @NotNull
    private static final AttributeKey<Timer.Sample> sampleAttributeKey = new AttributeKey("TimerSample");
    @NotNull
    private static final PipelinePhase monitoringPhase = new PipelinePhase("Monitoring");

    /*
     * WARNING - void declaration
     */
    private final List<Pair<String, String>> getLabels(Url url, String method, int status, Throwable throwable, Map<String, String> additionalAttributes) {
        void $this$mapTo$iv$iv;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"host", (Object)url.getHost()), TuplesKt.to((Object)"path", (Object)URLDecoder.decode(url.getEncodedPath(), StandardCharsets.UTF_8)), TuplesKt.to((Object)"method", (Object)method), TuplesKt.to((Object)"status", (Object)String.valueOf(status))};
        Map parameters = MapsKt.mutableMapOf((Pair[])pairArray);
        Throwable throwable2 = throwable;
        if (throwable2 != null) {
            Throwable it = throwable2;
            boolean bl = false;
            parameters.put("throwable", it.getClass().getSimpleName());
        }
        Map $this$map$iv = MapsKt.plus((Map)parameters, additionalAttributes);
        boolean $i$f$map = false;
        Map bl = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(new Pair(it.getKey(), it.getValue()));
        }
        return (List)destination$iv$iv;
    }

    private final void stopTimer(Timer.Sample sample, Url url, String method, int status, Throwable throwable, Map<String, String> additionalAttributes) {
        List<Pair<String, String>> labels = this.getLabels(url, method, status, throwable, additionalAttributes);
        Metric.Companion.instance().stopTimer(MetricName.HTTP_CLIENT_REQUESTS, sample, labels);
    }

    private final void recordError(Url url, String method, int status, Throwable throwable, Map<String, String> additionalAttributes) {
        List<Pair<String, String>> labels = this.getLabels(url, method, status, throwable, additionalAttributes);
        Metric.Companion.instance().counterIncrement(MetricName.HTTP_ERROR_CLIENT_REQUEST, labels);
    }

    public static final /* synthetic */ AttributeKey access$getSampleAttributeKey$cp() {
        return sampleAttributeKey;
    }

    public static final /* synthetic */ void access$recordError(KtorClientMicrometerMetrics $this, Url url, String method, int status, Throwable throwable, Map additionalAttributes) {
        $this.recordError(url, method, status, throwable, additionalAttributes);
    }

    public static final /* synthetic */ void access$stopTimer(KtorClientMicrometerMetrics $this, Timer.Sample sample, Url url, String method, int status, Throwable throwable, Map additionalAttributes) {
        $this.stopTimer(sample, url, method, status, throwable, additionalAttributes);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u0005X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/merlyn/desktopapp/http/KtorClientMicrometerMetrics$Config;", "", "<init>", "()V", "timeRequests", "", "getTimeRequests", "()Z", "app"})
    public static final class Config {
        private final boolean timeRequests;

        public final boolean getTimeRequests() {
            return this.timeRequests;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\u0011\u001a\u00020\u0012*\u00020\u00132\u0006\u0010\u0006\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\fJ!\u0010\u0015\u001a\u00020\u00032\u0017\u0010\u0016\u001a\u0013\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00120\u0017\u00a2\u0006\u0002\b\u0018H\u0016J\u0018\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J0\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u000b*\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0013H\u0002R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR \u0010\n\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u000b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/merlyn/desktopapp/http/KtorClientMicrometerMetrics$Feature;", "Lio/ktor/client/plugins/HttpClientPlugin;", "Lorg/merlyn/desktopapp/http/KtorClientMicrometerMetrics$Config;", "Lorg/merlyn/desktopapp/http/KtorClientMicrometerMetrics;", "<init>", "()V", "key", "Lio/ktor/util/AttributeKey;", "getKey", "()Lio/ktor/util/AttributeKey;", "additionalAttributesKey", "", "", "sampleAttributeKey", "Lio/micrometer/core/instrument/Timer$Sample;", "monitoringPhase", "Lio/ktor/util/pipeline/PipelinePhase;", "appendMetricAttribute", "", "Lio/ktor/util/Attributes;", "value", "prepare", "block", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "install", "plugin", "scope", "Lio/ktor/client/HttpClient;", "resolveAttributes", "Lio/ktor/util/pipeline/PipelineContext;", "url", "Lio/ktor/http/Url;", "attributes", "app"})
    public static final class Feature
    implements HttpClientPlugin<Config, KtorClientMicrometerMetrics> {
        private Feature() {
        }

        @NotNull
        public AttributeKey<KtorClientMicrometerMetrics> getKey() {
            return key;
        }

        public final void appendMetricAttribute(@NotNull Attributes $this$appendMetricAttribute, @NotNull String key, @NotNull String value2) {
            Map map2;
            Intrinsics.checkNotNullParameter((Object)$this$appendMetricAttribute, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            Map map3 = (Map)$this$appendMetricAttribute.getOrNull(additionalAttributesKey);
            if (map3 == null) {
                map3 = MapsKt.emptyMap();
            }
            Map existingMap = map2 = map3;
            boolean bl = false;
            $this$appendMetricAttribute.put(additionalAttributesKey, (Object)MapsKt.plus((Map)existingMap, (Map)MapsKt.mapOf((Pair)TuplesKt.to((Object)key, (Object)value2))));
        }

        @NotNull
        public KtorClientMicrometerMetrics prepare(@NotNull Function1<? super Config, Unit> block) {
            Intrinsics.checkNotNullParameter(block, (String)"block");
            Config config = new Config();
            block.invoke((Object)config);
            return new KtorClientMicrometerMetrics();
        }

        public void install(@NotNull KtorClientMicrometerMetrics plugin, @NotNull HttpClient scope) {
            Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
            Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
            scope.getReceivePipeline().insertPhaseAfter(HttpReceivePipeline.Phases.getBefore(), monitoringPhase);
            scope.getSendPipeline().intercept(HttpSendPipeline.Phases.getMonitoring(), (Function3)new Function3<PipelineContext<Object, HttpRequestBuilder>, Object, Continuation<? super Unit>, Object>(plugin, null){
                Object L$1;
                int label;
                private /* synthetic */ Object L$0;
                final /* synthetic */ KtorClientMicrometerMetrics $plugin;
                {
                    this.$plugin = $plugin;
                    super(3, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            PipelineContext $this$intercept = (PipelineContext)this.L$0;
                            Timer.Sample sample = Metric.Companion.instance().startTimer();
                            ((HttpRequestBuilder)$this$intercept.getContext()).getAttributes().put(KtorClientMicrometerMetrics.access$getSampleAttributeKey$cp(), (Object)sample);
                            this.L$0 = $this$intercept;
                            this.L$1 = sample;
                            this.label = 1;
                            Object object3 = $this$intercept.proceed((Continuation)this);
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            Object object3;
                            Timer.Sample sample = (Timer.Sample)this.L$1;
                            PipelineContext $this$intercept = (PipelineContext)this.L$0;
                            try {
                                void $result;
                                ResultKt.throwOnFailure((Object)$result);
                                object3 = $result;
                                return Unit.INSTANCE;
                            }
                            catch (Throwable cause) {
                                Url url = ((HttpRequestBuilder)$this$intercept.getContext()).getUrl().build();
                                int errorCode = cause instanceof HttpRequestTimeoutException ? 504 : 500;
                                KtorClientMicrometerMetrics.access$recordError(this.$plugin, url, ((HttpRequestBuilder)$this$intercept.getContext()).getMethod().getValue(), errorCode, cause, org.merlyn.desktopapp.http.KtorClientMicrometerMetrics$Feature.access$resolveAttributes(KtorClientMicrometerMetrics.Feature, $this$intercept, url, ((HttpRequestBuilder)$this$intercept.getContext()).getAttributes()));
                                KtorClientMicrometerMetrics.access$stopTimer(this.$plugin, sample, url, ((HttpRequestBuilder)$this$intercept.getContext()).getMethod().getValue(), errorCode, cause, org.merlyn.desktopapp.http.KtorClientMicrometerMetrics$Feature.access$resolveAttributes(KtorClientMicrometerMetrics.Feature, $this$intercept, url, ((HttpRequestBuilder)$this$intercept.getContext()).getAttributes()));
                                throw ExceptionUtilsJvmKt.unwrapCancellationException((Throwable)cause);
                            }
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Object invoke(PipelineContext<Object, HttpRequestBuilder> p1, Object p2, Continuation<? super Unit> p3) {
                    var var4_4 = new /* invalid duplicate definition of identical inner class */;
                    var4_4.L$0 = p1;
                    return var4_4.invokeSuspend(Unit.INSTANCE);
                }
            });
            scope.getReceivePipeline().intercept(monitoringPhase, (Function3)new Function3<PipelineContext<HttpResponse, Unit>, HttpResponse, Continuation<? super Unit>, Object>(plugin, null){
                int label;
                private /* synthetic */ Object L$0;
                /* synthetic */ Object L$1;
                final /* synthetic */ KtorClientMicrometerMetrics $plugin;
                {
                    this.$plugin = $plugin;
                    super(3, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            PipelineContext $this$intercept = (PipelineContext)this.L$0;
                            HttpResponse it = (HttpResponse)this.L$1;
                            Url url = it.getCall().getRequest().getUrl();
                            HttpStatusFamily[] httpStatusFamilyArray = new HttpStatusFamily[]{HttpStatusFamily.CLIENT_ERROR, HttpStatusFamily.SERVER_ERROR};
                            boolean isError = HttpStatusFamily.of((int)it.getCall().getResponse().getStatus().getValue()).isOneOf(httpStatusFamilyArray);
                            if (isError) {
                                KtorClientMicrometerMetrics.access$recordError(this.$plugin, url, HttpResponseKt.getRequest((HttpResponse)it).getMethod().getValue(), it.getCall().getResponse().getStatus().getValue(), null, org.merlyn.desktopapp.http.KtorClientMicrometerMetrics$Feature.access$resolveAttributes(KtorClientMicrometerMetrics.Feature, $this$intercept, url, HttpResponseKt.getRequest((HttpResponse)it).getAttributes()));
                            }
                            KtorClientMicrometerMetrics.access$stopTimer(this.$plugin, (Timer.Sample)HttpResponseKt.getRequest((HttpResponse)it).getAttributes().get(KtorClientMicrometerMetrics.access$getSampleAttributeKey$cp()), url, HttpResponseKt.getRequest((HttpResponse)it).getMethod().getValue(), it.getCall().getResponse().getStatus().getValue(), null, org.merlyn.desktopapp.http.KtorClientMicrometerMetrics$Feature.access$resolveAttributes(KtorClientMicrometerMetrics.Feature, $this$intercept, url, HttpResponseKt.getRequest((HttpResponse)it).getAttributes()));
                            this.L$0 = null;
                            this.label = 1;
                            Object object3 = $this$intercept.proceed((Continuation)this);
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Object invoke(PipelineContext<HttpResponse, Unit> p1, HttpResponse p2, Continuation<? super Unit> p3) {
                    var var4_4 = new /* invalid duplicate definition of identical inner class */;
                    var4_4.L$0 = p1;
                    var4_4.L$1 = p2;
                    return var4_4.invokeSuspend(Unit.INSTANCE);
                }
            });
        }

        private final Map<String, String> resolveAttributes(PipelineContext<?, ?> $this$resolveAttributes, Url url, Attributes attributes) {
            Map map2 = (Map)attributes.getOrNull(additionalAttributesKey);
            if (map2 == null) {
                map2 = MapsKt.emptyMap();
            }
            Map it = map2;
            boolean bl = false;
            return !it.containsKey("route") ? MapsKt.plus((Map)it, (Map)MapsKt.mapOf((Pair)TuplesKt.to((Object)"route", (Object)url.getEncodedPath()))) : it;
        }

        public static final /* synthetic */ Map access$resolveAttributes(Feature $this, PipelineContext $receiver, Url url, Attributes attributes) {
            return $this.resolveAttributes($receiver, url, attributes);
        }

        public /* synthetic */ Feature(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

