/*
 * Decompiled with CFR 0.152.
 */
package org.merlyn.desktopapp.log.layout;

import ch.qos.logback.classic.spi.ILoggingEvent;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.SharingStarted;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonObjectBuilder;
import org.jetbrains.annotations.NotNull;
import org.merlyn.desktopapp.config.StageConfig;
import org.merlyn.desktopapp.coresdk.JWTToken;
import org.merlyn.desktopapp.log.layout.EventLayout;
import org.merlyn.desktopapp.log.layout.LogDefinitionsKt;
import org.merlyn.desktopapp.os.HostOS;
import org.merlyn.desktopapp.storage.DeviceDataDao;
import org.merlyn.sharedui.viewmodels.usecases.ObserveLoginStateUseCase;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u0016\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/merlyn/desktopapp/log/layout/MetricsLogLayout;", "Lorg/merlyn/desktopapp/log/layout/EventLayout;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "loginState", "Lorg/merlyn/sharedui/viewmodels/usecases/ObserveLoginStateUseCase;", "stageConfig", "Lorg/merlyn/desktopapp/config/StageConfig;", "deviceDataDao", "Lorg/merlyn/desktopapp/storage/DeviceDataDao;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;Lorg/merlyn/sharedui/viewmodels/usecases/ObserveLoginStateUseCase;Lorg/merlyn/desktopapp/config/StageConfig;Lorg/merlyn/desktopapp/storage/DeviceDataDao;)V", "token", "Lkotlinx/coroutines/flow/StateFlow;", "", "appVersion", "Lkotlinx/serialization/json/JsonElement;", "deviceId", "getEventAsJson", "event", "Lch/qos/logback/classic/spi/ILoggingEvent;", "app"})
@SourceDebugExtension(value={"SMAP\nMetricsLogLayout.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MetricsLogLayout.kt\norg/merlyn/desktopapp/log/layout/MetricsLogLayout\n+ 2 JsonElementBuilders.kt\nkotlinx/serialization/json/JsonElementBuildersKt\n+ 3 Iterators.kt\nkotlin/collections/CollectionsKt__IteratorsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,59:1\n28#2,3:60\n31#2:66\n32#3,2:63\n1#4:65\n*S KotlinDebug\n*F\n+ 1 MetricsLogLayout.kt\norg/merlyn/desktopapp/log/layout/MetricsLogLayout\n*L\n29#1:60,3\n29#1:66\n34#1:63,2\n*E\n"})
public final class MetricsLogLayout
implements EventLayout {
    @NotNull
    private final StateFlow<String> token;
    @NotNull
    private final JsonElement appVersion;
    @NotNull
    private final JsonElement deviceId;

    public MetricsLogLayout(@NotNull CoroutineScope coroutineScope, @NotNull ObserveLoginStateUseCase loginState, @NotNull StageConfig stageConfig, @NotNull DeviceDataDao deviceDataDao) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        Intrinsics.checkNotNullParameter((Object)loginState, (String)"loginState");
        Intrinsics.checkNotNullParameter((Object)stageConfig, (String)"stageConfig");
        Intrinsics.checkNotNullParameter((Object)deviceDataDao, (String)"deviceDataDao");
        this.token = FlowKt.stateIn((Flow)((Flow)loginState.getAccessToken()), (CoroutineScope)coroutineScope, (SharingStarted)SharingStarted.Companion.getEagerly(), null);
        this.appVersion = LogDefinitionsKt.toJsonElement(stageConfig.getApplicationConfig().getAppVersion());
        this.deviceId = LogDefinitionsKt.toJsonElement(deviceDataDao.get().getDeviceId());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String getEventAsJson(@NotNull ILoggingEvent event) {
        Object object;
        JsonObjectBuilder builder$iv;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        boolean $i$f$buildJsonObject = false;
        JsonObjectBuilder $this$getEventAsJson_u24lambda_u244 = builder$iv = new JsonObjectBuilder();
        boolean bl = false;
        String userId = null;
        String userSubId = null;
        Object object2 = $this$getEventAsJson_u24lambda_u244;
        try {
            void $this$forEach$iv;
            JsonObjectBuilder $this$getEventAsJson_u24lambda_u244_u24lambda_u241 = object2;
            boolean bl2 = false;
            String string = event.getMessage();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getMessage(...)");
            Iterator iterator = ((Map)JsonElementKt.getJsonObject((JsonElement)Json.Default.parseToJsonElement(string))).entrySet().iterator();
            boolean $i$f$forEach = false;
            void var14_19 = $this$forEach$iv;
            while (var14_19.hasNext()) {
                Object element$iv = var14_19.next();
                Map.Entry entry = (Map.Entry)element$iv;
                boolean bl3 = false;
                String key = (String)entry.getKey();
                JsonElement value2 = (JsonElement)entry.getValue();
                $this$getEventAsJson_u24lambda_u244_u24lambda_u241.put(key, value2);
            }
            object = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable bl2) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl2));
        }
        object2 = object;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable != null) {
            Object it = object = throwable;
            boolean bl4 = false;
            $this$getEventAsJson_u24lambda_u244.put("message", LogDefinitionsKt.toJsonElement(event.getMessage()));
        }
        String string = (String)this.token.getValue();
        if (string != null) {
            String it = string;
            boolean bl5 = false;
            JWTToken jwt = new JWTToken(it);
            userId = LogDefinitionsKt.getUserId(jwt);
            userSubId = jwt.getSubject();
        }
        $this$getEventAsJson_u24lambda_u244.put("userId", LogDefinitionsKt.toJsonElement(userId));
        $this$getEventAsJson_u24lambda_u244.put("userSubId", LogDefinitionsKt.toJsonElement(userSubId));
        $this$getEventAsJson_u24lambda_u244.put("platform", LogDefinitionsKt.toJsonElement(HostOS.INSTANCE.getHostOs().name()));
        $this$getEventAsJson_u24lambda_u244.put("arch", LogDefinitionsKt.toJsonElement((Object)HostOS.INSTANCE.getHostRealArch()));
        $this$getEventAsJson_u24lambda_u244.put("osVersion", LogDefinitionsKt.toJsonElement(HostOS.INSTANCE.getHostOs().getVersion()));
        $this$getEventAsJson_u24lambda_u244.put("appVersion", this.appVersion);
        $this$getEventAsJson_u24lambda_u244.put("deviceId", this.deviceId);
        JsonObject formattedEvent = builder$iv.build();
        return formattedEvent + "\n";
    }
}

