/*
 * Decompiled with CFR 0.152.
 */
package org.merlyn.desktopapp.metrics;

import io.micrometer.cloudwatch2.CloudWatchNamingConvention;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.FunctionCounter;
import io.micrometer.core.instrument.FunctionTimer;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.TimeGauge;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.config.NamingConvention;
import io.micrometer.core.instrument.step.StepMeterRegistry;
import io.micrometer.core.instrument.step.StepRegistryConfig;
import io.micrometer.core.instrument.util.NamedThreadFactory;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.merlyn.desktopapp.metrics.EMFLoggingRegistryConfig;
import org.merlyn.desktopapp.metrics.EMFMetricsEnvironment;
import org.merlyn.desktopapp.metrics.EMFMetricsRegistryKt;
import software.amazon.cloudwatchlogs.emf.environment.Environment;
import software.amazon.cloudwatchlogs.emf.exception.DimensionSetExceededException;
import software.amazon.cloudwatchlogs.emf.exception.InvalidDimensionException;
import software.amazon.cloudwatchlogs.emf.logger.MetricsLogger;
import software.amazon.cloudwatchlogs.emf.model.DimensionSet;
import software.amazon.cloudwatchlogs.emf.model.Unit;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u001d\u001eB\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\f\u001a\u00020\rJ\b\u0010\u000e\u001a\u00020\rH\u0014J\b\u0010\u000f\u001a\u00020\u0010H\u0014J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002J\u001e\u0010\u0014\u001a\u00020\u00132\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u00122\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u001e\u0010\u0019\u001a\u00020\r2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u00122\u0006\u0010\u001a\u001a\u00020\u0013H\u0002J\u0016\u0010\u001b\u001a\u00020\u001c2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/merlyn/desktopapp/metrics/EMFMetricsRegistry;", "Lio/micrometer/core/instrument/step/StepMeterRegistry;", "config", "Lorg/merlyn/desktopapp/metrics/EMFLoggingRegistryConfig;", "clock", "Lio/micrometer/core/instrument/Clock;", "<init>", "(Lorg/merlyn/desktopapp/metrics/EMFLoggingRegistryConfig;Lio/micrometer/core/instrument/Clock;)V", "unitByLowercaseValue", "", "", "Lsoftware/amazon/cloudwatchlogs/emf/model/Unit;", "flush", "", "publish", "getBaseTimeUnit", "Ljava/util/concurrent/TimeUnit;", "metricsLoggers", "", "Lsoftware/amazon/cloudwatchlogs/emf/logger/MetricsLogger;", "prepareMetricsLogger", "tags", "Lio/micrometer/core/instrument/Tag;", "timestamp", "Ljava/time/Instant;", "addDimensionSet", "metricsLogger", "toDimensionSet", "Lsoftware/amazon/cloudwatchlogs/emf/model/DimensionSet;", "Batch", "MetricDataPoint", "app"})
@SourceDebugExtension(value={"SMAP\nEMFMetricsRegistry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EMFMetricsRegistry.kt\norg/merlyn/desktopapp/metrics/EMFMetricsRegistry\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,362:1\n1869#2,2:363\n1491#2:365\n1516#2,3:366\n1519#2,3:376\n1374#2:382\n1460#2,5:383\n1869#2,2:388\n1563#2:391\n1634#2,3:392\n1869#2,2:395\n384#3,7:369\n126#4:379\n153#4,2:380\n155#4:390\n*S KotlinDebug\n*F\n+ 1 EMFMetricsRegistry.kt\norg/merlyn/desktopapp/metrics/EMFMetricsRegistry\n*L\n123#1:363,2\n135#1:365\n135#1:366,3\n135#1:376,3\n145#1:382\n145#1:383,5\n157#1:388,2\n179#1:391\n179#1:392,3\n180#1:395,2\n135#1:369,7\n139#1:379\n139#1:380,2\n139#1:390\n*E\n"})
public final class EMFMetricsRegistry
extends StepMeterRegistry {
    @NotNull
    private final EMFLoggingRegistryConfig config;
    @NotNull
    private final Map<String, Unit> unitByLowercaseValue;

    public EMFMetricsRegistry(@NotNull EMFLoggingRegistryConfig config, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        super((StepRegistryConfig)config, clock);
        this.config = config;
        Map unitsByLowercase = new LinkedHashMap();
        for (Unit standardUnit : EntriesMappings.entries$0) {
            String string;
            if (standardUnit == Unit.UNKNOWN_TO_SDK_VERSION) continue;
            Map map2 = unitsByLowercase;
            String string2 = standardUnit.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            Intrinsics.checkNotNullExpressionValue((Object)string2.toLowerCase(Locale.ROOT), (String)"toLowerCase(...)");
            map2.put(string, standardUnit);
        }
        this.unitByLowercaseValue = MapsKt.toMap((Map)unitsByLowercase);
        this.config().namingConvention((NamingConvention)new CloudWatchNamingConvention());
        this.start((ThreadFactory)new NamedThreadFactory("emf-logging-metrics-publisher"));
    }

    public /* synthetic */ EMFMetricsRegistry(EMFLoggingRegistryConfig eMFLoggingRegistryConfig, Clock clock, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            eMFLoggingRegistryConfig = EMFLoggingRegistryConfig.Companion.getDEFAULT();
        }
        this(eMFLoggingRegistryConfig, clock);
    }

    public final void flush() {
        this.publish();
    }

    protected void publish() {
        if (this.config.enabled()) {
            Iterable $this$forEach$iv = this.metricsLoggers();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                MetricsLogger p0 = (MetricsLogger)element$iv;
                boolean $i$f$publish$stub_for_inlining = false;
                boolean bl = false;
                p0.flush();
            }
        }
    }

    @NotNull
    protected TimeUnit getBaseTimeUnit() {
        return TimeUnit.MILLISECONDS;
    }

    /*
     * WARNING - void declaration
     */
    private final List<MetricsLogger> metricsLoggers() {
        void $this$mapTo$iv$iv;
        Iterable answer$iv$iv$iv;
        void $this$groupByTo$iv$iv;
        MeterRegistry.Config config = this.config();
        Intrinsics.checkNotNullExpressionValue((Object)config, (String)"config(...)");
        TimeUnit timeUnit = this.getBaseTimeUnit();
        Clock clock = this.clock;
        Intrinsics.checkNotNullExpressionValue((Object)clock, (String)"clock");
        Batch batch = new Batch(config, this.unitByLowercaseValue, timeUnit, clock);
        List list = this.getMeters();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getMeters(...)");
        Iterable $this$groupBy$iv = list;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            List key$iv$iv;
            Meter it = (Meter)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it.getId().getConventionTags(this.config().namingConvention()), (String)"getConventionTags(...)");
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map tagsToMeters = destination$iv$iv;
        List metricsLoggers = new ArrayList();
        Map $this$map$iv = tagsToMeters;
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void $this$forEach$iv;
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv;
            void entry;
            Map.Entry item$iv$iv;
            Map.Entry bl = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv2;
            boolean bl3 = false;
            List tags = (List)entry.getKey();
            MetricsLogger metricsLogger = this.prepareMetricsLogger(tags, batch.getTimestamp());
            List meters = (List)entry.getValue();
            answer$iv$iv$iv = meters;
            boolean $i$f$flatMap = false;
            Iterator iterator2 = $this$flatMap$iv;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                Meter m = (Meter)element$iv$iv;
                boolean bl4 = false;
                Object object = m.match(batch::gaugeData, batch::counterData, batch::timerData, batch::summaryData, batch::longTaskTimerData, batch::timeGaugeData, batch::functionCounterData, batch::functionTimerData, batch::metricData);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"match(...)");
                Iterable list$iv$iv = (Iterable)object;
                CollectionsKt.addAll((Collection)destination$iv$iv3, (Iterable)list$iv$iv);
            }
            $this$flatMap$iv = (List)destination$iv$iv3;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                MetricDataPoint it = (MetricDataPoint)element$iv;
                boolean bl5 = false;
                MetricDataPoint metricDataPoint = it;
                Intrinsics.checkNotNull((Object)metricDataPoint);
                metricsLogger.putMetric(metricDataPoint.getKey(), it.getValue(), it.getUnit());
            }
            collection.add(metricsLoggers.add(metricsLogger));
        }
        List cfr_ignored_0 = (List)destination$iv$iv2;
        return metricsLoggers;
    }

    private final MetricsLogger prepareMetricsLogger(List<? extends Tag> tags, Instant timestamp) {
        MetricsLogger metricsLogger = new MetricsLogger((Environment)new EMFMetricsEnvironment()).setNamespace("desktop-app").setTimestamp(timestamp);
        Intrinsics.checkNotNullExpressionValue((Object)metricsLogger, (String)"setTimestamp(...)");
        MetricsLogger metricsLogger2 = metricsLogger;
        this.addDimensionSet(tags, metricsLogger2);
        return metricsLogger2;
    }

    private final void addDimensionSet(List<? extends Tag> tags, MetricsLogger metricsLogger) {
        DimensionSet[] dimensionSetArray = new DimensionSet[]{this.toDimensionSet(tags)};
        metricsLogger.setDimensions(dimensionSetArray);
    }

    /*
     * WARNING - void declaration
     */
    private final DimensionSet toDimensionSet(List<? extends Tag> tags) {
        void $this$mapTo$iv$iv;
        DimensionSet dimensionSet = new DimensionSet();
        Iterable $this$map$iv = tags;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Tag tag = (Tag)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(EMFMetricsRegistryKt.sanitize((Tag)it));
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Tag tag = (Tag)element$iv;
            boolean bl = false;
            try {
                dimensionSet.addDimension(tag.getKey(), tag.getValue());
            }
            catch (InvalidDimensionException e) {
                EMFMetricsRegistryKt.access$getInvalidTagValueLogger$p().debug(() -> EMFMetricsRegistry.toDimensionSet$lambda$7$lambda$5(tag));
            }
            catch (DimensionSetExceededException e) {
                EMFMetricsRegistryKt.access$getInvalidTagValueLogger$p().debug(() -> EMFMetricsRegistry.toDimensionSet$lambda$7$lambda$6(tag));
            }
        }
        return dimensionSet;
    }

    private static final Object toDimensionSet$lambda$7$lambda$5(Tag $tag) {
        return "Dropping dimension " + $tag.getKey() + " with value " + $tag.getValue();
    }

    private static final Object toDimensionSet$lambda$7$lambda$6(Tag $tag) {
        return "Too many dimensions. Dropping dimension " + $tag.getKey() + " with value " + $tag.getValue();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\u0018\u00002\u00020\u0001B7\u0012\n\u0010\u0002\u001a\u00060\u0003R\u00020\u0004\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u0017J\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0019\u001a\u00020\u001aJ\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u001c\u001a\u00020\u001dJ\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u001f\u001a\u00020 J\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\"\u001a\u00020#J\u0014\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020%J\u0014\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0019\u001a\u00020'J\u0014\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u001c\u001a\u00020)J\u0016\u0010*\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u00142\u0006\u0010+\u001a\u00020,J\u001a\u0010-\u001a\u0004\u0018\u00010\u00152\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0002J$\u0010-\u001a\u0004\u0018\u00010\u00152\u0006\u0010.\u001a\u00020/2\b\u00102\u001a\u0004\u0018\u00010\u00072\u0006\u00100\u001a\u000201H\u0002J.\u0010-\u001a\u0004\u0018\u00010\u00152\u0006\u0010.\u001a\u00020/2\b\u00102\u001a\u0004\u0018\u00010\u00072\b\u00103\u001a\u0004\u0018\u00010\u00072\u0006\u00100\u001a\u000201H\u0002J,\u0010-\u001a\u0004\u0018\u00010\u00152\u0006\u0010.\u001a\u00020/2\b\u00102\u001a\u0004\u0018\u00010\u00072\u0006\u00103\u001a\u00020\b2\u0006\u00100\u001a\u000201H\u0002J\u001a\u00104\u001a\u00020\u00072\u0006\u0010.\u001a\u00020/2\b\u00102\u001a\u0004\u0018\u00010\u0007H\u0002J\u0012\u00105\u001a\u00020\b2\b\u00103\u001a\u0004\u0018\u00010\u0007H\u0002J\u0010\u00106\u001a\u0002012\u0006\u00100\u001a\u000201H\u0002R\u0012\u0010\u0002\u001a\u00060\u0003R\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u00067"}, d2={"Lorg/merlyn/desktopapp/metrics/EMFMetricsRegistry$Batch;", "", "config", "Lio/micrometer/core/instrument/MeterRegistry$Config;", "Lio/micrometer/core/instrument/MeterRegistry;", "standardUnitByLowercaseValue", "", "", "Lsoftware/amazon/cloudwatchlogs/emf/model/Unit;", "baseTimeUnit", "Ljava/util/concurrent/TimeUnit;", "clock", "Lio/micrometer/core/instrument/Clock;", "<init>", "(Lio/micrometer/core/instrument/MeterRegistry$Config;Ljava/util/Map;Ljava/util/concurrent/TimeUnit;Lio/micrometer/core/instrument/Clock;)V", "timestamp", "Ljava/time/Instant;", "getTimestamp", "()Ljava/time/Instant;", "gaugeData", "", "Lorg/merlyn/desktopapp/metrics/EMFMetricsRegistry$MetricDataPoint;", "gauge", "Lio/micrometer/core/instrument/Gauge;", "counterData", "counter", "Lio/micrometer/core/instrument/Counter;", "timerData", "timer", "Lio/micrometer/core/instrument/Timer;", "summaryData", "summary", "Lio/micrometer/core/instrument/DistributionSummary;", "longTaskTimerData", "longTaskTimer", "Lio/micrometer/core/instrument/LongTaskTimer;", "timeGaugeData", "Lio/micrometer/core/instrument/TimeGauge;", "functionCounterData", "Lio/micrometer/core/instrument/FunctionCounter;", "functionTimerData", "Lio/micrometer/core/instrument/FunctionTimer;", "metricData", "m", "Lio/micrometer/core/instrument/Meter;", "metricDataPoint", "id", "Lio/micrometer/core/instrument/Meter$Id;", "value", "", "suffix", "unit", "getMetricName", "toUnit", "clampMetricValue", "app"})
    public static final class Batch {
        @NotNull
        private final MeterRegistry.Config config;
        @NotNull
        private final Map<String, Unit> standardUnitByLowercaseValue;
        @NotNull
        private final TimeUnit baseTimeUnit;
        @NotNull
        private final Instant timestamp;

        public Batch(@NotNull MeterRegistry.Config config, @NotNull Map<String, ? extends Unit> standardUnitByLowercaseValue, @NotNull TimeUnit baseTimeUnit, @NotNull Clock clock) {
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            Intrinsics.checkNotNullParameter(standardUnitByLowercaseValue, (String)"standardUnitByLowercaseValue");
            Intrinsics.checkNotNullParameter((Object)((Object)baseTimeUnit), (String)"baseTimeUnit");
            Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
            this.config = config;
            this.standardUnitByLowercaseValue = standardUnitByLowercaseValue;
            this.baseTimeUnit = baseTimeUnit;
            Instant instant = Instant.ofEpochMilli(clock.wallTime());
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"ofEpochMilli(...)");
            this.timestamp = instant;
        }

        @NotNull
        public final Instant getTimestamp() {
            return this.timestamp;
        }

        @NotNull
        public final List<MetricDataPoint> gaugeData(@NotNull Gauge gauge) {
            Intrinsics.checkNotNullParameter((Object)gauge, (String)"gauge");
            Meter.Id id = gauge.getId();
            Intrinsics.checkNotNullExpressionValue((Object)id, (String)"getId(...)");
            MetricDataPoint metricDataPoint = this.metricDataPoint(id, "value", gauge.value());
            Intrinsics.checkNotNull((Object)metricDataPoint);
            return CollectionsKt.listOf((Object)metricDataPoint);
        }

        @NotNull
        public final List<MetricDataPoint> counterData(@NotNull Counter counter) {
            Intrinsics.checkNotNullParameter((Object)counter, (String)"counter");
            Meter.Id id = counter.getId();
            Intrinsics.checkNotNullExpressionValue((Object)id, (String)"getId(...)");
            MetricDataPoint metricDataPoint = this.metricDataPoint(id, "count", Unit.COUNT, counter.count());
            Intrinsics.checkNotNull((Object)metricDataPoint);
            return CollectionsKt.listOf((Object)metricDataPoint);
        }

        @NotNull
        public final List<MetricDataPoint> timerData(@NotNull Timer timer) {
            Intrinsics.checkNotNullParameter((Object)timer, (String)"timer");
            List metrics = new ArrayList();
            Meter.Id id = timer.getId();
            Intrinsics.checkNotNullExpressionValue((Object)id, (String)"getId(...)");
            MetricDataPoint metricDataPoint = this.metricDataPoint(id, "sum", this.baseTimeUnit.name(), timer.totalTime(this.baseTimeUnit));
            Intrinsics.checkNotNull((Object)metricDataPoint);
            metrics.add(metricDataPoint);
            long count = timer.count();
            Meter.Id id2 = timer.getId();
            Intrinsics.checkNotNullExpressionValue((Object)id2, (String)"getId(...)");
            MetricDataPoint metricDataPoint2 = this.metricDataPoint(id2, "count", Unit.COUNT, (double)count);
            Intrinsics.checkNotNull((Object)metricDataPoint2);
            metrics.add(metricDataPoint2);
            if (count > 0L) {
                Meter.Id id3 = timer.getId();
                Intrinsics.checkNotNullExpressionValue((Object)id3, (String)"getId(...)");
                MetricDataPoint metricDataPoint3 = this.metricDataPoint(id3, "avg", this.baseTimeUnit.name(), timer.mean(this.baseTimeUnit));
                Intrinsics.checkNotNull((Object)metricDataPoint3);
                metrics.add(metricDataPoint3);
                Meter.Id id4 = timer.getId();
                Intrinsics.checkNotNullExpressionValue((Object)id4, (String)"getId(...)");
                MetricDataPoint metricDataPoint4 = this.metricDataPoint(id4, "max", this.baseTimeUnit.name(), timer.max(this.baseTimeUnit));
                Intrinsics.checkNotNull((Object)metricDataPoint4);
                metrics.add(metricDataPoint4);
            }
            return CollectionsKt.toList((Iterable)metrics);
        }

        @NotNull
        public final List<MetricDataPoint> summaryData(@NotNull DistributionSummary summary) {
            Intrinsics.checkNotNullParameter((Object)summary, (String)"summary");
            List metrics = new ArrayList();
            Meter.Id id = summary.getId();
            Intrinsics.checkNotNullExpressionValue((Object)id, (String)"getId(...)");
            MetricDataPoint metricDataPoint = this.metricDataPoint(id, "sum", summary.totalAmount());
            Intrinsics.checkNotNull((Object)metricDataPoint);
            metrics.add(metricDataPoint);
            long count = summary.count();
            Meter.Id id2 = summary.getId();
            Intrinsics.checkNotNullExpressionValue((Object)id2, (String)"getId(...)");
            MetricDataPoint metricDataPoint2 = this.metricDataPoint(id2, "count", Unit.COUNT, (double)count);
            Intrinsics.checkNotNull((Object)metricDataPoint2);
            metrics.add(metricDataPoint2);
            if (count > 0L) {
                Meter.Id id3 = summary.getId();
                Intrinsics.checkNotNullExpressionValue((Object)id3, (String)"getId(...)");
                MetricDataPoint metricDataPoint3 = this.metricDataPoint(id3, "avg", summary.mean());
                Intrinsics.checkNotNull((Object)metricDataPoint3);
                metrics.add(metricDataPoint3);
                Meter.Id id4 = summary.getId();
                Intrinsics.checkNotNullExpressionValue((Object)id4, (String)"getId(...)");
                MetricDataPoint metricDataPoint4 = this.metricDataPoint(id4, "max", summary.max());
                Intrinsics.checkNotNull((Object)metricDataPoint4);
                metrics.add(metricDataPoint4);
            }
            return CollectionsKt.toList((Iterable)metrics);
        }

        @NotNull
        public final List<MetricDataPoint> longTaskTimerData(@NotNull LongTaskTimer longTaskTimer) {
            Intrinsics.checkNotNullParameter((Object)longTaskTimer, (String)"longTaskTimer");
            List metrics = new ArrayList();
            Meter.Id id = longTaskTimer.getId();
            Intrinsics.checkNotNullExpressionValue((Object)id, (String)"getId(...)");
            MetricDataPoint metricDataPoint = this.metricDataPoint(id, "activeTasks", longTaskTimer.activeTasks());
            Intrinsics.checkNotNull((Object)metricDataPoint);
            metrics.add(metricDataPoint);
            Meter.Id id2 = longTaskTimer.getId();
            Intrinsics.checkNotNullExpressionValue((Object)id2, (String)"getId(...)");
            MetricDataPoint metricDataPoint2 = this.metricDataPoint(id2, "duration", longTaskTimer.duration(this.baseTimeUnit));
            Intrinsics.checkNotNull((Object)metricDataPoint2);
            metrics.add(metricDataPoint2);
            return CollectionsKt.toList((Iterable)metrics);
        }

        @NotNull
        public final List<MetricDataPoint> timeGaugeData(@NotNull TimeGauge gauge) {
            Intrinsics.checkNotNullParameter((Object)gauge, (String)"gauge");
            Meter.Id id = gauge.getId();
            Intrinsics.checkNotNullExpressionValue((Object)id, (String)"getId(...)");
            MetricDataPoint metricDataPoint = this.metricDataPoint(id, "value", gauge.value(this.baseTimeUnit));
            Intrinsics.checkNotNull((Object)metricDataPoint);
            return CollectionsKt.listOf((Object)metricDataPoint);
        }

        @NotNull
        public final List<MetricDataPoint> functionCounterData(@NotNull FunctionCounter counter) {
            Intrinsics.checkNotNullParameter((Object)counter, (String)"counter");
            Meter.Id id = counter.getId();
            Intrinsics.checkNotNullExpressionValue((Object)id, (String)"getId(...)");
            MetricDataPoint metricDataPoint = this.metricDataPoint(id, "count", Unit.COUNT, counter.count());
            Intrinsics.checkNotNull((Object)metricDataPoint);
            return CollectionsKt.listOf((Object)metricDataPoint);
        }

        @NotNull
        public final List<MetricDataPoint> functionTimerData(@NotNull FunctionTimer timer) {
            Intrinsics.checkNotNullParameter((Object)timer, (String)"timer");
            List metrics = new ArrayList();
            double sum = timer.totalTime(this.baseTimeUnit);
            if (!Double.isFinite(sum)) {
                return CollectionsKt.emptyList();
            }
            double count = timer.count();
            Meter.Id id = timer.getId();
            Intrinsics.checkNotNullExpressionValue((Object)id, (String)"getId(...)");
            MetricDataPoint metricDataPoint = this.metricDataPoint(id, "count", Unit.COUNT, count);
            Intrinsics.checkNotNull((Object)metricDataPoint);
            metrics.add(metricDataPoint);
            Meter.Id id2 = timer.getId();
            Intrinsics.checkNotNullExpressionValue((Object)id2, (String)"getId(...)");
            MetricDataPoint metricDataPoint2 = this.metricDataPoint(id2, "sum", sum);
            Intrinsics.checkNotNull((Object)metricDataPoint2);
            metrics.add(metricDataPoint2);
            if (count > 0.0) {
                Meter.Id id3 = timer.getId();
                Intrinsics.checkNotNullExpressionValue((Object)id3, (String)"getId(...)");
                MetricDataPoint metricDataPoint3 = this.metricDataPoint(id3, "avg", timer.mean(this.baseTimeUnit));
                Intrinsics.checkNotNull((Object)metricDataPoint3);
                metrics.add(metricDataPoint3);
            }
            return CollectionsKt.toList((Iterable)metrics);
        }

        @NotNull
        public final List<MetricDataPoint> metricData(@NotNull Meter m) {
            Intrinsics.checkNotNullParameter((Object)m, (String)"m");
            Iterable iterable = m.measure();
            Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"measure(...)");
            return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)iterable), arg_0 -> Batch.metricData$lambda$0(this, m, arg_0)));
        }

        private final MetricDataPoint metricDataPoint(Meter.Id id, double value2) {
            return this.metricDataPoint(id, null, id.getBaseUnit(), value2);
        }

        private final MetricDataPoint metricDataPoint(Meter.Id id, String suffix, double value2) {
            return this.metricDataPoint(id, suffix, id.getBaseUnit(), value2);
        }

        private final MetricDataPoint metricDataPoint(Meter.Id id, String suffix, String unit, double value2) {
            return this.metricDataPoint(id, suffix, this.toUnit(unit), value2);
        }

        private final MetricDataPoint metricDataPoint(Meter.Id id, String suffix, Unit unit, double value2) {
            if (Double.isNaN(value2)) {
                return null;
            }
            return new MetricDataPoint(this.getMetricName(id, suffix), this.clampMetricValue(value2), unit);
        }

        private final String getMetricName(Meter.Id id, String suffix) {
            String name = suffix != null ? id.getName() + "." + suffix : id.getName();
            String string = this.config.namingConvention().name(name, id.getType(), id.getBaseUnit());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name(...)");
            return string;
        }

        private final Unit toUnit(String unit) {
            if (unit == null) {
                return Unit.NONE;
            }
            String string = unit.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            Unit unit2 = this.standardUnitByLowercaseValue.get(string);
            if (unit2 == null) {
                unit2 = Unit.NONE;
            }
            return unit2;
        }

        private final double clampMetricValue(double value2) {
            if (Double.isNaN(value2)) {
                return value2;
            }
            double magnitude = Math.abs(value2);
            if (magnitude == 0.0) {
                return 0.0;
            }
            double clampedMag = Math.min(Math.max(magnitude, 8.51592E-109), 1.174271E108);
            return Math.copySign(clampedMag, value2);
        }

        private static final MetricDataPoint metricData$lambda$0(Batch this$0, Meter $m, Measurement ms) {
            Intrinsics.checkNotNullParameter((Object)ms, (String)"ms");
            Meter.Id id = $m.getId().withTag(ms.getStatistic());
            Intrinsics.checkNotNullExpressionValue((Object)id, (String)"withTag(...)");
            return this$0.metricDataPoint(id, ms.getValue());
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<Unit> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])Unit.values()));
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lorg/merlyn/desktopapp/metrics/EMFMetricsRegistry$MetricDataPoint;", "", "key", "", "value", "", "unit", "Lsoftware/amazon/cloudwatchlogs/emf/model/Unit;", "<init>", "(Ljava/lang/String;DLsoftware/amazon/cloudwatchlogs/emf/model/Unit;)V", "getKey", "()Ljava/lang/String;", "setKey", "(Ljava/lang/String;)V", "getValue", "()D", "setValue", "(D)V", "getUnit", "()Lsoftware/amazon/cloudwatchlogs/emf/model/Unit;", "setUnit", "(Lsoftware/amazon/cloudwatchlogs/emf/model/Unit;)V", "app"})
    public static final class MetricDataPoint {
        @NotNull
        private String key;
        private double value;
        @Nullable
        private Unit unit;

        public MetricDataPoint(@NotNull String key, double value2, @Nullable Unit unit) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            this.key = key;
            this.value = value2;
            this.unit = unit;
        }

        @NotNull
        public final String getKey() {
            return this.key;
        }

        public final void setKey(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.key = string;
        }

        public final double getValue() {
            return this.value;
        }

        public final void setValue(double d) {
            this.value = d;
        }

        @Nullable
        public final Unit getUnit() {
            return this.unit;
        }

        public final void setUnit(@Nullable Unit unit) {
            this.unit = unit;
        }
    }
}

