/*
 * Decompiled with CFR 0.152.
 */
package org.merlyn.desktopapp.os;

import com.sun.jna.Platform;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.merlyn.desktopapp.os.Arch;
import org.merlyn.desktopapp.os.OS;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0016\u001a\u00020\u0013H\u0002R\u001b\u0010\u0004\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R\u001b\u0010\n\u001a\u00020\u000b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\t\u001a\u0004\b\f\u0010\rR\u001b\u0010\u000f\u001a\u00020\u000b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\t\u001a\u0004\b\u0010\u0010\rR\u001b\u0010\u0012\u001a\u00020\u00138BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\t\u001a\u0004\b\u0012\u0010\u0014\u00a8\u0006\u0017"}, d2={"Lorg/merlyn/desktopapp/os/HostOS;", "", "<init>", "()V", "hostOs", "Lorg/merlyn/desktopapp/os/OS;", "getHostOs", "()Lorg/merlyn/desktopapp/os/OS;", "hostOs$delegate", "Lkotlin/Lazy;", "hostArch", "Lorg/merlyn/desktopapp/os/Arch;", "getHostArch", "()Lorg/merlyn/desktopapp/os/Arch;", "hostArch$delegate", "hostRealArch", "getHostRealArch", "hostRealArch$delegate", "isRosetta", "", "()Z", "isRosetta$delegate", "isRosettaInternal", "app"})
public final class HostOS {
    @NotNull
    public static final HostOS INSTANCE = new HostOS();
    @NotNull
    private static final Lazy hostOs$delegate = LazyKt.lazy(HostOS::hostOs_delegate$lambda$0);
    @NotNull
    private static final Lazy hostArch$delegate = LazyKt.lazy(HostOS::hostArch_delegate$lambda$1);
    @NotNull
    private static final Lazy hostRealArch$delegate = LazyKt.lazy(HostOS::hostRealArch_delegate$lambda$2);
    @NotNull
    private static final Lazy isRosetta$delegate = LazyKt.lazy(HostOS::isRosetta_delegate$lambda$3);

    private HostOS() {
    }

    @NotNull
    public final OS getHostOs() {
        Lazy lazy = hostOs$delegate;
        return (OS)((Object)lazy.getValue());
    }

    @NotNull
    public final Arch getHostArch() {
        Lazy lazy = hostArch$delegate;
        return (Arch)((Object)lazy.getValue());
    }

    @NotNull
    public final Arch getHostRealArch() {
        Lazy lazy = hostRealArch$delegate;
        return (Arch)((Object)lazy.getValue());
    }

    private final boolean isRosetta() {
        Lazy lazy = isRosetta$delegate;
        return (Boolean)lazy.getValue();
    }

    private final boolean isRosettaInternal() {
        String[] stringArray = new String[]{"sysctl", "-n", "sysctl.proc_translated"};
        Process process2 = new ProcessBuilder(stringArray).start();
        InputStream inputStream = process2.getInputStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
        InputStream inputStream2 = inputStream;
        Charset charset = Charsets.UTF_8;
        Reader reader = new InputStreamReader(inputStream2, charset);
        int n = 8192;
        List lines = TextStreamsKt.readLines((Reader)(reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n)));
        int result = process2.waitFor();
        return result == 0 && !((Collection)lines).isEmpty() ? !Intrinsics.areEqual(lines.get(0), (Object)"0") : false;
    }

    private static final OS hostOs_delegate$lambda$0() {
        return switch (Platform.getOSType()) {
            case 2 -> OS.Windows;
            case 0 -> OS.MacOS;
            case 1 -> OS.Linux;
            default -> throw new Error("Unknown os type " + Platform.getOSType());
        };
    }

    private static final Arch hostArch_delegate$lambda$1() {
        return Platform.isARM() ? Arch.ARM : (Platform.isIntel() ? Arch.X86 : Arch.UNKNOWN);
    }

    private static final Arch hostRealArch_delegate$lambda$2() {
        return Platform.isARM() ? Arch.ARM : (Platform.isIntel() ? (!INSTANCE.isRosetta() ? Arch.X86 : Arch.ARM) : Arch.UNKNOWN);
    }

    private static final boolean isRosetta_delegate$lambda$3() {
        return INSTANCE.getHostOs() != OS.MacOS ? false : INSTANCE.isRosettaInternal();
    }
}

