/*
 * Decompiled with CFR 0.152.
 */
package org.merlyn.desktopapp.personality;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.StateFlow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.merlyn.core.spacecontextservice.model.LocalizationContext;
import org.merlyn.desktopapp.personality.DateTimeProvider;
import org.merlyn.desktopapp.personality.DateTimeUtteranceProviderKt;
import org.merlyn.sharedui.res.Strings;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 \u00142\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u0014B\u001f\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0013\u0010\u000b\u001a\u00020\u00032\b\u0010\f\u001a\u0004\u0018\u00010\u0002H\u0096\u0002J\u0012\u0010\r\u001a\u00020\u00032\b\u0010\f\u001a\u0004\u0018\u00010\u0002H\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\f\u0010\u0012\u001a\u00020\u0003*\u00020\u0013H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/merlyn/desktopapp/personality/DateTimeUtteranceProvider;", "Lkotlin/Function1;", "Ljava/util/TimeZone;", "", "localizationContextFlow", "Lkotlinx/coroutines/flow/StateFlow;", "Lorg/merlyn/core/spacecontextservice/model/LocalizationContext;", "dateTimeProvider", "Lorg/merlyn/desktopapp/personality/DateTimeProvider;", "<init>", "(Lkotlinx/coroutines/flow/StateFlow;Lorg/merlyn/desktopapp/personality/DateTimeProvider;)V", "invoke", "timeZone", "getCurrentDateTimeFormatted", "is24HourClock", "", "locale", "Ljava/util/Locale;", "ordinal", "", "Companion", "app"})
public final class DateTimeUtteranceProvider
implements Function1<TimeZone, String> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final StateFlow<LocalizationContext> localizationContextFlow;
    @NotNull
    private final DateTimeProvider dateTimeProvider;
    @NotNull
    public static final String TIME_FORMAT = "h:mm a";
    @NotNull
    public static final String TIME_FORMAT_24H = "H:mm";
    @NotNull
    public static final String MONTH_FORMAT = "MMMM";

    public DateTimeUtteranceProvider(@NotNull StateFlow<LocalizationContext> localizationContextFlow, @NotNull DateTimeProvider dateTimeProvider) {
        Intrinsics.checkNotNullParameter(localizationContextFlow, (String)"localizationContextFlow");
        Intrinsics.checkNotNullParameter((Object)dateTimeProvider, (String)"dateTimeProvider");
        this.localizationContextFlow = localizationContextFlow;
        this.dateTimeProvider = dateTimeProvider;
    }

    public /* synthetic */ DateTimeUtteranceProvider(StateFlow stateFlow, DateTimeProvider dateTimeProvider, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            dateTimeProvider = new DateTimeProvider();
        }
        this((StateFlow<LocalizationContext>)stateFlow, dateTimeProvider);
    }

    @NotNull
    public String invoke(@Nullable TimeZone timeZone) {
        return this.getCurrentDateTimeFormatted(timeZone);
    }

    private final String getCurrentDateTimeFormatted(TimeZone timeZone) {
        LocalDateTime now = this.dateTimeProvider.now(timeZone);
        Locale locale = Locale.forLanguageTag(((LocalizationContext)this.localizationContextFlow.getValue()).getLocale());
        Intrinsics.checkNotNull((Object)locale);
        String string = now.format(DateTimeFormatter.ofPattern(this.is24HourClock(locale) ? TIME_FORMAT_24H : TIME_FORMAT, locale));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        String formattedTime = DateTimeUtteranceProviderKt.fixPartOfDayForTTS(string);
        String dayOfMonthOrdinal = Intrinsics.areEqual((Object)Locale.US.getLanguage(), (Object)locale.getLanguage()) ? this.ordinal(now.getDayOfMonth()) : String.valueOf(now.getDayOfMonth());
        String formattedMonthNow = now.format(DateTimeFormatter.ofPattern(MONTH_FORMAT, locale));
        return formattedTime + " " + dayOfMonthOrdinal + " " + Strings.INSTANCE.getOF_PREPOSITION() + " " + formattedMonthNow;
    }

    private final boolean is24HourClock(Locale locale) {
        return !Intrinsics.areEqual((Object)locale, (Object)Locale.US);
    }

    private final String ordinal(int $this$ordinal) {
        Object[] objectArray = new String[]{"th", "st", "nd", "rd", "th", "th", "th", "th", "th", "th"};
        List suffixes = CollectionsKt.listOf((Object[])objectArray);
        String value2 = (11 <= $this$ordinal ? $this$ordinal < 14 : false) ? $this$ordinal + "th" : "" + $this$ordinal + suffixes.get($this$ordinal % 10);
        return value2;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/merlyn/desktopapp/personality/DateTimeUtteranceProvider$Companion;", "", "<init>", "()V", "TIME_FORMAT", "", "TIME_FORMAT_24H", "MONTH_FORMAT", "app"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

