/*
 * Decompiled with CFR 0.152.
 */
package org.merlyn.desktopapp.service.browser.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.merlyn.desktopapp.os.OS;
import org.merlyn.desktopapp.service.browser.BrowserApplicationService;
import org.merlyn.desktopapp.service.browser.BrowserApplications;
import org.merlyn.desktopapp.service.browser.BrowserSetForegroundService;
import org.merlyn.desktopapp.service.browser.SetForegroundParams;
import org.merlyn.desktopapp.service.browser.SetForegroundResult;
import org.merlyn.sharedui.utils.win32.WindowHandle;
import org.merlyn.sharedui.utils.win32.WindowsWindowManager;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001a\u0010\u000e\u001a\u00020\u000f*\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0016"}, d2={"Lorg/merlyn/desktopapp/service/browser/impl/BrowserSetForegroundServiceImpl;", "Lorg/merlyn/desktopapp/service/browser/BrowserSetForegroundService;", "hostOS", "Lorg/merlyn/desktopapp/os/OS;", "browserApplications", "Lorg/merlyn/desktopapp/service/browser/BrowserApplications;", "browserApplicationService", "Lorg/merlyn/desktopapp/service/browser/BrowserApplicationService;", "<init>", "(Lorg/merlyn/desktopapp/os/OS;Lorg/merlyn/desktopapp/service/browser/BrowserApplications;Lorg/merlyn/desktopapp/service/browser/BrowserApplicationService;)V", "logger", "Lmu/KLogger;", "getLogger", "()Lmu/KLogger;", "setForeground", "Lorg/merlyn/desktopapp/service/browser/SetForegroundResult;", "params", "Lorg/merlyn/desktopapp/service/browser/SetForegroundParams;", "", "Lorg/merlyn/sharedui/utils/win32/WindowHandle;", "metadata", "Companion", "app"})
@SourceDebugExtension(value={"SMAP\nBrowserSetForegroundServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BrowserSetForegroundServiceImpl.kt\norg/merlyn/desktopapp/service/browser/impl/BrowserSetForegroundServiceImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,102:1\n1#2:103\n774#3:104\n865#3,2:105\n1869#3,2:107\n774#3:109\n865#3,2:110\n774#3:112\n865#3,2:113\n37#4:115\n36#4,3:116\n*S KotlinDebug\n*F\n+ 1 BrowserSetForegroundServiceImpl.kt\norg/merlyn/desktopapp/service/browser/impl/BrowserSetForegroundServiceImpl\n*L\n64#1:104\n64#1:105,2\n67#1:107,2\n74#1:109\n74#1:110,2\n80#1:112\n80#1:113,2\n96#1:115\n96#1:116,3\n*E\n"})
public final class BrowserSetForegroundServiceImpl
implements BrowserSetForegroundService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final OS hostOS;
    @NotNull
    private final BrowserApplications browserApplications;
    @NotNull
    private final BrowserApplicationService browserApplicationService;
    @NotNull
    private final KLogger logger;
    @NotNull
    public static final String CHROMIUM_WINDOW_CLASS = "Chrome_WidgetWin_1";

    public BrowserSetForegroundServiceImpl(@NotNull OS hostOS, @NotNull BrowserApplications browserApplications, @NotNull BrowserApplicationService browserApplicationService) {
        Intrinsics.checkNotNullParameter((Object)((Object)hostOS), (String)"hostOS");
        Intrinsics.checkNotNullParameter((Object)browserApplications, (String)"browserApplications");
        Intrinsics.checkNotNullParameter((Object)browserApplicationService, (String)"browserApplicationService");
        this.hostOS = hostOS;
        this.browserApplications = browserApplications;
        this.browserApplicationService = browserApplicationService;
        this.logger = KotlinLogging.INSTANCE.logger(BrowserSetForegroundServiceImpl::logger$lambda$0);
    }

    @NotNull
    public final KLogger getLogger() {
        return this.logger;
    }

    @Override
    @NotNull
    public SetForegroundResult setForeground(@NotNull SetForegroundParams params) {
        Object object;
        Object $this$setForeground_u24lambda_u242;
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        if (!(this.hostOS == OS.Windows)) {
            boolean $i$a$-require-BrowserSetForegroundServiceImpl$setForeground$22 = false;
            String $i$a$-require-BrowserSetForegroundServiceImpl$setForeground$22 = "Service only available for " + OS.Windows;
            throw new IllegalArgumentException($i$a$-require-BrowserSetForegroundServiceImpl$setForeground$22.toString());
        }
        Object object2 = this;
        try {
            $this$setForeground_u24lambda_u242 = object2;
            boolean bl = false;
            $this$setForeground_u24lambda_u242 = Result.constructor-impl((Object)super.setForeground(WindowsWindowManager.INSTANCE.getWindows(), params));
        }
        catch (Throwable bl) {
            $this$setForeground_u24lambda_u242 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object2 = $this$setForeground_u24lambda_u242;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable == null) {
            object = object2;
        } else {
            Throwable it = throwable;
            boolean bl = false;
            object = new SetForegroundResult.Error("WINDOW_FOCUS_FAILED");
        }
        return (SetForegroundResult)object;
    }

    /*
     * WARNING - void declaration
     */
    private final SetForegroundResult setForeground(Set<WindowHandle> $this$setForeground, SetForegroundParams metadata) {
        SetForegroundResult setForegroundResult;
        List list;
        void $this$filterTo$iv$iv;
        SetForegroundResult it;
        void $this$filterTo$iv$iv2;
        WindowHandle it2;
        void $this$filterTo$iv$iv3;
        long start2 = System.currentTimeMillis();
        Iterable $this$filter$iv = $this$setForeground;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv3) {
            it2 = (WindowHandle)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it2.getClassName(), (Object)CHROMIUM_WINDOW_CLASS)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$setForeground_u24lambda_u2414 = $this$filter$iv = (List)destination$iv$iv;
        boolean $i$a$-apply-BrowserSetForegroundServiceImpl$setForeground$windows$32 = false;
        this.logger.debug(BrowserSetForegroundServiceImpl::setForeground$lambda$14$lambda$9);
        Iterable $this$forEach$iv = $this$setForeground_u24lambda_u2414;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            WindowHandle window = (WindowHandle)element$iv;
            boolean bl = false;
            this.logger.debug(() -> BrowserSetForegroundServiceImpl.setForeground$lambda$14$lambda$11$lambda$10(window));
        }
        this.logger.debug(BrowserSetForegroundServiceImpl::setForeground$lambda$14$lambda$12);
        SetForegroundResult setForegroundResult2 = BrowserSetForegroundServiceImpl.setForeground$setForegroundIfSingle((List<WindowHandle>)$this$setForeground_u24lambda_u2414, this, start2, metadata);
        if (setForegroundResult2 != null) {
            SetForegroundResult it3 = setForegroundResult2;
            boolean bl = false;
            return it3;
        }
        $i$f$filter = false;
        Iterable $i$a$-apply-BrowserSetForegroundServiceImpl$setForeground$windows$32 = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            it2 = (WindowHandle)element$iv$iv;
            boolean bl = false;
            if (!StringsKt.contains((CharSequence)it2.getName(), (CharSequence)metadata.getTitle(), (boolean)true)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$setForeground_u24lambda_u2417 = $this$filter$iv = (List)destination$iv$iv;
        boolean $i$a$-apply-BrowserSetForegroundServiceImpl$setForeground$windows$52 = false;
        SetForegroundResult setForegroundResult3 = BrowserSetForegroundServiceImpl.setForeground$setForegroundIfSingle((List<WindowHandle>)$this$setForeground_u24lambda_u2417, this, start2, metadata);
        if (setForegroundResult3 != null) {
            it = setForegroundResult3;
            boolean bl = false;
            return it;
        }
        $i$f$filter = false;
        Iterable $i$a$-apply-BrowserSetForegroundServiceImpl$setForeground$windows$52 = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it2 = (WindowHandle)element$iv$iv;
            boolean bl = false;
            if (!this.browserApplications.isSupportedCommand(this.browserApplicationService.getBrowserApplicationConfig().getBrowserType(), it2.getProcess().getPath())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List $this$setForeground_u24lambda_u2420 = list = (List)destination$iv$iv;
        boolean bl = false;
        SetForegroundResult setForegroundResult4 = BrowserSetForegroundServiceImpl.setForeground$setForegroundIfSingle($this$setForeground_u24lambda_u2420, this, start2, metadata);
        if (setForegroundResult4 != null) {
            it = setForegroundResult4;
            boolean bl2 = false;
            return it;
        }
        List windows = list;
        if (windows.isEmpty()) {
            this.logger.error(() -> BrowserSetForegroundServiceImpl.setForeground$lambda$21(metadata));
            setForegroundResult = new SetForegroundResult.Error("WINDOW_NOT_FOUND");
        } else {
            this.logger.error(() -> BrowserSetForegroundServiceImpl.setForeground$lambda$22(windows, metadata));
            setForegroundResult = new SetForegroundResult.Error("WINDOW_MATCH_MULTIPLE");
        }
        return setForegroundResult;
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Object setForeground$setForegroundAndRespond$lambda$4(WindowHandle $this_setForegroundAndRespond, SetForegroundParams $metadata, long $time) {
        return "Succeeded in focusing window " + $this_setForegroundAndRespond + ", request: " + $metadata + ", in " + $time + " ms";
    }

    private static final Object setForeground$setForegroundAndRespond$lambda$5(WindowHandle $this_setForegroundAndRespond, SetForegroundParams $metadata, Throwable $t) {
        return "Failed to focus window " + $this_setForegroundAndRespond + ", request: " + $metadata + ", error: " + $t.getMessage();
    }

    private static final SetForegroundResult setForeground$setForegroundAndRespond(WindowHandle $this$setForeground_u24setForegroundAndRespond, long start2, BrowserSetForegroundServiceImpl this$0, SetForegroundParams $metadata) {
        SetForegroundResult setForegroundResult;
        long time = System.currentTimeMillis() - start2;
        try {
            $this$setForeground_u24setForegroundAndRespond.setForeground();
            this$0.logger.info(() -> BrowserSetForegroundServiceImpl.setForeground$setForegroundAndRespond$lambda$4($this$setForeground_u24setForegroundAndRespond, $metadata, time));
            setForegroundResult = SetForegroundResult.Success.INSTANCE;
        }
        catch (Throwable t) {
            this$0.logger.error(() -> BrowserSetForegroundServiceImpl.setForeground$setForegroundAndRespond$lambda$5($this$setForeground_u24setForegroundAndRespond, $metadata, t));
            setForegroundResult = new SetForegroundResult.Error("WINDOW_FOCUS_FAILED");
        }
        return setForegroundResult;
    }

    private static final Object setForeground$setForegroundIfSingle$lambda$7$lambda$6(WindowHandle $it) {
        return "Focusing window with title: '" + $it.getName() + "'...";
    }

    private static final SetForegroundResult setForeground$setForegroundIfSingle(List<WindowHandle> $this$setForeground_u24setForegroundIfSingle, BrowserSetForegroundServiceImpl this$0, long start2, SetForegroundParams $metadata) {
        WindowHandle windowHandle = (WindowHandle)CollectionsKt.singleOrNull($this$setForeground_u24setForegroundIfSingle);
        if (windowHandle != null) {
            WindowHandle it = windowHandle;
            boolean bl = false;
            this$0.logger.info(() -> BrowserSetForegroundServiceImpl.setForeground$setForegroundIfSingle$lambda$7$lambda$6(it));
            return BrowserSetForegroundServiceImpl.setForeground$setForegroundAndRespond(it, start2, this$0, $metadata);
        }
        return null;
    }

    private static final Object setForeground$lambda$14$lambda$9() {
        return "Enumerating chrome windows:";
    }

    private static final Object setForeground$lambda$14$lambda$11$lambda$10(WindowHandle $window) {
        return "Found chrome window: " + $window + " ...";
    }

    private static final Object setForeground$lambda$14$lambda$12() {
        return "Done enumerating chrome windows";
    }

    private static final Object setForeground$lambda$21(SetForegroundParams $metadata) {
        return "Did not find a suitable candidate window for request: " + $metadata;
    }

    private static final Object setForeground$lambda$22(List $windows, SetForegroundParams $metadata) {
        Collection $this$toTypedArray$iv = $windows;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String string = Arrays.toString(thisCollection$iv.toArray(new WindowHandle[0]));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return "Found multiple candidate windows: " + string + " for request: " + $metadata;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/merlyn/desktopapp/service/browser/impl/BrowserSetForegroundServiceImpl$Companion;", "", "<init>", "()V", "CHROMIUM_WINDOW_CLASS", "", "app"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

