/*
 * Decompiled with CFR 0.152.
 */
package org.merlyn.desktopapp.service.impl;

import io.ktor.client.HttpClient;
import io.ktor.client.request.HttpRequestBuilder;
import io.ktor.client.request.HttpRequestKt;
import io.ktor.client.statement.HttpResponse;
import io.ktor.client.statement.HttpStatement;
import io.ktor.http.HttpMethod;
import io.ktor.util.reflect.TypeInfoJvmKt;
import java.io.StringReader;
import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.Type;
import java.util.Properties;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.reflect.KType;
import kotlin.reflect.TypesJVMKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.merlyn.desktopapp.config.StageConfig;
import org.merlyn.desktopapp.os.HostOSKt;
import org.merlyn.desktopapp.service.RestartFunction;
import org.merlyn.desktopapp.service.UpdateService;
import org.merlyn.desktopapp.service.UpdateServiceCompanion;
import org.merlyn.desktopapp.service.impl.MacOSAppBundlePermissionsChecker;
import org.merlyn.desktopapp.service.impl.UpdateServiceImpl;
import org.merlyn.desktopapp.storage.ApplicationVersionMetaData;
import org.merlyn.desktopapp.storage.ApplicationVersionMetaDataDao;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u001a\u0010 \u001a\u00020\u00122\b\u0010!\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\"\u001a\u00020\u0012H\u0002J\b\u0010#\u001a\u00020\u001cH\u0002J\b\u0010(\u001a\u00020\u0012H\u0016J\b\u0010)\u001a\u00020\u0012H\u0016J\u000e\u0010*\u001a\u00020\u0012H\u0096@\u00a2\u0006\u0002\u0010+J\u0010\u0010,\u001a\u0004\u0018\u00010\u001cH\u0082@\u00a2\u0006\u0002\u0010+J\u000e\u0010-\u001a\u00020\u0012H\u0096@\u00a2\u0006\u0002\u0010+J\u0010\u0010.\u001a\u00020/2\u0006\u0010$\u001a\u00020%H\u0016J\b\u0010\"\u001a\u00020/H\u0016J\b\u0010\u0019\u001a\u00020/H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00180\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0016R\"\u0010\u001d\u001a\u0004\u0018\u00010\u001c2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010$\u001a\u00020%8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'\u00a8\u00060"}, d2={"Lorg/merlyn/desktopapp/service/impl/UpdateServiceImpl;", "Lorg/merlyn/desktopapp/service/UpdateService;", "config", "Lorg/merlyn/desktopapp/config/StageConfig;", "httpClient", "Lio/ktor/client/HttpClient;", "restartFunction", "Lorg/merlyn/desktopapp/service/RestartFunction;", "applicationVersionMetaDataDao", "Lorg/merlyn/desktopapp/storage/ApplicationVersionMetaDataDao;", "updateServiceCompanion", "Lorg/merlyn/desktopapp/service/UpdateServiceCompanion;", "<init>", "(Lorg/merlyn/desktopapp/config/StageConfig;Lio/ktor/client/HttpClient;Lorg/merlyn/desktopapp/service/RestartFunction;Lorg/merlyn/desktopapp/storage/ApplicationVersionMetaDataDao;Lorg/merlyn/desktopapp/service/UpdateServiceCompanion;)V", "logger", "Lmu/KLogger;", "_notifyUserOfUpdate", "Lkotlinx/coroutines/flow/MutableStateFlow;", "", "notifyUserOfUpdate", "Lkotlinx/coroutines/flow/Flow;", "getNotifyUserOfUpdate", "()Lkotlinx/coroutines/flow/Flow;", "_notifyUserOfUpdateAvailable", "", "notifyUserOfUpdateAvailable", "getNotifyUserOfUpdateAvailable", "value", "", "latestVersion", "getLatestVersion", "()Ljava/lang/String;", "calcNotifyUserOfUpdate", "currentVersion", "userNotified", "getMetadataUrl", "applicationVersionMetaData", "Lorg/merlyn/desktopapp/storage/ApplicationVersionMetaData;", "getApplicationVersionMetaData", "()Lorg/merlyn/desktopapp/storage/ApplicationVersionMetaData;", "isAppUpdatable", "isForcedUpdate", "checkForUpdate", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "retrieveLatestVersion", "performUpdate", "saveApplicationUpdateData", "", "app"})
@SourceDebugExtension(value={"SMAP\nUpdateServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UpdateServiceImpl.kt\norg/merlyn/desktopapp/service/impl/UpdateServiceImpl\n+ 2 builders.kt\nio/ktor/client/request/BuildersKt\n+ 3 builders.kt\nio/ktor/client/request/BuildersKt$get$4\n+ 4 HttpClientCall.kt\nio/ktor/client/call/HttpClientCallKt\n+ 5 TypeInfoJvm.kt\nio/ktor/util/reflect/TypeInfoJvmKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 7 StateFlow.kt\nkotlinx/coroutines/flow/StateFlowKt\n*L\n1#1,258:1\n329#2,4:259\n225#2:263\n99#2,2:265\n22#2:267\n331#3:264\n155#4:268\n17#5,3:269\n1#6:272\n230#7,5:273\n*S KotlinDebug\n*F\n+ 1 UpdateServiceImpl.kt\norg/merlyn/desktopapp/service/impl/UpdateServiceImpl\n*L\n204#1:259,4\n204#1:263\n204#1:265,2\n204#1:267\n204#1:264\n204#1:268\n204#1:269,3\n255#1:273,5\n*E\n"})
public final class UpdateServiceImpl
implements UpdateService {
    @NotNull
    private final StageConfig config;
    @NotNull
    private final HttpClient httpClient;
    @NotNull
    private final RestartFunction restartFunction;
    @NotNull
    private final ApplicationVersionMetaDataDao applicationVersionMetaDataDao;
    @NotNull
    private final UpdateServiceCompanion updateServiceCompanion;
    @NotNull
    private final KLogger logger;
    @NotNull
    private final MutableStateFlow<Boolean> _notifyUserOfUpdate;
    @NotNull
    private final Flow<Boolean> notifyUserOfUpdate;
    @NotNull
    private final MutableStateFlow<Integer> _notifyUserOfUpdateAvailable;
    @NotNull
    private final Flow<Integer> notifyUserOfUpdateAvailable;
    @Nullable
    private String latestVersion;

    public UpdateServiceImpl(@NotNull StageConfig config, @NotNull HttpClient httpClient, @NotNull RestartFunction restartFunction, @NotNull ApplicationVersionMetaDataDao applicationVersionMetaDataDao, @NotNull UpdateServiceCompanion updateServiceCompanion) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)httpClient, (String)"httpClient");
        Intrinsics.checkNotNullParameter((Object)restartFunction, (String)"restartFunction");
        Intrinsics.checkNotNullParameter((Object)applicationVersionMetaDataDao, (String)"applicationVersionMetaDataDao");
        Intrinsics.checkNotNullParameter((Object)updateServiceCompanion, (String)"updateServiceCompanion");
        this.config = config;
        this.httpClient = httpClient;
        this.restartFunction = restartFunction;
        this.applicationVersionMetaDataDao = applicationVersionMetaDataDao;
        this.updateServiceCompanion = updateServiceCompanion;
        this.logger = KotlinLogging.INSTANCE.logger(UpdateServiceImpl::logger$lambda$0);
        this._notifyUserOfUpdateAvailable = StateFlowKt.MutableStateFlow((Object)0);
        this.notifyUserOfUpdateAvailable = (Flow)FlowKt.asStateFlow(this._notifyUserOfUpdateAvailable);
        ApplicationVersionMetaData applicationUpdateData = this.applicationVersionMetaDataDao.get();
        this._notifyUserOfUpdate = StateFlowKt.MutableStateFlow((Object)this.calcNotifyUserOfUpdate(applicationUpdateData.getCurrentVersion(), applicationUpdateData.getUserNotified()));
        this.notifyUserOfUpdate = (Flow)FlowKt.asStateFlow(this._notifyUserOfUpdate);
    }

    @Override
    @NotNull
    public Flow<Boolean> getNotifyUserOfUpdate() {
        return this.notifyUserOfUpdate;
    }

    @Override
    @NotNull
    public Flow<Integer> getNotifyUserOfUpdateAvailable() {
        return this.notifyUserOfUpdateAvailable;
    }

    @Override
    @Nullable
    public String getLatestVersion() {
        return this.latestVersion;
    }

    private final boolean calcNotifyUserOfUpdate(String currentVersion, boolean userNotified) {
        return currentVersion != null ? !userNotified : false;
    }

    private final String getMetadataUrl() {
        String appRepositoryUrl = this.config.getApplicationConfig().getAppRepositoryUrl();
        return (String)(StringsKt.startsWith$default((String)appRepositoryUrl, (String)"http", (boolean)false, (int)2, null) ? appRepositoryUrl : "https://" + appRepositoryUrl) + "/metadata.properties";
    }

    @Override
    @NotNull
    public ApplicationVersionMetaData getApplicationVersionMetaData() {
        return this.applicationVersionMetaDataDao.get();
    }

    @Override
    public boolean isAppUpdatable() {
        return this.updateServiceCompanion.isAppUpdateEnabled() && (Boolean)HostOSKt.executeBasedOnTheOS(UpdateServiceImpl::isAppUpdatable$lambda$1, UpdateServiceImpl::isAppUpdatable$lambda$2, UpdateServiceImpl::isAppUpdatable$lambda$3) != false;
    }

    @Override
    public boolean isForcedUpdate() {
        return this.updateServiceCompanion.isForcedUpdate();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object checkForUpdate(@NotNull Continuation<? super Boolean> $completion) {
        if (!($completion instanceof checkForUpdate.1)) ** GOTO lbl-1000
        var5_2 = $completion;
        if ((var5_2.label & -2147483648) != 0) {
            var5_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ UpdateServiceImpl this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.checkForUpdate((Continuation<? super Boolean>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var6_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                this.logger.debug((Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, checkForUpdate$lambda$4(), ()Ljava/lang/Object;)());
                currentVersion = this.config.getApplicationConfig().getAppVersion();
                this.logger.debug((Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, checkForUpdate$lambda$5(java.lang.String ), ()Ljava/lang/Object;)((String)currentVersion));
                if (this.updateServiceCompanion.isServiceAvailable()) {
                    this.logger.debug((Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, checkForUpdate$lambda$6(org.merlyn.desktopapp.service.impl.UpdateServiceImpl ), ()Ljava/lang/Object;)((UpdateServiceImpl)this));
                }
                $continuation.L$0 = this;
                $continuation.L$1 = currentVersion;
                $continuation.label = 1;
                v0 = this.retrieveLatestVersion((Continuation<? super String>)$continuation);
                if (v0 == var6_4) {
                    return var6_4;
                }
                ** GOTO lbl29
            }
            case 1: {
                currentVersion = (String)$continuation.L$1;
                this = (UpdateServiceImpl)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl29:
                // 2 sources

                v1 = (String)v0;
                if (v1 == null) {
                    return Boxing.boxBoolean((boolean)false);
                }
                latestVersion = v1;
                if (new ComparableVersion(latestVersion).compareTo(new ComparableVersion(currentVersion)) > 0) {
                    this.logger.info((Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, checkForUpdate$lambda$7(java.lang.String ), ()Ljava/lang/Object;)((String)latestVersion));
                    return Boxing.boxBoolean((boolean)true);
                }
                this.logger.debug((Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, checkForUpdate$lambda$8(java.lang.String ), ()Ljava/lang/Object;)((String)currentVersion));
                return Boxing.boxBoolean((boolean)false);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object retrieveLatestVersion(Continuation<? super String> $completion) {
        if (!($completion instanceof retrieveLatestVersion.1)) ** GOTO lbl-1000
        var23_2 = $completion;
        if ((var23_2.label & -2147483648) != 0) {
            var23_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ UpdateServiceImpl this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return UpdateServiceImpl.access$retrieveLatestVersion(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var24_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                var2_5 = this;
                $this$retrieveLatestVersion_u24lambda_u2411 = var2_5;
                $i$a$-runCatching-UpdateServiceImpl$retrieveLatestVersion$2 = false;
                if (!$this$retrieveLatestVersion_u24lambda_u2411.updateServiceCompanion.isServiceAvailable()) ** GOTO lbl34
                $continuation.L$0 = this;
                $continuation.L$1 = $this$retrieveLatestVersion_u24lambda_u2411;
                $continuation.label = 1;
                v0 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((UpdateServiceImpl)$this$retrieveLatestVersion_u24lambda_u2411, null){
                    int label;
                    final /* synthetic */ UpdateServiceImpl $this_runCatching;
                    {
                        this.$this_runCatching = $receiver;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                UpdateServiceImpl.access$getLogger$p(this.$this_runCatching).debug(() -> retrieveLatestVersion.2.1.invokeSuspend$lambda$0(this.$this_runCatching));
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }

                    private static final Object invokeSuspend$lambda$0(UpdateServiceImpl $this_runCatching) {
                        return "Latest app version available reported by Conveyor: " + UpdateServiceImpl.access$getUpdateServiceCompanion$p($this_runCatching).getLatestVersion();
                    }
                }), (Continuation)$continuation);
                ** if (v0 != var24_4) goto lbl25
lbl24:
                // 1 sources

                return var24_4;
lbl25:
                // 1 sources

                ** GOTO lbl34
            }
            case 1: {
                $i$a$-runCatching-UpdateServiceImpl$retrieveLatestVersion$2 = false;
                $this$retrieveLatestVersion_u24lambda_u2411 = (UpdateServiceImpl)$continuation.L$1;
                this = (UpdateServiceImpl)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl34:
                // 3 sources

                metadataUrl = super.getMetadataUrl();
                $this$retrieveLatestVersion_u24lambda_u2411.logger.debug((Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, retrieveLatestVersion$lambda$11$lambda$9(java.lang.String ), ()Ljava/lang/Object;)((String)metadataUrl));
                var6_10 = $this$retrieveLatestVersion_u24lambda_u2411.httpClient;
                $completion$iv = $continuation;
                $i$f$get = false;
                $this$get$iv$iv = $this$get_u24default$iv;
                $i$f$get = false;
                var11_18 = $this$get$iv$iv;
                $this$get_u24lambda_u244$iv = var12_19 = new HttpRequestBuilder();
                $i$a$-get-BuildersKt$get$5$iv = false;
                HttpRequestKt.url((HttpRequestBuilder)$this$get_u24lambda_u244$iv, (String)metadataUrl);
                var15_22 = $this$get_u24lambda_u244$iv;
                $i$a$-get-BuildersKt$get$4 = false;
                builder$iv$iv$iv = var12_19;
                $i$f$get = false;
                builder$iv$iv$iv.setMethod(HttpMethod.Companion.getGet());
                $this$request$iv$iv$iv$iv = $this$get$iv$iv$iv;
                $i$f$request = false;
                $continuation.L$0 = this;
                $continuation.L$1 = $this$retrieveLatestVersion_u24lambda_u2411;
                $continuation.label = 2;
                v1 = new HttpStatement(builder$iv$iv$iv, (HttpClient)$this$request$iv$iv$iv$iv).execute((Continuation)$completion$iv);
                ** if (v1 != var24_4) goto lbl59
lbl58:
                // 1 sources

                return var24_4;
lbl59:
                // 1 sources

                ** GOTO lbl74
            }
            case 2: {
                $i$a$-runCatching-UpdateServiceImpl$retrieveLatestVersion$2 = false;
                $i$f$get = false;
                $i$f$get = false;
                $i$f$get = false;
                $i$f$request = false;
                $this$retrieveLatestVersion_u24lambda_u2411 = (UpdateServiceImpl)$continuation.L$1;
                this = (UpdateServiceImpl)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl74:
                // 2 sources

                $this$get_u24default$iv = (HttpResponse)v1;
                $completion$iv = $continuation;
                $i$f$body = false;
                $i$f$typeInfo = false;
                kType$iv$iv = Reflection.typeOf(String.class);
                reifiedType$iv$iv = TypesJVMKt.getJavaType((KType)kType$iv$iv);
                $continuation.L$0 = this;
                $continuation.L$1 = $this$retrieveLatestVersion_u24lambda_u2411;
                $continuation.label = 3;
                v2 = $this$body$iv.getCall().bodyNullable(TypeInfoJvmKt.typeInfoImpl((Type)reifiedType$iv$iv, (KClass)Reflection.getOrCreateKotlinClass(String.class), (KType)kType$iv$iv), (Continuation)$completion$iv);
                ** if (v2 != var24_4) goto lbl86
lbl85:
                // 1 sources

                return var24_4;
lbl86:
                // 1 sources

                ** GOTO lbl96
            }
            case 3: {
                $i$a$-runCatching-UpdateServiceImpl$retrieveLatestVersion$2 = false;
                $i$f$body = false;
                $this$retrieveLatestVersion_u24lambda_u2411 = (UpdateServiceImpl)$continuation.L$1;
                this = (UpdateServiceImpl)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl96:
                // 2 sources

                if (v2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                }
                response = (String)v2;
                metaDataProperties = new Properties();
                $continuation.L$0 = this;
                $continuation.L$1 = $this$retrieveLatestVersion_u24lambda_u2411;
                $continuation.L$2 = metaDataProperties;
                $continuation.label = 4;
                v3 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(metaDataProperties, response, null){
                    int label;
                    final /* synthetic */ Properties $metaDataProperties;
                    final /* synthetic */ String $response;
                    {
                        this.$metaDataProperties = $metaDataProperties;
                        this.$response = $response;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                this.$metaDataProperties.load(new StringReader(this.$response));
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                ** if (v3 != var24_4) goto lbl107
lbl106:
                // 1 sources

                return var24_4;
lbl107:
                // 1 sources

                ** GOTO lbl117
            }
            case 4: {
                $i$a$-runCatching-UpdateServiceImpl$retrieveLatestVersion$2 = false;
                metaDataProperties = (Properties)$continuation.L$2;
                $this$retrieveLatestVersion_u24lambda_u2411 = (UpdateServiceImpl)$continuation.L$1;
                this = (UpdateServiceImpl)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v3 = $result;
lbl117:
                    // 2 sources

                    if (!metaDataProperties.containsKey("app.version")) {
                        throw new RuntimeException("Cannot find app.version key in download site metadata.properties");
                    }
                    it = var20_29 = metaDataProperties.getProperty("app.version");
                    $i$a$-also-UpdateServiceImpl$retrieveLatestVersion$2$4 = false;
                    $this$retrieveLatestVersion_u24lambda_u2411.latestVersion = it;
                    $this$retrieveLatestVersion_u24lambda_u2411 = Result.constructor-impl((Object)var20_29);
                }
                catch (Throwable $i$a$-runCatching-UpdateServiceImpl$retrieveLatestVersion$2) {
                    $this$retrieveLatestVersion_u24lambda_u2411 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$i$a$-runCatching-UpdateServiceImpl$retrieveLatestVersion$2));
                }
                var2_5 = $this$retrieveLatestVersion_u24lambda_u2411;
                v4 = Result.exceptionOrNull-impl((Object)var2_5);
                if (v4 == null) {
                    v5 = var2_5;
                } else {
                    it = v4;
                    $i$a$-getOrElse-UpdateServiceImpl$retrieveLatestVersion$3 = false;
                    this.logger.error("Error checking latest app version available", it);
                    this.latestVersion = null;
                    v5 = null;
                }
                return v5;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Override
    @Nullable
    public Object performUpdate(@NotNull Continuation<? super Boolean> $completion) {
        if (this.updateServiceCompanion.isServiceAvailable()) {
            this.logger.info(UpdateServiceImpl::performUpdate$lambda$13);
            return Boxing.boxBoolean((boolean)this.updateServiceCompanion.performUpdate());
        }
        this.logger.info(UpdateServiceImpl::performUpdate$lambda$14);
        Object object = this;
        try {
            UpdateServiceImpl $this$performUpdate_u24lambda_u2415 = object;
            boolean bl = false;
            $this$performUpdate_u24lambda_u2415.restartFunction.execute();
            throw new KotlinNothingValueException();
        }
        catch (Throwable bl) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            Throwable throwable = Result.exceptionOrNull-impl((Object)object);
            if (throwable != null) {
                Throwable throwable2;
                Throwable it = throwable2 = throwable;
                boolean bl2 = false;
                this.logger.error("Error performing app update", it);
                return Boxing.boxBoolean((boolean)false);
            }
            return Boxing.boxBoolean((boolean)true);
        }
    }

    @Override
    public void saveApplicationUpdateData(@NotNull ApplicationVersionMetaData applicationVersionMetaData) {
        Intrinsics.checkNotNullParameter((Object)applicationVersionMetaData, (String)"applicationVersionMetaData");
        this.applicationVersionMetaDataDao.update(applicationVersionMetaData);
        this._notifyUserOfUpdate.setValue((Object)this.calcNotifyUserOfUpdate(applicationVersionMetaData.getCurrentVersion(), applicationVersionMetaData.getUserNotified()));
    }

    @Override
    public void userNotified() {
        this.applicationVersionMetaDataDao.update(ApplicationVersionMetaData.copy$default(this.getApplicationVersionMetaData(), null, true, null, null, null, 29, null));
        this._notifyUserOfUpdate.setValue((Object)this.calcNotifyUserOfUpdate(this.getApplicationVersionMetaData().getCurrentVersion(), true));
    }

    @Override
    public void notifyUserOfUpdateAvailable() {
        int it;
        Integer nextValue$iv;
        Object prevValue$iv;
        MutableStateFlow<Integer> $this$update$iv = this._notifyUserOfUpdateAvailable;
        boolean $i$f$update = false;
        do {
            prevValue$iv = $this$update$iv.getValue();
            it = ((Number)prevValue$iv).intValue();
            boolean bl = false;
        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = Integer.valueOf(it + 1))));
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final boolean isAppUpdatable$lambda$1() {
        return true;
    }

    private static final boolean isAppUpdatable$lambda$2() {
        return MacOSAppBundlePermissionsChecker.INSTANCE.isAppBundleWriteable();
    }

    private static final boolean isAppUpdatable$lambda$3() {
        return false;
    }

    private static final Object checkForUpdate$lambda$4() {
        return "Checking for update";
    }

    private static final Object checkForUpdate$lambda$5(String $currentVersion) {
        return "Current app version: " + $currentVersion;
    }

    private static final Object checkForUpdate$lambda$6(UpdateServiceImpl this$0) {
        return "Current app version reported by Conveyor: " + this$0.updateServiceCompanion.getCurrentVersion();
    }

    private static final Object checkForUpdate$lambda$7(String $latestVersion) {
        return "New app version available: " + $latestVersion;
    }

    private static final Object checkForUpdate$lambda$8(String $currentVersion) {
        return "App already on latest version: " + $currentVersion;
    }

    private static final Object retrieveLatestVersion$lambda$11$lambda$9(String $metadataUrl) {
        return "Checking repositoryUrl for version info " + $metadataUrl;
    }

    private static final Object performUpdate$lambda$13() {
        return "Performing update (using Conveyor)";
    }

    private static final Object performUpdate$lambda$14() {
        return "Performing update (using fallback method)";
    }

    public static final /* synthetic */ Object access$retrieveLatestVersion(UpdateServiceImpl $this, Continuation $completion) {
        return $this.retrieveLatestVersion((Continuation<? super String>)$completion);
    }

    public static final /* synthetic */ KLogger access$getLogger$p(UpdateServiceImpl $this) {
        return $this.logger;
    }

    public static final /* synthetic */ UpdateServiceCompanion access$getUpdateServiceCompanion$p(UpdateServiceImpl $this) {
        return $this.updateServiceCompanion;
    }
}

