/*
 * Decompiled with CFR 0.152.
 */
package org.merlyn.desktopapp.storage.modernimpl;

import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.merlyn.desktopapp.config.StageConfig;
import org.merlyn.desktopapp.coresdk.agent.ActionDefinitionsKt;
import org.merlyn.desktopapp.coresdk.agent.impl.BrowserAgent;
import org.merlyn.desktopapp.coresdk.agent.impl.UserGesturesAgent;
import org.merlyn.desktopapp.coresdk.rcu.KeyCode;
import org.merlyn.desktopapp.storage.ShortcutAction;
import org.merlyn.desktopapp.storage.ShortcutData;
import org.merlyn.desktopapp.storage.ShortcutDataDao;
import org.merlyn.desktopapp.storage.modernimpl.PreferencesFileStorage;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J\b\u0010\u000b\u001a\u00020\tH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\u001c\u0010\b\u001a\u00020\t2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u000fH\u0002J\b\u0010\u0010\u001a\u00020\tH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/merlyn/desktopapp/storage/modernimpl/ShortcutDataDaoImpl;", "Lorg/merlyn/desktopapp/storage/ShortcutDataDao;", "preferencesFileStorage", "Lorg/merlyn/desktopapp/storage/modernimpl/PreferencesFileStorage;", "config", "Lorg/merlyn/desktopapp/config/StageConfig;", "<init>", "(Lorg/merlyn/desktopapp/storage/modernimpl/PreferencesFileStorage;Lorg/merlyn/desktopapp/config/StageConfig;)V", "update", "Lorg/merlyn/desktopapp/storage/ShortcutData;", "newShortcutData", "get", "isDefault", "", "operation", "Lkotlin/Function1;", "createDefaultShortcutData", "app"})
public final class ShortcutDataDaoImpl
implements ShortcutDataDao {
    @NotNull
    private final PreferencesFileStorage preferencesFileStorage;
    @NotNull
    private final StageConfig config;

    public ShortcutDataDaoImpl(@NotNull PreferencesFileStorage preferencesFileStorage, @NotNull StageConfig config) {
        Intrinsics.checkNotNullParameter((Object)preferencesFileStorage, (String)"preferencesFileStorage");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.preferencesFileStorage = preferencesFileStorage;
        this.config = config;
    }

    @Override
    @NotNull
    public ShortcutData update(@NotNull ShortcutData newShortcutData) {
        Intrinsics.checkNotNullParameter((Object)newShortcutData, (String)"newShortcutData");
        return this.update((Function1<? super ShortcutData, ShortcutData>)((Function1)arg_0 -> ShortcutDataDaoImpl.update$lambda$0(newShortcutData, arg_0)));
    }

    @Override
    @NotNull
    public ShortcutData get() {
        ShortcutData shortcutData = !this.isDefault() ? this.preferencesFileStorage.getShortcutData() : null;
        if (shortcutData == null) {
            shortcutData = this.createDefaultShortcutData();
        }
        return shortcutData;
    }

    @Override
    public boolean isDefault() {
        Object object;
        return !this.config.getApplicationConfig().getShortcutsFromCloudEnabled() || ((object = this.preferencesFileStorage.getShortcutData()) != null && (object = ((ShortcutData)object).getActions()) != null ? object.isEmpty() : true);
    }

    private final ShortcutData update(Function1<? super ShortcutData, ShortcutData> operation) {
        ShortcutData shortcutData = (ShortcutData)operation.invoke((Object)this.get());
        this.preferencesFileStorage.setShortcutData(shortcutData);
        return shortcutData;
    }

    private final ShortcutData createDefaultShortcutData() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)((Object)KeyCode.SHORTCUT_2), (Object)new ShortcutAction(BrowserAgent.Companion.getNAME(), "OPEN_URL", ActionDefinitionsKt.buildOpenUrlParams$default(this.config.getApplicationConfig().getShortcut2Url(), null, 2, null))), TuplesKt.to((Object)((Object)KeyCode.SHORTCUT_3), (Object)new ShortcutAction(UserGesturesAgent.Companion.getAgentName(), "TAKE_SCREENSHOT", null)), TuplesKt.to((Object)((Object)KeyCode.SHORTCUT_4), (Object)new ShortcutAction(BrowserAgent.Companion.getNAME(), "OPEN_URL", ActionDefinitionsKt.buildOpenUrlParams$default(this.config.getApplicationConfig().getShortcut4Url(), null, 2, null))), TuplesKt.to((Object)((Object)KeyCode.SHORTCUT_1), (Object)new ShortcutAction(BrowserAgent.Companion.getNAME(), "OPEN_URL", ActionDefinitionsKt.buildOpenUrlParams$default(this.config.getApplicationConfig().getShortcut1Url(), null, 2, null)))};
        Map actions = MapsKt.mapOf((Pair[])pairArray);
        return new ShortcutData(actions);
    }

    private static final ShortcutData update$lambda$0(ShortcutData $newShortcutData, ShortcutData it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.copy($newShortcutData.getActions());
    }
}

