/*
 * Decompiled with CFR 0.152.
 */
package org.merlyn.agent.model;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0086\b\u0018\u0000 \u001b2\u00020\u0001:\u0002\u001b\u001cB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0014\u001a\u00020\u0003H\u00c2\u0003J\u0013\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u0011H\u00d6\u0001J\b\u0010\u001a\u001a\u00020\u0003H\u0016R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0013\u0010\b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0013\u0010\n\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u0011X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001d"}, d2={"Lorg/merlyn/agent/model/Locator;", "", "locator", "", "(Ljava/lang/String;)V", "agentName", "getAgentName", "()Ljava/lang/String;", "agentVersion", "getAgentVersion", "deviceId", "getDeviceId", "type", "Lorg/merlyn/agent/model/Locator$DestinationType;", "getType", "()Lorg/merlyn/agent/model/Locator$DestinationType;", "version", "", "getVersion", "()I", "component1", "copy", "equals", "", "other", "hashCode", "toString", "Companion", "DestinationType", "common"})
public final class Locator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String locator;
    private final int version;
    @NotNull
    private final DestinationType type;
    @Nullable
    private final String deviceId;
    @Nullable
    private final String agentName;
    @Nullable
    private final String agentVersion;

    public Locator(@NotNull String locator) {
        Intrinsics.checkNotNullParameter((Object)locator, (String)"locator");
        this.locator = locator;
        this.version = 1;
        String[] stringArray = new String[]{":"};
        List parts = StringsKt.split$default((CharSequence)this.locator, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        if (!(parts.size() >= 2)) {
            boolean bl = false;
            String string = "Invalid " + this.locator + ", minimum address parts length must be 2 (e.g. xx:yy)";
            throw new IllegalStateException(string.toString());
        }
        int version = Integer.parseInt(StringsKt.substringAfter$default((String)((String)parts.get(0)), (String)"mar", null, (int)2, null));
        if (!(version == this.version)) {
            boolean bl = false;
            String string = "Invalid version, must be " + this.version;
            throw new IllegalStateException(string.toString());
        }
        this.type = DestinationType.Companion.get((String)parts.get(1));
        switch (WhenMappings.$EnumSwitchMapping$0[this.type.ordinal()]) {
            case 1: 
            case 2: {
                this.deviceId = (String)CollectionsKt.getOrNull((List)parts, (int)2);
                this.agentName = (String)CollectionsKt.getOrNull((List)parts, (int)3);
                this.agentVersion = (String)CollectionsKt.getOrNull((List)parts, (int)4);
                break;
            }
            case 3: {
                this.deviceId = null;
                this.agentName = (String)CollectionsKt.getOrNull((List)parts, (int)2);
                this.agentVersion = (String)CollectionsKt.getOrNull((List)parts, (int)3);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    public final int getVersion() {
        return this.version;
    }

    @NotNull
    public final DestinationType getType() {
        return this.type;
    }

    @Nullable
    public final String getDeviceId() {
        return this.deviceId;
    }

    @Nullable
    public final String getAgentName() {
        return this.agentName;
    }

    @Nullable
    public final String getAgentVersion() {
        return this.agentVersion;
    }

    @NotNull
    public String toString() {
        return this.locator;
    }

    private final String component1() {
        return this.locator;
    }

    @NotNull
    public final Locator copy(@NotNull String locator) {
        Intrinsics.checkNotNullParameter((Object)locator, (String)"locator");
        return new Locator(locator);
    }

    public static /* synthetic */ Locator copy$default(Locator locator, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = locator.locator;
        }
        return locator.copy(string);
    }

    public int hashCode() {
        return this.locator.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Locator)) {
            return false;
        }
        Locator locator = (Locator)other;
        return Intrinsics.areEqual((Object)this.locator, (Object)locator.locator);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\b\u0086\u0001\u0018\u0000 \n2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\nB\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\u000b"}, d2={"Lorg/merlyn/agent/model/Locator$DestinationType;", "", "typeName", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getTypeName", "()Ljava/lang/String;", "CLOUD", "CLIENT", "WEB", "Companion", "common"})
    public static final class DestinationType
    extends Enum<DestinationType> {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private final String typeName;
        @NotNull
        private static final Map<String, DestinationType> map;
        public static final /* enum */ DestinationType CLOUD;
        public static final /* enum */ DestinationType CLIENT;
        public static final /* enum */ DestinationType WEB;
        private static final /* synthetic */ DestinationType[] $VALUES;

        private DestinationType(String typeName) {
            this.typeName = typeName;
        }

        @NotNull
        public final String getTypeName() {
            return this.typeName;
        }

        public static DestinationType[] values() {
            return (DestinationType[])$VALUES.clone();
        }

        public static DestinationType valueOf(String value) {
            return Enum.valueOf(DestinationType.class, value);
        }

        /*
         * WARNING - void declaration
         */
        static {
            void $this$associateByTo$iv$iv;
            CLOUD = new DestinationType("cloud");
            CLIENT = new DestinationType("client");
            WEB = new DestinationType("web");
            $VALUES = destinationTypeArray = new DestinationType[]{DestinationType.CLOUD, DestinationType.CLIENT, DestinationType.WEB};
            Companion = new Companion(null);
            DestinationType[] $this$associateBy$iv = DestinationType.values();
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)$this$associateBy$iv.length), (int)16);
            DestinationType[] destinationTypeArray = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            int n = ((void)$this$associateByTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void p0;
                void element$iv$iv;
                void var9_9 = element$iv$iv = $this$associateByTo$iv$iv[i];
                Map map = destination$iv$iv;
                boolean bl = false;
                map.put(p0.typeName, element$iv$iv);
            }
            map = destination$iv$iv;
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0005H\u0086\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/merlyn/agent/model/Locator$DestinationType$Companion;", "", "()V", "map", "", "", "Lorg/merlyn/agent/model/Locator$DestinationType;", "get", "value", "common"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final DestinationType get(@NotNull String value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                Object v = map.get(value);
                if (v == null) {
                    String string = "Required value was null.";
                    throw new IllegalArgumentException(string.toString());
                }
                return (DestinationType)((Object)v);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u000e\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\bJ\u001e\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\bJ\u0016\u0010\r\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\bJ!\u0010\u000e\u001a\u00020\b2\u0012\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0010\"\u00020\bH\u0002\u00a2\u0006\u0002\u0010\u0011J\u001e\u0010\u0012\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\b\u00a8\u0006\u0013"}, d2={"Lorg/merlyn/agent/model/Locator$Companion;", "", "()V", "buildLocator", "Lorg/merlyn/agent/model/Locator;", "destinationType", "Lorg/merlyn/agent/model/Locator$DestinationType;", "locationDetails", "", "client", "deviceId", "agentName", "agentVersion", "cloud", "joinLocationParts", "parts", "", "([Ljava/lang/String;)Ljava/lang/String;", "web", "common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Locator web(@NotNull String deviceId, @NotNull String agentName, @NotNull String agentVersion) {
            Intrinsics.checkNotNullParameter((Object)deviceId, (String)"deviceId");
            Intrinsics.checkNotNullParameter((Object)agentName, (String)"agentName");
            Intrinsics.checkNotNullParameter((Object)agentVersion, (String)"agentVersion");
            String[] stringArray = new String[]{deviceId, agentName, agentVersion};
            return this.buildLocator(DestinationType.WEB, this.joinLocationParts(stringArray));
        }

        @NotNull
        public final Locator client(@NotNull String deviceId) {
            Intrinsics.checkNotNullParameter((Object)deviceId, (String)"deviceId");
            return this.buildLocator(DestinationType.CLIENT, deviceId);
        }

        @NotNull
        public final Locator client(@NotNull String deviceId, @NotNull String agentName, @NotNull String agentVersion) {
            Intrinsics.checkNotNullParameter((Object)deviceId, (String)"deviceId");
            Intrinsics.checkNotNullParameter((Object)agentName, (String)"agentName");
            Intrinsics.checkNotNullParameter((Object)agentVersion, (String)"agentVersion");
            String[] stringArray = new String[]{deviceId, agentName, agentVersion};
            return this.buildLocator(DestinationType.CLIENT, this.joinLocationParts(stringArray));
        }

        @NotNull
        public final Locator cloud(@NotNull String agentName, @NotNull String agentVersion) {
            Intrinsics.checkNotNullParameter((Object)agentName, (String)"agentName");
            Intrinsics.checkNotNullParameter((Object)agentVersion, (String)"agentVersion");
            String[] stringArray = new String[]{agentName, agentVersion};
            return this.buildLocator(DestinationType.CLOUD, this.joinLocationParts(stringArray));
        }

        private final Locator buildLocator(DestinationType destinationType, String locationDetails) {
            String[] stringArray = new String[]{"mar1", destinationType.getTypeName(), locationDetails};
            String locatorString = this.joinLocationParts(stringArray);
            return new Locator(locatorString);
        }

        private final String joinLocationParts(String ... parts) {
            return ArraysKt.joinToString$default((Object[])parts, (CharSequence)":", null, null, (int)0, null, null, (int)62, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DestinationType.values().length];
            try {
                nArray[DestinationType.CLIENT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DestinationType.WEB.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DestinationType.CLOUD.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

