/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.protocol;

import io.sentry.ILogger;
import io.sentry.JsonDeserializer;
import io.sentry.JsonObjectReader;
import io.sentry.JsonSerializable;
import io.sentry.JsonUnknown;
import io.sentry.ObjectWriter;
import io.sentry.util.CollectionUtils;
import io.sentry.vendor.gson.stream.JsonToken;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MetricSummary
implements JsonUnknown,
JsonSerializable {
    private double min;
    private double max;
    private double sum;
    private int count;
    @Nullable
    private Map<String, String> tags;
    @Nullable
    private Map<String, Object> unknown;

    public MetricSummary() {
    }

    public MetricSummary(double min, double max, double sum, int count, @Nullable Map<String, String> tags) {
        this.tags = tags;
        this.min = min;
        this.max = max;
        this.count = count;
        this.sum = sum;
        this.unknown = null;
    }

    public void setTags(@Nullable Map<String, String> tags) {
        this.tags = tags;
    }

    public void setMin(double min) {
        this.min = min;
    }

    public void setMax(double max) {
        this.max = max;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public void setSum(double sum) {
        this.sum = sum;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public double getSum() {
        return this.sum;
    }

    public int getCount() {
        return this.count;
    }

    @Nullable
    public Map<String, String> getTags() {
        return this.tags;
    }

    @Override
    @Nullable
    public Map<String, Object> getUnknown() {
        return this.unknown;
    }

    @Override
    public void setUnknown(@Nullable Map<String, Object> unknown) {
        this.unknown = unknown;
    }

    @Override
    public void serialize(@NotNull ObjectWriter writer, @NotNull ILogger logger) throws IOException {
        writer.beginObject();
        writer.name("min").value(this.min);
        writer.name("max").value(this.max);
        writer.name("sum").value(this.sum);
        writer.name("count").value(this.count);
        if (this.tags != null) {
            writer.name("tags");
            writer.value(logger, this.tags);
        }
        writer.endObject();
    }

    public static final class JsonKeys {
        public static final String TAGS = "tags";
        public static final String MIN = "min";
        public static final String MAX = "max";
        public static final String COUNT = "count";
        public static final String SUM = "sum";
    }

    public static final class Deserializer
    implements JsonDeserializer<MetricSummary> {
        @Override
        @NotNull
        public MetricSummary deserialize(@NotNull JsonObjectReader reader, @NotNull ILogger logger) throws Exception {
            @NotNull MetricSummary summary = new MetricSummary();
            ConcurrentHashMap<String, Object> unknown = null;
            reader.beginObject();
            block14: while (reader.peek() == JsonToken.NAME) {
                String nextName;
                switch (nextName = reader.nextName()) {
                    case "tags": {
                        summary.tags = CollectionUtils.newConcurrentHashMap((Map)reader.nextObjectOrNull());
                        continue block14;
                    }
                    case "min": {
                        summary.setMin(reader.nextDouble());
                        continue block14;
                    }
                    case "max": {
                        summary.setMax(reader.nextDouble());
                        continue block14;
                    }
                    case "sum": {
                        summary.setSum(reader.nextDouble());
                        continue block14;
                    }
                    case "count": {
                        summary.setCount(reader.nextInt());
                        continue block14;
                    }
                }
                if (unknown == null) {
                    unknown = new ConcurrentHashMap<String, Object>();
                }
                reader.nextUnknown(logger, unknown, nextName);
            }
            summary.setUnknown(unknown);
            reader.endObject();
            return summary;
        }
    }
}

