/*
 * Decompiled with CFR 0.152.
 */
package org.merlyn.core.audio;

import java.nio.ByteOrder;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.merlyn.core.audio.AudioEncoding;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0014\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\tH\u00c6\u0003J\u000b\u0010\u001d\u001a\u0004\u0018\u00010\u000bH\u00c6\u0003JG\u0010\u001e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000bH\u00c6\u0001J\u0013\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\"\u001a\u00020\u0003H\u00d6\u0001J\t\u0010#\u001a\u00020\u000bH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006$"}, d2={"Lorg/merlyn/core/audio/AudioFormat;", "", "sampleRate", "", "bitDepth", "channels", "encoding", "Lorg/merlyn/core/audio/AudioEncoding;", "byteOrder", "Ljava/nio/ByteOrder;", "languageTag", "", "<init>", "(IIILorg/merlyn/core/audio/AudioEncoding;Ljava/nio/ByteOrder;Ljava/lang/String;)V", "getSampleRate", "()I", "getBitDepth", "getChannels", "getEncoding", "()Lorg/merlyn/core/audio/AudioEncoding;", "getByteOrder", "()Ljava/nio/ByteOrder;", "getLanguageTag", "()Ljava/lang/String;", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "hashCode", "toString", "sdkCore"})
public final class AudioFormat {
    private final int sampleRate;
    private final int bitDepth;
    private final int channels;
    @NotNull
    private final AudioEncoding encoding;
    @NotNull
    private final ByteOrder byteOrder;
    @Nullable
    private final String languageTag;

    public AudioFormat(int sampleRate, int bitDepth, int channels, @NotNull AudioEncoding encoding, @NotNull ByteOrder byteOrder, @Nullable String languageTag) {
        Intrinsics.checkNotNullParameter((Object)((Object)encoding), (String)"encoding");
        Intrinsics.checkNotNullParameter((Object)byteOrder, (String)"byteOrder");
        this.sampleRate = sampleRate;
        this.bitDepth = bitDepth;
        this.channels = channels;
        this.encoding = encoding;
        this.byteOrder = byteOrder;
        this.languageTag = languageTag;
    }

    public final int getSampleRate() {
        return this.sampleRate;
    }

    public final int getBitDepth() {
        return this.bitDepth;
    }

    public final int getChannels() {
        return this.channels;
    }

    @NotNull
    public final AudioEncoding getEncoding() {
        return this.encoding;
    }

    @NotNull
    public final ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    @Nullable
    public final String getLanguageTag() {
        return this.languageTag;
    }

    public final int component1() {
        return this.sampleRate;
    }

    public final int component2() {
        return this.bitDepth;
    }

    public final int component3() {
        return this.channels;
    }

    @NotNull
    public final AudioEncoding component4() {
        return this.encoding;
    }

    @NotNull
    public final ByteOrder component5() {
        return this.byteOrder;
    }

    @Nullable
    public final String component6() {
        return this.languageTag;
    }

    @NotNull
    public final AudioFormat copy(int sampleRate, int bitDepth, int channels, @NotNull AudioEncoding encoding, @NotNull ByteOrder byteOrder, @Nullable String languageTag) {
        Intrinsics.checkNotNullParameter((Object)((Object)encoding), (String)"encoding");
        Intrinsics.checkNotNullParameter((Object)byteOrder, (String)"byteOrder");
        return new AudioFormat(sampleRate, bitDepth, channels, encoding, byteOrder, languageTag);
    }

    public static /* synthetic */ AudioFormat copy$default(AudioFormat audioFormat, int n, int n2, int n3, AudioEncoding audioEncoding, ByteOrder byteOrder, String string, int n4, Object object) {
        if ((n4 & 1) != 0) {
            n = audioFormat.sampleRate;
        }
        if ((n4 & 2) != 0) {
            n2 = audioFormat.bitDepth;
        }
        if ((n4 & 4) != 0) {
            n3 = audioFormat.channels;
        }
        if ((n4 & 8) != 0) {
            audioEncoding = audioFormat.encoding;
        }
        if ((n4 & 0x10) != 0) {
            byteOrder = audioFormat.byteOrder;
        }
        if ((n4 & 0x20) != 0) {
            string = audioFormat.languageTag;
        }
        return audioFormat.copy(n, n2, n3, audioEncoding, byteOrder, string);
    }

    @NotNull
    public String toString() {
        return "AudioFormat(sampleRate=" + this.sampleRate + ", bitDepth=" + this.bitDepth + ", channels=" + this.channels + ", encoding=" + this.encoding + ", byteOrder=" + this.byteOrder + ", languageTag=" + this.languageTag + ")";
    }

    public int hashCode() {
        int result = Integer.hashCode(this.sampleRate);
        result = result * 31 + Integer.hashCode(this.bitDepth);
        result = result * 31 + Integer.hashCode(this.channels);
        result = result * 31 + this.encoding.hashCode();
        result = result * 31 + this.byteOrder.hashCode();
        result = result * 31 + (this.languageTag == null ? 0 : this.languageTag.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AudioFormat)) {
            return false;
        }
        AudioFormat audioFormat = (AudioFormat)other;
        if (this.sampleRate != audioFormat.sampleRate) {
            return false;
        }
        if (this.bitDepth != audioFormat.bitDepth) {
            return false;
        }
        if (this.channels != audioFormat.channels) {
            return false;
        }
        if (this.encoding != audioFormat.encoding) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.byteOrder, (Object)audioFormat.byteOrder)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.languageTag, (Object)audioFormat.languageTag);
    }
}

