/*
 * Decompiled with CFR 0.152.
 */
package org.merlyn.core.audio;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.TimeMark;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.merlyn.core.audio.AudioFormat;
import org.merlyn.core.audio.SpeechSessionInfo;
import org.merlyn.core.audio.SpeechSessionSegment;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0080\b\u0018\u00002\u00020\u00012\u00020\u0002B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0096\u0002J\b\u0010\u0012\u001a\u00020\u0006H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\t\u0010\u0015\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0002H\u00c2\u0003J'\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u0002H\u00c6\u0001R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0007\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\t\u0010\u0019\u001a\u00020\u001aX\u0096\u0005R\t\u0010\u001b\u001a\u00020\u001cX\u0096\u0005R\t\u0010\u001d\u001a\u00020\u0006X\u0096\u0005R\t\u0010\u001e\u001a\u00020\u0014X\u0096\u0005\u00a8\u0006\u001f"}, d2={"Lorg/merlyn/core/audio/FrameSegment;", "Lorg/merlyn/core/audio/SpeechSessionSegment;", "Lorg/merlyn/core/audio/SpeechSessionInfo;", "frame", "", "index", "", "session", "<init>", "([BILorg/merlyn/core/audio/SpeechSessionInfo;)V", "getFrame", "()[B", "getIndex", "()I", "equals", "", "other", "", "hashCode", "toString", "", "component1", "component2", "component3", "copy", "audioFormat", "Lorg/merlyn/core/audio/AudioFormat;", "createTime", "Lkotlin/time/TimeMark;", "ordinal", "requestId", "sdkCore"})
public final class FrameSegment
implements SpeechSessionSegment,
SpeechSessionInfo {
    @NotNull
    private final byte[] frame;
    private final int index;
    @NotNull
    private final SpeechSessionInfo session;

    public FrameSegment(@NotNull byte[] frame, int index, @NotNull SpeechSessionInfo session) {
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.frame = frame;
        this.index = index;
        this.session = session;
    }

    @NotNull
    public final byte[] getFrame() {
        return this.frame;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public int getOrdinal() {
        return this.session.getOrdinal();
    }

    @Override
    @NotNull
    public AudioFormat getAudioFormat() {
        return this.session.getAudioFormat();
    }

    @Override
    @NotNull
    public TimeMark getCreateTime() {
        return this.session.getCreateTime();
    }

    @Override
    @NotNull
    public String getRequestId() {
        return this.session.getRequestId();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type org.merlyn.core.audio.FrameSegment");
        FrameSegment cfr_ignored_0 = (FrameSegment)other;
        if (!Arrays.equals(this.frame, ((FrameSegment)other).frame)) {
            return false;
        }
        if (this.getIndex() != ((FrameSegment)other).getIndex()) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.session, (Object)((FrameSegment)other).session);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.frame);
        result = 31 * result + this.getIndex();
        result = 31 * result + this.session.hashCode();
        return result;
    }

    @NotNull
    public String toString() {
        return "FrameSegment(frame size=" + this.frame.length + ", index=" + this.getIndex() + ", session=" + this.session + ")";
    }

    @NotNull
    public final byte[] component1() {
        return this.frame;
    }

    public final int component2() {
        return this.index;
    }

    private final SpeechSessionInfo component3() {
        return this.session;
    }

    @NotNull
    public final FrameSegment copy(@NotNull byte[] frame, int index, @NotNull SpeechSessionInfo session) {
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        return new FrameSegment(frame, index, session);
    }

    public static /* synthetic */ FrameSegment copy$default(FrameSegment frameSegment, byte[] byArray, int n, SpeechSessionInfo speechSessionInfo, int n2, Object object) {
        if ((n2 & 1) != 0) {
            byArray = frameSegment.frame;
        }
        if ((n2 & 2) != 0) {
            n = frameSegment.index;
        }
        if ((n2 & 4) != 0) {
            speechSessionInfo = frameSegment.session;
        }
        return frameSegment.copy(byArray, n, speechSessionInfo);
    }
}

