/*
 * Decompiled with CFR 0.152.
 */
package org.merlyn.core.cloudclient;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlow;
import okhttp3.WebSocket;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.merlyn.core.cloudclient.CloseReason;
import org.merlyn.core.cloudclient.WebSocketSession;
import org.slf4j.Logger;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0016\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0006H\u0096@\u00a2\u0006\u0002\u0010\u001dJ\u000e\u0010\u001e\u001a\u00020\tH\u0096@\u00a2\u0006\u0002\u0010\u001fJ\b\u0010 \u001a\u00020\u001bH\u0016J\t\u0010!\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\u000f\u0010#\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u00c6\u0003J\t\u0010$\u001a\u00020\u000bH\u00c6\u0003J=\u0010%\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\b\b\u0002\u0010\n\u001a\u00020\u000bH\u00c6\u0001J\u0013\u0010&\u001a\u00020'2\b\u0010(\u001a\u0004\u0018\u00010)H\u00d6\u0003J\t\u0010*\u001a\u00020+H\u00d6\u0001J\t\u0010,\u001a\u00020\u0006H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00060\u0017X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006-"}, d2={"Lorg/merlyn/core/cloudclient/OkhttpWebSocketSession;", "Lorg/merlyn/core/cloudclient/WebSocketSession;", "webSocket", "Lokhttp3/WebSocket;", "incomingToProcess", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "", "closeReasonRef", "Lkotlinx/coroutines/CompletableDeferred;", "Lorg/merlyn/core/cloudclient/CloseReason;", "log", "Lorg/slf4j/Logger;", "<init>", "(Lokhttp3/WebSocket;Lkotlinx/coroutines/flow/MutableSharedFlow;Lkotlinx/coroutines/CompletableDeferred;Lorg/slf4j/Logger;)V", "getWebSocket", "()Lokhttp3/WebSocket;", "getIncomingToProcess", "()Lkotlinx/coroutines/flow/MutableSharedFlow;", "getCloseReasonRef", "()Lkotlinx/coroutines/CompletableDeferred;", "getLog", "()Lorg/slf4j/Logger;", "incoming", "Lkotlinx/coroutines/flow/SharedFlow;", "getIncoming", "()Lkotlinx/coroutines/flow/SharedFlow;", "send", "", "content", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "awaitClose", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "close", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "hashCode", "", "toString", "sdkCore"})
@SourceDebugExtension(value={"SMAP\nOkhttpWebSocketSession.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OkhttpWebSocketSession.kt\norg/merlyn/core/cloudclient/OkhttpWebSocketSession\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,32:1\n1#2:33\n*E\n"})
public final class OkhttpWebSocketSession
implements WebSocketSession {
    @NotNull
    private final WebSocket webSocket;
    @NotNull
    private final MutableSharedFlow<String> incomingToProcess;
    @NotNull
    private final CompletableDeferred<CloseReason> closeReasonRef;
    @NotNull
    private final Logger log;
    @NotNull
    private final SharedFlow<String> incoming;

    public OkhttpWebSocketSession(@NotNull WebSocket webSocket2, @NotNull MutableSharedFlow<String> incomingToProcess, @NotNull CompletableDeferred<CloseReason> closeReasonRef, @NotNull Logger log2) {
        Intrinsics.checkNotNullParameter((Object)webSocket2, (String)"webSocket");
        Intrinsics.checkNotNullParameter(incomingToProcess, (String)"incomingToProcess");
        Intrinsics.checkNotNullParameter(closeReasonRef, (String)"closeReasonRef");
        Intrinsics.checkNotNullParameter((Object)log2, (String)"log");
        this.webSocket = webSocket2;
        this.incomingToProcess = incomingToProcess;
        this.closeReasonRef = closeReasonRef;
        this.log = log2;
        this.incoming = FlowKt.asSharedFlow(this.incomingToProcess);
    }

    @NotNull
    public final WebSocket getWebSocket() {
        return this.webSocket;
    }

    @NotNull
    public final MutableSharedFlow<String> getIncomingToProcess() {
        return this.incomingToProcess;
    }

    @NotNull
    public final CompletableDeferred<CloseReason> getCloseReasonRef() {
        return this.closeReasonRef;
    }

    @NotNull
    public final Logger getLog() {
        return this.log;
    }

    @Override
    @NotNull
    public SharedFlow<String> getIncoming() {
        return this.incoming;
    }

    @Override
    @Nullable
    public Object send(@NotNull String content, @NotNull Continuation<? super Unit> $completion) {
        if (!this.webSocket.send(content)) {
            boolean bl = false;
            String string = "Failed to send: " + content;
            throw new IllegalStateException(string.toString());
        }
        this.log.debug("Sent message: " + content);
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object awaitClose(@NotNull Continuation<? super CloseReason> $completion) {
        return this.closeReasonRef.await($completion);
    }

    @Override
    public void close() {
        this.webSocket.close(1000, "Normal close");
        this.log.debug("Session closed");
    }

    @NotNull
    public final WebSocket component1() {
        return this.webSocket;
    }

    @NotNull
    public final MutableSharedFlow<String> component2() {
        return this.incomingToProcess;
    }

    @NotNull
    public final CompletableDeferred<CloseReason> component3() {
        return this.closeReasonRef;
    }

    @NotNull
    public final Logger component4() {
        return this.log;
    }

    @NotNull
    public final OkhttpWebSocketSession copy(@NotNull WebSocket webSocket2, @NotNull MutableSharedFlow<String> incomingToProcess, @NotNull CompletableDeferred<CloseReason> closeReasonRef, @NotNull Logger log2) {
        Intrinsics.checkNotNullParameter((Object)webSocket2, (String)"webSocket");
        Intrinsics.checkNotNullParameter(incomingToProcess, (String)"incomingToProcess");
        Intrinsics.checkNotNullParameter(closeReasonRef, (String)"closeReasonRef");
        Intrinsics.checkNotNullParameter((Object)log2, (String)"log");
        return new OkhttpWebSocketSession(webSocket2, incomingToProcess, closeReasonRef, log2);
    }

    public static /* synthetic */ OkhttpWebSocketSession copy$default(OkhttpWebSocketSession okhttpWebSocketSession, WebSocket webSocket2, MutableSharedFlow mutableSharedFlow, CompletableDeferred completableDeferred, Logger logger, int n, Object object) {
        if ((n & 1) != 0) {
            webSocket2 = okhttpWebSocketSession.webSocket;
        }
        if ((n & 2) != 0) {
            mutableSharedFlow = okhttpWebSocketSession.incomingToProcess;
        }
        if ((n & 4) != 0) {
            completableDeferred = okhttpWebSocketSession.closeReasonRef;
        }
        if ((n & 8) != 0) {
            logger = okhttpWebSocketSession.log;
        }
        return okhttpWebSocketSession.copy(webSocket2, mutableSharedFlow, completableDeferred, logger);
    }

    @NotNull
    public String toString() {
        return "OkhttpWebSocketSession(webSocket=" + this.webSocket + ", incomingToProcess=" + this.incomingToProcess + ", closeReasonRef=" + this.closeReasonRef + ", log=" + this.log + ")";
    }

    public int hashCode() {
        int result = this.webSocket.hashCode();
        result = result * 31 + this.incomingToProcess.hashCode();
        result = result * 31 + this.closeReasonRef.hashCode();
        result = result * 31 + this.log.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof OkhttpWebSocketSession)) {
            return false;
        }
        OkhttpWebSocketSession okhttpWebSocketSession = (OkhttpWebSocketSession)other;
        if (!Intrinsics.areEqual((Object)this.webSocket, (Object)okhttpWebSocketSession.webSocket)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.incomingToProcess, okhttpWebSocketSession.incomingToProcess)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.closeReasonRef, okhttpWebSocketSession.closeReasonRef)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.log, (Object)okhttpWebSocketSession.log);
    }
}

