/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.usb.linux;

import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.List;
import net.codecrete.usb.UsbDevice;
import net.codecrete.usb.common.ScopeCleanup;
import net.codecrete.usb.common.UsbDeviceRegistry;
import net.codecrete.usb.linux.EPoll;
import net.codecrete.usb.linux.Linux;
import net.codecrete.usb.linux.LinuxUsbDevice;
import net.codecrete.usb.linux.LinuxUsbException;
import net.codecrete.usb.linux.gen.epoll.epoll;
import net.codecrete.usb.linux.gen.epoll.epoll_event;
import net.codecrete.usb.linux.gen.fcntl.fcntl;
import net.codecrete.usb.linux.gen.udev.udev;

public class LinuxUsbDeviceRegistry
extends UsbDeviceRegistry {
    private static final System.Logger LOG = System.getLogger(LinuxUsbDeviceRegistry.class.getName());
    private static final MemorySegment SUBSYSTEM_USB;
    private static final MemorySegment MONITOR_NAME;
    private static final MemorySegment DEVTYPE_USB_DEVICE;
    private static final MemorySegment ATTR_ID_VENDOR;
    private static final MemorySegment ATTR_ID_PRODUCT;
    private static final MemorySegment ATTR_MANUFACTURER;
    private static final MemorySegment ATTR_PRODUCT;
    private static final MemorySegment ATTR_SERIAL;

    /*
     * Unable to fully structure code
     */
    @Override
    protected void monitorDevices() {
        try {
            udevInstance = udev.udev_new();
            if (udevInstance.address() == 0L) {
                LinuxUsbException.throwException("internal error (udev_new)", new Object[0]);
            }
            if ((monitor = udev.udev_monitor_new_from_netlink(udevInstance, LinuxUsbDeviceRegistry.MONITOR_NAME)).address() == 0L) {
                LinuxUsbException.throwException("internal error (udev_monitor_new_from_netlink)", new Object[0]);
            }
            if (udev.udev_monitor_filter_add_match_subsystem_devtype(monitor, LinuxUsbDeviceRegistry.SUBSYSTEM_USB, LinuxUsbDeviceRegistry.DEVTYPE_USB_DEVICE) < 0) {
                LinuxUsbException.throwException("internal error (udev_monitor_filter_add_match_subsystem_devtype)", new Object[0]);
            }
            if (udev.udev_monitor_enable_receiving(monitor) < 0) {
                LinuxUsbException.throwException("internal error (udev_monitor_enable_receiving)", new Object[0]);
            }
            if ((fd = udev.udev_monitor_get_fd(monitor)) < 0) {
                LinuxUsbException.throwException("internal error (udev_monitor_get_fd)", new Object[0]);
            }
            deviceList = this.enumeratePresentDevices(udevInstance);
            this.setInitialDeviceList(deviceList);
        }
        catch (Throwable e) {
            this.enumerationFailed(e);
            return;
        }
        arena = Arena.ofConfined();
        try {
            errorState = Linux.allocateErrorState(arena);
            epfd = EPoll.epoll_create1(fcntl.FD_CLOEXEC(), errorState);
            if (epfd < 0) {
                LinuxUsbException.throwLastError(errorState, "internal error (epoll_create)", new Object[0]);
            }
            EPoll.addFileDescriptor(epfd, epoll.EPOLLIN(), fd);
            event = arena.allocate(epoll_event.$LAYOUT());
            while (true) lbl-1000:
            // 6 sources

            {
                cleanup = new ScopeCleanup();
                try {
                    EPoll.epoll_wait(epfd, event, 1, -1, errorState);
                    udevDevice = udev.udev_monitor_receive_device(monitor);
                    if (udevDevice == null) ** GOTO lbl-1000
                    cleanup.add((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$monitorDevices$0(java.lang.foreign.MemorySegment ), ()V)((MemorySegment)udevDevice));
                    action = LinuxUsbDeviceRegistry.getDeviceAction(udevDevice);
                    if ("add".equals(action)) {
                        this.onDeviceConnected(udevDevice);
                    }
                    if (!"remove".equals(action)) ** GOTO lbl-1000
                    this.onDeviceDisconnected(udevDevice);
                }
                finally {
                    cleanup.close();
                    continue;
                }
                break;
            }
        }
        catch (Throwable var4_6) {
            if (arena != null) {
                try {
                    arena.close();
                }
                catch (Throwable var5_8) {
                    var4_6.addSuppressed(var5_8);
                }
            }
            throw var4_6;
        }
        ** GOTO lbl-1000
    }

    private List<UsbDevice> enumeratePresentDevices(MemorySegment udevInstance) {
        ArrayList<UsbDevice> result = new ArrayList<UsbDevice>();
        try (ScopeCleanup outerCleanup = new ScopeCleanup();){
            MemorySegment enumerate = udev.udev_enumerate_new(udevInstance);
            if (enumerate.address() == 0L) {
                LinuxUsbException.throwException("internal error (udev_enumerate_new)", new Object[0]);
            }
            outerCleanup.add(() -> udev.udev_enumerate_unref(enumerate));
            if (udev.udev_enumerate_add_match_subsystem(enumerate, SUBSYSTEM_USB) < 0) {
                LinuxUsbException.throwException("internal error (udev_enumerate_add_match_subsystem)", new Object[0]);
            }
            if (udev.udev_enumerate_scan_devices(enumerate) < 0) {
                LinuxUsbException.throwException("internal error (udev_enumerate_scan_devices)", new Object[0]);
            }
            MemorySegment entry = udev.udev_enumerate_get_list_entry(enumerate);
            while (entry.address() != 0L) {
                try (ScopeCleanup cleanup = new ScopeCleanup();){
                    MemorySegment dev;
                    MemorySegment path = udev.udev_list_entry_get_name(entry);
                    if (path.address() != 0L && (dev = udev.udev_device_new_from_syspath(udevInstance, path)).address() != 0L) {
                        cleanup.add(() -> udev.udev_device_unref(dev));
                        UsbDevice device = this.getDeviceDetails(dev);
                        if (device != null) {
                            result.add(device);
                        }
                    }
                }
                entry = udev.udev_list_entry_get_next(entry);
            }
        }
        return result;
    }

    private void onDeviceConnected(MemorySegment udevDevice) {
        UsbDevice device = this.getDeviceDetails(udevDevice);
        if (device != null) {
            this.addDevice(device);
        }
    }

    private void onDeviceDisconnected(MemorySegment udevDevice) {
        String devPath = LinuxUsbDeviceRegistry.getDeviceName(udevDevice);
        if (devPath == null) {
            return;
        }
        this.closeAndRemoveDevice(devPath);
    }

    private UsbDevice getDeviceDetails(MemorySegment udevDevice) {
        int vendorId = 0;
        int productId = 0;
        try {
            String idVendor = LinuxUsbDeviceRegistry.getDeviceAttribute(udevDevice, ATTR_ID_VENDOR);
            if (idVendor == null) {
                return null;
            }
            String idProduct = LinuxUsbDeviceRegistry.getDeviceAttribute(udevDevice, ATTR_ID_PRODUCT);
            if (idProduct == null) {
                return null;
            }
            String devPath = LinuxUsbDeviceRegistry.getDeviceName(udevDevice);
            if (devPath == null) {
                return null;
            }
            vendorId = Integer.parseInt(idVendor, 16);
            productId = Integer.parseInt(idProduct, 16);
            LinuxUsbDevice device = new LinuxUsbDevice(devPath, vendorId, productId);
            device.setProductStrings(LinuxUsbDeviceRegistry.getDeviceAttribute(udevDevice, ATTR_MANUFACTURER), LinuxUsbDeviceRegistry.getDeviceAttribute(udevDevice, ATTR_PRODUCT), LinuxUsbDeviceRegistry.getDeviceAttribute(udevDevice, ATTR_SERIAL));
            return device;
        }
        catch (Exception e) {
            LOG.log(System.Logger.Level.INFO, String.format("failed to retrieve information about device 0x%04x/0x%04x - ignoring device", vendorId, productId), (Throwable)e);
            return null;
        }
    }

    private static String getDeviceAttribute(MemorySegment udevDevice, MemorySegment attribute) {
        MemorySegment value = udev.udev_device_get_sysattr_value(udevDevice, attribute);
        if (value.address() == 0L) {
            return null;
        }
        return value.getUtf8String(0L);
    }

    private static String getDeviceName(MemorySegment udevDevice) {
        return udev.udev_device_get_devnode(udevDevice).getUtf8String(0L);
    }

    private static String getDeviceAction(MemorySegment udevDevice) {
        return udev.udev_device_get_action(udevDevice).getUtf8String(0L);
    }

    private static /* synthetic */ void lambda$monitorDevices$0(MemorySegment udevDevice) {
        udev.udev_device_unref(udevDevice);
    }

    static {
        Arena global = Arena.global();
        SUBSYSTEM_USB = global.allocateUtf8String("usb");
        MONITOR_NAME = global.allocateUtf8String("udev");
        DEVTYPE_USB_DEVICE = global.allocateUtf8String("usb_device");
        ATTR_ID_VENDOR = global.allocateUtf8String("idVendor");
        ATTR_ID_PRODUCT = global.allocateUtf8String("idProduct");
        ATTR_MANUFACTURER = global.allocateUtf8String("manufacturer");
        ATTR_PRODUCT = global.allocateUtf8String("product");
        ATTR_SERIAL = global.allocateUtf8String("serial");
    }
}

