/*
 * Decompiled with CFR 0.152.
 */
package org.merlyn.common.crashreporter;

import com.sun.jna.platform.win32.WinNT;
import io.sentry.Attachment;
import io.sentry.Hint;
import io.sentry.IScope;
import io.sentry.Sentry;
import io.sentry.SentryEvent;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.protocol.User;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.merlyn.common.crashreporter.Kernel32;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0003\n\u0002\b\u0005\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 \"2\u00020\u0001:\u0002\"#B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ \u0010\f\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u000bH\u0002J\u0016\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0007J\u000e\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0007J\u000e\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0007J\u000e\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0016J\u0016\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0007J,\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u00072\u0014\b\u0002\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u001cJ\f\u0010\u001d\u001a\u00020\u0005*\u00020\u001eH\u0002J\b\u0010\u001f\u001a\u00020 H\u0002J\f\u0010!\u001a\u00020\u0007*\u00020\u000bH\u0002\u00a8\u0006$"}, d2={"Lorg/merlyn/common/crashreporter/CrashReporter;", "", "<init>", "()V", "initialize", "", "appVersion", "", "environment", "region", "Lkotlin/Function0;", "Lorg/merlyn/common/crashreporter/CrashReporter$Region;", "initializeSentry", "addProperty", "key", "value", "leaveBreadcrumb", "message", "updateUserInfo", "deviceId", "captureException", "throwable", "", "captureExceptionWithLogs", "logFilenamePath", "captureFatalWithThreadDump", "dump", "tags", "", "setFingerprints", "Lio/sentry/SentryOptions;", "shouldEnableSentry", "", "toDSN", "Companion", "Region", "common"})
@SourceDebugExtension(value={"SMAP\nCrashReporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CrashReporter.kt\norg/merlyn/common/crashreporter/CrashReporter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,131:1\n1#2:132\n1863#3,2:133\n*S KotlinDebug\n*F\n+ 1 CrashReporter.kt\norg/merlyn/common/crashreporter/CrashReporter\n*L\n84#1:133,2\n*E\n"})
public final class CrashReporter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String SENTRY_US_DSN = "https://322a06da1ece0d9f809967b0707308f8@o4506659487219712.ingest.sentry.io/4506659970023429";
    @NotNull
    private static final String SENTRY_EU_DSN = "https://0f3d5919f5c9343873cf164d43151554@o4507589872254976.ingest.de.sentry.io/4507610533462096";
    @NotNull
    private static final String TAG_OS = "OS";
    @NotNull
    private static final String TAG_OS_VERSION = "OS version";
    @NotNull
    private static final String TAG_OS_VERSION_BUILD = "OS build";
    @Nullable
    private static CrashReporter instance;

    public final void initialize(@NotNull String appVersion, @NotNull String environment, @NotNull Function0<? extends Region> region) {
        Intrinsics.checkNotNullParameter((Object)appVersion, (String)"appVersion");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter(region, (String)"region");
        if (this.shouldEnableSentry()) {
            this.initializeSentry(environment, appVersion, (Region)((Object)region.invoke()));
        }
    }

    private final void initializeSentry(String environment, String appVersion, Region region) {
        Sentry.init(arg_0 -> CrashReporter.initializeSentry$lambda$1(this, region, appVersion, environment, arg_0));
    }

    public final void addProperty(@NotNull String key, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Sentry.configureScope(arg_0 -> CrashReporter.addProperty$lambda$2(key, value, arg_0));
    }

    public final void leaveBreadcrumb(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Sentry.addBreadcrumb((String)message);
    }

    public final void updateUserInfo(@NotNull String deviceId) {
        User user;
        Intrinsics.checkNotNullParameter((Object)deviceId, (String)"deviceId");
        User $this$updateUserInfo_u24lambda_u243 = user = new User();
        boolean bl = false;
        $this$updateUserInfo_u24lambda_u243.setId(deviceId);
        Sentry.setUser((User)user);
    }

    public final void captureException(@NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        Sentry.captureException((Throwable)throwable);
    }

    public final void captureExceptionWithLogs(@NotNull Throwable throwable, @NotNull String logFilenamePath) {
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        Intrinsics.checkNotNullParameter((Object)logFilenamePath, (String)"logFilenamePath");
        Attachment attachment = new Attachment(logFilenamePath);
        Sentry.captureException((Throwable)throwable, (Hint)Hint.withAttachment((Attachment)attachment));
    }

    public final void captureFatalWithThreadDump(@NotNull String message, @NotNull String dump, @NotNull Map<String, String> tags) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)dump, (String)"dump");
        Intrinsics.checkNotNullParameter(tags, (String)"tags");
        Sentry.captureMessage((String)message, (SentryLevel)SentryLevel.FATAL, arg_0 -> CrashReporter.captureFatalWithThreadDump$lambda$5(dump, tags, arg_0));
    }

    public static /* synthetic */ void captureFatalWithThreadDump$default(CrashReporter crashReporter, String string, String string2, Map map, int n, Object object) {
        if ((n & 4) != 0) {
            map = MapsKt.emptyMap();
        }
        crashReporter.captureFatalWithThreadDump(string, string2, map);
    }

    private final void setFingerprints(SentryOptions $this$setFingerprints) {
        $this$setFingerprints.setBeforeSend(CrashReporter::setFingerprints$lambda$6);
    }

    private final boolean shouldEnableSentry() {
        return !Boolean.parseBoolean(System.getenv("merlyn_localMode"));
    }

    private final String toDSN(Region $this$toDSN) {
        return switch (WhenMappings.$EnumSwitchMapping$0[$this$toDSN.ordinal()]) {
            case 1 -> SENTRY_US_DSN;
            case 2 -> SENTRY_EU_DSN;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private static final void initializeSentry$lambda$1(CrashReporter this$0, Region $region, String $appVersion, String $environment, SentryOptions options) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        options.setDsn(this$0.toDSN($region));
        options.setTracesSampleRate(Double.valueOf(1.0));
        options.setRelease($appVersion);
        options.setEnvironment($environment);
        options.setTag(TAG_OS, System.getProperty("os.name"));
        options.setTag(TAG_OS_VERSION, System.getProperty("os.version"));
        String string = System.getProperty("os.name");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
        if (StringsKt.startsWith((String)string, (String)"win", (boolean)true)) {
            CrashReporter crashReporter = this$0;
            try {
                boolean res;
                CrashReporter $this$initializeSentry_u24lambda_u241_u24lambda_u240 = crashReporter;
                boolean bl = false;
                WinNT.OSVERSIONINFOEX versionInfoEx = new WinNT.OSVERSIONINFOEX();
                Kernel32 kernel32 = Kernel32.Companion.getINSTANCE();
                boolean bl2 = res = kernel32 != null ? kernel32.GetVersionEx(versionInfoEx) : false;
                if (res) {
                    options.setTag(TAG_OS_VERSION_BUILD, versionInfoEx.dwBuildNumber.toString());
                }
                Object object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable throwable) {
                Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
        }
        this$0.setFingerprints(options);
    }

    private static final void addProperty$lambda$2(String $key, String $value, IScope scope) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        scope.setTag($key, $value);
    }

    private static final void captureFatalWithThreadDump$lambda$5(String $dump, Map $tags, IScope it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = $dump;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        it.addAttachment(Attachment.fromThreadDump((byte[])byArray));
        Iterable $this$forEach$iv = $tags.entrySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry entry = (Map.Entry)element$iv;
            boolean bl = false;
            it.setTag((String)entry.getKey(), (String)entry.getValue());
        }
    }

    private static final SentryEvent setFingerprints$lambda$6(SentryEvent event, Hint hint) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)hint, (String)"<unused var>");
        return event;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\f\u001a\u00020\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/merlyn/common/crashreporter/CrashReporter$Companion;", "", "<init>", "()V", "SENTRY_US_DSN", "", "SENTRY_EU_DSN", "TAG_OS", "TAG_OS_VERSION", "TAG_OS_VERSION_BUILD", "instance", "Lorg/merlyn/common/crashreporter/CrashReporter;", "getInstance", "common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CrashReporter getInstance() {
            if (instance == null) {
                instance = new CrashReporter();
            }
            CrashReporter crashReporter = instance;
            Intrinsics.checkNotNull((Object)crashReporter);
            return crashReporter;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/merlyn/common/crashreporter/CrashReporter$Region;", "", "<init>", "(Ljava/lang/String;I)V", "US", "EU", "common"})
    public static final class Region
    extends Enum<Region> {
        public static final /* enum */ Region US = new Region();
        public static final /* enum */ Region EU = new Region();
        private static final /* synthetic */ Region[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Region[] values() {
            return (Region[])$VALUES.clone();
        }

        public static Region valueOf(String value) {
            return Enum.valueOf(Region.class, value);
        }

        @NotNull
        public static EnumEntries<Region> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = regionArray = new Region[]{Region.US, Region.EU};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Region.values().length];
            try {
                nArray[Region.US.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Region.EU.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

