/*
 * Decompiled with CFR 0.152.
 */
package org.merlyn.desktopapp.checker.providers;

import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.merlyn.core.spacecontextservice.model.LocalizationContext;
import org.merlyn.desktopapp.config.StageConfig;
import org.merlyn.desktopapp.service.localization.LocalizationService;
import org.merlyn.desktopapp.storage.DeviceDataDao;
import org.merlyn.diagnostics.CheckerKt;
import org.merlyn.diagnostics.checkers.SystemData;
import org.merlyn.diagnostics.checkers.SystemProvider;
import org.merlyn.sharedui.regionselection.Region;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\n\u001a\u00020\u000bH\u0096@\u00a2\u0006\u0002\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/merlyn/desktopapp/checker/providers/OriginSystemProvider;", "Lorg/merlyn/diagnostics/checkers/SystemProvider;", "stageConfig", "Lorg/merlyn/desktopapp/config/StageConfig;", "localizationService", "Lorg/merlyn/desktopapp/service/localization/LocalizationService;", "deviceDataDao", "Lorg/merlyn/desktopapp/storage/DeviceDataDao;", "<init>", "(Lorg/merlyn/desktopapp/config/StageConfig;Lorg/merlyn/desktopapp/service/localization/LocalizationService;Lorg/merlyn/desktopapp/storage/DeviceDataDao;)V", "provide", "Lorg/merlyn/diagnostics/checkers/SystemData;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "app"})
public final class OriginSystemProvider
implements SystemProvider {
    @NotNull
    private final StageConfig stageConfig;
    @NotNull
    private final LocalizationService localizationService;
    @NotNull
    private final DeviceDataDao deviceDataDao;

    public OriginSystemProvider(@NotNull StageConfig stageConfig, @NotNull LocalizationService localizationService, @NotNull DeviceDataDao deviceDataDao) {
        Intrinsics.checkNotNullParameter((Object)stageConfig, (String)"stageConfig");
        Intrinsics.checkNotNullParameter((Object)localizationService, (String)"localizationService");
        Intrinsics.checkNotNullParameter((Object)deviceDataDao, (String)"deviceDataDao");
        this.stageConfig = stageConfig;
        this.localizationService = localizationService;
        this.deviceDataDao = deviceDataDao;
    }

    @Nullable
    public Object provide(@NotNull Continuation<? super SystemData> $completion) {
        Region region = this.localizationService.getRegion();
        return new SystemData(this.stageConfig.getApplicationConfig().getAppEnv().name(), this.stageConfig.getApplicationConfig().getAppVersion(), this.deviceDataDao.get().getDeviceId(), CheckerKt.dashesIfNoValue((String)(region != null ? region.name() : null)), ((LocalizationContext)this.localizationService.getLocalizationContextFlow().getValue()).getLocale());
    }
}

