/*
 * Decompiled with CFR 0.152.
 */
package org.merlyn.desktopapp.coresdk.rcu.impl;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlin.time.TimeSource;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.merlyn.agent.KeyEventAction;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0010\u001a\u00020\nR\u0010\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/merlyn/desktopapp/coresdk/rcu/impl/LongPressService;", "", "longPressDetectionThreshold", "Lkotlin/time/Duration;", "<init>", "(JLkotlin/jvm/internal/DefaultConstructorMarker;)V", "J", "keyPressTimestamp", "Lkotlin/time/TimeSource$Monotonic$ValueTimeMark;", "longPressDetectedWaitingForButtonRelease", "", "logger", "Lmu/KLogger;", "shouldProcessLongPress", "keyAction", "Lorg/merlyn/agent/KeyEventAction;", "shouldIgnoreButtonRelease", "app"})
public final class LongPressService {
    private final long longPressDetectionThreshold;
    @Nullable
    private TimeSource.Monotonic.ValueTimeMark keyPressTimestamp;
    private boolean longPressDetectedWaitingForButtonRelease;
    @NotNull
    private final KLogger logger;

    private LongPressService(long longPressDetectionThreshold) {
        this.longPressDetectionThreshold = longPressDetectionThreshold;
        this.logger = KotlinLogging.INSTANCE.logger(LongPressService::logger$lambda$0);
    }

    public /* synthetic */ LongPressService(long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            l = DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.SECONDS);
        }
        this(l, null);
    }

    public final boolean shouldProcessLongPress(@NotNull KeyEventAction keyAction) {
        Intrinsics.checkNotNullParameter((Object)((Object)keyAction), (String)"keyAction");
        return switch (WhenMappings.$EnumSwitchMapping$0[keyAction.ordinal()]) {
            case 1 -> {
                boolean shouldProcessLongPress;
                boolean v1;
                if (this.keyPressTimestamp == null) {
                    this.keyPressTimestamp = TimeSource.Monotonic.ValueTimeMark.box-impl((long)TimeSource.Monotonic.INSTANCE.markNow-z9LOYto());
                }
                TimeSource.Monotonic.ValueTimeMark v0 = this.keyPressTimestamp;
                Intrinsics.checkNotNull((Object)v0);
                long duration = TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)v0.unbox-impl());
                if (this.longPressDetectedWaitingForButtonRelease) {
                    v1 = false;
                } else {
                    boolean shouldProcess;
                    boolean v2 = shouldProcess = Duration.compareTo-LRDsOJo((long)duration, (long)this.longPressDetectionThreshold) >= 0;
                    if (shouldProcess) {
                        this.longPressDetectedWaitingForButtonRelease = true;
                    }
                    v1 = shouldProcess;
                }
                yield shouldProcessLongPress = v1;
            }
            case 2 -> {
                this.keyPressTimestamp = null;
                yield false;
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public final boolean shouldIgnoreButtonRelease() {
        boolean shouldIgnoreButtonRelease = this.longPressDetectedWaitingForButtonRelease;
        this.logger.info(() -> LongPressService.shouldIgnoreButtonRelease$lambda$1(shouldIgnoreButtonRelease));
        this.longPressDetectedWaitingForButtonRelease = false;
        return shouldIgnoreButtonRelease;
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Object shouldIgnoreButtonRelease$lambda$1(boolean $shouldIgnoreButtonRelease) {
        return "Resetting long press detection. Ignoring button release: " + $shouldIgnoreButtonRelease;
    }

    public /* synthetic */ LongPressService(long longPressDetectionThreshold, DefaultConstructorMarker $constructor_marker) {
        this(longPressDetectionThreshold);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[KeyEventAction.values().length];
            try {
                nArray[KeyEventAction.Down.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KeyEventAction.Up.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

