/*
 * Decompiled with CFR 0.152.
 */
package org.merlyn.desktopapp.http;

import java.time.Instant;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.merlyn.desktopapp.config.StageConfig;
import org.merlyn.desktopapp.http.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AnonymousCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.cognitoidentity.CognitoIdentityClient;
import software.amazon.awssdk.services.cognitoidentity.CognitoIdentityClientBuilder;
import software.amazon.awssdk.services.cognitoidentity.model.GetCredentialsForIdentityRequest;
import software.amazon.awssdk.services.cognitoidentity.model.GetCredentialsForIdentityResponse;
import software.amazon.awssdk.services.cognitoidentity.model.GetIdRequest;
import software.amazon.awssdk.services.cognitoidentity.model.GetIdResponse;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0012\u001a\u00020\u000fJ:\u0010\u000e\u001a\u00020\u000f2\u0017\u0010\u0013\u001a\u0013\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u0014\u00a2\u0006\u0002\b\u00172\u0017\u0010\u0018\u001a\u0013\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00160\u0014\u00a2\u0006\u0002\b\u0017H\u0002J\b\u0010\u001a\u001a\u00020\rH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0018\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/merlyn/desktopapp/http/CognitoHelper;", "", "config", "Lorg/merlyn/desktopapp/config/StageConfig;", "<init>", "(Lorg/merlyn/desktopapp/config/StageConfig;)V", "getConfig", "()Lorg/merlyn/desktopapp/config/StageConfig;", "region", "Lsoftware/amazon/awssdk/regions/Region;", "kotlin.jvm.PlatformType", "Lsoftware/amazon/awssdk/regions/Region;", "cognitoIdentityClient", "Lsoftware/amazon/awssdk/services/cognitoidentity/CognitoIdentityClient;", "getSTSCredentials", "Lorg/merlyn/desktopapp/http/AwsCredentials;", "idToken", "", "getSTSCredentialsNotLoggedAccess", "idRequestSpecific", "Lkotlin/Function1;", "Lsoftware/amazon/awssdk/services/cognitoidentity/model/GetIdRequest$Builder;", "", "Lkotlin/ExtensionFunctionType;", "credentialRequestSpecific", "Lsoftware/amazon/awssdk/services/cognitoidentity/model/GetCredentialsForIdentityRequest$Builder;", "createCognitoClient", "Companion", "app"})
public final class CognitoHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final StageConfig config;
    private final Region region;
    @Nullable
    private CognitoIdentityClient cognitoIdentityClient;
    @NotNull
    public static final String AWS_ROOT_URL = "amazonaws.com";

    public CognitoHelper(@NotNull StageConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.config = config;
        this.region = Region.of((String)this.config.getEnvironmentConfig().getRegion());
    }

    @NotNull
    public final StageConfig getConfig() {
        return this.config;
    }

    @NotNull
    public final AwsCredentials getSTSCredentials(@NotNull String idToken) {
        Intrinsics.checkNotNullParameter((Object)idToken, (String)"idToken");
        Map logins = MapsKt.mapOf((Pair)TuplesKt.to((Object)("cognito-idp." + this.region + ".amazonaws.com/" + this.config.getEnvironmentConfig().getAuthUserPoolId()), (Object)idToken));
        return this.getSTSCredentials((Function1<? super GetIdRequest.Builder, Unit>)((Function1)arg_0 -> CognitoHelper.getSTSCredentials$lambda$0(logins, arg_0)), (Function1<? super GetCredentialsForIdentityRequest.Builder, Unit>)((Function1)arg_0 -> CognitoHelper.getSTSCredentials$lambda$1(logins, arg_0)));
    }

    @NotNull
    public final AwsCredentials getSTSCredentialsNotLoggedAccess() {
        return this.getSTSCredentials((Function1<? super GetIdRequest.Builder, Unit>)((Function1)CognitoHelper::getSTSCredentialsNotLoggedAccess$lambda$2), (Function1<? super GetCredentialsForIdentityRequest.Builder, Unit>)((Function1)CognitoHelper::getSTSCredentialsNotLoggedAccess$lambda$3));
    }

    private final AwsCredentials getSTSCredentials(Function1<? super GetIdRequest.Builder, Unit> idRequestSpecific, Function1<? super GetCredentialsForIdentityRequest.Builder, Unit> credentialRequestSpecific) {
        GetIdRequest.Builder getIdRequestBuilder = GetIdRequest.builder().identityPoolId(this.config.getEnvironmentConfig().getCredentialsIdentityPoolId());
        Intrinsics.checkNotNull((Object)getIdRequestBuilder);
        idRequestSpecific.invoke((Object)getIdRequestBuilder);
        CognitoIdentityClient cognitoIdentityClient = this.cognitoIdentityClient;
        if (cognitoIdentityClient == null) {
            cognitoIdentityClient = this.createCognitoClient();
        }
        CognitoIdentityClient cognitoClient = cognitoIdentityClient;
        GetIdResponse idResponse = cognitoClient.getId((GetIdRequest)getIdRequestBuilder.build());
        GetCredentialsForIdentityRequest.Builder getCredentialsForIdentityRequestBuilder = GetCredentialsForIdentityRequest.builder().identityId(idResponse.identityId());
        Intrinsics.checkNotNull((Object)getCredentialsForIdentityRequestBuilder);
        credentialRequestSpecific.invoke((Object)getCredentialsForIdentityRequestBuilder);
        GetCredentialsForIdentityResponse credentialsResponse = cognitoClient.getCredentialsForIdentity((GetCredentialsForIdentityRequest)getCredentialsForIdentityRequestBuilder.build());
        String string = credentialsResponse.credentials().accessKeyId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"accessKeyId(...)");
        String string2 = credentialsResponse.credentials().secretKey();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"secretKey(...)");
        String string3 = credentialsResponse.credentials().sessionToken();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"sessionToken(...)");
        Instant instant = credentialsResponse.credentials().expiration();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"expiration(...)");
        return new AwsCredentials(string, string2, string3, instant);
    }

    private final CognitoIdentityClient createCognitoClient() {
        CognitoIdentityClient client;
        this.cognitoIdentityClient = client = (CognitoIdentityClient)((CognitoIdentityClientBuilder)((CognitoIdentityClientBuilder)CognitoIdentityClient.builder().region(this.region)).credentialsProvider((AwsCredentialsProvider)AnonymousCredentialsProvider.create())).build();
        Intrinsics.checkNotNull((Object)client);
        return client;
    }

    private static final Unit getSTSCredentials$lambda$0(Map $logins, GetIdRequest.Builder $this$getSTSCredentials) {
        Intrinsics.checkNotNullParameter((Object)$this$getSTSCredentials, (String)"$this$getSTSCredentials");
        $this$getSTSCredentials.logins($logins);
        return Unit.INSTANCE;
    }

    private static final Unit getSTSCredentials$lambda$1(Map $logins, GetCredentialsForIdentityRequest.Builder $this$getSTSCredentials) {
        Intrinsics.checkNotNullParameter((Object)$this$getSTSCredentials, (String)"$this$getSTSCredentials");
        $this$getSTSCredentials.logins($logins);
        return Unit.INSTANCE;
    }

    private static final Unit getSTSCredentialsNotLoggedAccess$lambda$2(GetIdRequest.Builder $this$getSTSCredentials) {
        Intrinsics.checkNotNullParameter((Object)$this$getSTSCredentials, (String)"$this$getSTSCredentials");
        return Unit.INSTANCE;
    }

    private static final Unit getSTSCredentialsNotLoggedAccess$lambda$3(GetCredentialsForIdentityRequest.Builder $this$getSTSCredentials) {
        Intrinsics.checkNotNullParameter((Object)$this$getSTSCredentials, (String)"$this$getSTSCredentials");
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/merlyn/desktopapp/http/CognitoHelper$Companion;", "", "<init>", "()V", "AWS_ROOT_URL", "", "app"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

