/*
 * Decompiled with CFR 0.152.
 */
package org.merlyn.desktopapp.log;

import com.j256.cloudwatchlogbackappender.CloudWatchAppender;
import com.sksamuel.hoplite.ClasspathResourceLoader;
import com.sksamuel.hoplite.ConfigLoader;
import com.sksamuel.hoplite.ConfigLoaderBuilder;
import com.sksamuel.hoplite.ConfigLoaderBuilderExtensionsKt;
import com.sksamuel.hoplite.ConfigSource;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.koin.core.Koin;
import org.koin.core.qualifier.Qualifier;
import org.koin.core.scope.Scope;
import org.koin.java.KoinJavaComponent;
import org.merlyn.desktopapp.config.StageConfig;
import org.merlyn.desktopapp.log.DesktopAppEmergencyAppender;
import org.merlyn.desktopapp.log.LogbackProperties;
import org.merlyn.desktopapp.log.LogbackService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0012\u001a\u00020\u0011J\b\u0010\u0013\u001a\u00020\u0014H\u0002J\u0006\u0010\u0015\u001a\u00020\u000fJ\u0006\u0010\u0016\u001a\u00020\u000fJ\u0006\u0010\u0017\u001a\u00020\u000fJ\u0006\u0010\u0018\u001a\u00020\u000fJ\n\u0010\u0019\u001a\u0004\u0018\u00010\rH\u0002J\n\u0010\u001a\u001a\u0004\u0018\u00010\rH\u0002J\n\u0010\u001b\u001a\u0004\u0018\u00010\rH\u0002J\n\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0002J\b\u0010 \u001a\u00020\u0011H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/merlyn/desktopapp/log/LogbackService;", "", "<init>", "()V", "properties", "Lorg/merlyn/desktopapp/log/LogbackProperties;", "pollLoggingEventsScope", "Lkotlinx/coroutines/CoroutineScope;", "config", "Lorg/merlyn/desktopapp/config/StageConfig;", "pollLoggingJob", "Lkotlinx/coroutines/Job;", "getAppenderByLoggerName", "Lcom/j256/cloudwatchlogbackappender/CloudWatchAppender;", "loggerName", "", "onAWSCredentials", "", "onAWSCredentialsRetrievalFailed", "canRunPollingLogsJob", "", "getChromeExtensionLogger", "getMetricsLogger", "getTechnicalMetricsLogger", "getCrashLogger", "getDefaultCloudWatchAppender", "getChromeExtensionCloudWatchAppender", "getMetricsCloudWatchAppender", "getEmergencyAppender", "Lorg/merlyn/desktopapp/log/DesktopAppEmergencyAppender;", "getRootLogger", "Lch/qos/logback/classic/Logger;", "setRegionForCloudWatch", "app"})
@SourceDebugExtension(value={"SMAP\nLogbackService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LogbackService.kt\norg/merlyn/desktopapp/log/LogbackService\n+ 2 ConfigLoader.kt\ncom/sksamuel/hoplite/ConfigLoader\n+ 3 Koin.kt\norg/koin/core/Koin\n+ 4 Scope.kt\norg/koin/core/scope/Scope\n*L\n1#1,132:1\n78#2,13:133\n124#2:146\n105#3,4:147\n136#4:151\n*S KotlinDebug\n*F\n+ 1 LogbackService.kt\norg/merlyn/desktopapp/log/LogbackService\n*L\n22#1:133,13\n22#1:146\n104#1:147,4\n104#1:151\n*E\n"})
public final class LogbackService {
    @NotNull
    private final LogbackProperties properties;
    @NotNull
    private final CoroutineScope pollLoggingEventsScope;
    private StageConfig config;
    @Nullable
    private Job pollLoggingJob;

    /*
     * WARNING - void declaration
     */
    public LogbackService() {
        void this_$iv;
        ConfigLoader configLoader = ConfigLoaderBuilderExtensionsKt.addResourceSource$default((ConfigLoaderBuilder)ConfigLoaderBuilder.Companion.default(), (String)"/logback.properties", (boolean)false, (boolean)false, (int)6, null).build();
        Object[] resourceOrFiles$iv = new String[]{};
        boolean $i$f$loadConfigOrThrow = false;
        List resourceOrFiles$iv$iv = ArraysKt.toList((Object[])resourceOrFiles$iv);
        ClasspathResourceLoader classpathResourceLoader$iv$iv = ClasspathResourceLoader.Companion.toClasspathResourceLoader(ConfigSource.Companion.class);
        boolean $i$f$loadConfigOrThrow2 = false;
        void this_$iv$iv$iv = this_$iv;
        boolean $i$f$loadConfig = false;
        this.properties = (LogbackProperties)this_$iv.returnOrThrow(this_$iv$iv$iv.loadConfig(Reflection.getOrCreateKotlinClass(LogbackProperties.class), CollectionsKt.emptyList(), resourceOrFiles$iv$iv, classpathResourceLoader$iv$iv));
        this.pollLoggingEventsScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getDefault()));
    }

    @Nullable
    public final CloudWatchAppender getAppenderByLoggerName(@NotNull String loggerName) {
        Intrinsics.checkNotNullParameter((Object)loggerName, (String)"loggerName");
        String string = loggerName;
        return Intrinsics.areEqual((Object)string, (Object)this.properties.getCeLogger()) ? this.getChromeExtensionCloudWatchAppender() : (Intrinsics.areEqual((Object)string, (Object)this.properties.getMetricsLogger()) ? this.getMetricsCloudWatchAppender() : this.getDefaultCloudWatchAppender());
    }

    public final void onAWSCredentials() {
        this.setRegionForCloudWatch();
        DesktopAppEmergencyAppender desktopAppEmergencyAppender = this.getEmergencyAppender();
        if (desktopAppEmergencyAppender != null) {
            desktopAppEmergencyAppender.setAwsConnectionEnabled(true);
        }
        CloudWatchAppender cloudWatchAppender = this.getDefaultCloudWatchAppender();
        boolean bl = cloudWatchAppender != null ? cloudWatchAppender.resetAWSLogsClient() : false;
        if (bl) {
            CloudWatchAppender cloudWatchAppender2 = this.getChromeExtensionCloudWatchAppender();
            boolean bl2 = cloudWatchAppender2 != null ? cloudWatchAppender2.resetAWSLogsClient() : false;
            if (bl2) {
                CloudWatchAppender cloudWatchAppender3 = this.getMetricsCloudWatchAppender();
                boolean bl3 = cloudWatchAppender3 != null ? cloudWatchAppender3.resetAWSLogsClient() : false;
                if (bl3 && this.canRunPollingLogsJob()) {
                    DesktopAppEmergencyAppender desktopAppEmergencyAppender2 = this.getEmergencyAppender();
                    boolean bl4 = desktopAppEmergencyAppender2 != null ? desktopAppEmergencyAppender2.areLogsToPoll() : false;
                    if (bl4) {
                        this.pollLoggingJob = BuildersKt.launch$default((CoroutineScope)this.pollLoggingEventsScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                            int label;
                            private /* synthetic */ Object L$0;
                            final /* synthetic */ LogbackService this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public final Object invokeSuspend(Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        Object object2;
                                        ResultKt.throwOnFailure((Object)object);
                                        CoroutineScope $this$launch = (CoroutineScope)this.L$0;
                                        KLogger logger = KotlinLogging.INSTANCE.logger(onAWSCredentials.1::invokeSuspend$lambda$0);
                                        Object object3 = $this$launch;
                                        Object object4 = this.this$0;
                                        try {
                                            boolean bl = false;
                                            logger.trace(onAWSCredentials.1::invokeSuspend$lambda$3$lambda$1);
                                            DesktopAppEmergencyAppender desktopAppEmergencyAppender = LogbackService.access$getEmergencyAppender((LogbackService)object4);
                                            if (desktopAppEmergencyAppender != null) {
                                                desktopAppEmergencyAppender.pollEventsToCloudwatch();
                                            }
                                            logger.trace(onAWSCredentials.1::invokeSuspend$lambda$3$lambda$2);
                                            object2 = Result.constructor-impl((Object)Unit.INSTANCE);
                                        }
                                        catch (Throwable bl) {
                                            object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
                                        }
                                        object3 = object2;
                                        Throwable throwable = Result.exceptionOrNull-impl((Object)object3);
                                        if (throwable != null) {
                                            void var3_3;
                                            Object it = object4 = throwable;
                                            boolean bl = false;
                                            var3_3.error("Unexpected error polling events to Cloudwatch: " + ((Throwable)it).getMessage(), (Throwable)it);
                                        }
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                var3_3.L$0 = value2;
                                return (Continuation)var3_3;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }

                            private static final Unit invokeSuspend$lambda$0() {
                                return Unit.INSTANCE;
                            }

                            private static final Object invokeSuspend$lambda$3$lambda$1() {
                                return "Polling events to cloudwatch...";
                            }

                            private static final Object invokeSuspend$lambda$3$lambda$2() {
                                return "Polled events to cloudwatch...";
                            }
                        }), (int)3, null);
                    }
                }
            }
        }
    }

    public final void onAWSCredentialsRetrievalFailed() {
        block0: {
            DesktopAppEmergencyAppender desktopAppEmergencyAppender = this.getEmergencyAppender();
            if (desktopAppEmergencyAppender == null) break block0;
            desktopAppEmergencyAppender.setAwsConnectionEnabled(false);
        }
    }

    private final boolean canRunPollingLogsJob() {
        Job job = this.pollLoggingJob;
        return job != null ? job.isCompleted() : true;
    }

    @NotNull
    public final String getChromeExtensionLogger() {
        return this.properties.getCeLogger();
    }

    @NotNull
    public final String getMetricsLogger() {
        return this.properties.getMetricsLogger();
    }

    @NotNull
    public final String getTechnicalMetricsLogger() {
        return this.properties.getTechnicalMetricsLogger();
    }

    @NotNull
    public final String getCrashLogger() {
        return this.properties.getCrashLogger();
    }

    private final CloudWatchAppender getDefaultCloudWatchAppender() {
        return (CloudWatchAppender)this.getRootLogger().getAppender(this.properties.getCloudwatchAppenderName());
    }

    private final CloudWatchAppender getChromeExtensionCloudWatchAppender() {
        Logger logger = LoggerFactory.getLogger((String)this.properties.getCeLogger());
        Intrinsics.checkNotNull((Object)logger, (String)"null cannot be cast to non-null type ch.qos.logback.classic.Logger");
        ch.qos.logback.classic.Logger ceLogger = (ch.qos.logback.classic.Logger)logger;
        return (CloudWatchAppender)ceLogger.getAppender(this.properties.getCeCloudwatchAppenderName());
    }

    private final CloudWatchAppender getMetricsCloudWatchAppender() {
        Logger logger = LoggerFactory.getLogger((String)this.properties.getMetricsLogger());
        Intrinsics.checkNotNull((Object)logger, (String)"null cannot be cast to non-null type ch.qos.logback.classic.Logger");
        ch.qos.logback.classic.Logger metricsLogger = (ch.qos.logback.classic.Logger)logger;
        return (CloudWatchAppender)metricsLogger.getAppender(this.properties.getMetricsCloudwatchAppenderName());
    }

    private final DesktopAppEmergencyAppender getEmergencyAppender() {
        CloudWatchAppender cloudWatchAppender = this.getDefaultCloudWatchAppender();
        return (DesktopAppEmergencyAppender)(cloudWatchAppender != null ? cloudWatchAppender.getAppender(this.properties.getEmergencyAppenderName()) : null);
    }

    private final ch.qos.logback.classic.Logger getRootLogger() {
        Logger logger = LoggerFactory.getLogger((String)"ROOT");
        Intrinsics.checkNotNull((Object)logger, (String)"null cannot be cast to non-null type ch.qos.logback.classic.Logger");
        return (ch.qos.logback.classic.Logger)logger;
    }

    private final void setRegionForCloudWatch() {
        block4: {
            StageConfig stageConfig;
            if (this.config == null) {
                Koin $this$iv = KoinJavaComponent.getKoin();
                Qualifier qualifier$iv = null;
                Function0 parameters$iv = null;
                boolean $i$f$get = false;
                Scope this_$iv$iv = $this$iv.getScopeRegistry().getRootScope();
                boolean $i$f$get2 = false;
                this.config = (StageConfig)this_$iv$iv.get(Reflection.getOrCreateKotlinClass(StageConfig.class), qualifier$iv, parameters$iv);
            }
            if ((stageConfig = this.config) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"config");
                stageConfig = null;
            }
            String region = stageConfig.getEnvironmentConfig().getRegion();
            CloudWatchAppender cloudWatchAppender = this.getDefaultCloudWatchAppender();
            if (cloudWatchAppender != null) {
                cloudWatchAppender.setRegion(region);
            }
            CloudWatchAppender cloudWatchAppender2 = this.getChromeExtensionCloudWatchAppender();
            if (cloudWatchAppender2 != null) {
                cloudWatchAppender2.setRegion(region);
            }
            CloudWatchAppender cloudWatchAppender3 = this.getMetricsCloudWatchAppender();
            if (cloudWatchAppender3 == null) break block4;
            cloudWatchAppender3.setRegion(region);
        }
    }

    public static final /* synthetic */ DesktopAppEmergencyAppender access$getEmergencyAppender(LogbackService $this) {
        return $this.getEmergencyAppender();
    }
}

