/*
 * Decompiled with CFR 0.152.
 */
package org.merlyn.desktopapp.metrics;

import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.config.MeterFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.merlyn.desktopapp.metrics.EMFLoggingRegistryConfig;
import org.merlyn.desktopapp.metrics.EMFMetricsRegistry;
import org.merlyn.desktopapp.metrics.MetricName;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u0013\b\u0002\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\f\u001a\u00020\rJ,\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\u001c\b\u0002\u0010\u0011\u001a\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00130\u0012\u0018\u00010\u000bJ:\u0010\u0014\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u001c\b\u0002\u0010\u0011\u001a\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00130\u0012\u0018\u00010\u000bJ\u001e\u0010\u0018\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u0013J\u0006\u0010\u001b\u001a\u00020\u001cJ4\u0010\u001d\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u001c2\u001c\b\u0002\u0010\u0011\u001a\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00130\u0012\u0018\u00010\u000bJ4\u0010\u001f\u001a\u0010\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u00070\u000b2\u001c\b\u0002\u0010\u0011\u001a\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00130\u0012\u0018\u00010\u000bH\u0002J\u0010\u0010 \u001a\u00020!2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\"\u0010\n\u001a\u0016\u0012\u0012\u0012\u0010\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u00070\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/merlyn/desktopapp/metrics/Metric;", "", "registry", "Lio/micrometer/core/instrument/MeterRegistry;", "<init>", "(Lio/micrometer/core/instrument/MeterRegistry;)V", "platformDimension", "Lio/micrometer/core/instrument/Tag;", "kotlin.jvm.PlatformType", "Lio/micrometer/core/instrument/Tag;", "dimensionSets", "", "flush", "", "counterIncrement", "metric", "Lorg/merlyn/desktopapp/metrics/MetricName;", "labels", "Lkotlin/Pair;", "", "gaugeValue", "value", "Ljava/util/concurrent/atomic/AtomicReference;", "", "recordAgentCounter", "agentName", "agentVersion", "startTimer", "Lio/micrometer/core/instrument/Timer$Sample;", "stopTimer", "timer", "convertLabelsToTags", "getTimerBuilder", "Lio/micrometer/core/instrument/Timer$Builder;", "Companion", "app"})
@SourceDebugExtension(value={"SMAP\nMetricDefinitions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MetricDefinitions.kt\norg/merlyn/desktopapp/metrics/Metric\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,102:1\n1869#2,2:103\n1869#2,2:105\n1869#2,2:107\n1563#2:109\n1634#2,3:110\n*S KotlinDebug\n*F\n+ 1 MetricDefinitions.kt\norg/merlyn/desktopapp/metrics/Metric\n*L\n32#1:103,2\n44#1:105,2\n78#1:107,2\n87#1:109\n87#1:110,3\n*E\n"})
public final class Metric {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MeterRegistry registry;
    private final Tag platformDimension;
    @NotNull
    private final List<List<Tag>> dimensionSets;
    @Nullable
    private static volatile Metric instance;

    private Metric(MeterRegistry registry) {
        this.registry = registry;
        this.platformDimension = Tag.of((String)"platform", (String)"$placeHolder");
        Object[] objectArray = new List[]{CollectionsKt.emptyList(), CollectionsKt.listOf((Object)this.platformDimension)};
        this.dimensionSets = CollectionsKt.listOf((Object[])objectArray);
        this.registry.config().meterFilter(MeterFilter.denyNameStartsWith((String)MetricName.HTTP_CLIENT_REQUESTS.getProp()));
        Metrics.addRegistry((MeterRegistry)this.registry);
    }

    /* synthetic */ Metric(MeterRegistry meterRegistry, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            EMFLoggingRegistryConfig eMFLoggingRegistryConfig = EMFLoggingRegistryConfig.Companion.getDEFAULT();
            Clock clock = Clock.SYSTEM;
            Intrinsics.checkNotNullExpressionValue((Object)clock, (String)"SYSTEM");
            meterRegistry = (MeterRegistry)new EMFMetricsRegistry(eMFLoggingRegistryConfig, clock);
        }
        this(meterRegistry);
    }

    public final void flush() {
        block0: {
            MeterRegistry meterRegistry = this.registry;
            EMFMetricsRegistry eMFMetricsRegistry = meterRegistry instanceof EMFMetricsRegistry ? (EMFMetricsRegistry)meterRegistry : null;
            if (eMFMetricsRegistry == null) break block0;
            eMFMetricsRegistry.flush();
        }
    }

    public final void counterIncrement(@NotNull MetricName metric, @Nullable List<Pair<String, String>> labels) {
        Intrinsics.checkNotNullParameter((Object)((Object)metric), (String)"metric");
        List<Tag> additionalDimensions = this.convertLabelsToTags(labels);
        Iterable $this$forEach$iv = this.dimensionSets;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            List dimensionSet = (List)element$iv;
            boolean bl = false;
            this.registry.counter(metric.getProp(), (Iterable)CollectionsKt.plus((Collection)additionalDimensions, (Iterable)dimensionSet)).increment();
        }
    }

    public static /* synthetic */ void counterIncrement$default(Metric metric, MetricName metricName, List list, int n, Object object) {
        if ((n & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        metric.counterIncrement(metricName, list);
    }

    public final void gaugeValue(@NotNull MetricName metric, @NotNull AtomicReference<Double> value2, @Nullable List<Pair<String, String>> labels) {
        Intrinsics.checkNotNullParameter((Object)((Object)metric), (String)"metric");
        Intrinsics.checkNotNullParameter(value2, (String)"value");
        List<Tag> additionalDimensions = this.convertLabelsToTags(labels);
        Iterable $this$forEach$iv = this.dimensionSets;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            List dimensionSet = (List)element$iv;
            boolean bl = false;
            Gauge.builder((String)metric.getProp(), value2, Metric::gaugeValue$lambda$2$lambda$1).strongReference(true).tags((Iterable)CollectionsKt.plus((Collection)additionalDimensions, (Iterable)dimensionSet)).register(this.registry);
        }
    }

    public static /* synthetic */ void gaugeValue$default(Metric metric, MetricName metricName, AtomicReference atomicReference, List list, int n, Object object) {
        if ((n & 4) != 0) {
            list = CollectionsKt.emptyList();
        }
        metric.gaugeValue(metricName, atomicReference, list);
    }

    public final void recordAgentCounter(@NotNull MetricName metric, @NotNull String agentName, @NotNull String agentVersion) {
        Intrinsics.checkNotNullParameter((Object)((Object)metric), (String)"metric");
        Intrinsics.checkNotNullParameter((Object)agentName, (String)"agentName");
        Intrinsics.checkNotNullParameter((Object)agentVersion, (String)"agentVersion");
        Pair agentNameLabel = new Pair((Object)"agentName", (Object)agentName);
        Pair agentVersionLabel = new Pair((Object)"agentVersion", (Object)agentVersion);
        Metric.counterIncrement$default(this, metric, null, 2, null);
        this.counterIncrement(metric, CollectionsKt.listOf((Object)agentNameLabel));
        Object[] objectArray = new Pair[]{agentNameLabel, agentVersionLabel};
        this.counterIncrement(metric, CollectionsKt.listOf((Object[])objectArray));
    }

    @NotNull
    public final Timer.Sample startTimer() {
        Timer.Sample sample = Timer.start((MeterRegistry)this.registry);
        Intrinsics.checkNotNullExpressionValue((Object)sample, (String)"start(...)");
        return sample;
    }

    public final void stopTimer(@NotNull MetricName metric, @NotNull Timer.Sample timer, @Nullable List<Pair<String, String>> labels) {
        Intrinsics.checkNotNullParameter((Object)((Object)metric), (String)"metric");
        Intrinsics.checkNotNullParameter((Object)timer, (String)"timer");
        List<Tag> additionalDimensions = this.convertLabelsToTags(labels);
        Iterable $this$forEach$iv = this.dimensionSets;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            List dimensionSet = (List)element$iv;
            boolean bl = false;
            timer.stop(this.getTimerBuilder(metric).tags((Iterable)CollectionsKt.plus((Collection)additionalDimensions, (Iterable)dimensionSet)).register(this.registry));
        }
    }

    public static /* synthetic */ void stopTimer$default(Metric metric, MetricName metricName, Timer.Sample sample, List list, int n, Object object) {
        if ((n & 4) != 0) {
            list = CollectionsKt.emptyList();
        }
        metric.stopTimer(metricName, sample, list);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Tag> convertLabelsToTags(List<Pair<String, String>> labels) {
        List list;
        List<Pair<String, String>> list2 = labels;
        if (list2 != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = list2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Pair pair = (Pair)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Tag.of((String)((String)it.getFirst()), (String)((String)it.getSecond())));
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    static /* synthetic */ List convertLabelsToTags$default(Metric metric, List list, int n, Object object) {
        if ((n & 1) != 0) {
            list = CollectionsKt.emptyList();
        }
        return metric.convertLabelsToTags(list);
    }

    private final Timer.Builder getTimerBuilder(MetricName metric) {
        double[] dArray = new double[]{0.5, 0.9, 0.99};
        Timer.Builder builder = Timer.builder((String)metric.getProp()).publishPercentiles(dArray).publishPercentileHistogram();
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"publishPercentileHistogram(...)");
        return builder;
    }

    private static final double gaugeValue$lambda$2$lambda$1(AtomicReference it) {
        Object v = it.get();
        Intrinsics.checkNotNullExpressionValue(v, (String)"get(...)");
        return ((Number)v).doubleValue();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/merlyn/desktopapp/metrics/Metric$Companion;", "", "<init>", "()V", "instance", "Lorg/merlyn/desktopapp/metrics/Metric;", "app"})
    @SourceDebugExtension(value={"SMAP\nMetricDefinitions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MetricDefinitions.kt\norg/merlyn/desktopapp/metrics/Metric$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,102:1\n1#2:103\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final Metric instance() {
            Metric metric = instance;
            if (metric == null) {
                Companion companion = this;
                synchronized (companion) {
                    boolean bl = false;
                    Metric metric2 = instance;
                    if (metric2 == null) {
                        Metric metric3;
                        Metric it = metric3 = new Metric(null, 1, null);
                        boolean bl2 = false;
                        instance = it;
                        metric2 = metric3;
                    }
                    Metric metric4 = metric2;
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 4] lbl17 : MonitorExitStatement: MONITOREXIT : var1_1
                    metric = metric4;
                }
            }
            return metric;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

