/*
 * Decompiled with CFR 0.152.
 */
package org.merlyn.desktopapp.startup.impl;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.merlyn.desktopapp.coresdk.JWTToken;
import org.merlyn.desktopapp.http.InstantHelper;
import org.merlyn.desktopapp.service.ShortcutService;
import org.merlyn.desktopapp.startup.Hook;
import org.merlyn.sharedui.viewmodels.usecases.ObserveLoginStateUseCase;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u000e\u001a\u00020\u000fH\u0094@\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\fR\u000e\u0010\r\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/merlyn/desktopapp/startup/impl/ShortcutHook;", "Lorg/merlyn/desktopapp/startup/Hook;", "shortcutService", "Lorg/merlyn/desktopapp/service/ShortcutService;", "instantHelper", "Lorg/merlyn/desktopapp/http/InstantHelper;", "observeLoginState", "Lorg/merlyn/sharedui/viewmodels/usecases/ObserveLoginStateUseCase;", "<init>", "(Lorg/merlyn/desktopapp/service/ShortcutService;Lorg/merlyn/desktopapp/http/InstantHelper;Lorg/merlyn/sharedui/viewmodels/usecases/ObserveLoginStateUseCase;)V", "lastExecutionInstant", "", "Ljava/lang/Long;", "executionDelayShowingHibernation", "internalExecute", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "wasHibernating", "", "checkIfRefreshShortcuts", "app"})
@SourceDebugExtension(value={"SMAP\nShortcutHook.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShortcutHook.kt\norg/merlyn/desktopapp/startup/impl/ShortcutHook\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,44:1\n1#2:45\n*E\n"})
public final class ShortcutHook
extends Hook {
    @NotNull
    private final ShortcutService shortcutService;
    @NotNull
    private final InstantHelper instantHelper;
    @NotNull
    private final ObserveLoginStateUseCase observeLoginState;
    @Nullable
    private Long lastExecutionInstant;
    private final long executionDelayShowingHibernation;

    public ShortcutHook(@NotNull ShortcutService shortcutService, @NotNull InstantHelper instantHelper, @NotNull ObserveLoginStateUseCase observeLoginState) {
        Intrinsics.checkNotNullParameter((Object)shortcutService, (String)"shortcutService");
        Intrinsics.checkNotNullParameter((Object)instantHelper, (String)"instantHelper");
        Intrinsics.checkNotNullParameter((Object)observeLoginState, (String)"observeLoginState");
        super(Duration.getInWholeMilliseconds-impl((long)DurationKt.toDuration((int)30, (DurationUnit)DurationUnit.SECONDS)), false, 2, null);
        this.shortcutService = shortcutService;
        this.instantHelper = instantHelper;
        this.observeLoginState = observeLoginState;
        this.executionDelayShowingHibernation = (long)4 * Duration.getInWholeNanoseconds-impl((long)DurationKt.toDuration((long)this.getScheduleInMs(), (DurationUnit)DurationUnit.MILLISECONDS));
    }

    @Override
    @Nullable
    protected Object internalExecute(@NotNull Continuation<? super Unit> $completion) {
        Long l = this.lastExecutionInstant;
        if (l != null) {
            long it = ((Number)l).longValue();
            boolean bl = false;
            if (this.wasHibernating()) {
                this.checkIfRefreshShortcuts();
            }
        }
        this.lastExecutionInstant = Boxing.boxLong((long)System.nanoTime());
        return Unit.INSTANCE;
    }

    private final boolean wasHibernating() {
        boolean bl;
        Long l = this.lastExecutionInstant;
        if (l != null) {
            long it = ((Number)l).longValue();
            boolean bl2 = false;
            bl = System.nanoTime() - it > this.executionDelayShowingHibernation;
        } else {
            bl = false;
        }
        return bl;
    }

    private final void checkIfRefreshShortcuts() {
        block1: {
            String string = (String)this.observeLoginState.getAccessToken().getValue();
            if (string == null) break block1;
            String it = string;
            boolean bl = false;
            JWTToken jwt = new JWTToken(it);
            if (this.instantHelper.tokenIsUsable(Long.parseLong(jwt.getExpiration()))) {
                this.shortcutService.onRefresh();
            }
        }
    }
}

