/*
 * Decompiled with CFR 0.152.
 */
package org.merlyn.soundrecorder.permissions.foundation;

import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.platform.mac.CoreFoundation;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.merlyn.soundrecorder.permissions.foundation.Foundation;
import org.merlyn.soundrecorder.permissions.foundation.NSObject;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0003H\u0016R\u0014\u0010\u0007\u001a\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000f"}, d2={"Lorg/merlyn/soundrecorder/permissions/foundation/NSString;", "Lorg/merlyn/soundrecorder/permissions/foundation/NSObject;", "javaString", "", "<init>", "(Ljava/lang/String;)V", "toString", "jVMString", "getJVMString", "()Ljava/lang/String;", "cFStringRef", "Lcom/sun/jna/platform/mac/CoreFoundation$CFStringRef;", "getCFStringRef", "()Lcom/sun/jna/platform/mac/CoreFoundation$CFStringRef;", "Companion", "app"})
public final class NSString
extends NSObject {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private static final Pointer nativeClass = Foundation.INSTANCE.objc_getClass("NSString");
    @Nullable
    private static final Pointer stringWithUTF8StringSelector = Foundation.INSTANCE.sel_registerName("stringWithUTF8String:");

    public NSString(@NotNull String javaString) {
        Intrinsics.checkNotNullParameter((Object)javaString, (String)"javaString");
        NativeLong nativeLong = NSString.Companion.getNativeString(javaString);
        Intrinsics.checkNotNull((Object)nativeLong);
        super(nativeLong);
    }

    @NotNull
    public String toString() {
        return this.getJVMString();
    }

    private final String getJVMString() {
        String string = this.getCFStringRef().stringValue();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"stringValue(...)");
        return string;
    }

    private final CoreFoundation.CFStringRef getCFStringRef() {
        return new CoreFoundation.CFStringRef(new Pointer(this.id.longValue()));
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/merlyn/soundrecorder/permissions/foundation/NSString$Companion;", "", "<init>", "()V", "nativeClass", "Lcom/sun/jna/Pointer;", "stringWithUTF8StringSelector", "getNativeString", "Lcom/sun/jna/NativeLong;", "javaString", "", "app"})
    public static final class Companion {
        private Companion() {
        }

        private final NativeLong getNativeString(String javaString) {
            return Foundation.INSTANCE.objc_msgSend(nativeClass, stringWithUTF8StringSelector, javaString);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

