/*
 * Decompiled with CFR 0.152.
 */
package org.merlyn.sharedui.fxviews.avatar;

import java.util.List;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Background;
import javafx.scene.layout.Pane;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.merlyn.sharedui.avatarmanager.state.BaseAvatarState;
import org.merlyn.sharedui.avatarmanager.statedata.DisambiguationItem;
import org.merlyn.sharedui.avatarmanager.statedata.SoloAvatarStateData;
import org.merlyn.sharedui.fxviews.anims.AvatarTransitionManager;
import org.merlyn.sharedui.fxviews.avatar.AvatarListener;
import org.merlyn.sharedui.fxviews.avatar.AvatarSizeUtilsKt;
import org.merlyn.sharedui.fxviews.avatar.DisambiguationPane;
import org.merlyn.sharedui.fxviews.avatar.ErrorPane;
import org.merlyn.sharedui.fxviews.avatar.Transcript;
import org.merlyn.sharedui.fxviews.avatar.UserTranscript;
import org.merlyn.sharedui.fxviews.avatar.XioBall;
import org.merlyn.sharedui.fxviews.utils.MeasurementUtilsKt;
import org.merlyn.sharedui.fxviews.utils.SoloMeasurable;
import org.merlyn.sharedui.utils.FxViewUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002Bb\u00126\u0010\u0003\u001a2\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\b\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\n0\u0004\u0012!\u0010\u000b\u001a\u001d\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\n0\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\b\u0010(\u001a\u00020\nH\u0002J\b\u0010)\u001a\u00020\u0005H\u0002J\b\u0010*\u001a\u00020\u0005H\u0002J\b\u0010+\u001a\u00020\u0005H\u0002J\b\u0010,\u001a\u00020\u0005H\u0002J\u000e\u0010-\u001a\u00020\n2\u0006\u0010.\u001a\u00020/J\u0010\u00100\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020/H\u0002J\u0010\u00101\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020/H\u0002J\f\u00102\u001a\u00020\n*\u00020/H\u0002J\u000e\u00103\u001a\u0004\u0018\u000104*\u00020/H\u0002J\u000e\u00105\u001a\u0004\u0018\u000104*\u00020/H\u0002J\f\u00106\u001a\u000207*\u00020/H\u0002J\u0014\u00108\u001a\n\u0012\u0004\u0012\u00020:\u0018\u000109*\u00020/H\u0002J\u0010\u0010;\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010<\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020/H\u0002J\u0010\u0010=\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020/H\u0002R>\u0010\u0003\u001a2\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\b\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\n0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\u000b\u001a\u001d\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\n0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u0014\u0010#\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u0014\u0010&\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010%\u00a8\u0006>"}, d2={"Lorg/merlyn/sharedui/fxviews/avatar/AvatarViewPane;", "Ljavafx/scene/layout/AnchorPane;", "Lorg/merlyn/sharedui/fxviews/utils/SoloMeasurable;", "onResizeRequest", "Lkotlin/Function2;", "", "Lkotlin/ParameterName;", "name", "w", "h", "", "willContainerHeightChange", "Lkotlin/Function1;", "<init>", "(Lkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function1;)V", "avatarState", "Lorg/merlyn/sharedui/avatarmanager/state/BaseAvatarState;", "xioBall", "Lorg/merlyn/sharedui/fxviews/avatar/XioBall;", "transcript", "Lorg/merlyn/sharedui/fxviews/avatar/Transcript;", "userTranscript", "Lorg/merlyn/sharedui/fxviews/avatar/UserTranscript;", "disambiguationPane", "Lorg/merlyn/sharedui/fxviews/avatar/DisambiguationPane;", "errorPane", "Lorg/merlyn/sharedui/fxviews/avatar/ErrorPane;", "avatarTransitionManager", "Lorg/merlyn/sharedui/fxviews/anims/AvatarTransitionManager;", "listener", "Lorg/merlyn/sharedui/fxviews/avatar/AvatarListener;", "getListener", "()Lorg/merlyn/sharedui/fxviews/avatar/AvatarListener;", "setListener", "(Lorg/merlyn/sharedui/fxviews/avatar/AvatarListener;)V", "calculatedWidth", "getCalculatedWidth", "()D", "calculatedHeight", "getCalculatedHeight", "relayout", "calculateWidthInternal", "calculateHeightInternal", "calculateHeightBasedOnView", "calculateHeightBasedOnState", "changeState", "state", "Lorg/merlyn/sharedui/avatarmanager/statedata/SoloAvatarStateData;", "adjustViews", "setRecommendation", "setTranscriptSize", "getTranscriptText", "", "getUserTranscript", "isSingleLine", "", "getDisambiguationItems", "", "Lorg/merlyn/sharedui/avatarmanager/statedata/DisambiguationItem;", "setTranscriptBg", "setIcon", "setOptions", "sharedui"})
@SourceDebugExtension(value={"SMAP\nAvatarViewPane.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AvatarViewPane.kt\norg/merlyn/sharedui/fxviews/avatar/AvatarViewPane\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,281:1\n1#2:282\n*E\n"})
public final class AvatarViewPane
extends AnchorPane
implements SoloMeasurable {
    @NotNull
    private final Function2<Double, Double, Unit> onResizeRequest;
    @NotNull
    private final Function1<Double, Unit> willContainerHeightChange;
    @NotNull
    private BaseAvatarState avatarState;
    @NotNull
    private final XioBall xioBall;
    @NotNull
    private final Transcript transcript;
    @NotNull
    private final UserTranscript userTranscript;
    @NotNull
    private final DisambiguationPane disambiguationPane;
    @NotNull
    private final ErrorPane errorPane;
    @NotNull
    private final AvatarTransitionManager avatarTransitionManager;
    @Nullable
    private AvatarListener listener;

    public AvatarViewPane(@NotNull Function2<? super Double, ? super Double, Unit> onResizeRequest, @NotNull Function1<? super Double, Unit> willContainerHeightChange) {
        Intrinsics.checkNotNullParameter(onResizeRequest, (String)"onResizeRequest");
        Intrinsics.checkNotNullParameter(willContainerHeightChange, (String)"willContainerHeightChange");
        this.onResizeRequest = onResizeRequest;
        this.willContainerHeightChange = willContainerHeightChange;
        this.avatarState = BaseAvatarState.AvatarHidden.INSTANCE;
        this.xioBall = new XioBall();
        this.transcript = new Transcript();
        this.userTranscript = new UserTranscript();
        this.disambiguationPane = new DisambiguationPane();
        this.errorPane = new ErrorPane((Function0<Unit>)((Function0)new Function0<Unit>((Object)this){

            public final void invoke() {
                AvatarViewPane.access$relayout((AvatarViewPane)this.receiver);
            }
        }));
        FxViewUtilsKt.onClick((Node)this.xioBall, (Function0<Unit>)((Function0)() -> AvatarViewPane._init_$lambda$0(this)));
        AnchorPane.setTopAnchor((Node)((Node)this.xioBall), (Double)16.0);
        AnchorPane.setRightAnchor((Node)((Node)this.xioBall), (Double)16.0);
        AnchorPane.setTopAnchor((Node)((Node)this.errorPane), (Double)16.0);
        AnchorPane.setRightAnchor((Node)((Node)this.errorPane), (Double)16.0);
        AnchorPane.setTopAnchor((Node)((Node)this.transcript), (Double)16.0);
        AnchorPane.setRightAnchor((Node)((Node)this.transcript), (Double)16.0);
        AnchorPane.setTopAnchor((Node)((Node)this.userTranscript), (Double)16.0);
        AnchorPane.setRightAnchor((Node)((Node)this.userTranscript), (Double)16.0);
        AnchorPane.setTopAnchor((Node)((Node)this.disambiguationPane), (Double)16.0);
        AnchorPane.setRightAnchor((Node)((Node)this.disambiguationPane), (Double)16.0);
        this.setBackground(Background.EMPTY);
        this.transcript.setVisible(false);
        this.userTranscript.setVisible(false);
        this.disambiguationPane.setVisible(false);
        Object[] objectArray = new Node[]{this.disambiguationPane, this.transcript, this.xioBall, this.userTranscript, this.errorPane};
        this.getChildren().addAll(objectArray);
        this.avatarTransitionManager = new AvatarTransitionManager(this.xioBall, this.transcript, this.userTranscript, this.disambiguationPane);
        this.avatarTransitionManager.setResizeRequestListener((Function0<Unit>)((Function0)new Function0<Unit>((Object)this){

            public final void invoke() {
                ((AvatarViewPane)this.receiver).relayout();
            }
        }));
        this.transcript.widthProperty().addListener((arg_0, arg_1, arg_2) -> AvatarViewPane._init_$lambda$2((arg_0, arg_1, arg_2) -> AvatarViewPane._init_$lambda$1(this, arg_0, arg_1, arg_2), arg_0, arg_1, arg_2));
        this.errorPane.widthProperty().addListener((arg_0, arg_1, arg_2) -> AvatarViewPane._init_$lambda$4((arg_0, arg_1, arg_2) -> AvatarViewPane._init_$lambda$3(this, arg_0, arg_1, arg_2), arg_0, arg_1, arg_2));
        FxViewUtilsKt.onEscapeClick((Node)this.disambiguationPane, (Function0<Unit>)((Function0)() -> AvatarViewPane._init_$lambda$5(this)));
        this.errorPane.setOnCloseErrorClicked((Function1<? super Long, Unit>)((Function1)arg_0 -> AvatarViewPane._init_$lambda$6(this, arg_0)));
    }

    @Nullable
    public final AvatarListener getListener() {
        return this.listener;
    }

    public final void setListener(@Nullable AvatarListener avatarListener) {
        this.listener = avatarListener;
    }

    @Override
    public double getCalculatedWidth() {
        return this.calculateWidthInternal();
    }

    @Override
    public double getCalculatedHeight() {
        return this.calculateHeightInternal();
    }

    private final void relayout() {
        this.layout();
        this.onResizeRequest.invoke((Object)this.getCalculatedWidth(), (Object)this.getCalculatedHeight());
    }

    private final double calculateWidthInternal() {
        double widthCalculated = Math.max(Math.max(Math.max(MeasurementUtilsKt.calculateWidth((Pane)this.transcript), MeasurementUtilsKt.calculateWidth((Pane)this.userTranscript)), Math.max(MeasurementUtilsKt.calculateWidth((Pane)this.disambiguationPane), MeasurementUtilsKt.calculateWidth(this.xioBall))), MeasurementUtilsKt.calculateWidth((Pane)this.errorPane));
        double spacing = !(widthCalculated == 0.0) ? 16.0 : 0.0;
        return widthCalculated + spacing;
    }

    private final double calculateHeightInternal() {
        double heightCalculated = Math.max(this.calculateHeightBasedOnView(), this.calculateHeightBasedOnState());
        double spacing = !(heightCalculated == 0.0) ? 16.0 : 0.0;
        return heightCalculated + spacing;
    }

    private final double calculateHeightBasedOnView() {
        double xioBallH = MeasurementUtilsKt.calculateHeight$default(this.xioBall, 0.0, 1, null);
        double disambiguationH = MeasurementUtilsKt.calculateHeight$default((Pane)this.disambiguationPane, 0.0, 1, null);
        double transcriptH = MeasurementUtilsKt.calculateHeight$default((Pane)this.transcript, 0.0, 1, null);
        double userTranscriptH = MeasurementUtilsKt.calculateHeight$default((Pane)this.userTranscript, 0.0, 1, null);
        double errorPaneH = MeasurementUtilsKt.calculateHeight$default((Pane)this.errorPane, 0.0, 1, null);
        Object[] objectArray = new Double[]{xioBallH, transcriptH, userTranscriptH, transcriptH + MeasurementUtilsKt.calculateHeight((Pane)this.userTranscript, 16.0), disambiguationH + MeasurementUtilsKt.calculateHeight((Pane)this.userTranscript, 16.0), disambiguationH, errorPaneH};
        return CollectionsKt.maxOrThrow((Iterable)CollectionsKt.listOf((Object[])objectArray));
    }

    private final double calculateHeightBasedOnState() {
        BaseAvatarState baseAvatarState = this.avatarState;
        return baseAvatarState instanceof BaseAvatarState.AvatarCloudResponse || baseAvatarState instanceof BaseAvatarState.AvatarErrorResponse ? MeasurementUtilsKt.calculateHeight$default((Pane)this.transcript, 0.0, 1, null) + MeasurementUtilsKt.calculateHeight$default((Pane)this.userTranscript, 0.0, 1, null) + 12.0 : (baseAvatarState instanceof BaseAvatarState.AvatarCloudResponseDisambiguation || baseAvatarState instanceof BaseAvatarState.AvatarLocalDisambiguation ? MeasurementUtilsKt.calculateHeight$default((Pane)this.userTranscript, 0.0, 1, null) + 12.0 + MeasurementUtilsKt.calculateHeight$default((Pane)this.disambiguationPane, 0.0, 1, null) : 0.0);
    }

    public final void changeState(@NotNull SoloAvatarStateData state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        BaseAvatarState fromState = this.avatarState;
        this.avatarState = state.getBaseAvatarStateData().getAvatarState();
        this.errorPane.setErrorNotifications(state.getBaseAvatarStateData().getErrorList());
        this.errorPane.setVisible(state.getBaseAvatarStateData().getAvatarState() instanceof BaseAvatarState.AvatarErrorNotification);
        this.adjustViews(state);
        this.avatarTransitionManager.animate(fromState, this.avatarState);
        this.willContainerHeightChange.invoke((Object)AvatarSizeUtilsKt.calculateAvatarPaneHeight(state));
    }

    private final void adjustViews(SoloAvatarStateData avatarState) {
        Object it;
        this.setTranscriptSize(avatarState);
        this.setTranscriptBg(avatarState.getBaseAvatarStateData().getAvatarState());
        this.setRecommendation(avatarState);
        this.setIcon(avatarState);
        this.setOptions(avatarState);
        String string = this.getTranscriptText(avatarState);
        if (string != null) {
            it = string;
            boolean bl = false;
            this.transcript.setText((String)it);
        }
        String string2 = this.getUserTranscript(avatarState);
        if (string2 != null) {
            it = string2;
            boolean bl = false;
            this.userTranscript.setUserTranscript((String)it);
        }
        List<DisambiguationItem> list = this.getDisambiguationItems(avatarState);
        if (list != null) {
            it = list;
            boolean bl = false;
            this.disambiguationPane.setItems((List<DisambiguationItem>)it);
        }
        boolean it2 = this.isSingleLine(avatarState);
        boolean bl = false;
        this.transcript.setSingleLine(it2);
    }

    private final void setRecommendation(SoloAvatarStateData avatarState) {
        BaseAvatarState baseAvatarState = avatarState.getBaseAvatarStateData().getAvatarState();
        if (!Intrinsics.areEqual((Object)baseAvatarState, (Object)BaseAvatarState.AvatarIdle.INSTANCE) && !Intrinsics.areEqual((Object)baseAvatarState, (Object)BaseAvatarState.AvatarHidden.INSTANCE)) {
            if (Intrinsics.areEqual((Object)baseAvatarState, (Object)BaseAvatarState.AvatarRecommendation.INSTANCE)) {
                this.transcript.setRightSpacing(false);
            } else {
                this.transcript.setRightSpacing(true);
            }
        }
        if (avatarState.getBaseAvatarStateData().getAvatarState() instanceof BaseAvatarState.AvatarRecommendation) {
            FxViewUtilsKt.onClick((Node)this.transcript, (Function0<Unit>)((Function0)() -> AvatarViewPane.setRecommendation$lambda$11(avatarState)));
        } else {
            FxViewUtilsKt.onClick((Node)this.transcript, (Function0<Unit>)((Function0)AvatarViewPane::setRecommendation$lambda$12));
        }
    }

    private final void setTranscriptSize(SoloAvatarStateData $this$setTranscriptSize) {
        BaseAvatarState baseAvatarState = $this$setTranscriptSize.getBaseAvatarStateData().getAvatarState();
        double size = baseAvatarState instanceof BaseAvatarState.AvatarCloudResponseDisambiguation || baseAvatarState instanceof BaseAvatarState.AvatarContextualSuggestionDisambiguation || baseAvatarState instanceof BaseAvatarState.AvatarLocalDisambiguation ? 348.0 : -1.0;
        this.transcript.setMinWidth(size);
        this.transcript.setMaxWidth(size);
    }

    private final String getTranscriptText(SoloAvatarStateData $this$getTranscriptText) {
        BaseAvatarState baseAvatarState = $this$getTranscriptText.getBaseAvatarStateData().getAvatarState();
        return baseAvatarState instanceof BaseAvatarState.AvatarCloudResponseDisambiguation || baseAvatarState instanceof BaseAvatarState.AvatarCloudResponse || baseAvatarState instanceof BaseAvatarState.AvatarContextualSuggestion || baseAvatarState instanceof BaseAvatarState.AvatarContextualSuggestionDisambiguation || baseAvatarState instanceof BaseAvatarState.AvatarLocalDisambiguation || baseAvatarState instanceof BaseAvatarState.AvatarErrorResponse || baseAvatarState instanceof BaseAvatarState.AvatarCloudNotification || baseAvatarState instanceof BaseAvatarState.AvatarRecommendation ? $this$getTranscriptText.getBaseAvatarStateData().getMerlynTranscript() : null;
    }

    private final String getUserTranscript(SoloAvatarStateData $this$getUserTranscript) {
        BaseAvatarState baseAvatarState = $this$getUserTranscript.getBaseAvatarStateData().getAvatarState();
        return baseAvatarState instanceof BaseAvatarState.AvatarUserTranscript || baseAvatarState instanceof BaseAvatarState.AvatarErrorResponse || baseAvatarState instanceof BaseAvatarState.AvatarCloudResponseDisambiguation || baseAvatarState instanceof BaseAvatarState.AvatarLocalDisambiguation || baseAvatarState instanceof BaseAvatarState.AvatarCloudResponse ? $this$getUserTranscript.getBaseAvatarStateData().getUserTranscript() : null;
    }

    private final boolean isSingleLine(SoloAvatarStateData $this$isSingleLine) {
        return $this$isSingleLine.getBaseAvatarStateData().getAvatarState() instanceof BaseAvatarState.AvatarLocalDisambiguation;
    }

    private final List<DisambiguationItem> getDisambiguationItems(SoloAvatarStateData $this$getDisambiguationItems) {
        BaseAvatarState baseAvatarState = $this$getDisambiguationItems.getBaseAvatarStateData().getAvatarState();
        return baseAvatarState instanceof BaseAvatarState.AvatarCloudResponseDisambiguation || baseAvatarState instanceof BaseAvatarState.AvatarContextualSuggestionDisambiguation || baseAvatarState instanceof BaseAvatarState.AvatarLocalDisambiguation ? $this$getDisambiguationItems.getBaseAvatarStateData().getDisambiguationList() : null;
    }

    private final void setTranscriptBg(BaseAvatarState avatarState) {
        BaseAvatarState baseAvatarState = avatarState;
        if (!(baseAvatarState instanceof BaseAvatarState.AvatarIdle) && !(baseAvatarState instanceof BaseAvatarState.AvatarHidden)) {
            if (baseAvatarState instanceof BaseAvatarState.AvatarCloudNotification) {
                this.transcript.setStateError();
            } else if (baseAvatarState instanceof BaseAvatarState.AvatarCloudResponseDisambiguation || baseAvatarState instanceof BaseAvatarState.AvatarLocalDisambiguation || baseAvatarState instanceof BaseAvatarState.AvatarContextualSuggestionDisambiguation) {
                this.transcript.setStateDisambiguation();
            } else {
                this.transcript.setStateDefault();
            }
        }
    }

    private final void setIcon(SoloAvatarStateData avatarState) {
        BaseAvatarState baseAvatarState = avatarState.getBaseAvatarStateData().getAvatarState();
        if (baseAvatarState instanceof BaseAvatarState.AvatarCloudNotification) {
            this.transcript.setIcon(avatarState.getBaseAvatarStateData().getIcon());
        } else if (!(baseAvatarState instanceof BaseAvatarState.AvatarIdle) && !(baseAvatarState instanceof BaseAvatarState.AvatarHidden)) {
            this.transcript.setIcon(null);
        }
    }

    private final void setOptions(SoloAvatarStateData avatarState) {
        BaseAvatarState baseAvatarState = avatarState.getBaseAvatarStateData().getAvatarState();
        if (baseAvatarState instanceof BaseAvatarState.AvatarCloudNotification) {
            this.transcript.setOptions(avatarState.getBaseAvatarStateData().getOptions());
        } else if (!(baseAvatarState instanceof BaseAvatarState.AvatarIdle) && !(baseAvatarState instanceof BaseAvatarState.AvatarHidden)) {
            this.transcript.setOptions(CollectionsKt.emptyList());
        }
    }

    private static final Unit _init_$lambda$0(AvatarViewPane this$0) {
        block0: {
            AvatarListener avatarListener = this$0.listener;
            if (avatarListener == null) break block0;
            avatarListener.onXioBallClick();
        }
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(AvatarViewPane this$0, ObservableValue observableValue, Number number, Number number2) {
        this$0.relayout();
        return Unit.INSTANCE;
    }

    private static final void _init_$lambda$2(Function3 $tmp0, ObservableValue p0, Object p1, Object p2) {
        $tmp0.invoke((Object)p0, p1, p2);
    }

    private static final Unit _init_$lambda$3(AvatarViewPane this$0, ObservableValue observableValue, Number number, Number number2) {
        this$0.relayout();
        return Unit.INSTANCE;
    }

    private static final void _init_$lambda$4(Function3 $tmp0, ObservableValue p0, Object p1, Object p2) {
        $tmp0.invoke((Object)p0, p1, p2);
    }

    private static final Unit _init_$lambda$5(AvatarViewPane this$0) {
        block0: {
            AvatarListener avatarListener = this$0.listener;
            if (avatarListener == null) break block0;
            avatarListener.onDisambiguationEscapeClick();
        }
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$6(AvatarViewPane this$0, long id) {
        block0: {
            AvatarListener avatarListener = this$0.listener;
            if (avatarListener == null) break block0;
            avatarListener.onErrorCloseClicked(id);
        }
        return Unit.INSTANCE;
    }

    private static final Unit setRecommendation$lambda$11(SoloAvatarStateData $avatarState) {
        block0: {
            Function0<Unit> function0 = $avatarState.getBaseAvatarStateData().getTranscriptionClickAction();
            if (function0 == null) break block0;
            function0.invoke();
        }
        return Unit.INSTANCE;
    }

    private static final Unit setRecommendation$lambda$12() {
        return Unit.INSTANCE;
    }
}

