/*
 * Decompiled with CFR 0.152.
 */
package org.merlyn.sharedui.utils.win32;

import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.Psapi;
import com.sun.jna.platform.win32.User32;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinDef;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.merlyn.sharedui.utils.win32.Win32Locator;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J!\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000b\u00a2\u0006\u0002\u0010\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/merlyn/sharedui/utils/win32/Win32Process;", "Lorg/merlyn/sharedui/utils/win32/Win32Locator;", "<init>", "()V", "logger", "Lmu/KLogger;", "createDetachedProcess", "", "command", "", "arguments", "", "(Ljava/lang/String;[Ljava/lang/String;)Z", "sharedui"})
public final class Win32Process
implements Win32Locator {
    @NotNull
    public static final Win32Process INSTANCE = new Win32Process();
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger(Win32Process::logger$lambda$0);

    private Win32Process() {
    }

    public final boolean createDetachedProcess(@NotNull String command, @NotNull String[] arguments) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        WinBase.STARTUPINFO startupInfo = new WinBase.STARTUPINFO();
        WinBase.PROCESS_INFORMATION processInformation = new WinBase.PROCESS_INFORMATION();
        boolean result = this.getKernel32().CreateProcess(command, ArraysKt.joinToString$default((Object[])arguments, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null), null, null, false, new WinDef.DWORD(0xC000000L), null, null, startupInfo, processInformation);
        if (result) {
            this.getKernel32().CloseHandle(processInformation.hProcess);
            this.getKernel32().CloseHandle(processInformation.hThread);
        } else {
            logger.error(() -> Win32Process.createDetachedProcess$lambda$2(command, arguments));
        }
        return result;
    }

    @Override
    @NotNull
    public User32 getUser32() {
        return Win32Locator.DefaultImpls.getUser32(this);
    }

    @Override
    @NotNull
    public Kernel32 getKernel32() {
        return Win32Locator.DefaultImpls.getKernel32(this);
    }

    @Override
    @NotNull
    public Psapi getPsApi() {
        return Win32Locator.DefaultImpls.getPsApi(this);
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final CharSequence createDetachedProcess$lambda$2$lambda$1(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "";
    }

    private static final Object createDetachedProcess$lambda$2(String $command, String[] $arguments) {
        return "Error executing process: command: " + $command + " arguments: " + ArraysKt.joinToString$default((Object[])$arguments, null, null, null, (int)0, null, Win32Process::createDetachedProcess$lambda$2$lambda$1, (int)31, null) + " error: " + INSTANCE.getKernel32().GetLastError();
    }
}

