/*
 * Decompiled with CFR 0.152.
 */
package org.merlyn.sharedui.utils.win32;

import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.Kernel32Util;
import com.sun.jna.platform.win32.Psapi;
import com.sun.jna.platform.win32.User32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.ptr.IntByReference;
import java.awt.Rectangle;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.merlyn.sharedui.utils.win32.ProcessInfo;
import org.merlyn.sharedui.utils.win32.Win32Locator;
import org.merlyn.sharedui.utils.win32.Win32LocatorKt;
import org.merlyn.sharedui.utils.win32.WindowHandleKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u001b\u001a\u00020\u001cH\u0002J\u0006\u0010\u001d\u001a\u00020\u001cJ\u0006\u0010\u001e\u001a\u00020\u001cJ\u0006\u0010\u001f\u001a\u00020\u001cJ!\u0010 \u001a\u0002H!\"\u0004\b\u0000\u0010!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u0002H!0#H\u0002\u00a2\u0006\u0002\u0010$J\b\u0010%\u001a\u00020\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\tR\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0018R\u0011\u0010\u001a\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0018\u00a8\u0006&"}, d2={"Lorg/merlyn/sharedui/utils/win32/WindowHandle;", "Lorg/merlyn/sharedui/utils/win32/Win32Locator;", "hWnd", "Lcom/sun/jna/platform/win32/WinDef$HWND;", "<init>", "(Lcom/sun/jna/platform/win32/WinDef$HWND;)V", "id", "", "getId", "()Ljava/lang/String;", "name", "getName", "rect", "Ljava/awt/Rectangle;", "getRect", "()Ljava/awt/Rectangle;", "className", "getClassName", "process", "Lorg/merlyn/sharedui/utils/win32/ProcessInfo;", "getProcess", "()Lorg/merlyn/sharedui/utils/win32/ProcessInfo;", "isActive", "", "()Z", "isForeground", "isVisible", "setForegroundInternal", "", "setForeground", "moveToTopWithoutRequestingFocus", "restore", "withThreadInput", "T", "block", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "toString", "sharedui"})
@SourceDebugExtension(value={"SMAP\nWindowHandle.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowHandle.kt\norg/merlyn/sharedui/utils/win32/WindowHandle\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,145:1\n1#2:146\n*E\n"})
public final class WindowHandle
implements Win32Locator {
    @NotNull
    private final WinDef.HWND hWnd;

    public WindowHandle(@NotNull WinDef.HWND hWnd) {
        Intrinsics.checkNotNullParameter((Object)hWnd, (String)"hWnd");
        this.hWnd = hWnd;
    }

    @NotNull
    public final String getId() {
        String string = this.hWnd.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public final String getName() {
        User32 $this$_get_name__u24lambda_u241 = this.getUser32();
        boolean bl = false;
        return Win32LocatorKt.getString$default(0, arg_0 -> WindowHandle._get_name_$lambda$1$lambda$0($this$_get_name__u24lambda_u241, this, arg_0), 1, null);
    }

    @NotNull
    public final Rectangle getRect() {
        User32 $this$_get_rect__u24lambda_u242 = this.getUser32();
        boolean bl = false;
        WinDef.RECT rect = new WinDef.RECT();
        User32.INSTANCE.GetWindowRect(this.hWnd, rect);
        Rectangle rectangle = rect.toRectangle();
        Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"with(...)");
        return rectangle;
    }

    @NotNull
    public final String getClassName() {
        User32 $this$_get_className__u24lambda_u244 = this.getUser32();
        boolean bl = false;
        return Win32LocatorKt.getString$default(0, arg_0 -> WindowHandle._get_className_$lambda$4$lambda$3($this$_get_className__u24lambda_u244, this, arg_0), 1, null);
    }

    @NotNull
    public final ProcessInfo getProcess() {
        User32 $this$_get_process__u24lambda_u245 = this.getUser32();
        boolean bl = false;
        IntByReference processId = new IntByReference();
        int threadId = $this$_get_process__u24lambda_u245.GetWindowThreadProcessId(this.hWnd, processId);
        return new ProcessInfo(processId.getValue(), threadId);
    }

    public final boolean isActive() {
        User32 $this$_get_isActive__u24lambda_u246 = this.getUser32();
        boolean bl = false;
        return Intrinsics.areEqual((Object)$this$_get_isActive__u24lambda_u246.GetActiveWindow(), (Object)this.hWnd);
    }

    public final boolean isForeground() {
        User32 $this$_get_isForeground__u24lambda_u247 = this.getUser32();
        boolean bl = false;
        return Intrinsics.areEqual((Object)$this$_get_isForeground__u24lambda_u247.GetForegroundWindow(), (Object)this.hWnd);
    }

    public final boolean isVisible() {
        User32 $this$_get_isVisible__u24lambda_u248 = this.getUser32();
        boolean bl = false;
        return $this$_get_isVisible__u24lambda_u248.IsWindowVisible(this.hWnd);
    }

    private final void setForegroundInternal() {
        if (!this.getUser32().SetForegroundWindow(this.hWnd)) {
            boolean $i$a$-check-WindowHandle$setForegroundInternal$32 = false;
            String $i$a$-check-WindowHandle$setForegroundInternal$32 = this + " SetForegroundWindow failed";
            throw new IllegalStateException($i$a$-check-WindowHandle$setForegroundInternal$32.toString());
        }
        if (!this.isForeground()) {
            boolean bl = false;
            String string = this + " Unexpectedly not in foreground after successful call to SetForegroundWindow";
            throw new IllegalStateException(string.toString());
        }
        WindowHandleKt.access$getLogger$p().info(() -> WindowHandle.setForegroundInternal$lambda$11(this));
    }

    public final void setForeground() {
        if (this.isForeground()) {
            WindowHandleKt.access$getLogger$p().info(() -> WindowHandle.setForeground$lambda$12(this));
            return;
        }
        try {
            this.setForegroundInternal();
            return;
        }
        catch (Throwable t) {
            WindowHandleKt.access$getLogger$p().warn(() -> WindowHandle.setForeground$lambda$13(this, t));
            this.withThreadInput(() -> WindowHandle.setForeground$lambda$14(this));
            return;
        }
    }

    public final void moveToTopWithoutRequestingFocus() {
        this.getUser32().BringWindowToTop(this.hWnd);
    }

    public final void restore() {
        User32 $this$restore_u24lambda_u2416 = this.getUser32();
        boolean bl = false;
        ((Boolean)this.withThreadInput(() -> WindowHandle.restore$lambda$16$lambda$15($this$restore_u24lambda_u2416, this))).booleanValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> T withThreadInput(Function0<? extends T> block) {
        User32 $this$withThreadInput_u24lambda_u2423 = this.getUser32();
        boolean bl = false;
        WinDef.HWND foregroundWindow = $this$withThreadInput_u24lambda_u2423.GetForegroundWindow();
        if (foregroundWindow == null) {
            WindowHandleKt.access$getLogger$p().info(WindowHandle::withThreadInput$lambda$23$lambda$17);
            return (T)block.invoke();
        }
        WindowHandle handle = new WindowHandle(foregroundWindow);
        WindowHandleKt.access$getLogger$p().info(() -> WindowHandle.withThreadInput$lambda$23$lambda$18(handle));
        WinDef.DWORD currentThreadId = new WinDef.DWORD((long)this.getKernel32().GetCurrentThreadId());
        WinDef.DWORD foregroundWindowThreadId = new WinDef.DWORD((long)handle.getProcess().getThreadId());
        if (!$this$withThreadInput_u24lambda_u2423.AttachThreadInput(currentThreadId, foregroundWindowThreadId, true)) {
            WindowHandleKt.access$getLogger$p().warn(WindowHandle::withThreadInput$lambda$23$lambda$19);
        } else {
            WindowHandleKt.access$getLogger$p().info(WindowHandle::withThreadInput$lambda$23$lambda$20);
        }
        try {
            Object object = block.invoke();
            return (T)object;
        }
        finally {
            if (!$this$withThreadInput_u24lambda_u2423.AttachThreadInput(currentThreadId, foregroundWindowThreadId, false)) {
                WindowHandleKt.access$getLogger$p().warn(WindowHandle::withThreadInput$lambda$23$lambda$21);
            } else {
                WindowHandleKt.access$getLogger$p().info(WindowHandle::withThreadInput$lambda$23$lambda$22);
            }
        }
    }

    @NotNull
    public String toString() {
        return "WindowInfo(id='" + this.hWnd + "', text='" + this.getName() + "', className='" + this.getClassName() + "', rect=" + this.getRect() + ", isActive=" + this.isActive() + ", isForeground=" + this.isForeground() + ", isVisible=" + this.isVisible() + ", threadId=" + this.getProcess() + ")";
    }

    @Override
    @NotNull
    public User32 getUser32() {
        return Win32Locator.DefaultImpls.getUser32(this);
    }

    @Override
    @NotNull
    public Kernel32 getKernel32() {
        return Win32Locator.DefaultImpls.getKernel32(this);
    }

    @Override
    @NotNull
    public Psapi getPsApi() {
        return Win32Locator.DefaultImpls.getPsApi(this);
    }

    private static final Unit _get_name_$lambda$1$lambda$0(User32 $this_with, WindowHandle this$0, char[] it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $this_with.GetWindowText(this$0.hWnd, it, it.length);
        return Unit.INSTANCE;
    }

    private static final Unit _get_className_$lambda$4$lambda$3(User32 $this_with, WindowHandle this$0, char[] it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $this_with.GetClassName(this$0.hWnd, it, it.length);
        return Unit.INSTANCE;
    }

    private static final Object setForegroundInternal$lambda$11(WindowHandle this$0) {
        return this$0 + " SetForegroundWindow succeeded";
    }

    private static final Object setForeground$lambda$12(WindowHandle this$0) {
        return this$0 + " is already foreground";
    }

    private static final Object setForeground$lambda$13(WindowHandle this$0, Throwable $t) {
        return this$0 + " initially failed to set to foreground: " + $t.getMessage() + " ...";
    }

    private static final Unit setForeground$lambda$14(WindowHandle this$0) {
        this$0.setForegroundInternal();
        return Unit.INSTANCE;
    }

    private static final boolean restore$lambda$16$lambda$15(User32 $this_with, WindowHandle this$0) {
        return $this_with.ShowWindow(this$0.hWnd, 9);
    }

    private static final Object withThreadInput$lambda$23$lambda$17() {
        return "Foreground window == null, not attaching thread input";
    }

    private static final Object withThreadInput$lambda$23$lambda$18(WindowHandle $handle) {
        return "Attaching thread input to: " + $handle + " ...";
    }

    private static final Object withThreadInput$lambda$23$lambda$19() {
        return "Failed to attach thread input: " + Kernel32Util.getLastErrorMessage();
    }

    private static final Object withThreadInput$lambda$23$lambda$20() {
        return "Attached thread input";
    }

    private static final Object withThreadInput$lambda$23$lambda$21() {
        return "Failed to detach thread input: " + Kernel32Util.getLastErrorMessage();
    }

    private static final Object withThreadInput$lambda$23$lambda$22() {
        return "Detached thread input";
    }
}

