/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.helpers;

import com.microsoft.alm.helpers.Environment;
import com.microsoft.alm.helpers.Path;
import com.microsoft.alm.helpers.SystemHelper;
import java.io.File;
import java.io.FileReader;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SettingsHelper {
    private static final Logger logger = LoggerFactory.getLogger(SettingsHelper.class);
    private static final String VENDOR_FOLDER = SystemHelper.isLinux() ? ".microsoft" : "Microsoft";
    private static final String PROGRAM_FOLDER = "VstsAuthLib4J";
    private static final String FILE_NAME = "settings.properties";
    private final Properties properties = new Properties();
    private static final String DO_NOT_SET_SYSTEM_ENV = "doNotSetSystemEnv";
    private static SettingsHelper instance;

    public static synchronized SettingsHelper getInstance() {
        if (instance == null) {
            instance = new SettingsHelper();
        }
        return instance;
    }

    private static String getSettingsFolderName() {
        String folder = SystemHelper.isWindows() ? Path.construct(Environment.getFolderPath(Environment.SpecialFolder.LocalApplicationData), VENDOR_FOLDER, PROGRAM_FOLDER) : (SystemHelper.isMac() ? Path.construct(Environment.getFolderPath(Environment.SpecialFolder.UserProfile), "Library", "Application Support", VENDOR_FOLDER, PROGRAM_FOLDER) : Path.construct(Environment.getFolderPath(Environment.SpecialFolder.UserProfile), VENDOR_FOLDER, PROGRAM_FOLDER));
        return folder;
    }

    private SettingsHelper() {
        File potential;
        String path = SettingsHelper.getSettingsFolderName();
        File folder = new File(path);
        logger.info("Searching for {}", (Object)Path.combine(folder.getAbsolutePath(), FILE_NAME));
        if (folder.exists() && (potential = new File(folder, FILE_NAME)).exists() && potential.isFile() && potential.canRead()) {
            logger.info("Found setting file, trying to load properties from {}", (Object)potential.getAbsolutePath());
            try {
                boolean setSystemEnv;
                this.properties.load(new FileReader(potential));
                logger.info("Properties loaded.");
                boolean bl = setSystemEnv = Boolean.valueOf(this.properties.getProperty(DO_NOT_SET_SYSTEM_ENV)) == false;
                if (setSystemEnv) {
                    for (Map.Entry<Object, Object> entry : this.properties.entrySet()) {
                        if (!(entry.getKey() instanceof String) || !(entry.getValue() instanceof String)) continue;
                        logger.info("Setting System property {} to {}", entry.getKey(), entry.getValue());
                        System.setProperty(entry.getKey().toString(), entry.getValue().toString());
                    }
                }
            }
            catch (Throwable t) {
                logger.warn("Failed to load properties.", t);
                this.properties.clear();
            }
        }
    }

    public synchronized String getProperty(String name) {
        String result = this.properties.getProperty(name);
        if (result == null) {
            result = System.getProperty(name);
        }
        return result;
    }

    public synchronized String getProperty(String name, String defaultValue) {
        String result = this.getProperty(name);
        return result == null ? defaultValue : result;
    }
}

