/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.metrics;

import io.sentry.MeasurementUnit;
import io.sentry.metrics.Metric;
import io.sentry.metrics.MetricType;
import java.util.Arrays;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class GaugeMetric
extends Metric {
    private double last;
    private double min;
    private double max;
    private double sum;
    private int count;

    public GaugeMetric(@NotNull String key, double value, @Nullable MeasurementUnit unit, @Nullable Map<String, String> tags, @NotNull Long timestamp) {
        super(MetricType.Gauge, key, unit, tags, timestamp);
        this.last = value;
        this.min = value;
        this.max = value;
        this.sum = value;
        this.count = 1;
    }

    @Override
    public void add(double value) {
        this.last = value;
        this.min = Math.min(this.min, value);
        this.max = Math.max(this.max, value);
        this.sum += value;
        ++this.count;
    }

    public double getLast() {
        return this.last;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public double getSum() {
        return this.sum;
    }

    public int getCount() {
        return this.count;
    }

    @Override
    public int getWeight() {
        return 5;
    }

    @Override
    @NotNull
    public Iterable<?> serialize() {
        return Arrays.asList(this.last, this.min, this.max, this.sum, this.count);
    }
}

