/*
 * Decompiled with CFR 0.152.
 */
package org.merlyn.desktopapp.coresdk.usb.hid;

import java.io.Closeable;
import java.lang.invoke.LambdaMetafactory;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.ExecutorsKt;
import kotlinx.coroutines.Job;
import mu.KLogger;
import mu.KotlinLogging;
import org.hid4java.HidDevice;
import org.hid4java.HidManager;
import org.hid4java.HidServices;
import org.hid4java.HidServicesListener;
import org.hid4java.HidServicesSpecification;
import org.hid4java.ScanMode;
import org.hid4java.event.HidServicesEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.merlyn.desktopapp.coresdk.peer.PeerIdProvider;
import org.merlyn.desktopapp.coresdk.usb.MerlynDeviceRegistry;
import org.merlyn.desktopapp.coresdk.usb.hid.HidVendorEventsProcessor;
import org.merlyn.desktopapp.log.LogbackServiceKt;
import org.merlyn.desktopapp.metrics.Metric;
import org.merlyn.desktopapp.metrics.MetricName;
import org.merlyn.desktopapp.storage.DeviceDataDao;
import org.slf4j.MDC;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001cJ\u0010\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0012\u0010!\u001a\u00020\u00192\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0016J\u0012\u0010\"\u001a\u00020\u00192\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0016J\b\u0010#\u001a\u00020\u0019H\u0002J\u0010\u0010$\u001a\u00020\u001c2\u0006\u0010\u0012\u001a\u00020\u0014H\u0002J\b\u0010%\u001a\u00020\u0019H\u0002J\u0010\u0010&\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u0014H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082.\u00a2\u0006\u0002\n\u0000R\"\u0010\u0012\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u0013j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0014`\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/merlyn/desktopapp/coresdk/usb/hid/HidVendorEventsController;", "Lorg/hid4java/HidServicesListener;", "peerIdProvider", "Lorg/merlyn/desktopapp/coresdk/peer/PeerIdProvider;", "merlynDeviceRegistry", "Lorg/merlyn/desktopapp/coresdk/usb/MerlynDeviceRegistry;", "deviceDataDao", "Lorg/merlyn/desktopapp/storage/DeviceDataDao;", "hidVendorEventsProcessor", "Lorg/merlyn/desktopapp/coresdk/usb/hid/HidVendorEventsProcessor;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lorg/merlyn/desktopapp/coresdk/peer/PeerIdProvider;Lorg/merlyn/desktopapp/coresdk/usb/MerlynDeviceRegistry;Lorg/merlyn/desktopapp/storage/DeviceDataDao;Lorg/merlyn/desktopapp/coresdk/usb/hid/HidVendorEventsProcessor;Lkotlinx/coroutines/CoroutineScope;)V", "logger", "Lmu/KLogger;", "hidServices", "Lorg/hid4java/HidServices;", "device", "Ljava/util/concurrent/atomic/AtomicReference;", "Lorg/hid4java/HidDevice;", "Lco/touchlab/stately/concurrency/AtomicReference;", "jobKeyProcessor", "Lkotlinx/coroutines/Job;", "register", "", "scanForHidDeviceChanges", "isAttach", "", "hidDeviceAttached", "event", "Lorg/hid4java/event/HidServicesEvent;", "hidDeviceDetached", "hidFailure", "hidDataReceived", "detachDevice", "isMerlynDescriptor", "handleHidDevicesWhenStarting", "attachDevice", "app"})
@SourceDebugExtension(value={"SMAP\nHidVendorEventsController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HidVendorEventsController.kt\norg/merlyn/desktopapp/coresdk/usb/hid/HidVendorEventsController\n+ 2 KotlinLoggingMDC.kt\nmu/KotlinLoggingMDCKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,166:1\n20#2,7:167\n28#2,7:175\n20#2,7:182\n28#2,7:190\n1#3:174\n1#3:189\n1#3:199\n295#4,2:197\n*S KotlinDebug\n*F\n+ 1 HidVendorEventsController.kt\norg/merlyn/desktopapp/coresdk/usb/hid/HidVendorEventsController\n*L\n79#1:167,7\n79#1:175,7\n87#1:182,7\n87#1:190,7\n79#1:174\n87#1:189\n121#1:197,2\n*E\n"})
public final class HidVendorEventsController
implements HidServicesListener {
    @NotNull
    private final PeerIdProvider peerIdProvider;
    @NotNull
    private final MerlynDeviceRegistry merlynDeviceRegistry;
    @NotNull
    private final DeviceDataDao deviceDataDao;
    @NotNull
    private final HidVendorEventsProcessor hidVendorEventsProcessor;
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private final KLogger logger;
    private HidServices hidServices;
    @NotNull
    private final AtomicReference<HidDevice> device;
    @Nullable
    private Job jobKeyProcessor;

    public HidVendorEventsController(@NotNull PeerIdProvider peerIdProvider, @NotNull MerlynDeviceRegistry merlynDeviceRegistry, @NotNull DeviceDataDao deviceDataDao, @NotNull HidVendorEventsProcessor hidVendorEventsProcessor, @NotNull CoroutineScope scope) {
        Intrinsics.checkNotNullParameter((Object)peerIdProvider, (String)"peerIdProvider");
        Intrinsics.checkNotNullParameter((Object)merlynDeviceRegistry, (String)"merlynDeviceRegistry");
        Intrinsics.checkNotNullParameter((Object)deviceDataDao, (String)"deviceDataDao");
        Intrinsics.checkNotNullParameter((Object)hidVendorEventsProcessor, (String)"hidVendorEventsProcessor");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        this.peerIdProvider = peerIdProvider;
        this.merlynDeviceRegistry = merlynDeviceRegistry;
        this.deviceDataDao = deviceDataDao;
        this.hidVendorEventsProcessor = hidVendorEventsProcessor;
        this.scope = scope;
        this.logger = KotlinLogging.INSTANCE.logger(HidVendorEventsController::logger$lambda$0);
        this.device = new AtomicReference<Object>(null);
    }

    public /* synthetic */ HidVendorEventsController(PeerIdProvider peerIdProvider, MerlynDeviceRegistry merlynDeviceRegistry, DeviceDataDao deviceDataDao, HidVendorEventsProcessor hidVendorEventsProcessor, CoroutineScope coroutineScope, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            ExecutorService executorService = Executors.newFixedThreadPool(1);
            Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"newFixedThreadPool(...)");
            coroutineScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)ExecutorsKt.from((ExecutorService)executorService)));
        }
        this(peerIdProvider, merlynDeviceRegistry, deviceDataDao, hidVendorEventsProcessor, coroutineScope);
    }

    public final void register() {
        block2: {
            Object object;
            Object object2 = this;
            try {
                HidVendorEventsController $this$register_u24lambda_u240 = object2;
                boolean bl = false;
                HidServicesSpecification hidServicesSpecification = new HidServicesSpecification();
                hidServicesSpecification.setAutoStart(false);
                hidServicesSpecification.setAutoShutdown(false);
                hidServicesSpecification.setScanMode(ScanMode.NO_SCAN);
                BuildersKt.runBlocking((CoroutineContext)$this$register_u24lambda_u240.scope.getCoroutineContext(), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>($this$register_u24lambda_u240, hidServicesSpecification, this, null){
                    int label;
                    final /* synthetic */ HidVendorEventsController $this_runCatching;
                    final /* synthetic */ HidServicesSpecification $hidServicesSpecification;
                    final /* synthetic */ HidVendorEventsController this$0;
                    {
                        this.$this_runCatching = $receiver;
                        this.$hidServicesSpecification = $hidServicesSpecification;
                        this.this$0 = $receiver2;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object $result) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                HidServices hidServices = HidManager.getHidServices((HidServicesSpecification)this.$hidServicesSpecification);
                                Intrinsics.checkNotNullExpressionValue((Object)hidServices, (String)"getHidServices(...)");
                                HidVendorEventsController.access$setHidServices$p(this.$this_runCatching, hidServices);
                                HidServices hidServices2 = HidVendorEventsController.access$getHidServices$p(this.$this_runCatching);
                                if (hidServices2 == null) {
                                    Intrinsics.throwUninitializedPropertyAccessException((String)"hidServices");
                                    hidServices2 = null;
                                }
                                hidServices2.addHidServicesListener((HidServicesListener)this.this$0);
                                HidServices hidServices3 = HidVendorEventsController.access$getHidServices$p(this.$this_runCatching);
                                if (hidServices3 == null) {
                                    Intrinsics.throwUninitializedPropertyAccessException((String)"hidServices");
                                    hidServices3 = null;
                                }
                                hidServices3.start();
                                HidVendorEventsController.access$handleHidDevicesWhenStarting(this.$this_runCatching);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }));
                Runtime.getRuntime().addShutdownHook(new Thread(() -> HidVendorEventsController.register$lambda$0$0($this$register_u24lambda_u240), "hid4java-shutdown"));
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable == null) break block2;
            Object it = object = throwable;
            boolean bl = false;
            this.logger.error("Unable to register HID library", (Throwable)it);
            Metric.counterIncrement$default(Metric.Companion.instance(), MetricName.PLATFORM_ERROR_HID_REGISTRATION, null, 2, null);
        }
    }

    public final void scanForHidDeviceChanges(boolean isAttach) {
        if (!isAttach) {
            Job job = this.jobKeyProcessor;
            if (job != null) {
                Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
            }
            this.jobKeyProcessor = null;
        }
        BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ HidVendorEventsController this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        HidServices hidServices = HidVendorEventsController.access$getHidServices$p(this.this$0);
                        if (hidServices == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"hidServices");
                            hidServices = null;
                        }
                        hidServices.scan();
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hidDeviceAttached(@NotNull HidServicesEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        HidDevice hidDevice = event.getHidDevice();
        Intrinsics.checkNotNullExpressionValue((Object)hidDevice, (String)"getHidDevice(...)");
        if (this.isMerlynDescriptor(hidDevice)) {
            Pair pair$iv = TuplesKt.to((Object)LogbackServiceKt.getDeviceIdMDCKey(), (Object)this.deviceDataDao.get().getDeviceId());
            boolean restorePrevious$iv = true;
            boolean $i$f$withLoggingContext = false;
            if (pair$iv.getSecond() == null) {
                boolean bl = false;
                HidDevice hidDevice2 = event.getHidDevice();
                Intrinsics.checkNotNullExpressionValue((Object)hidDevice2, (String)"getHidDevice(...)");
                this.attachDevice(hidDevice2);
            } else {
                String previousValue$iv = MDC.get((String)((String)pair$iv.getFirst()));
                try {
                    Unit unit;
                    Closeable closeable = (Closeable)MDC.putCloseable((String)((String)pair$iv.getFirst()), (String)((String)pair$iv.getSecond()));
                    Throwable throwable = null;
                    try {
                        MDC.MDCCloseable it$iv = (MDC.MDCCloseable)closeable;
                        boolean bl = false;
                        boolean bl2 = false;
                        HidDevice hidDevice3 = event.getHidDevice();
                        Intrinsics.checkNotNullExpressionValue((Object)hidDevice3, (String)"getHidDevice(...)");
                        this.attachDevice(hidDevice3);
                        unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                    closeable = unit;
                }
                finally {
                    if (previousValue$iv != null) {
                        MDC.put((String)((String)pair$iv.getFirst()), (String)previousValue$iv);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hidDeviceDetached(@NotNull HidServicesEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        HidDevice hidDevice = event.getHidDevice();
        Intrinsics.checkNotNullExpressionValue((Object)hidDevice, (String)"getHidDevice(...)");
        if (this.isMerlynDescriptor(hidDevice)) {
            Pair pair$iv = TuplesKt.to((Object)LogbackServiceKt.getDeviceIdMDCKey(), (Object)this.deviceDataDao.get().getDeviceId());
            boolean restorePrevious$iv = true;
            boolean $i$f$withLoggingContext = false;
            if (pair$iv.getSecond() == null) {
                boolean bl = false;
                this.detachDevice();
            } else {
                String previousValue$iv = MDC.get((String)((String)pair$iv.getFirst()));
                try {
                    Unit unit;
                    Closeable closeable = (Closeable)MDC.putCloseable((String)((String)pair$iv.getFirst()), (String)((String)pair$iv.getSecond()));
                    Throwable throwable = null;
                    try {
                        MDC.MDCCloseable it$iv = (MDC.MDCCloseable)closeable;
                        boolean bl = false;
                        boolean bl2 = false;
                        this.detachDevice();
                        unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                    closeable = unit;
                }
                finally {
                    if (previousValue$iv != null) {
                        MDC.put((String)((String)pair$iv.getFirst()), (String)previousValue$iv);
                    }
                }
            }
        }
    }

    public void hidFailure(@Nullable HidServicesEvent event) {
        this.logger.warn(() -> HidVendorEventsController.hidFailure$lambda$0(event));
    }

    public void hidDataReceived(@Nullable HidServicesEvent event) {
        this.logger.warn(() -> HidVendorEventsController.hidDataReceived$lambda$0(event));
    }

    private final void detachDevice() {
        HidDevice hidDevice = this.device.get();
        if (hidDevice != null) {
            HidDevice it = hidDevice;
            boolean bl = false;
            this.logger.info(HidVendorEventsController::detachDevice$lambda$0$0);
            Job job = this.jobKeyProcessor;
            if (job != null) {
                Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
            }
            this.peerIdProvider.detachPeer();
            this.device.set(null);
        } else {
            HidVendorEventsController $this$detachDevice_u24lambda_u241 = this;
            boolean bl = false;
            $this$detachDevice_u24lambda_u241.logger.debug(HidVendorEventsController::detachDevice$lambda$1$0);
        }
    }

    private final boolean isMerlynDescriptor(HidDevice device) {
        return this.merlynDeviceRegistry.isMerlynVendorKeyCodeDevice(device.getVendorId(), device.getProductId(), device.getInterfaceNumber());
    }

    private final void handleHidDevicesWhenStarting() {
        block3: {
            HidDevice hidDevice;
            Object v2;
            block2: {
                HidServices hidServices = this.hidServices;
                if (hidServices == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"hidServices");
                    hidServices = null;
                }
                List list = hidServices.getAttachedHidDevices();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAttachedHidDevices(...)");
                Iterable $this$firstOrNull$iv = list;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    HidDevice device = (HidDevice)element$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)device);
                    if (!this.isMerlynDescriptor(device)) continue;
                    v2 = element$iv;
                    break block2;
                }
                v2 = null;
            }
            HidDevice hidDevice2 = v2;
            if (hidDevice2 == null) break block3;
            HidDevice $this$handleHidDevicesWhenStarting_u24lambda_u241 = hidDevice = hidDevice2;
            boolean bl = false;
            this.attachDevice($this$handleHidDevicesWhenStarting_u24lambda_u241);
        }
    }

    private final void attachDevice(HidDevice device) {
        HidDevice hidDevice = this.device.compareAndExchange(null, device);
        if (hidDevice != null) {
            HidDevice it = hidDevice;
            boolean bl = false;
            this.logger.debug(() -> HidVendorEventsController.attachDevice$lambda$0$0(device));
            return;
        }
        this.logger.info(() -> HidVendorEventsController.attachDevice$lambda$1(device));
        String string = device.getSerialNumber();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSerialNumber(...)");
        this.peerIdProvider.attachNewPeer(string);
        Job job = this.jobKeyProcessor;
        if (job != null) {
            Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
        }
        this.jobKeyProcessor = BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(device, this, null){
            Object L$1;
            int I$0;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ HidDevice $device;
            final /* synthetic */ HidVendorEventsController this$0;
            {
                this.$device = $device;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Unable to fully structure code
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public final Object invokeSuspend(Object $result) {
                block12: {
                    var2_2 = (CoroutineScope)this.L$0;
                    var5_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            if (this.$device.isClosed()) {
                                HidVendorEventsController.access$getLogger$p(this.this$0).info((Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, invokeSuspend$lambda$0(), ()Ljava/lang/Object;)());
                                this.$device.open();
                                try {
                                    buffer = new byte[5];
                                }
                                catch (RuntimeException e) {
                                    HidVendorEventsController.access$getLogger$p(this.this$0).debug((Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, invokeSuspend$lambda$1(java.lang.RuntimeException ), ()Ljava/lang/Object;)((RuntimeException)e));
                                    return Unit.INSTANCE;
                                }
lbl20:
                                // 4 sources

                                while (CoroutineScopeKt.isActive((CoroutineScope)$this$launch)) {
                                    read = this.$device.read(buffer, 1000);
                                    if (read <= 0) continue;
                                    this.L$0 = $this$launch;
                                    this.L$1 = buffer;
                                    this.I$0 = read;
                                    this.label = 1;
                                    v0 = HidVendorEventsController.access$getHidVendorEventsProcessor$p(this.this$0).onEvent(buffer, (Continuation<? super Unit>)((Continuation)this));
                                    if (v0 != var5_3) continue;
                                    return var5_3;
                                }
                                break;
                            }
                            break block12;
                        }
                        case 1: {
                            read = this.I$0;
                            buffer = (byte[])this.L$1;
                            {
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
                                ** GOTO lbl20
                            }
                        }
                    }
                    HidVendorEventsController.access$getLogger$p(this.this$0).info((Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, invokeSuspend$lambda$2(), ()Ljava/lang/Object;)());
                    this.$device.close();
                    return Unit.INSTANCE;
                    finally {
                        HidVendorEventsController.access$getLogger$p(this.this$0).info((Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, invokeSuspend$lambda$2(), ()Ljava/lang/Object;)());
                        this.$device.close();
                    }
                }
                HidVendorEventsController.access$getLogger$p(this.this$0).debug((Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, invokeSuspend$lambda$3(), ()Ljava/lang/Object;)());
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value2;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final Object invokeSuspend$lambda$0() {
                return "Opening HID paired device...";
            }

            private static final Object invokeSuspend$lambda$1(RuntimeException $e) {
                return "Runtime exception while reading from the RCU: " + $e.getMessage();
            }

            private static final Object invokeSuspend$lambda$2() {
                return "Closing HID paired device...";
            }

            private static final Object invokeSuspend$lambda$3() {
                return "NOT opening HID paired device as is already open.";
            }
        }), (int)3, null);
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final void register$lambda$0$0(HidVendorEventsController $this_runCatching) {
        HidServices hidServices = $this_runCatching.hidServices;
        if (hidServices == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"hidServices");
            hidServices = null;
        }
        hidServices.shutdown();
    }

    private static final Object hidFailure$lambda$0(HidServicesEvent $event) {
        return "Event received (but we were not expecting it): " + $event;
    }

    private static final Object hidDataReceived$lambda$0(HidServicesEvent $event) {
        return "Event received (but we were not expecting it): " + $event;
    }

    private static final Object detachDevice$lambda$0$0() {
        return "Removing HID paired device. Detaching...";
    }

    private static final Object detachDevice$lambda$1$0() {
        return "Removing HID paired device. NOT detaching as is already detached";
    }

    private static final Object attachDevice$lambda$0$0(HidDevice $device) {
        return "Found HID paired device. NOT attaching as is already attached: " + $device.getSerialNumber();
    }

    private static final Object attachDevice$lambda$1(HidDevice $device) {
        return "Found HID paired device. Attaching: " + $device.getSerialNumber();
    }

    public static final /* synthetic */ HidServices access$getHidServices$p(HidVendorEventsController $this) {
        return $this.hidServices;
    }

    public static final /* synthetic */ KLogger access$getLogger$p(HidVendorEventsController $this) {
        return $this.logger;
    }

    public static final /* synthetic */ HidVendorEventsProcessor access$getHidVendorEventsProcessor$p(HidVendorEventsController $this) {
        return $this.hidVendorEventsProcessor;
    }

    public static final /* synthetic */ void access$setHidServices$p(HidVendorEventsController $this, HidServices hidServices) {
        $this.hidServices = hidServices;
    }

    public static final /* synthetic */ void access$handleHidDevicesWhenStarting(HidVendorEventsController $this) {
        $this.handleHidDevicesWhenStarting();
    }
}

