/*
 * Decompiled with CFR 0.152.
 */
package org.merlyn.desktopapp.startup.impl;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.merlyn.desktopapp.config.AppConfig;
import org.merlyn.desktopapp.config.StageConfig;
import org.merlyn.desktopapp.os.HostOS;
import org.merlyn.desktopapp.os.OS;
import org.merlyn.desktopapp.service.InstallationType;
import org.merlyn.desktopapp.service.MsixInstallationInformation;
import org.merlyn.desktopapp.service.UpdateService;
import org.merlyn.desktopapp.startup.Hook;
import org.merlyn.desktopapp.startup.impl.CheckForUpdatesAnalytics;
import org.merlyn.desktopapp.startup.impl.CheckForUpdatesHook;
import org.merlyn.desktopapp.storage.ApplicationVersionMetaData;
import org.merlyn.sharedui.viewmodels.usecases.RequestAttentionNotificationUseCase;
import org.merlyn.sharedui.viewmodels.usecases.StatusDiagnosticEvents;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 +2\u00020\u0001:\u0002*+BQ\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u000e\b\u0002\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u0012\b\b\u0002\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u000e\u0010\u0018\u001a\u00020\u0019H\u0094@\u00a2\u0006\u0002\u0010\u001aJ\u001e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0082@\u00a2\u0006\u0002\u0010!J(\u0010\"\u001a\u00020#2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u000e\u001a\u00020\u00102\u0006\u0010$\u001a\u00020\u0012H\u0002J\u0010\u0010%\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\"\u0010&\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\u00102\b\u0010\u0015\u001a\u0004\u0018\u00010\u00102\u0006\u0010'\u001a\u00020\rH\u0002J\u0014\u0010(\u001a\u00020\u001c*\u00020\u00102\u0006\u0010)\u001a\u00020\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lorg/merlyn/desktopapp/startup/impl/CheckForUpdatesHook;", "Lorg/merlyn/desktopapp/startup/Hook;", "config", "Lorg/merlyn/desktopapp/config/StageConfig;", "updateService", "Lorg/merlyn/desktopapp/service/UpdateService;", "requestAttentionNotificationUseCase", "Lorg/merlyn/sharedui/viewmodels/usecases/RequestAttentionNotificationUseCase;", "statusDiagnosticEvents", "Lorg/merlyn/sharedui/viewmodels/usecases/StatusDiagnosticEvents;", "msixInstallationInformation", "Lorg/merlyn/desktopapp/service/MsixInstallationInformation;", "scheduleInMs", "", "now", "Lkotlin/Function0;", "Ljava/time/Instant;", "maxUpdateAttempts", "", "<init>", "(Lorg/merlyn/desktopapp/config/StageConfig;Lorg/merlyn/desktopapp/service/UpdateService;Lorg/merlyn/sharedui/viewmodels/usecases/RequestAttentionNotificationUseCase;Lorg/merlyn/sharedui/viewmodels/usecases/StatusDiagnosticEvents;Lorg/merlyn/desktopapp/service/MsixInstallationInformation;JLkotlin/jvm/functions/Function0;I)V", "updatesNotificationInstant", "analytics", "Lorg/merlyn/desktopapp/startup/impl/CheckForUpdatesAnalytics;", "internalExecute", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "attemptUpdate", "", "applicationConfig", "Lorg/merlyn/desktopapp/config/AppConfig;", "applicationVersionMetaData", "Lorg/merlyn/desktopapp/storage/ApplicationVersionMetaData;", "(Lorg/merlyn/desktopapp/config/AppConfig;Lorg/merlyn/desktopapp/storage/ApplicationVersionMetaData;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "handleUpdateFailed", "Lorg/merlyn/desktopapp/startup/impl/CheckForUpdatesHook$UpdateFailedResult;", "tryingUpdateAttempt", "conditionallyNotifyUserOfUpdateAvailable", "adjustNextUpdatesNotificationInstant", "updatesNotificationPeriod", "isEqualOrAfter", "otherInstant", "UpdateFailedResult", "Companion", "app"})
@SourceDebugExtension(value={"SMAP\nCheckForUpdatesHook.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CheckForUpdatesHook.kt\norg/merlyn/desktopapp/startup/impl/CheckForUpdatesHook\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,225:1\n1#2:226\n*E\n"})
public final class CheckForUpdatesHook
extends Hook {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final StageConfig config;
    @NotNull
    private final UpdateService updateService;
    @NotNull
    private final RequestAttentionNotificationUseCase requestAttentionNotificationUseCase;
    @NotNull
    private final MsixInstallationInformation msixInstallationInformation;
    @NotNull
    private final Function0<Instant> now;
    private final int maxUpdateAttempts;
    @Nullable
    private Instant updatesNotificationInstant;
    @NotNull
    private CheckForUpdatesAnalytics analytics;
    public static final int DEFAULT_MAX_UPDATE_ATTEMPTS = 10;

    public CheckForUpdatesHook(@NotNull StageConfig config, @NotNull UpdateService updateService, @NotNull RequestAttentionNotificationUseCase requestAttentionNotificationUseCase, @NotNull StatusDiagnosticEvents statusDiagnosticEvents, @NotNull MsixInstallationInformation msixInstallationInformation, long scheduleInMs, @NotNull Function0<Instant> now, int maxUpdateAttempts) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)updateService, (String)"updateService");
        Intrinsics.checkNotNullParameter((Object)requestAttentionNotificationUseCase, (String)"requestAttentionNotificationUseCase");
        Intrinsics.checkNotNullParameter((Object)statusDiagnosticEvents, (String)"statusDiagnosticEvents");
        Intrinsics.checkNotNullParameter((Object)msixInstallationInformation, (String)"msixInstallationInformation");
        Intrinsics.checkNotNullParameter(now, (String)"now");
        super(scheduleInMs, false, 2, null);
        this.config = config;
        this.updateService = updateService;
        this.requestAttentionNotificationUseCase = requestAttentionNotificationUseCase;
        this.msixInstallationInformation = msixInstallationInformation;
        this.now = now;
        this.maxUpdateAttempts = maxUpdateAttempts;
        this.analytics = new CheckForUpdatesAnalytics(statusDiagnosticEvents);
        if (this.config.getApplicationConfig().getEnableUpdateChecks()) {
            this.getLogger().info(() -> CheckForUpdatesHook._init_$lambda$0(scheduleInMs));
        }
    }

    public /* synthetic */ CheckForUpdatesHook(StageConfig stageConfig, UpdateService updateService, RequestAttentionNotificationUseCase requestAttentionNotificationUseCase, StatusDiagnosticEvents statusDiagnosticEvents, MsixInstallationInformation msixInstallationInformation, long l, Function0 function0, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x40) != 0) {
            function0 = 1.INSTANCE;
        }
        if ((n2 & 0x80) != 0) {
            n = 10;
        }
        this(stageConfig, updateService, requestAttentionNotificationUseCase, statusDiagnosticEvents, msixInstallationInformation, l, (Function0<Instant>)function0, n);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    protected Object internalExecute(@NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof internalExecute.1)) ** GOTO lbl-1000
        var6_2 = $completion;
        if ((var6_2.label & -2147483648) != 0) {
            var6_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ CheckForUpdatesHook this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.internalExecute((Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var7_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                applicationConfig = this.config.getApplicationConfig();
                if (!applicationConfig.getEnableUpdateChecks()) {
                    return Unit.INSTANCE;
                }
                if (HostOS.INSTANCE.getHostOs() != OS.Windows) ** GOTO lbl28
                $continuation.L$0 = applicationConfig;
                $continuation.label = 1;
                v0 = this.msixInstallationInformation.getInstallationType((Continuation<? super InstallationType>)$continuation);
                if (v0 == var7_4) {
                    return var7_4;
                }
                ** GOTO lbl26
            }
            case 1: {
                applicationConfig = (AppConfig)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl26:
                // 2 sources

                installationType = (InstallationType)v0;
                this.analytics.sendUpdateCapabilities(OS.Windows.toString(), applicationConfig.getAppVersion(), installationType.toString());
lbl28:
                // 2 sources

                applicationVersionMetaData = this.updateService.getApplicationVersionMetaData();
                if (applicationVersionMetaData.getCurrentVersion() == null) {
                    this.updateService.saveApplicationUpdateData(new ApplicationVersionMetaData(applicationConfig.getAppVersion(), true, null, null, null));
                    return Unit.INSTANCE;
                }
                if (!Intrinsics.areEqual((Object)applicationVersionMetaData.getCurrentVersion(), (Object)applicationConfig.getAppVersion())) {
                    this.updateService.saveApplicationUpdateData(new ApplicationVersionMetaData(applicationConfig.getAppVersion(), false, null, null, null));
                    this.analytics.sendUpdateSuccess();
                    return Unit.INSTANCE;
                }
                $continuation.L$0 = applicationConfig;
                $continuation.L$1 = applicationVersionMetaData;
                $continuation.label = 2;
                v1 = this.updateService.checkForUpdate((Continuation<? super Boolean>)$continuation);
                if (v1 == var7_4) {
                    return var7_4;
                }
                ** GOTO lbl49
            }
            case 2: {
                applicationVersionMetaData = (ApplicationVersionMetaData)$continuation.L$1;
                applicationConfig = (AppConfig)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl49:
                // 2 sources

                if (!((Boolean)v1).booleanValue()) ** GOTO lbl67
                if (!applicationConfig.getUpdatesForcedApplyEnabled()) ** GOTO lbl65
                $continuation.L$0 = applicationConfig;
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)applicationVersionMetaData);
                $continuation.label = 3;
                v2 = this.attemptUpdate(applicationConfig, applicationVersionMetaData, (Continuation<? super Boolean>)$continuation);
                if (v2 == var7_4) {
                    return var7_4;
                }
                ** GOTO lbl63
            }
            case 3: {
                applicationVersionMetaData = (ApplicationVersionMetaData)$continuation.L$1;
                applicationConfig = (AppConfig)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl63:
                // 2 sources

                if (finished = ((Boolean)v2).booleanValue()) {
                    return Unit.INSTANCE;
                }
lbl65:
                // 3 sources

                if (applicationConfig.getUpdatesNotificationEnabled()) {
                    this.conditionallyNotifyUserOfUpdateAvailable(applicationConfig);
                }
lbl67:
                // 4 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object attemptUpdate(AppConfig applicationConfig, ApplicationVersionMetaData applicationVersionMetaData, Continuation<? super Boolean> $completion) {
        if (!($completion instanceof attemptUpdate.1)) ** GOTO lbl-1000
        var8_4 = $completion;
        if ((var8_4.label & -2147483648) != 0) {
            var8_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                int I$0;
                boolean Z$0;
                /* synthetic */ Object result;
                final /* synthetic */ CheckForUpdatesHook this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return CheckForUpdatesHook.access$attemptUpdate(this.this$0, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var9_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (!this.updateService.isAppUpdatable() && !this.updateService.isForcedUpdate()) {
                    v0 = applicationConfig.getAppVersion();
                    v1 = this.updateService.getLatestVersion();
                    if (v1 == null) {
                        v1 = "unknown";
                    }
                    this.analytics.sendUpdateIgnored(v0, v1);
                    return Boxing.boxBoolean((boolean)false);
                }
                now = (Instant)this.now.invoke();
                v2 = applicationVersionMetaData.getTryingUpdateAttempt();
                v3 = tryingUpdateAttempt = v2 != null ? v2 : 0;
                if (applicationVersionMetaData.getTryingUpdateToVersion() == null) ** GOTO lbl36
                if (!Intrinsics.areEqual((Object)applicationVersionMetaData.getTryingUpdateToVersion(), (Object)this.updateService.getLatestVersion())) ** GOTO lbl35
                result = this.handleUpdateFailed(applicationConfig, applicationVersionMetaData, now, tryingUpdateAttempt);
                switch (WhenMappings.$EnumSwitchMapping$0[result.ordinal()]) {
                    case 1: {
                        ** GOTO lbl36
                    }
                    case 2: {
                        return Boxing.boxBoolean((boolean)true);
                    }
                    case 3: {
                        return Boxing.boxBoolean((boolean)false);
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
lbl35:
                // 1 sources

                tryingUpdateAttempt = 0;
lbl36:
                // 3 sources

                this.updateService.saveApplicationUpdateData(ApplicationVersionMetaData.copy$default(applicationVersionMetaData, null, false, this.updateService.getLatestVersion(), Boxing.boxLong((long)now.toEpochMilli()), Boxing.boxInt((int)(tryingUpdateAttempt + 1)), 3, null));
                this.analytics.resetUpdateFailureSent();
                $continuation.L$0 = applicationConfig;
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)applicationVersionMetaData);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)now);
                $continuation.I$0 = tryingUpdateAttempt;
                $continuation.label = 1;
                v4 = this.updateService.performUpdate((Continuation<? super Boolean>)$continuation);
                if (v4 == var9_6) {
                    return var9_6;
                }
                ** GOTO lbl54
            }
            case 1: {
                tryingUpdateAttempt = $continuation.I$0;
                now = (Instant)$continuation.L$2;
                applicationVersionMetaData = (ApplicationVersionMetaData)$continuation.L$1;
                applicationConfig = (AppConfig)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v4 = $result;
lbl54:
                // 2 sources

                if (res = ((Boolean)v4).booleanValue()) {
                    $continuation.L$0 = applicationConfig;
                    $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)applicationVersionMetaData);
                    $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)now);
                    $continuation.I$0 = tryingUpdateAttempt;
                    $continuation.Z$0 = res;
                    $continuation.label = 2;
                    v5 = this.requestAttentionNotificationUseCase.invoke((Continuation)$continuation);
                    if (v5 == var9_6) {
                        return var9_6;
                    }
                }
                ** GOTO lbl73
            }
            case 2: {
                res = $continuation.Z$0;
                tryingUpdateAttempt = $continuation.I$0;
                now = (Instant)$continuation.L$2;
                applicationVersionMetaData = (ApplicationVersionMetaData)$continuation.L$1;
                applicationConfig = (AppConfig)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v5 = $result;
lbl73:
                // 2 sources

                if (!res) {
                    v6 = applicationConfig.getAppVersion();
                    v7 = this.updateService.getApplicationVersionMetaData().getTryingUpdateToVersion();
                    Intrinsics.checkNotNull((Object)v7);
                    v8 = this.updateService.getApplicationVersionMetaData().getTryingUpdateAttempt();
                    Intrinsics.checkNotNull((Object)v8);
                    this.analytics.sendUpdateFailure(v6, v7, v8);
                }
                return Boxing.boxBoolean((boolean)true);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final UpdateFailedResult handleUpdateFailed(AppConfig applicationConfig, ApplicationVersionMetaData applicationVersionMetaData, Instant now, int tryingUpdateAttempt) {
        Comparable<Long> comparable;
        block6: {
            block5: {
                String string = applicationConfig.getAppVersion();
                String string2 = applicationVersionMetaData.getTryingUpdateToVersion();
                Intrinsics.checkNotNull((Object)string2);
                Integer n = applicationVersionMetaData.getTryingUpdateAttempt();
                this.analytics.sendUpdateFailure(string, string2, n != null ? n : 0);
                comparable = applicationVersionMetaData.getTryingUpdateInstant();
                if (comparable == null) break block5;
                long it = ((Number)((Object)comparable)).longValue();
                boolean bl = false;
                Instant instant = Instant.ofEpochMilli(it);
                comparable = instant;
                if (instant != null) break block6;
            }
            return UpdateFailedResult.Wait;
        }
        Comparable<Long> tryingUpdateInstant = comparable;
        if (now.isBefore(((Instant)tryingUpdateInstant).plus(applicationConfig.getUpdatesForcedApplyRetryPeriod(), ChronoUnit.MINUTES))) {
            return UpdateFailedResult.Wait;
        }
        if (tryingUpdateAttempt >= this.maxUpdateAttempts) {
            return UpdateFailedResult.RetryAttemptsExceeded;
        }
        return UpdateFailedResult.Retry;
    }

    private final void conditionallyNotifyUserOfUpdateAvailable(AppConfig applicationConfig) {
        block3: {
            Instant updatesNotificationInstant;
            Instant now;
            block2: {
                now = (Instant)this.now.invoke();
                updatesNotificationInstant = this.updatesNotificationInstant;
                boolean bl = false;
                if (updatesNotificationInstant == null) break block2;
                Instant instant = updatesNotificationInstant.plus(applicationConfig.getUpdatesNotificationPeriod(), ChronoUnit.MINUTES);
                Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"plus(...)");
                if (!this.isEqualOrAfter(now, instant)) break block3;
            }
            this.analytics.sendUpdateNotification();
            this.updatesNotificationInstant = this.adjustNextUpdatesNotificationInstant(now, updatesNotificationInstant, applicationConfig.getUpdatesNotificationPeriod());
            this.updateService.notifyUserOfUpdateAvailable();
        }
    }

    private final Instant adjustNextUpdatesNotificationInstant(Instant now, Instant updatesNotificationInstant, long updatesNotificationPeriod) {
        Instant instant;
        Instant instant2 = updatesNotificationInstant;
        if (instant2 == null) {
            return now;
        }
        Instant newUpdatesNotificationInstant = instant2;
        do {
            Intrinsics.checkNotNullExpressionValue((Object)newUpdatesNotificationInstant.plus(updatesNotificationPeriod, ChronoUnit.MINUTES), (String)"plus(...)");
            instant = newUpdatesNotificationInstant.plus(updatesNotificationPeriod, ChronoUnit.MINUTES);
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"plus(...)");
        } while (this.isEqualOrAfter(now, instant));
        return newUpdatesNotificationInstant;
    }

    private final boolean isEqualOrAfter(Instant $this$isEqualOrAfter, Instant otherInstant) {
        return !$this$isEqualOrAfter.isBefore(otherInstant);
    }

    private static final Object _init_$lambda$0(long $scheduleInMs) {
        return "Checking for app updates every " + $scheduleInMs;
    }

    public static final /* synthetic */ Object access$attemptUpdate(CheckForUpdatesHook $this, AppConfig applicationConfig, ApplicationVersionMetaData applicationVersionMetaData, Continuation $completion) {
        return $this.attemptUpdate(applicationConfig, applicationVersionMetaData, (Continuation<? super Boolean>)$completion);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/merlyn/desktopapp/startup/impl/CheckForUpdatesHook$Companion;", "", "<init>", "()V", "DEFAULT_MAX_UPDATE_ATTEMPTS", "", "app"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lorg/merlyn/desktopapp/startup/impl/CheckForUpdatesHook$UpdateFailedResult;", "", "<init>", "(Ljava/lang/String;I)V", "Retry", "Wait", "RetryAttemptsExceeded", "app"})
    public static final class UpdateFailedResult
    extends Enum<UpdateFailedResult> {
        public static final /* enum */ UpdateFailedResult Retry = new UpdateFailedResult();
        public static final /* enum */ UpdateFailedResult Wait = new UpdateFailedResult();
        public static final /* enum */ UpdateFailedResult RetryAttemptsExceeded = new UpdateFailedResult();
        private static final /* synthetic */ UpdateFailedResult[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static UpdateFailedResult[] values() {
            return (UpdateFailedResult[])$VALUES.clone();
        }

        public static UpdateFailedResult valueOf(String value2) {
            return Enum.valueOf(UpdateFailedResult.class, value2);
        }

        @NotNull
        public static EnumEntries<UpdateFailedResult> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = updateFailedResultArray = new UpdateFailedResult[]{UpdateFailedResult.Retry, UpdateFailedResult.Wait, UpdateFailedResult.RetryAttemptsExceeded};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[UpdateFailedResult.values().length];
            try {
                nArray[UpdateFailedResult.Retry.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UpdateFailedResult.Wait.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UpdateFailedResult.RetryAttemptsExceeded.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

